import { AfterContentInit, ChangeDetectorRef, ElementRef, OnDestroy, OnInit } from "@angular/core";
import { StiModelService } from "../services/model.service";
import { StiEditableContent } from "../system/interfaces";
import { StiEditableContentService } from "../services/sti-editable-content.service";
import { StiHorizontalAlignment } from "../system/enums";
import { StiMouseService } from "../services/mouse.service";
import { Subscription } from "rxjs";
import * as i0 from "@angular/core";
export declare class StiEditableContentComponent implements OnInit, AfterContentInit, OnDestroy {
    model: StiModelService;
    editableContentService: StiEditableContentService;
    mouseService: StiMouseService;
    private cdr;
    elementRef: ElementRef;
    editableContent: StiEditableContent;
    displayContent: string;
    required: boolean;
    eParent: any;
    hideEmpty: boolean;
    active: boolean;
    alignment?: StiHorizontalAlignment;
    isTableTotalHeader?: boolean;
    disablePadding?: boolean;
    fromButton?: boolean;
    parentCursor?: string;
    isTableHeader?: boolean;
    mouseUpSubscription: Subscription;
    isInitialize: boolean;
    focused: boolean;
    get cursor(): "" | "default" | "text";
    get showPlaceholder(): boolean;
    hasWordWrap(): boolean;
    getValue(): String;
    get showNonActivePlaceholder(): boolean;
    get placeholderOutline(): string;
    click(): void;
    get isEditable(): boolean;
    get width(): string;
    get align(): string;
    constructor(model: StiModelService, editableContentService: StiEditableContentService, mouseService: StiMouseService, cdr: ChangeDetectorRef);
    ngOnDestroy(): void;
    ngAfterContentInit(): void;
    needToUpdate(event: any): void;
    focus(): void;
    blur(): void;
    setContent(innerText: any): void;
    getCharCode(event: any): any;
    disableEnter(event: any): void;
    disableDrag(event: any): void;
    closeAll(element: any): void;
    ngOnInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiEditableContentComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiEditableContentComponent, "sti-editable-content-component", never, { "editableContent": { "alias": "editableContent"; "required": false; }; "displayContent": { "alias": "displayContent"; "required": false; }; "required": { "alias": "required"; "required": false; }; "eParent": { "alias": "eParent"; "required": false; }; "hideEmpty": { "alias": "hideEmpty"; "required": false; }; "active": { "alias": "active"; "required": false; }; "alignment": { "alias": "alignment"; "required": false; }; "isTableTotalHeader": { "alias": "isTableTotalHeader"; "required": false; }; "disablePadding": { "alias": "disablePadding"; "required": false; }; "fromButton": { "alias": "fromButton"; "required": false; }; "parentCursor": { "alias": "parentCursor"; "required": false; }; "isTableHeader": { "alias": "isTableHeader"; "required": false; }; }, {}, never, never, false, never>;
}
