import { Char } from "./Char";
export class TimeSpan {
    static { this.ticksPerMillisecond = 1; }
    static { this.millisecondsPerTick = 1 / TimeSpan.ticksPerMillisecond; }
    static { this.ticksPerSecond = TimeSpan.ticksPerMillisecond * 1000; }
    static { this.secondsPerTick = 1 / TimeSpan.ticksPerSecond; }
    static { this.ticksPerMinute = TimeSpan.ticksPerSecond * 60; }
    static { this.minutesPerTick = 1 / TimeSpan.ticksPerMinute; }
    static { this.ticksPerHour = TimeSpan.ticksPerMinute * 60; }
    static { this.hoursPerTick = 1 / TimeSpan.ticksPerHour; }
    static { this.ticksPerDay = TimeSpan.ticksPerHour * 24; }
    static { this.daysPerTick = 1 / TimeSpan.ticksPerDay; }
    static { this.millisPerSecond = 1000; }
    static { this.millisPerMinute = TimeSpan.millisPerSecond * 60; }
    static { this.millisPerHour = TimeSpan.millisPerMinute * 60; }
    static { this.millisPerDay = TimeSpan.millisPerHour * 24; }
    static { this.maxSeconds = Number.MAX_VALUE / TimeSpan.ticksPerSecond; }
    static { this.minSeconds = Number.MIN_VALUE / TimeSpan.ticksPerSecond; }
    static { this.maxMilliSeconds = Number.MAX_VALUE / TimeSpan.ticksPerMillisecond; }
    static { this.minMilliSeconds = Number.MIN_VALUE / TimeSpan.ticksPerMillisecond; }
    static { this.ticksPerTenthSecond = TimeSpan.ticksPerMillisecond * 100; }
    get zero() {
        return new TimeSpan();
    }
    static getNetTypeName() {
        return "System.TimeSpan";
    }
    static { this._minValue = null; }
    static minValue() {
        if (this._minValue == null)
            this._minValue = new TimeSpan(0, 0, Number.MIN_VALUE);
        return this._minValue;
    }
    static { this._maxValue = null; }
    static maxValue() {
        if (this._maxValue == null)
            this._maxValue = new TimeSpan(0, 0, Number.MAX_VALUE);
        return this._maxValue;
    }
    get days() {
        return Math.floor(this.ticks / TimeSpan.ticksPerDay);
    }
    get hours() {
        return Math.floor(this.ticks / TimeSpan.ticksPerHour) % 24;
    }
    get milliseconds() {
        return Math.floor(this.ticks / TimeSpan.ticksPerMillisecond) % 1000;
    }
    get minutes() {
        return Math.floor(this.ticks / TimeSpan.ticksPerMinute) % 60;
    }
    get seconds() {
        return Math.floor(this.ticks / TimeSpan.ticksPerSecond) % 60;
    }
    get totalDays() {
        return this.ticks * TimeSpan.daysPerTick;
    }
    get totalHours() {
        return this.ticks * TimeSpan.hoursPerTick;
    }
    get totalMilliseconds() {
        let temp = this.ticks * TimeSpan.millisecondsPerTick;
        if (temp > TimeSpan.maxMilliSeconds)
            return TimeSpan.maxMilliSeconds;
        if (temp < TimeSpan.minMilliSeconds)
            return TimeSpan.minMilliSeconds;
        return temp;
    }
    get totalMinutes() {
        return this.ticks * TimeSpan.minutesPerTick;
    }
    get totalSeconds() {
        return this.ticks * TimeSpan.secondsPerTick;
    }
    static fromString(value, format = null) {
        if (value == null)
            return null;
        let isDefaultFormat = false;
        if (format == null || format.length == 0) {
            format = "hh:mm:ss";
            isDefaultFormat = true;
        }
        let days = 0;
        let hours = 0;
        let minutes = 0;
        let seconds = 0;
        let milliseconds = 0;
        let char;
        let pos = 0;
        let values = [];
        let stringValues = [];
        let minus = false;
        // Parse time into separate numeric values
        while (pos < value.length) {
            char = value.charAt(pos);
            if (Char.isDigit(char)) {
                stringValues.push(char);
                pos++;
                while (pos < value.length && Char.isDigit(char = value.charAt(pos))) {
                    stringValues[stringValues.length - 1] += value.charAt(pos);
                    pos++;
                }
                values.push(+(stringValues[stringValues.length - 1]));
            }
            else if (char == "-")
                minus = true;
            if (isDefaultFormat && char === ".") {
                if (values.length === 1)
                    format = "d.hh:mm:ss";
                else
                    format += ".f";
            }
            pos++;
        }
        pos = 0;
        let index = -1;
        // Parsing format and replacement of appropriate values of time
        while (pos < format.length && index + 1 < values.length) {
            char = format.charAt(pos);
            if (char === "d" || char === "h" || char === "H" || char === "m" || char === "s" || char === "f" || char === "F") {
                index++;
                while (pos < format.length && format.charAt(pos) === char)
                    pos++;
            }
            switch (char) {
                case "d": // days
                    days = values[index];
                    break;
                case "h":
                case "H": // hours
                    hours = values[index];
                    break;
                case "m": // minutes
                    minutes = values[index];
                    break;
                case "s": // seconds
                    seconds = values[index];
                    break;
                case "f":
                case "F": // seconds fraction
                    milliseconds = values[index];
                    break;
                default:
                    pos++;
                    break;
            }
        }
        let timeSpan = TimeSpan.create(days, hours, minutes, seconds, milliseconds);
        timeSpan._minus = minus;
        return timeSpan;
    }
    static interval(value, scale) {
        let tmp = value * scale;
        let millis = tmp + (value >= 0 ? 0.5 : -0.5);
        return new TimeSpan(millis * TimeSpan.ticksPerMillisecond);
    }
    /* static fromTicks(value: number): TimeSpan {
       return new TimeSpan(value);
     }
  
     static fromSeconds(value: number): TimeSpan {
       return this.interval(value, this.millisPerSecond);
     }
  
     static fromMilliseconds(value: number): TimeSpan {
       return this.interval(value, 1);
     }
  
     add(value: number): TimeSpan {
       return new TimeSpan(this.ticks + value);
     }
  
     add2(value: TimeSpan): TimeSpan {
       return new TimeSpan(this.ticks + value.ticks);
     }*/
    toString(format) {
        if (format == null || format.length == 0) {
            format = "hh:mm:ss";
            if (this.days != 0) {
                format = "d.hh:mm:ss";
            }
        }
        /*switch (format) {
          case "t":
            format = CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "T":
            format = CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
        }
    
        format = format.replace(/H/gm, "h");
    */
        let result = "";
        let pos = 0;
        let isDays = false;
        /*  while (pos < format.length) {
            let f = format.charAt(pos);
    
            if (!Char.isLetter(f)) {
              result += f;
              pos++;
              continue;
            }
    
            while (pos + 1 < format.length && Char.isLetter(format.charAt(pos + 1))) {
              pos++;
              f += format.charAt(pos);
            }
    
            switch (f[0]) {
              case "d":
                isDays = true;
                result += Math.abs(this.days).toString().ss.padLeft(f.length, "0");
                break;
              case "h":
                result += Math.abs(isDays ? this.hours : StiMath.trunc(StiMath.round2(this.totalHours, 2))).toString().ss.padLeft(f.length, "0");
                break;
              case "m":
                result += Math.abs(this.minutes).toString().ss.padLeft(f.length, "0");
                break;
              case "s":
                result += Math.abs(this.seconds).toString().ss.padLeft(f.length, "0");
                break;
              case "f":
                result += Math.abs(this.milliseconds).toString().ss.padLeft(f.length, "0");
                break
              case "F":
                if (this.milliseconds != 0)
                  result += Math.abs(this.milliseconds).toString().ss.padLeft(f.length, "0");
                break;
            }
            pos++;
          }
    
          if (this._minus) return "-" + result;*/
        return result;
    }
    negate() {
        if (this.ticks == TimeSpan.minValue().ticks)
            throw new Error("Overflow_NegateTwosCompNum");
        return new TimeSpan(-this.ticks);
    }
    static timeToTicks(day, hour, minute, second, milliseconds) {
        let totalSeconds = day * 86400 + hour * 3600 + minute * 60 + second;
        return totalSeconds * TimeSpan.ticksPerSecond;
    }
    static create(days = 0, hours = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return null; // new TimeSpan(TimeSpan.timeToTicks(days, hours, minutes, seconds, milliseconds));
    }
    constructor(param1 = 0, minutes = null, seconds = null, milliseconds = null) {
        this._minus = false;
        if (minutes == null) {
            this.ticks = param1;
        }
        else {
            let hours1 = param1;
            if (milliseconds == null)
                milliseconds = 0;
            this.ticks = TimeSpan.timeToTicks(0, hours1, minutes, seconds, milliseconds);
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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