/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import List from "./List";
import { StiObject } from "./StiObject";
export default class Hashtable {
    constructor(options = { ignoreCase: false }) {
        this.ignoreCase = false;
        this.isSimpleKeys = false;
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.ignoreCase = options.ignoreCase;
        if (this.ignoreCase)
            this.isSimpleKeys = true;
    }
    get(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.values[this.indexObject[key]];
        }
        return this.values[this.keys.indexOf(key)];
    }
    set(key, value) {
        if (this.isSimpleKeys) {
            let type = typeof key;
            if (type != "string" && type != "number") {
                this.isSimpleKeys = false;
                this.indexObject = {};
            }
        }
        else if (this.keys.length == 0) {
            let type = typeof key;
            if (type == "string" || type == "number")
                this.isSimpleKeys = true;
        }
        let index = -1;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0)
            this.values[index] = value;
        else {
            if (this.isSimpleKeys) {
                if (this.ignoreCase)
                    key = key.toLowerCase();
                this.indexObject[key] = this.keys.length;
            }
            this.keys.push(key);
            this.values.push(value);
        }
    }
    /** Adds an element with the specified key and value into the Hashtable. */
    add(key, value) {
        this.set(key, value);
    }
    /** Determines whether the Hashtable contains a specific key. */
    contains(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific key. */
    containsKey(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific value. */
    containsValue(value) {
        return this.values.contains(value);
    }
    /** Removes the element with the specified key from the Hashtable. */
    remove(key) {
        let index;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0) {
            this.keys.removeAt(index);
            this.values.removeAt(index);
            if (this.isSimpleKeys) {
                this.indexObject = {};
                for (let index = 0; index < this.keys.length; index++) {
                    this.indexObject[this.ignoreCase ? this.keys[index].toLowerCase() : this.keys[index]] = index;
                }
            }
        }
    }
    /** Removes all elements from the Hashtable. */
    clear() {
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.isSimpleKeys = false;
    }
    /** Copies the Hashtable elements to a one-dimensional Array instance at the specified index. */
    copyTo(array, arrayIndex) {
        while (array.length < arrayIndex) {
            array.push(null);
        }
        for (let value of this.values) {
            if (array.length > arrayIndex)
                array[arrayIndex] = value;
            else
                array.push(value);
            arrayIndex++;
        }
    }
    /** Gets the number of key/value pairs contained in the Hashtable. */
    get count() {
        return this.keys.length;
    }
    clone() {
        let newHashtable = new Hashtable();
        this.keys.copyTo(newHashtable.keys);
        this.values.copyTo(newHashtable.values);
        if (this.isSimpleKeys)
            for (let key of StiObject.keys(this.indexObject)) {
                newHashtable.indexObject[key] = this.indexObject[key];
            }
        newHashtable.ignoreCase = this.ignoreCase;
        newHashtable.isSimpleKeys = this.isSimpleKeys;
        return newHashtable;
    }
}
//# sourceMappingURL=data:application/json;base64,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