import { TimeSpan } from "./TimeSpan";
export class DateTime {
    // Number of 100ns ticks per time unit
    static { this.ticksPerMillisecond = 1000; }
    static { this.ticksPerSecond = DateTime.ticksPerMillisecond * 1000; }
    static { this.ticksPerMinute = DateTime.ticksPerSecond * 60; }
    static { this.ticksPerHour = DateTime.ticksPerMinute * 60; }
    static { this.ticksPerDay = DateTime.ticksPerHour * 24; }
    // Number of milliseconds per time unit
    static { this.millisPerSecond = 1000; }
    static { this.millisPerMinute = DateTime.millisPerSecond * 60; }
    static { this.millisPerHour = DateTime.millisPerMinute * 60; }
    static { this.millisPerDay = DateTime.millisPerHour * 24; }
    // Number of days in a non-leap year
    static { this.daysPerYear = 365; }
    // Number of days in 4 years
    static { this.daysPer4Years = DateTime.daysPerYear * 4 + 1; }
    // Number of days in 100 years
    static { this.daysPer100Years = DateTime.daysPer4Years * 25 - 1; }
    // Number of days in 400 years
    static { this.daysPer400Years = DateTime.daysPer100Years * 4 + 1; }
    // Number of days from 1/1/0001 to 12/31/1600
    static { this.daysTo1601 = DateTime.daysPer400Years * 4; }
    // Number of days from 1/1/0001 to 12/30/1899
    static { this.daysTo1899 = DateTime.daysPer400Years * 4 + DateTime.daysPer100Years * 3 - 367; }
    // Number of days from 1/1/0001 to 12/31/9999
    static { this.daysTo10000 = DateTime.daysPer400Years * 25 - 366; }
    static { this.minTicks = 0; }
    static { this.maxTicks = DateTime.daysTo10000 * DateTime.ticksPerDay - 1; }
    static { this.maxMillis = DateTime.daysTo10000 * DateTime.millisPerDay; }
    static { this.fileTimeOffset = DateTime.daysTo1601 * DateTime.ticksPerDay; }
    static { this.doubleDateOffset = DateTime.daysTo1899 * DateTime.ticksPerDay; }
    // The minimum OA date is 0100/01/01 (Note it's year 100).
    // The maximum OA date is 9999/12/31
    static { this.oADateMinAsTicks = (DateTime.daysPer100Years - DateTime.daysPerYear) * DateTime.ticksPerDay; }
    // All OA dates must be greater than (not >=) OADateMinAsDouble
    static { this.oADateMinAsDouble = -657435; }
    // All OA dates must be less than (not <=) OADateMaxAsDouble
    static { this.oADateMaxAsDouble = 2958466; }
    static { this.datePartYear = 0; }
    static { this.datePartDayOfYear = 1; }
    static { this.datePartMonth = 2; }
    static { this.DatePartDay = 3; }
    static { this.daysToMonth365 = [
        0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365
    ]; }
    static { this.daysToMonth366 = [
        0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366
    ]; }
    static { this.minValue = new DateTime(DateTime.minTicks); }
    static { this.maxValue = new DateTime(DateTime.maxTicks); }
    static getNetTypeName() {
        return "System.DateTime";
    }
    get year() {
        return this.innerDate.getFullYear();
    }
    get month() {
        return this.innerDate.getMonth() + 1;
    }
    /*get monthName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.monthNames[this.month - 1];
    }
  
    get monthGenitiveName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.monthGenitiveNames[this.month - 1];
    }
  
    get monthShortName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.abbreviatedMonthNames[this.month - 1];
    }*/
    get day() {
        return this.innerDate.getDate();
    }
    /** 0 – Sunday, 1 – Monday etc */
    get dayOfWeek() {
        return this.innerDate.getDay();
    }
    /*get dayName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.dayNames[this.dayOfWeek];
    }
  
    get dayShortName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.shortestDayNames[this.dayOfWeek];
    }*/
    get hour() {
        return this.innerDate.getHours();
    }
    get minute() {
        return this.innerDate.getMinutes();
    }
    get second() {
        return this.innerDate.getSeconds();
    }
    get millisecond() {
        return this.innerDate.getMilliseconds();
    }
    get ticks() {
        return this.innerDate.getTime();
    }
    get dayOfYear() {
        let oneJan = new Date(this.innerDate.getFullYear(), 0, 1);
        let diff = this.innerDate.getTime() - oneJan.getTime();
        return Math.ceil(diff / 86400000) + 1;
    }
    /*firstDayOfWeek(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("week").toDate());
    }
  
    lastDayOfWeek(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("week").toDate());
    }
  
    firstDayOfMonth(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("month").toDate());
    }
  
    lastDayOfMonth(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("month").toDate());
    }
  
    firstDayOfQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfFirthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(0);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfFirthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(0);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfSecondQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(3);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfSecondQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(3);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfThirdQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(6);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfThirdQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(6);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfFourthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(9);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfFourthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(9);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfYear(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("year").toDate());
    }
  
    lastDayOfYear(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("year").toDate());
    }
  
    toShortDateString(): string {
      return this.toString(CultureInfo.currentCulture.dateTimeFormat.shortDatePattern);
    }
  
    toShortTimeString(): string {
      return this.toString(CultureInfo.currentCulture.dateTimeFormat.shortTimePattern);
    }*/
    static now() {
        return new DateTime(new Date());
    }
    static today() {
        let today = new DateTime(new Date());
        return new DateTime(today.year, today.month, today.day, 0, 0, 0, 0);
    }
    static isLeapYear(year) {
        return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
    }
    /** The month number ranging from 1 to 12. JS calculate month from 0. This will even work for December. */
    static daysInMonth(year, month) {
        return 33 - new Date(year, month - 1, 33).getDate();
    }
    static compare(t1, t2) {
        if (t1.ticks < t2.ticks)
            return -1;
        if (t1.ticks > t2.ticks)
            return 1;
        return 0;
    }
    static doubleDateToTicks(value) {
        if (value >= this.oADateMaxAsDouble || value <= this.oADateMinAsDouble)
            return null;
        let millis = (value * this.millisPerDay + (value >= 0 ? 0.5 : -0.5));
        // The interesting thing here is when you have a value like 12.5 it all positive 12 days and 12 hours from 01/01/1899
        // However if you a value of -12.25 it is minus 12 days but still positive 6 hours, almost as though you meant -11.75 all negative
        // This line below fixes up the millis in the negative case
        if (millis < 0) {
            millis -= (millis % this.millisPerDay) * 2;
        }
        millis += this.doubleDateOffset / this.ticksPerMillisecond;
        if (millis < 0 || millis >= this.maxMillis)
            return null;
        return millis * this.ticksPerMillisecond;
    }
    // private static ticksToOADate(value: number): number {
    //     //The time value for the date 1899-12-30 is -2209197600000 milliseconds
    //     let millis: number = (value + 2209197600000) / this.ticksPerMillisecond;
    //     if (millis < 0) {
    //         let frac: number = millis % this.millisPerDay;
    //         if (frac != 0) millis -= (this.millisPerDay + frac) * 2;
    //     }
    //     return millis / this.millisPerDay * 1000;
    // }
    toString(format = "G") {
        /*let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
        if (!dayjsDate.isValid()) return "";
        dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
    
    
        LT: culture.dateTimeFormat.shortTimePattern,
        LTS: culture.dateTimeFormat.longTimePattern,
        L: culture.dateTimeFormat.shortDatePattern,
        LLL: culture.dateTimeFormat.longDatePattern,
        LLLL: culture.dateTimeFormat.fullDateTimePattern
    
        t	ShortTimePattern	h:mm tt       LT: "h:mm A",
        T	LongTimePattern	    h:mm:ss tt    LTS: "h:mm:ss A",
    
        d	ShortDatePattern	M/d/yyyy                L: "M/D/YYYY",
        D	LongDatePattern	    dddd, MMMM dd, yyyy     LLL: "MMMM Do YYYY",
    
        f	(combination of D and t)	dddd, MMMM dd, yyyy h:mm tt
        F	FullDateTimePattern	        dddd, MMMM dd, yyyy h:mm:ss tt LLLL: "dddd, MMMM Do YYYY LT",
    
        g	(combination of d and t)	M/d/yyyy h:mm tt
        G	(combination of d and T)	M/d/yyyy h:mm:ss tt
        */
        /*switch (format) {
          case "t":
            format = CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "T":
            format = CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
          case "d":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern;
            break;
          case "D":
            format = CultureInfo.currentCulture.dateTimeFormat.longDatePattern;
            break;
          case "f":
            format = CultureInfo.currentCulture.dateTimeFormat.longDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "F":
            format = CultureInfo.currentCulture.dateTimeFormat.fullDateTimePattern;
            break;
          case "g":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "G":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
          case "y":
          case "Y":
            format = CultureInfo.currentCulture.dateTimeFormat.yearMonthPattern;
            break;
          case "s":
            format = "yyyy-MM-dd\\THH:mm:ss";
            break;// ISO
          case "u":
            format = "yyyy-MM-dd HH:mm:ss\\Z";
            break;// ISO
          case "m":
          case "M":   // MonthDayPattern;
            format = CultureInfo.currentCulture.name.ss.contains("en") || CultureInfo.currentCulture.name.ss.contains("us") ? "MMMM d" : "d MMMM";
            break;
          case "r":
          case "R":   // The RFC1123 Format Specifier
            format = "ddd, dd MMM yyyy HH\\:mm\\:ss \\G\\M\\T";
            break;
        }*/
        format = format.replace(/d/gm, "D").replace(/DDDD/gm, "dddd").replace(/DDD/gm, "ddd");
        format = format.replace(/y/gm, "Y");
        format = format.replace(/f/gm, "S").replace(/F/gm, "S");
        format = format.replace(/tt/gm, "A").replace(/t/gm, "A");
        format = format.replace(/zzz/gm, "Z").replace(/zz/gm, "Z").replace(/z/gm, "Z");
        return format + this.DateTimeOffset;
    }
    static ticksNetToTicksJs(ticks) {
        // ticks are in nanotime; convert to microtime
        let ticksToMicrotime = ticks / 10000;
        // ticks are recorded from 1/1/1; get microtime difference from 1/1/1/ to 1/1/1970
        let epochMicrotimeDiff = 62135607600000; // Math.abs(new Date(0, 0, 1).setFullYear(1))
        return ticksToMicrotime - epochMicrotimeDiff;
    }
    negate() {
        if (this.ticks == TimeSpan.minValue().ticks)
            throw new Error("Overflow_NegateTwosCompNum");
        return new DateTime(-this.ticks);
    }
    addYears(value) {
        return new DateTime(this.year + value, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    }
    addMonths(value) {
        let newMonth = this.month + value;
        let newYear = this.year;
        if (newMonth < 1) {
            newYear--;
            newMonth = 12 + newMonth;
        }
        return new DateTime(newYear, newMonth, this.day, this.hour, this.minute, this.second, this.millisecond);
    }
    /*addDays(value: number): DateTime {
      let newDate: DateTime = new DateTime(this.innerDate.getTime());
      let newDay = newDate.day + value;
      if (newDay < 1) {
        newDate = newDate.addMonths(-1);
        newDay = newDate.lastDayOfMonth().day + newDay;
      }
      return new DateTime(newDate.year, newDate.month, newDay, newDate.hour, newDate.minute, newDate.second, newDate.millisecond);
    }*/
    addHours(value) {
        return new DateTime(this.year, this.month, this.day, this.hour + value, this.minute, this.second, this.millisecond);
    }
    addMinutes(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute + value, this.second, this.millisecond);
    }
    addSeconds(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second + value, this.millisecond);
    }
    addMilliseconds(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond + value);
    }
    addTicks(value) {
        return new DateTime(this.ticks + value);
    }
    compareTo(value) {
        if (this.ticks < value.ticks)
            return -1;
        if (this.ticks > value.ticks)
            return 1;
        return 0;
    }
    subtract(value) {
        return new TimeSpan(this.ticks - value.ticks);
    }
    get date() {
        return this.innerDate;
    }
    static oaDateToTicks0(oaDate) {
        let ticks = ((oaDate - 25569) * 86400000);
        if (oaDate < 0) {
            const frac = (oaDate - Math.trunc(oaDate)) * 86400000;
            if (frac !== 0) {
                ticks -= frac * 2;
            }
        }
        return ticks;
    }
    static ticksToOADate0(ticks) {
        let oad = (ticks / 86400000) + 25569;
        if (oad < 0) {
            const frac = oad - Math.trunc(oad);
            if (frac !== 0) {
                oad = Math.ceil(oad) - frac - 2;
            }
        }
        return oad;
    }
    toOADate() {
        //return (this.ticks / 86400000) + 25569;
        return DateTime.ticksToOADate0(this.ticks);
    }
    toOADate2(round) {
        let ticks = DateTime.ticksToOADate0(this.ticks);
        //let ticks = DateTime.ticksToOADate(this.ticks);
        if (round)
            return Math.round(ticks);
        return ticks;
    }
    toNetJsonString() {
        return "\\/Date(" + this.ticks.toString() + ")\\/";
    }
    static fromNetJsonString(jsonDate) {
        let m = /-?\d+/.exec(jsonDate);
        let date = new Date(parseInt(m[0]));
        return new DateTime(date);
    }
    static fromOADate(oadate) {
        return new DateTime(DateTime.oaDateToTicks0(oadate));
        //return new DateTime(((oadate - 25569) * 86400000));
        // return new DateTime(this.doubleDateToTicks(d));
    }
    static fromString(d = "2015-12-31", logError = true) {
        try {
            d = d.trim();
            let date = d.split(".").join("-").split("\\").join("-").split(" ").join("-");
            return new DateTime(new Date());
            let dayjsDate;
            /*if (date.indexOf("/") >= 0) {
              // Date
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              // DateTime
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-H:m", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-H:m:s", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-h:m:s-a", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-H:m", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-H:m:s", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-h:m:s-a", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              date = d.split("/").join("-");
            }
      
            // Date
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // DateTime
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s-SSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s-SSSSSSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // Time
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // ISO
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DD", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:sZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSSSSSZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSSSSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            if (logError) StiError.showError("Parse DateTime Error (" + d + ")", false);*/
            return null;
        }
        catch (e) {
            return null;
        }
    }
    /*
        static fromString2(format = "2015-12-31", value: string, logError = true): DateTime {
          try {
            let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(value, [format], true);
            if (dayjsDate.isValid() == false) {
              if (logError) StiError.showError("Parse DateTime Error (" + value + ")", false);
              return null;
            }
  
            return new DateTime(dayjsDate.toDate());
          }
          catch (e) {
          }
          return null;
        }
  
        static isISO8601String(d: string): boolean {
          try {
            d = d.trim();
  
            let dayjsDate;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DD", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mmZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSS", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSSSS", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ssZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSSSSZ", true);
            if (dayjsDate.isValid()) return true;
          }
          catch (e) {
          }
  
          return false;
        }*/
    get timeOfDay() {
        return new TimeSpan(this.ticks - new DateTime(this.year, this.month, this.day, 0, 0, 0, 0).ticks);
    }
    get date2() {
        return new DateTime(this.year, this.month, this.day, 0, 0, 0, 0);
    }
    constructor(param1, month, day, hour, minute, second, millisecond) {
        this.DateTimeOffset = "";
        if (typeof param1 == "undefined") {
            this.innerDate = new Date();
        }
        else if (typeof param1 != "number" && param1 instanceof Date) {
            this.innerDate = param1; // set date
        }
        else {
            if (!month) {
                this.innerDate = new Date();
                this.innerDate.setTime(param1); // set ticks
            }
            else {
                this.innerDate = new Date();
                this.innerDate.setFullYear(param1);
                this.innerDate.setMonth(month - 1);
                this.innerDate.setDate(day || 1);
                this.innerDate.setHours(hour || 0);
                this.innerDate.setMinutes(minute || 0);
                this.innerDate.setSeconds(second || 0);
                this.innerDate.setMilliseconds(millisecond || 0);
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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