/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import { Chars } from "./Chars";
import { UnicodeCategory } from "./UnicodeCategory";
export class Char {
    static isUpper(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.UppercaseLetter);
    }
    static isLower(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.LowercaseLetter);
    }
    static isLetter(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat);
    }
    static isDigit(char, index = 0) {
        if (char != null && typeof char == "number") {
            let cat = Chars.getUnicodeCategory(char);
            return (cat == UnicodeCategory.DecimalDigitNumber);
        }
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.DecimalDigitNumber);
    }
    static isLetterOrDigit(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat) || cat == UnicodeCategory.DecimalDigitNumber;
    }
    static toLower(char) {
        return char.toLocaleLowerCase();
    }
    static toUpper(char) {
        return char.toLocaleUpperCase();
    }
    static isWhitespace(char, index = 0, allowNbsp = true) {
        if (char == null || char.length < index + 1)
            return false;
        let code = char.charCodeAt(index);
        if ((code == 0x20) || (code >= 0x09 && code <= 0x0d) || (code == 0xa0 && allowNbsp) || code == 0x85)
            return true;
        let cat = Chars.getUnicodeCategory(code);
        return cat == UnicodeCategory.SpaceSeparator ||
            cat == UnicodeCategory.LineSeparator ||
            cat == UnicodeCategory.ParagraphSeparator;
    }
    static checkLetter(uc) {
        return uc == UnicodeCategory.UppercaseLetter ||
            uc == UnicodeCategory.LowercaseLetter ||
            uc == UnicodeCategory.TitlecaseLetter ||
            uc == UnicodeCategory.ModifierLetter ||
            uc == UnicodeCategory.OtherLetter;
    }
    static getUnicodeCategory(char, index = 0) {
        if (char == null || char.length < index + 1)
            return UnicodeCategory.OtherNotAssigned;
        let code = char.charCodeAt(index);
        return Chars.getUnicodeCategory(code);
    }
    static isControl(char, index = 0) {
        return Char.getUnicodeCategory(char, index) == UnicodeCategory.Control;
    }
}
//# sourceMappingURL=data:application/json;base64,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