import { Injectable } from "@angular/core";
import { StiComboBoxElement } from "./elements/StiComboBoxElement";
import { StiAddressElement } from "./elements/StiAddressElement";
import { StiBarcodeElement } from "./elements/StiBarcodeElement";
import { StiButtonElement } from "./elements/StiButtonElement";
import { StiCheckBoxElement } from "./elements/StiCheckBoxElement";
import { StiDateTimeBoxElement } from "./elements/StiDateTimeBoxElement";
import { StiForm } from "./elements/StiForm";
import { StiFormPageElement } from "./elements/StiFormPageElement";
import { StiImageElement } from "./elements/StiImageElement";
import { StiLabelElement } from "./elements/StiLabelElement";
import StiLineElement from "./elements/StiLineElement";
import { StiListBoxElement } from "./elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "./elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "./elements/StiNumberBoxElement";
import { StiPanelElement } from "./elements/StiPanelElement";
import { StiSignatureElement } from "./elements/StiSignatureElement";
import { StiSingleSelectionElement } from "./elements/StiSingleSelectionElement";
import { StiTableElement } from "./elements/StiTableElement";
import { StiTextBoxElement } from "./elements/StiTextBoxElement";
import { StiTextElement } from "./elements/StiTextElement";
import { Subject } from "rxjs";
import { first } from "rxjs/operators";
import * as i0 from "@angular/core";
export class StimulsoftFormsService {
    constructor() {
        this.serviceEvents = new Subject();
        this.serviceEventsCallbacks = new Subject();
    }
    /**
     * Post custom data to controller
     * @param data to send to controller
     * @param func callback function
     * @param options to send to controller
     */
    postData(data, func, options) {
        this.serviceEvents.next({ action: "postData", data: data, func: func, options: options });
    }
    /**
     * Add Element to Form
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     */
    addElementToForm(elementType) {
        if (!(this.createElement(elementType) instanceof StiFormPageElement) &&
            !(this.createElement(elementType) instanceof StiForm)) {
            this.serviceEvents.next({
                action: "addElementToForm",
                element: this.createElement(elementType),
            });
        }
    }
    /**
     * Show form tab
     * @param tabName
     * Home
     * Insert
     * Preview
     * PdfPreview
     */
    showTab(tabName) {
        switch (tabName.toLowerCase()) {
            case "home":
                this.serviceEvents.next({ action: "showTab", tabName: "Home" });
                break;
            case "insert":
                this.serviceEvents.next({ action: "showTab", tabName: "Insert" });
                break;
            case "preview":
                this.serviceEvents.next({ action: "showTab", tabName: "Preview" });
                break;
            case "pdfpreview":
                this.serviceEvents.next({ action: "showTab", tabName: "PDFPreview" });
                break;
            default:
                this.serviceEvents.next({ action: "showTab", tabName: "Home" });
                break;
        }
    }
    // Showing form file menu
    showFileMenu() {
        this.serviceEvents.next({ action: "showFileMenu" });
    }
    // Showing form save menu
    showSaveMenu() {
        this.serviceEvents.next({ action: "showSaveMenu" });
    }
    // Download pdf file of current form
    exportToPdf(readOnly = false, pdfACompliance = false) {
        this.serviceEvents.next({ action: "exportToPdf", readOnly: readOnly, pdfACompliance: pdfACompliance });
    }
    // Return pdf bytes of current form
    getPdfBytes(readOnly = false, pdfACompliance = false) {
        this.serviceEvents.next({ action: "getPdfBytes", readOnly: readOnly, pdfACompliance: pdfACompliance });
        return this.serviceEventsCallbacks
            .pipe(first())
            .toPromise()
            .then((data) => {
            if (data.action == "pdfBytesCallback") {
                return data.value;
            }
        });
    }
    /**
     * Set form zoom
     * @param zoom
     * PageWidth
     * OnePage
     * from 10%
     * to 400%
     */
    setZoom(zoom) {
        this.serviceEvents.next({ action: "setZoom", zoom: zoom });
    }
    /**
     * Create form element
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns Element object
     */
    createElement(elementType) {
        return new (this.getElementClass(elementType))();
    }
    /**
     * Get class of form element
     * @param type
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns element Class
     */
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftFormsService, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftFormsService, providedIn: "root" }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftFormsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: () => [] });
//# sourceMappingURL=data:application/json;base64,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