import { Injectable } from "@angular/core";
import { StiLocalizationService } from "./sti-localization.service";
import StiJson from "../system/StiJson";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiUserService {
    constructor(model) {
        this.model = model;
        this.showLocalizationPreview = false;
        this.showUserInfo = false;
        this.buildDate = new Date(2022, 8, 27);
        this.trialMessage = "";
    }
    get currentUser() {
        return this._currentUser;
    }
    set currentUser(value) {
        if (value) {
            if (value == "empty") {
                this._currentUser = null;
            }
            else {
                let user = this.model.toCamelCase(value);
                this._currentUser = user;
                if (user?.created && !this.model.isWebView && (!this.licenseProducts || this.licenseProducts.length == 0)) {
                    this.buildDate = StiJson.jsonDateFormatToDate(user.created).date;
                }
                if (this.model.properties) {
                    this.model.properties.developerRole = user.developerRole;
                }
            }
            this.checkLicense();
        }
    }
    getBackground(user) {
        let key = user?.userKey ? user?.userKey : user?.key ?? "key";
        var r = 0;
        var g = 0;
        var b = 0;
        for (var i = 0; i < key.length / 3; i += 3) {
            r += key.charCodeAt(i);
            g += key.charCodeAt(i + 1);
            b += key.charCodeAt(i + 2);
        }
        r = (r % 100) + 100;
        g = (g % 100) + 100;
        b = (b % 100) + 100;
        return `rgb(${r},${g}, ${b})`;
    }
    checkLicense() {
        this.model.userWasChecked = true;
        if (this.licenseProducts?.length > 0 || this.currentUser) {
            let expirationDate = 0;
            if (this.licenseProducts?.length > 0) {
                this.licenseProducts.forEach((product) => {
                    if (product.ident == "Ultimate" ||
                        product.ident == "FormsWeb" ||
                        product.ident == 1 ||
                        product.ident == 26 ||
                        product.ident == "BICloud" ||
                        product.ident == 18 ||
                        product.ident == "BIDesigner" ||
                        product.ident == 12) {
                        expirationDate = Math.max(expirationDate, new Date(product.expirationDate).getTime());
                    }
                });
            }
            if (this.currentUser) {
                this.model.userIsAuthorized = true;
            }
            if (expirationDate != 0 && expirationDate > this.buildDate.getTime()) {
                this.model.showTrialBar = this.currentUser?.developerRole == "Owner";
                this.model.showTrialModalWindow = false;
                this.model.showTrialTitle = this.currentUser?.developerRole == "Owner";
                this.model.userIsAuthorized = true;
            }
            else {
                this.showTrial();
            }
        }
        else {
            this.showTrial();
        }
    }
    resetTrial() {
        this.model.showTrialBar = true;
        this.model.showTrialTitle = true;
        this.model.canCloseTrialWindow = true;
        this.model.disableCloseButton = false;
        this.model.showTrialModalWindow = false;
    }
    showTrial() {
        let currentDate = new Date();
        let trDays = Math.floor((currentDate.getTime() - this.buildDate.getTime()) / 1000 / 60 / 60 / 24);
        this.trialMessage = StiLocalizationService.get("Notices", "YouUsingTrialVersion");
        this.resetTrial();
        if (trDays > 30) {
            this.model.disableCloseButton = true;
        }
        if (!this.model.buildDate) {
            return;
        }
        if (trDays > 45) {
            this.model.showTrialTitle = true;
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
        if (trDays > 60) {
            if (this.currentUser) {
                this.model.canCloseTrialWindow = false;
            }
            this.trialMessage = StiLocalizationService.get("Notices", "YourTrialHasExpired");
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUserService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUserService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUserService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXVzZXItc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9zZXJ2aWNlcy9zdGktdXNlci1zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFFM0MsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sNEJBQTRCLENBQUM7QUFDcEUsT0FBTyxPQUFPLE1BQU0sbUJBQW1CLENBQUM7OztBQUd4QyxNQUFNLE9BQU8sY0FBYztJQVN6QixZQUFtQixLQUFzQjtRQUF0QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQVBsQyw0QkFBdUIsR0FBWSxLQUFLLENBQUM7UUFDekMsaUJBQVksR0FBWSxLQUFLLENBQUM7UUFJOUIsY0FBUyxHQUFTLElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDeEMsaUJBQVksR0FBVyxFQUFFLENBQUM7SUFDWSxDQUFDO0lBRTlDLElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQUs7UUFDMUIsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUNWLElBQUksS0FBSyxJQUFJLE9BQU8sRUFBRSxDQUFDO2dCQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUMzQixDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQ3pDLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDO2dCQUN6QixJQUFJLElBQUksRUFBRSxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLE1BQU0sSUFBSSxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUMxRyxJQUFJLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO2dCQUNuRSxDQUFDO2dCQUVELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsQ0FBQztvQkFDMUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7Z0JBQzNELENBQUM7WUFDSCxDQUFDO1lBQ0QsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBQ3RCLENBQUM7SUFDSCxDQUFDO0lBQ0QsYUFBYSxDQUFDLElBQVM7UUFDckIsSUFBSSxHQUFHLEdBQUcsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxLQUFLLENBQUM7UUFDN0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ1YsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ1YsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ1YsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztZQUMzQyxDQUFDLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUN2QixDQUFDLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7WUFDM0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQzdCLENBQUM7UUFDRCxDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDO1FBQ3BCLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUM7UUFDcEIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQztRQUNwQixPQUFPLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztJQUNoQyxDQUFDO0lBRUQsWUFBWTtRQUNWLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQztRQUNqQyxJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUUsTUFBTSxHQUFHLENBQUMsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDekQsSUFBSSxjQUFjLEdBQUcsQ0FBQyxDQUFDO1lBQ3ZCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRSxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7b0JBQ3ZDLElBQ0UsT0FBTyxDQUFDLEtBQUssSUFBSSxVQUFVO3dCQUMzQixPQUFPLENBQUMsS0FBSyxJQUFJLFVBQVU7d0JBQzNCLE9BQU8sQ0FBQyxLQUFLLElBQUksQ0FBQzt3QkFDbEIsT0FBTyxDQUFDLEtBQUssSUFBSSxFQUFFO3dCQUNuQixPQUFPLENBQUMsS0FBSyxJQUFJLFNBQVM7d0JBQzFCLE9BQU8sQ0FBQyxLQUFLLElBQUksRUFBRTt3QkFDbkIsT0FBTyxDQUFDLEtBQUssSUFBSSxZQUFZO3dCQUM3QixPQUFPLENBQUMsS0FBSyxJQUFJLEVBQUUsRUFDbkIsQ0FBQzt3QkFDRCxjQUFjLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7b0JBQ3hGLENBQUM7Z0JBQ0gsQ0FBQyxDQUFDLENBQUM7WUFDTCxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JCLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDO1lBQ3JDLENBQUM7WUFDRCxJQUFJLGNBQWMsSUFBSSxDQUFDLElBQUksY0FBYyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQztnQkFDckUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxhQUFhLElBQUksT0FBTyxDQUFDO2dCQUNyRSxJQUFJLENBQUMsS0FBSyxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxhQUFhLElBQUksT0FBTyxDQUFDO2dCQUN2RSxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQztZQUNyQyxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ25CLENBQUM7UUFDSCxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUNuQixDQUFDO0lBQ0gsQ0FBQztJQUVELFVBQVU7UUFDUixJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUM7UUFDL0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDO1FBQ3RDLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDRCxTQUFTO1FBQ1AsSUFBSSxXQUFXLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUM3QixJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxFQUFFLENBQUMsR0FBRyxJQUFJLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUNsRyxJQUFJLENBQUMsWUFBWSxHQUFHLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsc0JBQXNCLENBQUMsQ0FBQztRQUNsRixJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDbEIsSUFBSSxNQUFNLEdBQUcsRUFBRSxFQUFFLENBQUM7WUFDaEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7UUFDdkMsQ0FBQztRQUNELElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQzFCLE9BQU87UUFDVCxDQUFDO1FBQ0QsSUFBSSxNQUFNLEdBQUcsRUFBRSxFQUFFLENBQUM7WUFDaEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDO1lBQ2pDLFVBQVUsQ0FBQyxHQUFHLEVBQUU7Z0JBQ2QsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7b0JBQ3JCLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDO2dCQUN6QyxDQUFDO1lBQ0gsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ1gsQ0FBQztRQUNELElBQUksTUFBTSxHQUFHLEVBQUUsRUFBRSxDQUFDO1lBQ2hCLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUNyQixJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztZQUN6QyxDQUFDO1lBQ0QsSUFBSSxDQUFDLFlBQVksR0FBRyxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLHFCQUFxQixDQUFDLENBQUM7WUFDakYsVUFBVSxDQUFDLEdBQUcsRUFBRTtnQkFDZCxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztvQkFDckIsSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUM7Z0JBQ3pDLENBQUM7WUFDSCxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDWCxDQUFDO0lBQ0gsQ0FBQzsrR0F6SFUsY0FBYzttSEFBZCxjQUFjOzs0RkFBZCxjQUFjO2tCQUQxQixVQUFVIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgU3RpSnNvbiBmcm9tIFwiLi4vc3lzdGVtL1N0aUpzb25cIjtcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGNsYXNzIFN0aVVzZXJTZXJ2aWNlIHtcclxuICBwcml2YXRlIF9jdXJyZW50VXNlcjogYW55O1xyXG4gIHB1YmxpYyBzaG93TG9jYWxpemF0aW9uUHJldmlldzogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBzaG93VXNlckluZm86IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgcHJldmlld1g6IG51bWJlcjtcclxuICBwdWJsaWMgcHJldmlld1k6IG51bWJlcjtcclxuICBwdWJsaWMgbGljZW5zZVByb2R1Y3RzOiBhbnk7XHJcbiAgcHVibGljIGJ1aWxkRGF0ZTogRGF0ZSA9IG5ldyBEYXRlKDIwMjIsIDgsIDI3KTtcclxuICBwdWJsaWMgdHJpYWxNZXNzYWdlOiBzdHJpbmcgPSBcIlwiO1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlKSB7IH1cclxuXHJcbiAgcHVibGljIGdldCBjdXJyZW50VXNlcigpIHtcclxuICAgIHJldHVybiB0aGlzLl9jdXJyZW50VXNlcjtcclxuICB9XHJcbiAgcHVibGljIHNldCBjdXJyZW50VXNlcih2YWx1ZSkge1xyXG4gICAgaWYgKHZhbHVlKSB7XHJcbiAgICAgIGlmICh2YWx1ZSA9PSBcImVtcHR5XCIpIHtcclxuICAgICAgICB0aGlzLl9jdXJyZW50VXNlciA9IG51bGw7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgbGV0IHVzZXIgPSB0aGlzLm1vZGVsLnRvQ2FtZWxDYXNlKHZhbHVlKTtcclxuICAgICAgICB0aGlzLl9jdXJyZW50VXNlciA9IHVzZXI7XHJcbiAgICAgICAgaWYgKHVzZXI/LmNyZWF0ZWQgJiYgIXRoaXMubW9kZWwuaXNXZWJWaWV3ICYmICghdGhpcy5saWNlbnNlUHJvZHVjdHMgfHwgdGhpcy5saWNlbnNlUHJvZHVjdHMubGVuZ3RoID09IDApKSB7XHJcbiAgICAgICAgICB0aGlzLmJ1aWxkRGF0ZSA9IFN0aUpzb24uanNvbkRhdGVGb3JtYXRUb0RhdGUodXNlci5jcmVhdGVkKS5kYXRlO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKHRoaXMubW9kZWwucHJvcGVydGllcykge1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5wcm9wZXJ0aWVzLmRldmVsb3BlclJvbGUgPSB1c2VyLmRldmVsb3BlclJvbGU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuY2hlY2tMaWNlbnNlKCk7XHJcbiAgICB9XHJcbiAgfVxyXG4gIGdldEJhY2tncm91bmQodXNlcjogYW55KSB7XHJcbiAgICBsZXQga2V5ID0gdXNlcj8udXNlcktleSA/IHVzZXI/LnVzZXJLZXkgOiB1c2VyPy5rZXkgPz8gXCJrZXlcIjtcclxuICAgIHZhciByID0gMDtcclxuICAgIHZhciBnID0gMDtcclxuICAgIHZhciBiID0gMDtcclxuICAgIGZvciAodmFyIGkgPSAwOyBpIDwga2V5Lmxlbmd0aCAvIDM7IGkgKz0gMykge1xyXG4gICAgICByICs9IGtleS5jaGFyQ29kZUF0KGkpO1xyXG4gICAgICBnICs9IGtleS5jaGFyQ29kZUF0KGkgKyAxKTtcclxuICAgICAgYiArPSBrZXkuY2hhckNvZGVBdChpICsgMik7XHJcbiAgICB9XHJcbiAgICByID0gKHIgJSAxMDApICsgMTAwO1xyXG4gICAgZyA9IChnICUgMTAwKSArIDEwMDtcclxuICAgIGIgPSAoYiAlIDEwMCkgKyAxMDA7XHJcbiAgICByZXR1cm4gYHJnYigke3J9LCR7Z30sICR7Yn0pYDtcclxuICB9XHJcblxyXG4gIGNoZWNrTGljZW5zZSgpIHtcclxuICAgIHRoaXMubW9kZWwudXNlcldhc0NoZWNrZWQgPSB0cnVlO1xyXG4gICAgaWYgKHRoaXMubGljZW5zZVByb2R1Y3RzPy5sZW5ndGggPiAwIHx8IHRoaXMuY3VycmVudFVzZXIpIHtcclxuICAgICAgbGV0IGV4cGlyYXRpb25EYXRlID0gMDtcclxuICAgICAgaWYgKHRoaXMubGljZW5zZVByb2R1Y3RzPy5sZW5ndGggPiAwKSB7XHJcbiAgICAgICAgdGhpcy5saWNlbnNlUHJvZHVjdHMuZm9yRWFjaCgocHJvZHVjdCkgPT4ge1xyXG4gICAgICAgICAgaWYgKFxyXG4gICAgICAgICAgICBwcm9kdWN0LmlkZW50ID09IFwiVWx0aW1hdGVcIiB8fFxyXG4gICAgICAgICAgICBwcm9kdWN0LmlkZW50ID09IFwiRm9ybXNXZWJcIiB8fFxyXG4gICAgICAgICAgICBwcm9kdWN0LmlkZW50ID09IDEgfHxcclxuICAgICAgICAgICAgcHJvZHVjdC5pZGVudCA9PSAyNiB8fFxyXG4gICAgICAgICAgICBwcm9kdWN0LmlkZW50ID09IFwiQklDbG91ZFwiIHx8XHJcbiAgICAgICAgICAgIHByb2R1Y3QuaWRlbnQgPT0gMTggfHxcclxuICAgICAgICAgICAgcHJvZHVjdC5pZGVudCA9PSBcIkJJRGVzaWduZXJcIiB8fFxyXG4gICAgICAgICAgICBwcm9kdWN0LmlkZW50ID09IDEyXHJcbiAgICAgICAgICApIHtcclxuICAgICAgICAgICAgZXhwaXJhdGlvbkRhdGUgPSBNYXRoLm1heChleHBpcmF0aW9uRGF0ZSwgbmV3IERhdGUocHJvZHVjdC5leHBpcmF0aW9uRGF0ZSkuZ2V0VGltZSgpKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG4gICAgICBpZiAodGhpcy5jdXJyZW50VXNlcikge1xyXG4gICAgICAgIHRoaXMubW9kZWwudXNlcklzQXV0aG9yaXplZCA9IHRydWU7XHJcbiAgICAgIH1cclxuICAgICAgaWYgKGV4cGlyYXRpb25EYXRlICE9IDAgJiYgZXhwaXJhdGlvbkRhdGUgPiB0aGlzLmJ1aWxkRGF0ZS5nZXRUaW1lKCkpIHtcclxuICAgICAgICB0aGlzLm1vZGVsLnNob3dUcmlhbEJhciA9IHRoaXMuY3VycmVudFVzZXI/LmRldmVsb3BlclJvbGUgPT0gXCJPd25lclwiO1xyXG4gICAgICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsTW9kYWxXaW5kb3cgPSBmYWxzZTtcclxuICAgICAgICB0aGlzLm1vZGVsLnNob3dUcmlhbFRpdGxlID0gdGhpcy5jdXJyZW50VXNlcj8uZGV2ZWxvcGVyUm9sZSA9PSBcIk93bmVyXCI7XHJcbiAgICAgICAgdGhpcy5tb2RlbC51c2VySXNBdXRob3JpemVkID0gdHJ1ZTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLnNob3dUcmlhbCgpO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICB0aGlzLnNob3dUcmlhbCgpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcmVzZXRUcmlhbCgpIHtcclxuICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsQmFyID0gdHJ1ZTtcclxuICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsVGl0bGUgPSB0cnVlO1xyXG4gICAgdGhpcy5tb2RlbC5jYW5DbG9zZVRyaWFsV2luZG93ID0gdHJ1ZTtcclxuICAgIHRoaXMubW9kZWwuZGlzYWJsZUNsb3NlQnV0dG9uID0gZmFsc2U7XHJcbiAgICB0aGlzLm1vZGVsLnNob3dUcmlhbE1vZGFsV2luZG93ID0gZmFsc2U7XHJcbiAgfVxyXG4gIHNob3dUcmlhbCgpIHtcclxuICAgIGxldCBjdXJyZW50RGF0ZSA9IG5ldyBEYXRlKCk7XHJcbiAgICBsZXQgdHJEYXlzID0gTWF0aC5mbG9vcigoY3VycmVudERhdGUuZ2V0VGltZSgpIC0gdGhpcy5idWlsZERhdGUuZ2V0VGltZSgpKSAvIDEwMDAgLyA2MCAvIDYwIC8gMjQpO1xyXG4gICAgdGhpcy50cmlhbE1lc3NhZ2UgPSBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIk5vdGljZXNcIiwgXCJZb3VVc2luZ1RyaWFsVmVyc2lvblwiKTtcclxuICAgIHRoaXMucmVzZXRUcmlhbCgpO1xyXG4gICAgaWYgKHRyRGF5cyA+IDMwKSB7XHJcbiAgICAgIHRoaXMubW9kZWwuZGlzYWJsZUNsb3NlQnV0dG9uID0gdHJ1ZTtcclxuICAgIH1cclxuICAgIGlmICghdGhpcy5tb2RlbC5idWlsZERhdGUpIHtcclxuICAgICAgcmV0dXJuO1xyXG4gICAgfVxyXG4gICAgaWYgKHRyRGF5cyA+IDQ1KSB7XHJcbiAgICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsVGl0bGUgPSB0cnVlO1xyXG4gICAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgICBpZiAodGhpcy5jdXJyZW50VXNlcikge1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5zaG93VHJpYWxNb2RhbFdpbmRvdyA9IHRydWU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9LCAzMDAwKTtcclxuICAgIH1cclxuICAgIGlmICh0ckRheXMgPiA2MCkge1xyXG4gICAgICBpZiAodGhpcy5jdXJyZW50VXNlcikge1xyXG4gICAgICAgIHRoaXMubW9kZWwuY2FuQ2xvc2VUcmlhbFdpbmRvdyA9IGZhbHNlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMudHJpYWxNZXNzYWdlID0gU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJOb3RpY2VzXCIsIFwiWW91clRyaWFsSGFzRXhwaXJlZFwiKTtcclxuICAgICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgICAgaWYgKHRoaXMuY3VycmVudFVzZXIpIHtcclxuICAgICAgICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsTW9kYWxXaW5kb3cgPSB0cnVlO1xyXG4gICAgICAgIH1cclxuICAgICAgfSwgMzAwMCk7XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==