import { Injectable } from "@angular/core";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiNameService {
    constructor(model) {
        this.model = model;
    }
    getElementName(component, prefix) {
        return StiNameService.getElementName2(component, this.model.form, prefix);
    }
    checkElementName(element) {
        let prefix = element.name;
        while (prefix && prefix.length > 0 && !isNaN(parseFloat(prefix[prefix.length - 1]))) {
            prefix = prefix.substring(0, prefix.length - 1);
        }
        return this.getElementName(element, prefix);
    }
    static getElementName2(component, form, prefix) {
        let index = prefix ? "" : 1;
        prefix = prefix && prefix.length > 0 ? prefix : component instanceof StiFormPageElement ? "Page" : component.type.replace("_", "").replace("Element", "");
        while (form.getElementByName(prefix + index) != null) {
            index = index == "" ? 2 : index + 1;
        }
        return prefix + index;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNameService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNameService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNameService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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