import { Injectable } from "@angular/core";
import { StiUsedFontsList } from "./objects";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./http-client.service";
export class StiFontService {
    constructor(model, httpService) {
        this.model = model;
        this.httpService = httpService;
        this.signatureFontsLoaded = false;
        this.checkedFonts = new StiUsedFontsList();
        model.formEvents.subscribe((e) => {
            if (this.model.getBrowserType() != "firefox") {
                if (e.name == "SetForm") {
                    this.checkFonts();
                }
                else if (e.name == "UpdateFonts") {
                    this.updateFonts(e.value);
                }
            }
        });
    }
    loadFont(fonts) {
        if (fonts.length > 0) {
            fonts.forEach((font) => {
                this.checkedFonts.add(font.fontFamily, font.fontStyle, font.fontSize);
            });
            this.httpService
                .post(this.model.requestUrl, { action: "GetFonts", fonts: fonts }, "json", { showProgress: false })
                .subscribe((data) => {
                if (Array.isArray(data)) {
                    this.loadFontsToCss(data);
                }
            });
        }
    }
    loadSignatureFonts() {
        if (!this.signatureFontsLoaded) {
            this.signatureFontsLoaded = true;
            this.httpService
                .post(this.model.requestUrl, { action: "GetSignatureFonts" }, "json", { showProgress: false })
                .subscribe((data) => {
                if (Array.isArray(data)) {
                    this.loadFontsToCss(data);
                }
            });
        }
    }
    loadFontsToCss(data) {
        data.forEach((item) => {
            let style = document.createElement("style");
            let cssText = "@font-face {\r\n" +
                "font-family: '" + item.originalFontFamily + "';\r\n" +
                (item.originalFontWeight ? "font-weight: " + item.originalFontWeight + ";\r\n" : "") +
                (item.originalFontStyle ? "font-style: " + item.originalFontStyle + ";\r\n" : "") +
                "src: url(" + item.contentForCss + "); }";
            style.innerHTML = cssText;
            style.id = item.originalFontFamily;
            let head = document.getElementsByTagName("head")[0];
            head.appendChild(style);
        });
    }
    checkFonts() {
        let usedFonts = new StiUsedFontsList();
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                element.getUsedFonts(usedFonts);
            });
        });
        let forceLoad = document.fonts.check("12px Dummy font name");
        let fontsToLoad = usedFonts.fonts.filter((f) => this.checkedFonts.fonts.indexOf(f) == -1 &&
            (forceLoad || !document?.fonts.check(f.fontStyle + " " + f.fontSize + "px '" + f.fontFamily + "'")));
        this.loadFont(fontsToLoad);
    }
    updateFonts(font) {
        let isChecked = this.checkedFonts.fonts.find((f) => f.fontFamily == font.fontFamily && f.fontSize == font.fontSize && f.fontStyle == font.fontStyle);
        if (!isChecked &&
            !document?.fonts?.check((font?.fontStyle ? font?.fontStyle : "") +
                " " +
                (font?.fontSize ? font?.fontSize : 12) +
                "px '" +
                (font?.fontFamily ? font?.fontFamily : "Arial") +
                "'")) {
            let fontToLoad = [];
            fontToLoad.push(font);
            this.loadFont(fontToLoad);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFontService, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFontService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFontService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }] });
//# sourceMappingURL=data:application/json;base64,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