import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiEditableContentService {
    constructor(model) {
        this.model = model;
        this.activeControl = false;
    }
    getIntEditableContent() {
        return this._editableContent;
    }
    get editableContent() {
        return this._editableContent || this.model.selectedComponent?.element?.getDefaultEditableContent();
    }
    set editableContent(value) {
        this._editableContent = value;
    }
    startEdit(editableElementRef = null) {
        editableElementRef = editableElementRef ?? this.editableElementRef;
        if (editableElementRef) {
            let caretOffset = this.getCaretOffset(editableElementRef.nativeElement ?? editableElementRef);
            this.activeControl = true;
            setTimeout(() => {
                this.activeControl = false;
                let el = editableElementRef.nativeElement ?? editableElementRef;
                el.focus();
                if (el.tagName.toLowerCase() != "label" && el?.innerText?.length > 0) {
                    this.setCaret(el, caretOffset);
                }
            }, 0);
        }
    }
    getCaretOffset(element) {
        let caretOffset = 0;
        let doc = element.ownerDocument || element.document;
        let win = doc.defaultView || doc.parentWindow;
        let sel;
        if (typeof win.getSelection != "undefined") {
            sel = win.getSelection();
            if (sel.rangeCount > 0) {
                let range = win.getSelection().getRangeAt(0);
                let preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                caretOffset = preCaretRange.toString().length;
            }
        }
        else if ((sel = doc.selection) && sel.type != "Control") {
            let textRange = sel.createRange();
            let preCaretTextRange = doc.body.createTextRange();
            preCaretTextRange.moveToElementText(element);
            preCaretTextRange.setEndPoint("EndToEnd", textRange);
            caretOffset = preCaretTextRange.text.length;
        }
        return caretOffset;
    }
    setCaret(el, caretOffset) {
        var range = document.createRange();
        var sel = window.getSelection();
        range.setStart(el.childNodes[0], caretOffset);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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