import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiLabelAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "./sti-barcode.service";
export class StiComponentResizerService {
    constructor(model, mouseService, render, barcodeService) {
        this.model = model;
        this.mouseService = mouseService;
        this.render = render;
        this.barcodeService = barcodeService;
        this.isResizing = false;
        this.startFromRight = false;
        this.startFromLeft = false;
        this.startFromBottom = false;
        this.startFromBottomLeft = false;
        this.startFromBottomRight = false;
        this.maxWidth = 0;
        this.minWidth = 0;
        this.columnWidth = 64.326;
        this.StartResizeSubj = new Subject();
        this.EndResizeSubj = new Subject();
        mouseService.getDocumentMouseUp().subscribe((event) => {
            document.body.style.cursor = "";
            if (this.isResizing) {
                this.EndResizeSubj.next({ event: "End Resize" });
            }
            this.currentPage = null;
            this.currentPanel = null;
            this.isResizing = false;
            this.model.canDrag = true;
            this.startFromRight = false;
            this.startFromLeft = false;
            this.startFromBottom = false;
            this.startFromBottomLeft = false;
            this.startFromBottomRight = false;
            this.model.cursor = "default";
        });
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resizeFromBottomRight(event);
            this.resizeFromBottomLeft(event);
            this.resizeFromLeft(event);
            this.resizeFromRight(event);
            this.resizeFromBottom(event);
        });
        model.formEvents.subscribe((e) => {
            if (e.name == "UpdateAllSizes") {
                this.elementsToUpdate = [];
                this.model.elementToUpdate = null;
                this.model.form.pages.forEach((p) => p.allElements.forEach((e) => this.elementsToUpdate.push(e)));
                this.updateElements();
            }
        });
    }
    updateElements() {
        if (this.elementsToUpdate.length > 0) {
            if (this.model.elementToUpdate == null) {
                this.model.elementToUpdate = this.elementsToUpdate.splice(0, 1)[0];
            }
            setTimeout(() => {
                this.updateElements();
            }, 0);
        }
        else {
        }
    }
    initResize(element, e, startPosition) {
        e.stopPropagation();
        document.body.style.cursor = "nwse-resize";
        this.freeAreaHeight = 0;
        this.startMouseX = e.clientX;
        this.startMouseY = e.clientY;
        this.startElementX = element.x;
        this.startHeight = element.height;
        this.model.lastFormState = this.model.form.saveToJsonObject().serialize();
        this.gridVerticalStep = this.model.form.settings.gridVerticalStep;
        element.width = this.startWidth = element.width;
        if (element instanceof StiSignatureElement || element instanceof StiImageElement) {
            this.startCanvasHeight = element.canvasHeight;
        }
        if (element instanceof StiBarcodeElement) {
            this.startCanvasHeight = element.Height;
        }
        this.element = element;
        this.maxWidth = 0;
        this.StartResizeSubj.next({ event: "Start Resize" });
        this.currentPage = this.model.getElementPage(element);
        this.currentPanel = this.model.getElementPanel(element);
        this.currentPage
            ? (this.maxWidth = this.currentPage?.contentAreaWidth)
            : (this.maxWidth = this.currentPanel.contentAreaWidth);
        this.minWidth = element.geometry.minWidth;
        let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
        otherElements.splice(otherElements.indexOf(this.element), 1);
        this.freeAreaHeight = this.render.getFreeToBottomResizeArea(this.element, otherElements);
        this.currentPage
            ? (this.columnWidth = Number((this.currentPage?.contentAreaWidth / this.model.form.settings.gridColumns).toFixed(2)))
            : (this.columnWidth = Number((this.currentPanel?.contentAreaWidth / this.model.form.settings.gridColumns).toFixed(2)));
        if (startPosition == "fromRight") {
            this.startFromRight = true;
            this.model.cursor = "ew-resize";
            element.width = Math.round((element.x + element.width) / this.columnWidth) * this.columnWidth - element.x;
            this.startWidth = element.width;
        }
        else if (startPosition == "fromLeft") {
            this.startFromLeft = true;
            this.model.cursor = "ew-resize";
            let startX = element.x;
            element.x = Math.round(element.x / this.columnWidth) * this.columnWidth;
            this.startElementX = element.x;
            element.width = startX > element.x ? element.width + (startX - element.x) : element.width - (element.x - startX);
            this.startWidth = element.width;
        }
        else if (startPosition == "fromBottom") {
            this.startFromBottom = true;
            this.model.cursor = "ns-resize";
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        else if (startPosition == "fromBottomLeft") {
            this.startFromBottomLeft = true;
            this.model.cursor = "nesw-resize";
            let startX = element.x;
            element.x = Math.round(element.x / this.columnWidth) * this.columnWidth;
            this.startElementX = element.x;
            element.width = startX > element.x ? element.width + (startX - element.x) : element.width - (element.x - startX);
            this.startWidth = element.width;
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        else if (startPosition == "fromBottomRight") {
            this.startFromBottomRight = true;
            this.model.cursor = "nwse-resize";
            element.width = Math.round((element.x + element.width) / this.columnWidth) * this.columnWidth - element.x;
            this.startWidth = element.width;
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        this.isResizing = true;
    }
    resizeFromBottomRight(event) {
        if (this.isResizing && this.startFromBottomRight) {
            let delta = this.startMouseX - event.clientX;
            let deltaTop = this.startMouseY - event.clientY;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
                else {
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
            }
            else {
                this.element.width = this.startWidth;
            }
            if (this.element.width + this.element.x > this.maxWidth) {
                this.element.width = this.maxWidth - this.element.x;
            }
            else if (this.element.width <= this.minWidth) {
                this.element.width = this.minWidth;
            }
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width =
                    this.element.width -
                        (this.element.label.alignment != StiLabelAlignment.Top ? this.element.label.width : 0) -
                        this.element.padding.right -
                        this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromBottomLeft(event) {
        if (this.isResizing && this.startFromBottomLeft) {
            let delta = this.startMouseX - event.clientX;
            let deltaTop = this.startMouseY - event.clientY;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.x = this.startElementX + this.columnWidth * step;
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
                else {
                    this.element.x = this.startElementX - this.columnWidth * step;
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
            }
            else {
                this.element.x = this.startElementX;
                this.element.width = this.startWidth;
            }
            if (this.element.x < 0) {
                this.element.x = 0;
                this.element.width = this.startWidth + this.startElementX;
            }
            else if (this.element.x + this.element.geometry.minWidth > this.startElementX + this.startWidth) {
                this.element.x = this.startWidth - this.element.geometry.minWidth + this.startElementX;
                this.element.width = this.element.geometry.minWidth;
            }
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width =
                    this.element.width -
                        (this.element.label.alignment != StiLabelAlignment.Top ? this.element.label.width : 0) -
                        this.element.padding.right -
                        this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromRight(event) {
        if (this.isResizing && this.startFromRight) {
            let delta = this.startMouseX - event.clientX;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
                else {
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
            }
            else {
                this.element.width = this.startWidth;
            }
            if (this.element.width + this.element.x > this.maxWidth) {
                this.element.width = this.maxWidth - this.element.x;
            }
            else if (this.element.width <= this.minWidth) {
                this.element.width = this.minWidth;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromLeft(event) {
        if (this.isResizing && this.startFromLeft) {
            let delta = this.startMouseX - event.clientX;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.x = this.startElementX + this.columnWidth * step;
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
                else {
                    this.element.x = this.startElementX - this.columnWidth * step;
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
            }
            else {
                this.element.x = this.startElementX;
                this.element.width = this.startWidth;
            }
            if (this.element.x < 0) {
                this.element.x = 0;
                this.element.width = this.startWidth + this.startElementX;
            }
            else if (this.element.x + this.element.geometry.minWidth > this.startElementX + this.startWidth) {
                this.element.x = this.startWidth - this.element.geometry.minWidth + this.startElementX;
                this.element.width = this.element.geometry.minWidth;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromBottom(event) {
        if (this.isResizing && this.startFromBottom) {
            let deltaTop = this.startMouseY - event.clientY;
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width = this.element.width - this.element.padding.right - this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentResizerService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: StiRectangleGeometryLayout }, { token: i3.StiBarcodeService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentResizerService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentResizerService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: StiRectangleGeometryLayout }, { type: i3.StiBarcodeService }] });
//# sourceMappingURL=data:application/json;base64,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