import { Injectable } from '@angular/core';
import Guid from '../system/Guid';
import StiJson from '../system/StiJson';
import { StiClipboardData } from './objects';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-helper.service";
import * as i3 from "./sti-name.service";
import * as i4 from "./sti-draggable.service";
export class StiClipboardService {
    constructor(model, helper, nameService, draggableService) {
        this.model = model;
        this.helper = helper;
        this.nameService = nameService;
        this.draggableService = draggableService;
        document.addEventListener("visibilitychange", () => {
            if (!document.hidden) {
                this.updateDataFromClipboard();
            }
        });
        this.updateDataFromClipboard();
    }
    get hasCopy() {
        return this.copiedElement ? true : false;
    }
    get canCopy() {
        return this.model.selectedComponent?.element ? false : true;
    }
    updateDataFromClipboard() {
        let this_ = this;
        this.loadDataFromClipboard().then(e => {
            if (e instanceof DOMException) {
                setTimeout(() => this_.updateDataFromClipboard(), 500);
            }
        });
    }
    loadDataFromClipboard(forceReadClipboard = false) {
        return navigator.permissions.query({ name: "clipboard-read" }).then(value => {
            try {
                return forceReadClipboard || value.state == "granted" ? navigator.clipboard.readText() : null;
            }
            catch {
                return null;
            }
        }).then(data => {
            try {
                if (data && data.indexOf("StiFormsClipboard") >= 0) {
                    let clipboardData = JSON.parse(data);
                    let clazz = this.helper.getElementClass(clipboardData.type);
                    let element = new clazz();
                    let jObject = new StiJson();
                    let elementStr = this.helper.base64Decode(clipboardData.value);
                    jObject.deserialize(elementStr);
                    element.loadFromJsonObject(jObject);
                    if (clipboardData.displayValue) {
                        element["displayValue"] = this.helper.base64Decode(clipboardData.displayValue);
                    }
                    this.copiedElement = element;
                }
            }
            catch {
                return null;
            }
        }).catch(e => { return e; });
    }
    pasteElement(event) {
        this.loadDataFromClipboard(true).then(() => {
            if (this.copiedElement) {
                let element = this.helper.clone(this.copiedElement);
                element.name = this.nameService.checkElementName(element);
                element.guid = Guid.newGuid().toString();
                this.draggableService.startDrag(event, element, false, true);
            }
        }).catch(reason => {
            //console.log(reason);
        });
    }
    copyElement() {
        let element = this.model.selectedComponent?.element;
        if (element)
            try {
                this.copiedElement = this.helper.clone(element);
                let elementStr = element.saveToJsonObject({}).serialize();
                let base64Element = this.helper.base64Encode(elementStr);
                let base64ElementValue = element["displayValue"] ? this.helper.base64Encode(element["displayValue"]) : null;
                let clipboardData = new StiClipboardData(base64Element, element.type, base64ElementValue);
                navigator.clipboard.writeText(JSON.stringify(clipboardData));
                this.loadDataFromClipboard(true);
            }
            catch (e) {
                //console.error(e);
            }
    }
    cutElement() {
        this.copyElement();
        this.helper.deleteSelectedComponent();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiClipboardService, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiNameService }, { token: i4.StiDraggableService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiClipboardService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiClipboardService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiNameService }, { type: i4.StiDraggableService }] });
//# sourceMappingURL=data:application/json;base64,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