import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
export class StiChangesService {
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.forceChanged = false;
        this.started = false;
        model.formEvents.subscribe((e) => {
            if (e.name == "SetForm" || e.name == "UpdateForm") {
                this.savedForm = this.model.form.saveToJsonObject({ notSerializeImages: true }).serialize();
            }
        });
    }
    start() {
        if (this.started) {
            return;
        }
        let this_ = this;
        setInterval(() => {
            if (this_.model.form &&
                this_.model.draggingElement == null &&
                !this_.mouseService.leftButtonDown &&
                this.model.elementToUpdate == null) {
                let s = this_.model.form.saveToJsonObject({ notSerializeImages: true }).serialize();
                let equals = this_.savedForm == s;
                if (!equals || this_.forceChanged) {
                    this_.savedForm = s;
                    this_.model.formEvents.next({ name: "FormChanged" });
                    this_.forceChanged = false;
                }
            }
        }, 1000);
    }
    forceChanges() {
        this.forceChanged = true;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiChangesService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiChangesService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiChangesService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }] });
//# sourceMappingURL=data:application/json;base64,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