import StiJson from "../system/StiJson";
export default class StiPadding {
    constructor(left = 0, top = 0, right = 0, bottom = 0, changesInterceptor) {
        this._left = 0;
        this._right = 0;
        this._top = 0;
        this._bottom = 0;
        this._left = left;
        this._right = right;
        this._top = top;
        this._bottom = bottom;
        this.changesInterceptor = changesInterceptor;
    }
    get left() {
        return this._left;
    }
    set left(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._left;
        this._left = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.left", value, oldPadding);
        }
    }
    get right() {
        return this._right;
    }
    set right(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._right;
        this._right = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.right", value, oldPadding);
        }
    }
    get top() {
        return this._top;
    }
    set top(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._top;
        this._top = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.top", value, oldPadding);
        }
    }
    get bottom() {
        return this._bottom;
    }
    set bottom(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._bottom;
        this._bottom = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.bottom", value, oldPadding);
        }
    }
    isChanged() {
        return this.savedPadding == null || !this.savedPadding.equals(this);
    }
    resetChanged() {
        this.savedPadding = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("Left", this.left);
        json.addPropertyNumber("Top", this.top);
        json.addPropertyNumber("Right", this.right);
        json.addPropertyNumber("Bottom", this.bottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Left":
                    this.left = property.value;
                    break;
                case "Top":
                    this.top = property.value;
                    break;
                case "Right":
                    this.right = property.value;
                    break;
                case "Bottom":
                    this.bottom = property.value;
                    break;
            }
        }
    }
    clone() {
        return new StiPadding(this.left, this.top, this.right, this.bottom);
    }
    equals(padding) {
        return (this.left == padding.left &&
            this.top == padding.top &&
            this.right == padding.right &&
            this.bottom == padding.bottom);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpUGFkZGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9wcm9wZXJ0aWVzL1N0aVBhZGRpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxPQUFPLE1BQU0sbUJBQW1CLENBQUM7QUFFeEMsTUFBTSxDQUFDLE9BQU8sT0FBTyxVQUFVO0lBUTdCLFlBQ0UsT0FBZSxDQUFDLEVBQ2hCLE1BQWMsQ0FBQyxFQUNmLFFBQWdCLENBQUMsRUFDakIsU0FBaUIsQ0FBQyxFQUNsQixrQkFBMEM7UUFWcEMsVUFBSyxHQUFHLENBQUMsQ0FBQztRQUNWLFdBQU0sR0FBRyxDQUFDLENBQUM7UUFDWCxTQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ1QsWUFBTyxHQUFHLENBQUMsQ0FBQztRQVNsQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztRQUNsQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztRQUNwQixJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQztRQUN0QixJQUFJLENBQUMsa0JBQWtCLEdBQUcsa0JBQWtCLENBQUM7SUFDL0MsQ0FBQztJQUVELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQy9ELElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDMUIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ2pELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsY0FBYyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztRQUM3RSxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBRUQsSUFBVyxLQUFLLENBQUMsS0FBYTtRQUM1QixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQy9ELElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7UUFDcEIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ2pELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsZUFBZSxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0lBRUQsSUFBVyxHQUFHLENBQUMsS0FBYTtRQUMxQixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQy9ELElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7UUFDbEIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ2pELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsYUFBYSxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztRQUM1RSxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBRUQsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQy9ELElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7UUFDckIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ2pELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQy9FLENBQUM7SUFDSCxDQUFDO0lBRU0sU0FBUztRQUNkLE9BQU8sSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBRU0sWUFBWTtRQUNqQixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztJQUNuQyxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsT0FBWTtRQUMzQixJQUFJLElBQUksR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzlDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVNLGtCQUFrQixDQUFDLElBQWE7UUFDckMsS0FBSyxJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQztZQUN2QyxRQUFRLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztnQkFDdEIsS0FBSyxNQUFNO29CQUNULElBQUksQ0FBQyxJQUFJLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDM0IsTUFBTTtnQkFDUixLQUFLLEtBQUs7b0JBQ1IsSUFBSSxDQUFDLEdBQUcsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUMxQixNQUFNO2dCQUNSLEtBQUssT0FBTztvQkFDVixJQUFJLENBQUMsS0FBSyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzVCLE1BQU07Z0JBQ1IsS0FBSyxRQUFRO29CQUNYLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDN0IsTUFBTTtZQUNWLENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUVNLEtBQUs7UUFDVixPQUFPLElBQUksVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBRU0sTUFBTSxDQUFDLE9BQW1CO1FBQy9CLE9BQU8sQ0FDTCxJQUFJLENBQUMsSUFBSSxJQUFJLE9BQU8sQ0FBQyxJQUFJO1lBQ3pCLElBQUksQ0FBQyxHQUFHLElBQUksT0FBTyxDQUFDLEdBQUc7WUFDdkIsSUFBSSxDQUFDLEtBQUssSUFBSSxPQUFPLENBQUMsS0FBSztZQUMzQixJQUFJLENBQUMsTUFBTSxJQUFJLE9BQU8sQ0FBQyxNQUFNLENBQzlCLENBQUM7SUFDSixDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGlDaGFuZ2VzSW50ZXJjZXB0b3IgfSBmcm9tIFwiLi4vc3lzdGVtL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IFN0aUpzb24gZnJvbSBcIi4uL3N5c3RlbS9TdGlKc29uXCI7XHJcblxyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBTdGlQYWRkaW5nIHtcclxuICBwcml2YXRlIHNhdmVkUGFkZGluZzogU3RpUGFkZGluZztcclxuICBwdWJsaWMgY2hhbmdlc0ludGVyY2VwdG9yOiBTdGlDaGFuZ2VzSW50ZXJjZXB0b3I7XHJcbiAgcHJpdmF0ZSBfbGVmdCA9IDA7XHJcbiAgcHJpdmF0ZSBfcmlnaHQgPSAwO1xyXG4gIHByaXZhdGUgX3RvcCA9IDA7XHJcbiAgcHJpdmF0ZSBfYm90dG9tID0gMDtcclxuXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBsZWZ0OiBudW1iZXIgPSAwLFxyXG4gICAgdG9wOiBudW1iZXIgPSAwLFxyXG4gICAgcmlnaHQ6IG51bWJlciA9IDAsXHJcbiAgICBib3R0b206IG51bWJlciA9IDAsXHJcbiAgICBjaGFuZ2VzSW50ZXJjZXB0b3I/OiBTdGlDaGFuZ2VzSW50ZXJjZXB0b3JcclxuICApIHtcclxuICAgIHRoaXMuX2xlZnQgPSBsZWZ0O1xyXG4gICAgdGhpcy5fcmlnaHQgPSByaWdodDtcclxuICAgIHRoaXMuX3RvcCA9IHRvcDtcclxuICAgIHRoaXMuX2JvdHRvbSA9IGJvdHRvbTtcclxuICAgIHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yID0gY2hhbmdlc0ludGVyY2VwdG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBsZWZ0KCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5fbGVmdDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgbGVmdCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkUGFkZGluZyA9IHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yID8gdGhpcy5jbG9uZSgpIDogbnVsbDtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2xlZnQ7XHJcbiAgICB0aGlzLl9sZWZ0ID0gdmFsdWU7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKFwicGFkZGluZy5sZWZ0XCIsIHZhbHVlLCBvbGRQYWRkaW5nKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgcmlnaHQoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9yaWdodDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgcmlnaHQodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFBhZGRpbmcgPSB0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciA/IHRoaXMuY2xvbmUoKSA6IG51bGw7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9yaWdodDtcclxuICAgIHRoaXMuX3JpZ2h0ID0gdmFsdWU7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKFwicGFkZGluZy5yaWdodFwiLCB2YWx1ZSwgb2xkUGFkZGluZyk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IHRvcCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX3RvcDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgdG9wKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGxldCBvbGRQYWRkaW5nID0gdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgPyB0aGlzLmNsb25lKCkgOiBudWxsO1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fdG9wO1xyXG4gICAgdGhpcy5fdG9wID0gdmFsdWU7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKFwicGFkZGluZy50b3BcIiwgdmFsdWUsIG9sZFBhZGRpbmcpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBib3R0b20oKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9ib3R0b207XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGJvdHRvbSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkUGFkZGluZyA9IHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yID8gdGhpcy5jbG9uZSgpIDogbnVsbDtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2JvdHRvbTtcclxuICAgIHRoaXMuX2JvdHRvbSA9IHZhbHVlO1xyXG4gICAgaWYgKHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yICYmIG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yLnByb3BlcnR5Q2hhbmdlZChcInBhZGRpbmcuYm90dG9tXCIsIHZhbHVlLCBvbGRQYWRkaW5nKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBpc0NoYW5nZWQoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5zYXZlZFBhZGRpbmcgPT0gbnVsbCB8fCAhdGhpcy5zYXZlZFBhZGRpbmcuZXF1YWxzKHRoaXMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHJlc2V0Q2hhbmdlZCgpIHtcclxuICAgIHRoaXMuc2F2ZWRQYWRkaW5nID0gdGhpcy5jbG9uZSgpO1xyXG4gIH1cclxuXHJcbiAgc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zOiBhbnkpOiBTdGlKc29uIHtcclxuICAgIGxldCBqc29uID0gbmV3IFN0aUpzb24oKTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJMZWZ0XCIsIHRoaXMubGVmdCk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5TnVtYmVyKFwiVG9wXCIsIHRoaXMudG9wKTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJSaWdodFwiLCB0aGlzLnJpZ2h0KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJCb3R0b21cIiwgdGhpcy5ib3R0b20pO1xyXG4gICAgcmV0dXJuIGpzb247XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJMZWZ0XCI6XHJcbiAgICAgICAgICB0aGlzLmxlZnQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJUb3BcIjpcclxuICAgICAgICAgIHRoaXMudG9wID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiUmlnaHRcIjpcclxuICAgICAgICAgIHRoaXMucmlnaHQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCb3R0b21cIjpcclxuICAgICAgICAgIHRoaXMuYm90dG9tID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGNsb25lKCk6IFN0aVBhZGRpbmcge1xyXG4gICAgcmV0dXJuIG5ldyBTdGlQYWRkaW5nKHRoaXMubGVmdCwgdGhpcy50b3AsIHRoaXMucmlnaHQsIHRoaXMuYm90dG9tKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBlcXVhbHMocGFkZGluZzogU3RpUGFkZGluZyk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIChcclxuICAgICAgdGhpcy5sZWZ0ID09IHBhZGRpbmcubGVmdCAmJlxyXG4gICAgICB0aGlzLnRvcCA9PSBwYWRkaW5nLnRvcCAmJlxyXG4gICAgICB0aGlzLnJpZ2h0ID09IHBhZGRpbmcucmlnaHQgJiZcclxuICAgICAgdGhpcy5ib3R0b20gPT0gcGFkZGluZy5ib3R0b21cclxuICAgICk7XHJcbiAgfVxyXG59XHJcbiJdfQ==