import StiJson from "../system/StiJson";
import { StiPen } from "./StiPen";
export class StiBorder {
    constructor(pen, drawLeft, drawTop, drawRight, drawBottom) {
        this.pen = pen;
        this.drawLeft = drawLeft;
        this.drawTop = drawTop;
        this.drawRight = drawRight;
        this.drawBottom = drawBottom;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Pen", this.pen.saveToJsonObject(options));
        json.addPropertyBool("DrawLeft", this.drawLeft);
        json.addPropertyBool("DrawTop", this.drawTop);
        json.addPropertyBool("DrawRight", this.drawRight);
        json.addPropertyBool("DrawBottom", this.drawBottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawLeft":
                    this.drawLeft = property.value;
                    break;
                case "DrawTop":
                    this.drawTop = property.value;
                    break;
                case "DrawBottom":
                    this.drawBottom = property.value;
                    break;
                case "DrawRight":
                    this.drawRight = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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