import StiJson from "../../../system/StiJson";
export class StiRadioButtonCellItem {
    constructor(name, isChecked) {
        this.name = name;
        this.isChecked = isChecked;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyBool("IsChecked", this.isChecked);
        return jObject;
    }
    get value() {
        return this.isChecked;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "IsChecked":
                    this.isChecked = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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