import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import StiFormObject from "../base/StiFormObject";
export class StiColumnItem extends StiFormObject {
    constructor(label, form) {
        super();
        this.label = label;
        this.form = form;
        this.headerAlignment = StiHorizontalAlignment.Left;
        this.cellAlignment = StiHorizontalAlignment.Left;
        this.headerForeColor = Color.black();
        this.headerBackColor = Color.transparent();
        this.backgroundColor = Color.transparent();
        this.cellBackColor = Color.white();
        this.cellForeColor = Color.black();
        this.cellBorderColor = Color.lightGray();
        this.font = new Font("Segoe UI", 10);
        this.useWordWrap = false;
    }
    setDefaultValues() { }
    copyFrom(parentItem) {
        this.headerAlignment = parentItem.headerAlignment;
        this.cellAlignment = parentItem.cellAlignment;
        this.headerForeColor = parentItem.headerForeColor.clone();
        this.headerBackColor = parentItem.headerBackColor.clone();
        this.backgroundColor = parentItem.backgroundColor.clone();
        this.cellBackColor = parentItem.cellBackColor.clone();
        this.cellForeColor = parentItem.cellForeColor.clone();
        this.cellBorderColor = parentItem.cellBorderColor.clone();
        this.font = parentItem.font.clone();
        this.useWordWrap = parentItem.useWordWrap;
    }
    createCell() {
        return null;
    }
    get eValue() {
        return this.label;
    }
    set eValue(value) {
        this.label = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.headerForeColor;
    }
    set eColor(value) {
        this.headerForeColor = value;
    }
    get eBackgroundColor() {
        return this.headerBackColor;
    }
    set eBackgroundColor(value) {
        this.headerBackColor = value;
    }
    get eContentAlignment() {
        return this.headerAlignment;
    }
    set eContentAlignment(value) {
        this.headerAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
    htmlStyle() {
        return this.eParent
            ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`
            : "";
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Label", this.label);
        jObject.addPropertyEnum("HeaderAlignment", StiHorizontalAlignment, this.headerAlignment);
        jObject.addPropertyEnum("CellAlignment", StiHorizontalAlignment, this.cellAlignment);
        jObject.addPropertyColor("HeaderBackColor", this.headerBackColor);
        jObject.addPropertyColor("HeaderForeColor", this.headerForeColor);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("CellBackColor", this.cellBackColor);
        jObject.addPropertyColor("CellForeColor", this.cellForeColor);
        jObject.addPropertyColor("CellBorderColor", this.cellBorderColor);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyNumber("Width", this.width);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = property.value;
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "HeaderAlignment":
                    this.headerAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "CellAlignment":
                    this.cellAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "HeaderBackColor":
                    this.headerBackColor = new Color();
                    this.headerBackColor.deserializeFromString(property.value);
                    break;
                case "HeaderForeColor":
                    this.headerForeColor = new Color();
                    this.headerForeColor.deserializeFromString(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "CellBackColor":
                    this.cellBackColor = new Color();
                    this.cellBackColor.deserializeFromString(property.value);
                    break;
                case "CellForeColor":
                    this.cellForeColor = new Color();
                    this.cellForeColor.deserializeFromString(property.value);
                    break;
                case "CellBorderColor":
                    this.cellBorderColor = new Color();
                    this.cellBorderColor.deserializeFromString(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
            }
        }
        if (!json.properties().find((property) => property.name == "Font")) {
            this.font = this.eParent.font.clone();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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