import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment, StiLineWeight } from "../../system/enums";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
export class StiInnerTextSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._borderWeight = StiLineWeight.Thin;
        this._contentAlignment = StiHorizontalAlignment.Left;
        this._backgroundColor = Color.white();
        this._backgroundColor.changesInterceptor = this;
        this._backgroundColor.propertyName = "backgroundColor";
        this._borderColor = Color.lightGray();
        this._borderColor.changesInterceptor = this;
        this._borderColor.propertyName = "borderColor";
        this._checkColor = Color.black();
        this._checkColor.changesInterceptor = this;
        this._checkColor.propertyName = "checkColor";
        this._color = Color.black();
        this._color.changesInterceptor = this;
        this._font._size = 10;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`innerText.${propName}`, value, oldObject);
    }
    get backgroundColor() {
        return this._backgroundColor;
    }
    set backgroundColor(value) {
        let oldValue = this._backgroundColor.clone();
        this._backgroundColor = value;
        this._backgroundColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("backgroundColor", value, oldValue);
        }
    }
    get borderColor() {
        return this._borderColor;
    }
    set borderColor(value) {
        let oldValue = this._borderColor.clone();
        this._borderColor = value;
        this._borderColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("borderColor", value, oldValue);
        }
    }
    get checkColor() {
        return this._checkColor;
    }
    set checkColor(value) {
        let oldValue = this._checkColor.clone();
        this._checkColor = value;
        this._checkColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("checkColor", value, oldValue);
        }
    }
    get borderWeight() {
        return this._borderWeight;
    }
    set borderWeight(value) {
        let oldValue = this._borderWeight;
        this._borderWeight = value;
        if (oldValue != value) {
            this.propertyChanged("borderWeight", value, oldValue);
        }
    }
    get contentAlignment() {
        return this._contentAlignment;
    }
    set contentAlignment(value) {
        let oldValue = this._contentAlignment;
        this._contentAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("contentAlignment", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        json.addPropertyColor("BorderColor", this.borderColor);
        json.addPropertyColor("CheckColor", this.checkColor);
        json.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        json.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                case "BackColor":
                    this._backgroundColor = new Color();
                    this._backgroundColor.changesInterceptor = this;
                    this._backgroundColor.propertyName = "backgroundColor";
                    this._backgroundColor.deserializeFromString(property.value);
                    break;
                case "BorderColor":
                    this._borderColor = new Color();
                    this._borderColor.changesInterceptor = this;
                    this._borderColor.propertyName = "borderColor";
                    this._borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this._checkColor = new Color();
                    this._checkColor.changesInterceptor = this;
                    this._checkColor.propertyName = "checkColor";
                    this._checkColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this._borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "contentAlignment":
                case "ContentAlignment":
                    this._contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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