import Guid from "../../system/Guid";
import StiJson from "../../system/StiJson";
export default class StiFormObject {
    constructor() {
        this.guid = Guid.newGuid().toString();
    }
    static { this.TYPE_PROPERTY_NAME = "Type"; }
    saveToJsonObject(options) {
        let json = new StiJson();
        if (this.type) {
            json.addPropertyString(StiFormObject.TYPE_PROPERTY_NAME, this.type.replace("_", ""));
        }
        json.addPropertyString("Guid", this.guid);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Guid":
                    this.guid = property.value;
                    break;
            }
        }
    }
    deserializeCollection(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let typeJson = property.value.value.filter((x) => x.name == StiFormObject.TYPE_PROPERTY_NAME);
            if (typeJson.length == 1) {
                let inst = this.createElementClass(typeJson[0].value);
                inst.loadFromJsonObject(property.value);
                result.push(inst);
            }
        }
        return result;
    }
    createElementClass(type) {
        return {};
    }
}
//# sourceMappingURL=data:application/json;base64,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