import StiPadding from "../properties/StiPadding";
import StiPagePaperKind from "../properties/StiPagePaperKind";
import StiFormObject from "./base/StiFormObject";
import { StiPanelElement } from "./StiPanelElement";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiButtonElement } from "./StiButtonElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import StiLineElement from "./StiLineElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiSignatureElement } from "./StiSignatureElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTableElement } from "./StiTableElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiTextElement } from "./StiTextElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import Color from "../system/Color";
import { PaperKind } from "../system/enums";
import { StiAddressElement } from "./StiAddressElement";
import { StiPDFSignatureElement } from "./StiPDFSignatureElement";
export class StiFormPageElement extends StiFormObject {
    static { this.PAGE_ELEMENTS = [
        StiBarcodeElement,
        StiButtonElement,
        StiCheckBoxElement,
        StiComboBoxElement,
        StiDateTimeBoxElement,
        StiImageElement,
        StiLabelElement,
        StiLineElement,
        StiListBoxElement,
        StiMultipleSelectionElement,
        StiSignatureElement,
        StiPDFSignatureElement,
        StiSingleSelectionElement,
        StiTableElement,
        StiTextBoxElement,
        StiTextElement,
        StiNumberBoxElement,
        StiPanelElement,
        StiAddressElement,
    ]; }
    get width() {
        return this.paperKind.width;
    }
    get height() {
        return this.paperKind.height;
    }
    set width(value) {
        this.paperKind.width = Number(value);
    }
    set height(value) {
        this.paperKind.height = Number(value);
    }
    get contentAreaWidth() {
        let padding = this.padding;
        return this.width - padding.left - padding.right;
    }
    get contentAreaHeight() {
        let padding = this.padding;
        return this.height - padding.top - padding.bottom;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        let oldValue = this._name;
        if (oldValue != value) {
            this._name = value;
        }
    }
    get allElements() {
        let elements = [];
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
        return elements;
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.removeProperty(StiFormObject.TYPE_PROPERTY_NAME);
        jObject.addPropertyJObject("Margins", this.padding.saveToJsonObject(options));
        jObject.addPropertyJObject("PaperKind", this.paperKind.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("Visible", this.visible);
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyString("BackgroundImage", this.backgroundImage?.substring(this.backgroundImage.indexOf(",") + 1));
        }
        jObject.addPropertyArray("Elements", this.elements);
        jObject.addPropertyStringNullOrEmpty("Name", this.name);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Visible":
                    this.visible = property.value;
                    break;
                case "Margins":
                    this.padding.loadFromJsonObject(property.value);
                    break;
                case "PaperKind":
                    this.paperKind.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor.deserializeFromString(property.value);
                    this.backgroundColor.a = 255;
                    break;
                case "BackgroundImage":
                    if (property.value) {
                        this.backgroundImage = "data:image/png;base64," + property.value;
                    }
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
    constructor(form) {
        super();
        this.type = "StiPageElement";
        this.elements = new Array();
        this.visible = true;
        this.padding = new StiPadding(39, 39, 39, 39);
        this.paperKind = StiPagePaperKind.fromStandardPaperKind(PaperKind.A4);
        this.backgroundColor = Color.white();
        this.form = form;
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement(this.form);
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement(this.form);
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement(this.form);
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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