import { Component, EventEmitter, Input, Output } from "@angular/core";
import { StiCheckBoxElement } from "../../elements/StiCheckBoxElement";
import { StiMultipleSelectionElement } from "../../elements/StiMultipleSelectionElement";
import { StiDateTimeBoxElement } from "../../elements/StiDateTimeBoxElement";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiSvgCheckBoxComponent {
    constructor(model) {
        this.model = model;
        this.useCustomOption = false;
        this.disablePlaceHolder = false;
        this.buttonClick = new EventEmitter();
        this.isCurrentOption = false;
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get isSafari() {
        return this.model.getBrowserType() == "safari" ? true : false;
    }
    get isCheckBox() {
        return this.element instanceof StiCheckBoxElement;
    }
    get backColor() {
        return this.element.backgroundColor.toHtmlColor();
    }
    get checkColor() {
        if (this.element instanceof StiCheckBoxElement) {
            return this.element?.checkColor.toHtmlColor();
        }
        else if (this.element instanceof StiMultipleSelectionElement) {
            return this.element?.checkColor.toHtmlColor();
        }
        else if (this.element instanceof StiDateTimeBoxElement) {
            return "black";
        }
    }
    get borderColor() {
        return this.element.borderColor.toHtmlColor();
    }
    get required() {
        return this.element["required"];
    }
    get tooltip() {
        return this.element instanceof StiDateTimeBoxElement ? "" : this.element["tooltip"];
    }
    get textStyle() {
        if (this.element instanceof StiCheckBoxElement) {
            return this.element?.text.htmlStyle();
        }
        else if (this.element instanceof StiMultipleSelectionElement) {
            return this.element?.htmlStyle();
        }
    }
    get needToFill() {
        return (this.element.required &&
            (!this.element.value || this.element.value.length == 0) &&
            this.model.hasEmptyReuiredFields);
    }
    setContent(innerText) {
        this.text = innerText;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState() {
        this.buttonClick.emit();
    }
    getContent(innerText) {
        if (this.isCurrentOption) {
            this.element.selectedOptions?.forEach((option) => {
                if (this.element.options?.indexOf(option) == -1) {
                    this.element.selectedOptions?.splice(this.element.selectedOptions.indexOf(option), 1);
                }
            });
            this.element.selectedOptions.push(innerText);
        }
        this.element["customOptionText"] = innerText;
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event))
            event.preventDefault();
    }
    checkOption() {
        if (this.element.selectedOptions.indexOf(this.element?.customOptionText) >= 0) {
            this.isCurrentOption = true;
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSvgCheckBoxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: { element: "element", id: "id", text: "text", state: "state", useCustomOption: "useCustomOption", disablePlaceHolder: "disablePlaceHolder", tabIndex: "tabIndex" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `
    <div
      class="custom-checkbox"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        [tabIndex]="tabIndex"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>

      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 19px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="disablePlaceHolder"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-checkbox other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        tooltipPosition="bottom"
        [tabIndex]="tabIndex"
        showDelay="500"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 19px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>

      <!--  <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, isInline: true, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label{margin-left:5px;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}label:hover{cursor:text}span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:100%;position:relative;display:flex}.custom-checkbox input[type=checkbox],.other input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:100;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSvgCheckBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-svg-checkbox-component", template: `
    <div
      class="custom-checkbox"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        [tabIndex]="tabIndex"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>

      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 19px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="disablePlaceHolder"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-checkbox other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        tooltipPosition="bottom"
        [tabIndex]="tabIndex"
        showDelay="500"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 19px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>

      <!--  <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label{margin-left:5px;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}label:hover{cursor:text}span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:100%;position:relative;display:flex}.custom-checkbox input[type=checkbox],.other input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:100;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], id: [{
                type: Input
            }], text: [{
                type: Input
            }], state: [{
                type: Input
            }], useCustomOption: [{
                type: Input
            }], disablePlaceHolder: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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