import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/http-client.service";
import * as i3 from "../services/sti-user-service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "@angular/common";
export class StiUserInfoComponent {
    constructor(model, httpService, userService, loc) {
        this.model = model;
        this.httpService = httpService;
        this.userService = userService;
        this.loc = loc;
    }
    get userInfo() {
        return { name: "My1 Company", mail: "Stimulsoft130@gmail.com" };
    }
    setEvent(event) {
        if (event == "Logout") {
            this.httpService.post("", { action: "InterfaceEvent", event: "LogoutButtonClick" }).subscribe(() => {
                if (!this.model.isWebView) {
                    this.model.userIsAuthorized = false;
                    this.userService.licenseProducts = [];
                    this.userService.currentUser = "empty";
                    this.userService.checkLicense();
                }
            });
        }
        else if (event == "Account") {
            this.httpService.post("", { action: "InterfaceEvent", event: "AccountButtonClick" }).subscribe(() => { });
        }
        else if (event == "Cloud") {
            this.httpService.post("", { action: "InterfaceEvent", event: "CloudButtonClick" }).subscribe(() => { });
        }
        this.userService.showUserInfo = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUserInfoComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiUserService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiUserInfoComponent, selector: "sti-user-info", ngImport: i0, template: `
    <div
      class="parent-user-info-container"
      [style.visibility]="userService.showUserInfo ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="350"
    >
      <div class="user-info">
        <div class="user-image">
          <img
            [style.width.px]="82"
            [style.height.px]="82"
            *ngIf="userService?.currentUser?.picture"
            src="data:image/jpeg;base64,{{ userService?.currentUser?.picture }}"
            alt=""
          />
          <div
            *ngIf="!userService?.currentUser?.picture"
            class="custom-image"
            [style.background-color]="userService.getBackground(userService.currentUser)"
          >
            <span [style.margin-top.px]="11">{{
              userService.currentUser
                ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : "") +
                  (userService.currentUser.lastName ? userService.currentUser.lastName[0] : "")
                : "MC"
            }}</span>
          </div>
        </div>
        <div class="info">
          <span [style.font-size.px]="18" [style.font-weight]="'bold'">{{
            userService.currentUser
              ? (userService.currentUser.firstName ? userService.currentUser.firstName : "") +
                " " +
                (userService.currentUser.lastName ? userService.currentUser.lastName : "")
              : "My1 Company"
          }}</span>
          <span>{{
            userService.currentUser
              ? userService.currentUser.userName
                ? userService.currentUser.userName
                : ""
              : userInfo.mail
          }}</span>
          <span class="link" (click)="setEvent('Cloud')">{{ loc.get2("Cloud", "Cloud") }}</span>
          <span class="link" (click)="setEvent('Account')">{{ loc.get2("Cloud", "Account") }}</span>
        </div>
      </div>
      <div class="logout">
        <div class="logout-button" (click)="setEvent('Logout')">
          <span>{{ loc.get2("Cloud", "ButtonLogout") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".parent-user-info-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;overflow:hidden;font-family:Segoe UI;box-shadow:0 0 7px #0000004d}.user-info{height:100%;width:100%;display:flex;overflow:hidden}.info{display:flex;flex-direction:column;font-size:13px;align-items:start;justify-content:center}.info span{margin:3px}.user-image{padding:15px}.user-image img{border-radius:40px}.logout{width:100%;height:60px;display:flex;justify-content:flex-end;align-items:flex-end;padding:10px}.logout-button{height:24px;min-width:60px;background-color:#3d6bba;display:flex;align-items:center;justify-content:center;font-size:13px;padding:0 10px;color:#fff}.logout-button:hover{background-color:#4377d0}.link{color:#5a83ad;border-bottom:1px solid transparent}.link:hover{border-color:#5a83ad}span{width:max-content}.custom-image{height:82px;width:82px;border-radius:40px;margin:0 5px;color:#fff;font-size:42px;display:flex;justify-content:center}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUserInfoComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-user-info", template: `
    <div
      class="parent-user-info-container"
      [style.visibility]="userService.showUserInfo ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="350"
    >
      <div class="user-info">
        <div class="user-image">
          <img
            [style.width.px]="82"
            [style.height.px]="82"
            *ngIf="userService?.currentUser?.picture"
            src="data:image/jpeg;base64,{{ userService?.currentUser?.picture }}"
            alt=""
          />
          <div
            *ngIf="!userService?.currentUser?.picture"
            class="custom-image"
            [style.background-color]="userService.getBackground(userService.currentUser)"
          >
            <span [style.margin-top.px]="11">{{
              userService.currentUser
                ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : "") +
                  (userService.currentUser.lastName ? userService.currentUser.lastName[0] : "")
                : "MC"
            }}</span>
          </div>
        </div>
        <div class="info">
          <span [style.font-size.px]="18" [style.font-weight]="'bold'">{{
            userService.currentUser
              ? (userService.currentUser.firstName ? userService.currentUser.firstName : "") +
                " " +
                (userService.currentUser.lastName ? userService.currentUser.lastName : "")
              : "My1 Company"
          }}</span>
          <span>{{
            userService.currentUser
              ? userService.currentUser.userName
                ? userService.currentUser.userName
                : ""
              : userInfo.mail
          }}</span>
          <span class="link" (click)="setEvent('Cloud')">{{ loc.get2("Cloud", "Cloud") }}</span>
          <span class="link" (click)="setEvent('Account')">{{ loc.get2("Cloud", "Account") }}</span>
        </div>
      </div>
      <div class="logout">
        <div class="logout-button" (click)="setEvent('Logout')">
          <span>{{ loc.get2("Cloud", "ButtonLogout") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".parent-user-info-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;overflow:hidden;font-family:Segoe UI;box-shadow:0 0 7px #0000004d}.user-info{height:100%;width:100%;display:flex;overflow:hidden}.info{display:flex;flex-direction:column;font-size:13px;align-items:start;justify-content:center}.info span{margin:3px}.user-image{padding:15px}.user-image img{border-radius:40px}.logout{width:100%;height:60px;display:flex;justify-content:flex-end;align-items:flex-end;padding:10px}.logout-button{height:24px;min-width:60px;background-color:#3d6bba;display:flex;align-items:center;justify-content:center;font-size:13px;padding:0 10px;color:#fff}.logout-button:hover{background-color:#4377d0}.link{color:#5a83ad;border-bottom:1px solid transparent}.link:hover{border-color:#5a83ad}span{width:max-content}.custom-image{height:82px;width:82px;border-radius:40px;margin:0 5px;color:#fff;font-size:42px;display:flex;justify-content:center}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiUserService }, { type: i4.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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