import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/sti-localization.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../../services/sti-user-service";
import * as i4 from "../../services/http-client.service";
export class StiTrialModalWindowComponent {
    constructor(loc, model, userService, httpService) {
        this.loc = loc;
        this.model = model;
        this.userService = userService;
        this.httpService = httpService;
    }
    upgradeClick() {
        if (this.model.canCloseTrialWindow) {
            this.model.showTrialModalWindow = !this.model.showTrialModalWindow;
        }
        else {
            if (this.model.isWebView) {
                this.httpService
                    .post("", {
                    action: "InterfaceEvent",
                    event: "ExpiredTrialButtonClick",
                    data: { message: this.userService.trialMessage },
                })
                    .subscribe(() => { });
            }
            else {
                window.location.href = "https://www.stimulsoft.com/en/online-store#embedded/forms/ultimate";
            }
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTrialModalWindowComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }, { token: i3.StiUserService }, { token: i4.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTrialModalWindowComponent, selector: "sti-trial-modal-window", ngImport: i0, template: `
    <div class="trial-modal">
      <div class="trial-navigation">
        <div class="designer-info">
          <span>{{ loc.getP("Designer") }}</span>
        </div>
        <div class="close-button" (click)="upgradeClick()">
          <i class="pi pi-times"></i>
        </div>
      </div>
      <div class="trial-info">
        <div class="trial-image">
          <img class="warning-image" [src]="model.getImage('images.Other.Warning.png')" alt="" />
        </div>
        <div class="trial-alert">
          <span>{{ loc.getP(userService.trialMessage) }}</span>
        </div>
      </div>
      <div class="close-container">
        <div class="agree-button" (click)="upgradeClick()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".pi{font-size:.825rem;color:var(--text-color)}.trial-modal{cursor:default;z-index:9999;width:550px;height:290px;position:absolute;left:calc(50% - 225px);top:calc(50% - 145px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.trial-navigation{width:100%;height:31px;display:flex}.designer-info{padding-left:15px;width:100%;height:100%;display:flex;align-items:center;justify-content:start}.designer-info span{font-size:15px;font-weight:700;color:#1c4786}.close-button{height:24px;width:28px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#dadada}.trial-info{height:173px;width:100%;display:flex;flex-direction:column}.trial-image{height:132px;display:flex;align-items:center;justify-content:center}.warning-image{width:112px;height:112px}.trial-alert{display:flex;align-items:center;justify-content:center;flex:1}.trial-alert span{font-size:16px;color:#1c4786}.close-container{display:flex;width:100%;justify-content:center;flex:1;padding-top:20px}.agree-button{width:200px;height:30px;display:flex;align-items:center;justify-content:center;border-radius:3px;background-color:#1c4786}.agree-button:hover{background-color:#3b629b}.agree-button span{color:#fff;font-size:14px}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTrialModalWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-trial-modal-window", template: `
    <div class="trial-modal">
      <div class="trial-navigation">
        <div class="designer-info">
          <span>{{ loc.getP("Designer") }}</span>
        </div>
        <div class="close-button" (click)="upgradeClick()">
          <i class="pi pi-times"></i>
        </div>
      </div>
      <div class="trial-info">
        <div class="trial-image">
          <img class="warning-image" [src]="model.getImage('images.Other.Warning.png')" alt="" />
        </div>
        <div class="trial-alert">
          <span>{{ loc.getP(userService.trialMessage) }}</span>
        </div>
      </div>
      <div class="close-container">
        <div class="agree-button" (click)="upgradeClick()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".pi{font-size:.825rem;color:var(--text-color)}.trial-modal{cursor:default;z-index:9999;width:550px;height:290px;position:absolute;left:calc(50% - 225px);top:calc(50% - 145px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.trial-navigation{width:100%;height:31px;display:flex}.designer-info{padding-left:15px;width:100%;height:100%;display:flex;align-items:center;justify-content:start}.designer-info span{font-size:15px;font-weight:700;color:#1c4786}.close-button{height:24px;width:28px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#dadada}.trial-info{height:173px;width:100%;display:flex;flex-direction:column}.trial-image{height:132px;display:flex;align-items:center;justify-content:center}.warning-image{width:112px;height:112px}.trial-alert{display:flex;align-items:center;justify-content:center;flex:1}.trial-alert span{font-size:16px;color:#1c4786}.close-container{display:flex;width:100%;justify-content:center;flex:1;padding-top:20px}.agree-button{width:200px;height:30px;display:flex;align-items:center;justify-content:center;border-radius:3px;background-color:#1c4786}.agree-button:hover{background-color:#3b629b}.agree-button span{color:#fff;font-size:14px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }, { type: i3.StiUserService }, { type: i4.StiHttpClientService }] });
//# sourceMappingURL=data:application/json;base64,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