import { Directive, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-tooltip.service";
import * as i2 from "../../services/model.service";
export class StiTooltipDirective {
    constructor(tooltipService, el, model) {
        this.tooltipService = tooltipService;
        this.el = el;
        this.model = model;
        this.active = false;
    }
    ngAfterViewInit() {
        const onMouseEnter = (event) => {
            this.active = true;
            this.tooltipService.text = this.text;
            this.tooltipService.position = this.tooltipPosition ? this.tooltipPosition : "bottom";
            this.tooltipService.delay = this.showDelay ? this.showDelay : 0;
            this.tooltipService.elementRect = this.model.getPositionRelativeToForm(this.el.nativeElement);
            if (this.text) {
                this.activate();
            }
        };
        const onClick = (event) => {
            this.deactivate();
        };
        const onMouseLeave = (event) => {
            this.deactivate();
        };
        this.el.nativeElement.addEventListener("mouseenter", onMouseEnter);
        this.el.nativeElement.addEventListener("click", onClick);
        this.el.nativeElement.addEventListener("mouseleave", onMouseLeave);
    }
    activate() {
        this.active = true;
        this.clearHideTimeout();
        if (this.showDelay) {
            this.showTimeout = setTimeout(() => {
                this.show();
            }, this.showDelay);
        }
        else {
            this.show();
        }
    }
    deactivate() {
        this.active = false;
        this.clearShowTimeout();
        this.hide();
    }
    show() {
        this.tooltipService.showTooltip = true;
    }
    hide() {
        this.tooltipService.showTooltip = false;
    }
    clearShowTimeout() {
        if (this.showTimeout) {
            clearTimeout(this.showTimeout);
            this.showTimeout = null;
        }
    }
    clearHideTimeout() {
        if (this.hideTimeout) {
            clearTimeout(this.hideTimeout);
            this.hideTimeout = null;
        }
    }
    ngOnDestroy() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTooltipDirective, deps: [{ token: i1.StiTooltipService }, { token: i0.ElementRef }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Directive }); }
    static { this.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "18.2.14", type: StiTooltipDirective, selector: "[stiTooltip]", inputs: { tooltipPosition: "tooltipPosition", text: ["stiTooltip", "text"], showDelay: "showDelay" }, ngImport: i0 }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTooltipDirective, decorators: [{
            type: Directive,
            args: [{ selector: "[stiTooltip]" }]
        }], ctorParameters: () => [{ type: i1.StiTooltipService }, { type: i0.ElementRef }, { type: i2.StiModelService }], propDecorators: { tooltipPosition: [{
                type: Input
            }], text: [{
                type: Input,
                args: ["stiTooltip"]
            }], showDelay: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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