import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-toolbar-resizer.service";
import * as i2 from "@angular/common";
import * as i3 from "./sti-tooltip/sti-tooltip.directive";
export class StiToolbarResizerComponent {
    constructor(toolbarResizerService) {
        this.toolbarResizerService = toolbarResizerService;
    }
    get isMaximize() {
        return this.toolbarResizerService.isMaximizeMode;
    }
    get isMinimize() {
        return this.toolbarResizerService.isMinimizeMode;
    }
    setMinimizeMode() {
        this.toolbarResizerService.isMinimizeMode = true;
        this.toolbarResizerService.isMaximizeMode = false;
        if (document.querySelector(".maximize")) {
            document.querySelector(".maximize")?.classList?.remove("maxMode");
        }
        document.querySelector(".minimize")?.classList?.add("minMode");
    }
    setMaximizeMode() {
        this.toolbarResizerService.isMinimizeMode = false;
        this.toolbarResizerService.isMaximizeMode = true;
        if (document.querySelector(".minimize")) {
            document.querySelector(".minimize")?.classList?.remove("minMode");
        }
        document.querySelector(".maximize")?.classList?.add("maxMode");
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolbarResizerComponent, deps: [{ token: i1.StiToolbarResizerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiToolbarResizerComponent, selector: "sti-toolbar-resizer", ngImport: i0, template: `
    <div class="toolbarResizer">
      <div
        class="resizer minimize"
        *ngIf="this.isMaximize"
        (mousedown)="setMinimizeMode()"
        stiTooltip="Minimize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
      <div
        class="resizer maximize"
        *ngIf="this.isMinimize"
        (mousedown)="setMaximizeMode()"
        stiTooltip="Maximize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
    </div>
    <style>
      .toolbarResizer {
      }
      .resizer {
        width: 8px;
        height: 30px;
        background-color: var(--toolbarResizer-color);
        border: 1px solid var(--toolbarResizerBorder-color);
        position: fixed;
        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);
      }
      .minimize {
        border-bottom-left-radius: 3px;
        border-top-left-radius: 3px;
        left: 192px;
      }
      .minimize:hover {
        background-color: var(--hover-color);
      }
      .point {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1px;
        height: 2px;
        background-color: rgb(119, 119, 119);
      }
      .maximize {
        border-top-right-radius: 3px;
        border-bottom-right-radius: 3px;
        left: 45px;
        margin-right: 10px;
      }
      .maximize:hover {
        background-color: var(--hover-color);
      }
      .maxMode {
        left: 192px;
      }
      .minMode {
        left: 45px;
      }
    </style>
  `, isInline: true, styles: ["\n      .toolbarResizer {\n      }\n      .resizer {\n        width: 8px;\n        height: 30px;\n        background-color: var(--toolbarResizer-color);\n        border: 1px solid var(--toolbarResizerBorder-color);\n        position: fixed;\n        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);\n      }\n      .minimize {\n        border-bottom-left-radius: 3px;\n        border-top-left-radius: 3px;\n        left: 192px;\n      }\n      .minimize:hover {\n        background-color: var(--hover-color);\n      }\n      .point {\n        position: absolute;\n        top: 50%;\n        left: 50%;\n        width: 1px;\n        height: 2px;\n        background-color: rgb(119, 119, 119);\n      }\n      .maximize {\n        border-top-right-radius: 3px;\n        border-bottom-right-radius: 3px;\n        left: 45px;\n        margin-right: 10px;\n      }\n      .maximize:hover {\n        background-color: var(--hover-color);\n      }\n      .maxMode {\n        left: 192px;\n      }\n      .minMode {\n        left: 45px;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolbarResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-toolbar-resizer",
                    template: `
    <div class="toolbarResizer">
      <div
        class="resizer minimize"
        *ngIf="this.isMaximize"
        (mousedown)="setMinimizeMode()"
        stiTooltip="Minimize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
      <div
        class="resizer maximize"
        *ngIf="this.isMinimize"
        (mousedown)="setMaximizeMode()"
        stiTooltip="Maximize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
    </div>
    <style>
      .toolbarResizer {
      }
      .resizer {
        width: 8px;
        height: 30px;
        background-color: var(--toolbarResizer-color);
        border: 1px solid var(--toolbarResizerBorder-color);
        position: fixed;
        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);
      }
      .minimize {
        border-bottom-left-radius: 3px;
        border-top-left-radius: 3px;
        left: 192px;
      }
      .minimize:hover {
        background-color: var(--hover-color);
      }
      .point {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1px;
        height: 2px;
        background-color: rgb(119, 119, 119);
      }
      .maximize {
        border-top-right-radius: 3px;
        border-bottom-right-radius: 3px;
        left: 45px;
        margin-right: 10px;
      }
      .maximize:hover {
        background-color: var(--hover-color);
      }
      .maxMode {
        left: 192px;
      }
      .minMode {
        left: 45px;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiToolbarResizerService }] });
//# sourceMappingURL=data:application/json;base64,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