import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/sti-helper.service";
import * as i2 from "../../services/model.service";
import * as i3 from "@angular/common";
export class StiTieredMenuComponent {
    constructor(helper, model) {
        this.helper = helper;
        this.model = model;
        this.baseZIndex = 9999;
        this.isInitialized = false;
    }
    ngAfterViewInit() {
        setTimeout(() => {
            this.isInitialized = true;
        });
    }
    getMenuTop() {
        let rect = this.model.getPositionRelativeToForm(this.parentElement);
        return this.isInitialized
            ? window.innerHeight - rect.top >= (this.menuElementRef ? this.menuElementRef?.nativeElement?.offsetHeight : 165)
                ? 0
                : this.menuElementRef
                    ? -(this.menuElementRef?.nativeElement?.offsetHeight - rect.height)
                    : -165
            : 0;
    }
    getMunuLeft() {
        let rect = this.model.getPositionRelativeToForm(this.parentElement);
        return window.innerWidth - rect.right >= 107 ? 100 : -107;
    }
    onMouseEnter(index) {
        this.currentHoveredElementIndex = index;
    }
    onMouseClick(item) {
        item.command(item);
        this.model.showTieredMenu = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTieredMenuComponent, deps: [{ token: i1.StiHelperService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTieredMenuComponent, selector: "sti-tiered-menu", inputs: { menu: "menu", parentElement: "parentElement", baseZIndex: "baseZIndex" }, viewQueries: [{ propertyName: "menuElementRef", first: true, predicate: ["menuElement"], descendants: true }], ngImport: i0, template: `<div
    class="tiered-menu-container"
    [style.left.px]="parentElement ? getMunuLeft() : model.tieredMenuX"
    [style.top.px]="parentElement ? getMenuTop() : model.tieredMenuY"
    [style.zIndex]="baseZIndex"
    #menuElement
  >
    <div
      class="tiered-menu-item"
      *ngFor="let item of menu; index as i"
      (mouseenter)="onMouseEnter(i)"
      (click)="item.command ? onMouseClick(item) : onMouseEnter(i)"
      #parentElement
    >
      <span class="item-label">{{ item.label }}</span>
      <span *ngIf="item.items"><i class="pi pi-chevron-right"></i></span>
      <sti-tiered-menu
        *ngIf="currentHoveredElementIndex == i && item.items"
        [menu]="item.items"
        [baseZIndex]="baseZIndex + 1"
        [parentElement]="parentElement"
      ></sti-tiered-menu>
    </div>
  </div>`, isInline: true, styles: [".tiered-menu-container{position:absolute;left:500px;top:500px;width:6.5rem;background:#fff;user-select:none;-webkit-user-select:none;border:1px solid #c8c8c8;box-shadow:0 0 6px #00000029;border-radius:3px;font-family:Segoe UI}.tiered-menu-item{width:calc(100% - 6px);display:flex;align-items:center;justify-content:center;margin:3px;font-size:13px;font-weight:400;padding:.3rem;color:#333;border-radius:3px;position:relative}.tiered-menu-item span{display:flex;align-items:center;height:100%}.tiered-menu-item:hover{background-color:#eaeaea;cursor:pointer}.item-label{flex:1;line-height:1}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: StiTieredMenuComponent, selector: "sti-tiered-menu", inputs: ["menu", "parentElement", "baseZIndex"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTieredMenuComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-tiered-menu", template: `<div
    class="tiered-menu-container"
    [style.left.px]="parentElement ? getMunuLeft() : model.tieredMenuX"
    [style.top.px]="parentElement ? getMenuTop() : model.tieredMenuY"
    [style.zIndex]="baseZIndex"
    #menuElement
  >
    <div
      class="tiered-menu-item"
      *ngFor="let item of menu; index as i"
      (mouseenter)="onMouseEnter(i)"
      (click)="item.command ? onMouseClick(item) : onMouseEnter(i)"
      #parentElement
    >
      <span class="item-label">{{ item.label }}</span>
      <span *ngIf="item.items"><i class="pi pi-chevron-right"></i></span>
      <sti-tiered-menu
        *ngIf="currentHoveredElementIndex == i && item.items"
        [menu]="item.items"
        [baseZIndex]="baseZIndex + 1"
        [parentElement]="parentElement"
      ></sti-tiered-menu>
    </div>
  </div>`, styles: [".tiered-menu-container{position:absolute;left:500px;top:500px;width:6.5rem;background:#fff;user-select:none;-webkit-user-select:none;border:1px solid #c8c8c8;box-shadow:0 0 6px #00000029;border-radius:3px;font-family:Segoe UI}.tiered-menu-item{width:calc(100% - 6px);display:flex;align-items:center;justify-content:center;margin:3px;font-size:13px;font-weight:400;padding:.3rem;color:#333;border-radius:3px;position:relative}.tiered-menu-item span{display:flex;align-items:center;height:100%}.tiered-menu-item:hover{background-color:#eaeaea;cursor:pointer}.item-label{flex:1;line-height:1}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiHelperService }, { type: i2.StiModelService }], propDecorators: { menu: [{
                type: Input
            }], parentElement: [{
                type: Input
            }], baseZIndex: [{
                type: Input
            }], menuElementRef: [{
                type: ViewChild,
                args: ["menuElement"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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