import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
export class StiTableComboboxComponent {
    get cell() {
        return this.item.cells[this.index];
    }
    get selectedIndex() {
        return this.item?.comboBoxOptions[this.cell?.selectedIndex ? this.cell?.selectedIndex : 0];
    }
    set selectedIndex(value) {
        this.item.comboBoxOptions.forEach((option, index) => {
            if (option == value) {
                this.cell.selectedIndex = index;
            }
        });
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableComboboxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableComboboxComponent, selector: "sti-table-combobox-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone" }, ngImport: i0, template: ` <select
    class="selection"
    name=""
    id=""
    [style]="object.font.htmlStyle()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.text-decoration]="'none'"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [(ngModel)]="selectedIndex"
    [tabIndex]="tabIndex"
    [disabled]="disabled"
  >
    <option
      *ngFor="let option of item?.comboBoxOptions"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style]="object.font.htmlStyle()"
    >
      {{ option }}
    </option>
  </select>`, isInline: true, styles: [".selection{width:99%;border:1px solid rgb(198,198,198);background:#fff;height:fit-content;padding:3px 4px;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:not([disabled]):hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgSelectOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i3.ɵNgSelectMultipleOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i3.SelectControlValueAccessor, selector: "select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]", inputs: ["compareWith"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableComboboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-combobox-component", template: ` <select
    class="selection"
    name=""
    id=""
    [style]="object.font.htmlStyle()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.text-decoration]="'none'"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [(ngModel)]="selectedIndex"
    [tabIndex]="tabIndex"
    [disabled]="disabled"
  >
    <option
      *ngFor="let option of item?.comboBoxOptions"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style]="object.font.htmlStyle()"
    >
      {{ option }}
    </option>
  </select>`, styles: [".selection{width:99%;border:1px solid rgb(198,198,198);background:#fff;height:fit-content;padding:3px 4px;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:not([disabled]):hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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