import { Component, Input } from "@angular/core";
import { StiTableElement } from "../elements/StiTableElement";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/mouse.service";
export class StiTableColumnResizerComponent {
    initResize(event) {
        event.stopPropagation();
        if (this.model.previewMode) {
            return;
        }
        this.isResizing = true;
        this.startPoint = event.clientX;
        if (this.resizableItem instanceof StiColumnItem) {
            this.startColumnWidth = this.resizableItem.width;
            this.maxWidth = this.startColumnWidth + this.element.columns[this.index + 1].width;
            this.adjacentColumnWidth = this.element.columns[this.index + 1].width;
        }
        else {
            this.startColumnWidth = this.resizableItem.rowLabelsWidth;
            this.maxWidth = this.startColumnWidth + this.element.columns[0].width;
            this.adjacentColumnWidth = this.element.columns[0].width;
        }
    }
    resize(event) {
        if (this.isResizing) {
            let delta = event.clientX - this.startPoint;
            if (this.startColumnWidth + delta >= this.minWidth && this.adjacentColumnWidth - delta >= this.minWidth) {
                if (this.resizableItem instanceof StiColumnItem) {
                    this.resizableItem.width = this.startColumnWidth + delta;
                    this.element.columns[this.index + 1].width = this.adjacentColumnWidth - delta;
                }
                else {
                    this.resizableItem.rowLabelsWidth = this.startColumnWidth + delta;
                    this.element.columns[0].width = this.adjacentColumnWidth - delta;
                }
            }
            else {
                if (this.resizableItem instanceof StiColumnItem) {
                    if (this.startColumnWidth + delta <= this.minWidth) {
                        this.resizableItem.width = this.minWidth;
                        this.element.columns[this.index + 1].width = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth - delta <= this.minWidth) {
                        this.element.columns[this.index + 1].width = this.minWidth;
                        this.resizableItem.width = this.maxWidth - this.minWidth;
                    }
                }
                else {
                    if (this.startColumnWidth + delta <= this.minWidth) {
                        this.resizableItem.rowLabelsWidth = this.minWidth;
                        this.element.columns[0].width = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth - delta <= this.minWidth) {
                        this.element.columns[0].width = this.minWidth;
                        this.resizableItem.rowLabelsWidth = this.maxWidth - this.minWidth;
                    }
                }
            }
        }
    }
    get showResizePreview() {
        return this.element instanceof StiTableElement &&
            !this.model.previewMode &&
            ((!this.element.gridLines.drawVertical && this.resizableItem instanceof StiColumnItem) ||
                (!this.element.columnHeadersBorder.drawLeft && !(this.resizableItem instanceof StiColumnItem))) &&
            this.model.selectedComponent?.element == this.element
            ? true
            : false;
    }
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.minWidth = 40;
        this.isResizing = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnResizerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableColumnResizerComponent, selector: "sti-table-column-resizer", inputs: { resizableItem: "resizableItem", element: "element", index: "index" }, ngImport: i0, template: `
    <div
      class="column-resizer"
      (mousedown)="initResize($event)"
      [style.border-right]="showResizePreview ? '1px solid black' : ''"
      [style.cursor]="model.previewMode ? 'default' : 'ew-resize'"
    ></div>
    <style>
      .column-resizer {
        height: 100%;
        width: 5px;
        position: absolute;
        opacity: 0.5;
        top: 0;
        right: 0;
      }
      .column-resizer:hover {
        cursor: ew-resize;
      }
    </style>
  `, isInline: true, styles: ["\n      .column-resizer {\n        height: 100%;\n        width: 5px;\n        position: absolute;\n        opacity: 0.5;\n        top: 0;\n        right: 0;\n      }\n      .column-resizer:hover {\n        cursor: ew-resize;\n      }\n    "] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-column-resizer",
                    template: `
    <div
      class="column-resizer"
      (mousedown)="initResize($event)"
      [style.border-right]="showResizePreview ? '1px solid black' : ''"
      [style.cursor]="model.previewMode ? 'default' : 'ew-resize'"
    ></div>
    <style>
      .column-resizer {
        height: 100%;
        width: 5px;
        position: absolute;
        opacity: 0.5;
        top: 0;
        right: 0;
      }
      .column-resizer:hover {
        cursor: ew-resize;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }], propDecorators: { resizableItem: [{
                type: Input
            }], element: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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