import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../svg.components/svg.radiobutton.component";
export class StiSingleSelectionComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get columns() {
        return (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) >
            this.element.columns
            ? new Array(Number(this.element.columns)).fill(3)
            : new Array(this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length).fill(1);
    }
    get rows() {
        return this.element.useCustomOption
            ? new Array(Math.ceil((this.element.options.length + 1) / Number(this.element.columns))).fill(2)
            : new Array(Math.ceil(this.element.options.length / Number(this.element.columns))).fill(2);
    }
    getColumns(rowIndex) {
        if ((this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
            Number(this.element.columns) * rowIndex >=
            Number(this.element.columns)) {
            return new Array(Number(this.element.columns)).fill(3);
        }
        else {
            let count = (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
                Number(this.element.columns) * rowIndex;
            return new Array(Number(count)).fill(3);
        }
    }
    get align() {
        return "start";
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState(option) {
        this.element.selectedOption = option;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSingleSelectionComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSingleSelectionComponent, selector: "sti-singleselection-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-single-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element?.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-radiobutton-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [state]="
                      element?.options[i * element.columns + idx] == element?.selectedOption && element?.selectedOption
                    "
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-radiobutton-component>
                  <sti-svg-radiobutton-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [id]="'SingleSelectionCustomOption'"
                    [text]="element?.customOptionText"
                    [state]="element?.customOptionText == element?.selectedOption"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-radiobutton-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}.custom-radio{position:absolute;opacity:0;z-index:-1;left:0}tr{width:100%;max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiSvgRadiobuttonComponent, selector: "sti-svg-radiobutton-component", inputs: ["element", "id", "text", "state", "useCustomOption", "tabIndex"], outputs: ["buttonClick"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSingleSelectionComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-singleselection-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-single-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element?.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-radiobutton-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [state]="
                      element?.options[i * element.columns + idx] == element?.selectedOption && element?.selectedOption
                    "
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-radiobutton-component>
                  <sti-svg-radiobutton-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [id]="'SingleSelectionCustomOption'"
                    [text]="element?.customOptionText"
                    [state]="element?.customOptionText == element?.selectedOption"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-radiobutton-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}.custom-radio{position:absolute;opacity:0;z-index:-1;left:0}tr{width:100%;max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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