import { Component, Input, ViewChild, } from "@angular/core";
import { StiLabelAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-component";
import * as i8 from "../sti-editable-content.component";
export class StiPDFSignatureComponent {
    get align() {
        return "start";
    }
    get cursor() {
        return this.signatureService.drawingMode
            ? `url(${this.model.getImage("signature.Brush.png")}) 8 ${16 * window.devicePixelRatio - 4 * window.devicePixelRatio}, auto`
            : "";
    }
    get canvasWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return (this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left - 2);
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left;
            }
        }
    }
    get canvasHeight() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top) {
                return this.element.height - this.element.padding.top - this.element.padding.bottom;
            }
            else {
                return (this.element.height -
                    (this.labelRef?.offsetHeight ? this.labelRef?.offsetHeight : 0) -
                    this.element.padding.top -
                    this.element.padding.bottom -
                    (this.labelRef?.offsetHeight ? this.topMargin : 0));
            }
        }
    }
    constructor(model, mouse, resize, loc, signatureService, cdr) {
        this.model = model;
        this.mouse = mouse;
        this.resize = resize;
        this.loc = loc;
        this.signatureService = signatureService;
        this.cdr = cdr;
        this.isClone = false;
        this.topMargin = 8;
    }
    ngAfterContentChecked() { }
    ngOnDestroy() { }
    ngDoCheck() {
        this.labelRef = this.label ? this.label["elementRef"]["nativeElement"] : null;
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.sigPad;
            this.cdr.detectChanges();
        }
    }
    onMouseDown(event) { }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPDFSignatureComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiComponentResizerService }, { token: i4.StiLocalizationService }, { token: i5.SignatureService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPDFSignatureComponent, selector: "sti-pdf-signature-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "sigPad", first: true, predicate: ["sigPad"], descendants: true }, { propertyName: "text", first: true, predicate: ["textPreview"], descendants: true }, { propertyName: "ref", first: true, predicate: ["ref"], descendants: true }, { propertyName: "label", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-signature">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
      #label
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div [style.align-self]="align" [style.position]="'relative'" [style.display]="'flex'">
            <div
              class="canvas"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.cursor]="cursor"
            ></div>
            <div
              class="digital-signature"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.border]="model.previewMode ? '' : '1px dashed lightgray'"
              [style.background-color]="element?.placeholderBackColor.toHtmlColor()"
              [style.position]="'absolute'"
              [style.left]="0"
              [style.top]="0"
              #sigPad
            >
              <h2>{{ element.placeholder }}</h2>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td>
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.digital-signature{background-color:#d3d3d3;text-align:center;display:flex;align-items:center;justify-content:center;overflow:hidden}.digital-signature h2{color:red;margin:0;font-size:8px}input{visibility:hidden;width:0px}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i8.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPDFSignatureComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-pdf-signature-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-signature">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
      #label
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div [style.align-self]="align" [style.position]="'relative'" [style.display]="'flex'">
            <div
              class="canvas"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.cursor]="cursor"
            ></div>
            <div
              class="digital-signature"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.border]="model.previewMode ? '' : '1px dashed lightgray'"
              [style.background-color]="element?.placeholderBackColor.toHtmlColor()"
              [style.position]="'absolute'"
              [style.left]="0"
              [style.top]="0"
              #sigPad
            >
              <h2>{{ element.placeholder }}</h2>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td>
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.digital-signature{background-color:#d3d3d3;text-align:center;display:flex;align-items:center;justify-content:center;overflow:hidden}.digital-signature h2{color:red;margin:0;font-size:8px}input{visibility:hidden;width:0px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiComponentResizerService }, { type: i4.StiLocalizationService }, { type: i5.SignatureService }, { type: i0.ChangeDetectorRef }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], sigPad: [{
                type: ViewChild,
                args: ["sigPad"]
            }], text: [{
                type: ViewChild,
                args: ["textPreview"]
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }], label: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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