import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-component-resizer.service";
import * as i2 from "../services/model.service";
import * as i3 from "@angular/common";
export class StiPageGridOverlayComponent {
    constructor(componentResizerService, model) {
        this.componentResizerService = componentResizerService;
        this.model = model;
    }
    get paddingLeft() {
        return this.model.lastUsedPage?.padding.left;
    }
    get paddingRight() {
        return this.model.lastUsedPage?.padding.right;
    }
    get paddingTop() {
        return this.model.lastUsedPage?.padding.top;
    }
    get paddingBottom() {
        return this.model.lastUsedPage?.padding.bottom;
    }
    get columns() {
        return new Array(Number(this.model.form.settings.gridColumns)).fill(3);
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPageGridOverlayComponent, deps: [{ token: i1.StiComponentResizerService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPageGridOverlayComponent, selector: "sti-page-grid-overlay", ngImport: i0, template: `
    <div
      class="grid-overlay"
      [style.opacity]="componentResizerService.isResizing || this.model.pageWithGrid ? 0.5 : 0"
      [style.padding-left.px]="this.paddingLeft"
      [style.padding-right.px]="this.paddingRight"
      [style.padding-top.px]="this.paddingTop"
      [style.padding-bottom.px]="this.paddingBottom"
    >
      <div class="column {{ i == columns.length - 1 ? 'last' : '' }}" *ngFor="let column of columns; index as i"></div>
    </div>

    <style>
      .grid-overlay {
        position: absolute;
        pointer-events: none;
        width: 100%;
        height: 100%;
        top: 0px;
        left: 0px;
        display: flex;
        opacity: 0;
        padding: 10px;
        transition: opacity 0.3s ease 0s;
        z-index: 1;
      }

      .column {
        width: 100%;
        margin: 0px;
        position: relative;
      }

      .column::before {
        content: "";
        position: absolute;
        left: 0px;
        top: 0px;
        width: 1px;
        height: 100%;
        background-color: rgb(234, 234, 234);
      }

      .column.last::after {
        content: "";
        position: absolute;
        right: 0px;
        top: 0px;
        width: 1px;
        height: 100%;
        background-color: rgb(234, 234, 234);
      }
    </style>
  `, isInline: true, styles: ["\n      .grid-overlay {\n        position: absolute;\n        pointer-events: none;\n        width: 100%;\n        height: 100%;\n        top: 0px;\n        left: 0px;\n        display: flex;\n        opacity: 0;\n        padding: 10px;\n        transition: opacity 0.3s ease 0s;\n        z-index: 1;\n      }\n\n      .column {\n        width: 100%;\n        margin: 0px;\n        position: relative;\n      }\n\n      .column::before {\n        content: \"\";\n        position: absolute;\n        left: 0px;\n        top: 0px;\n        width: 1px;\n        height: 100%;\n        background-color: rgb(234, 234, 234);\n      }\n\n      .column.last::after {\n        content: \"\";\n        position: absolute;\n        right: 0px;\n        top: 0px;\n        width: 1px;\n        height: 100%;\n        background-color: rgb(234, 234, 234);\n      }\n    "], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPageGridOverlayComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-page-grid-overlay",
                    template: `
    <div
      class="grid-overlay"
      [style.opacity]="componentResizerService.isResizing || this.model.pageWithGrid ? 0.5 : 0"
      [style.padding-left.px]="this.paddingLeft"
      [style.padding-right.px]="this.paddingRight"
      [style.padding-top.px]="this.paddingTop"
      [style.padding-bottom.px]="this.paddingBottom"
    >
      <div class="column {{ i == columns.length - 1 ? 'last' : '' }}" *ngFor="let column of columns; index as i"></div>
    </div>

    <style>
      .grid-overlay {
        position: absolute;
        pointer-events: none;
        width: 100%;
        height: 100%;
        top: 0px;
        left: 0px;
        display: flex;
        opacity: 0;
        padding: 10px;
        transition: opacity 0.3s ease 0s;
        z-index: 1;
      }

      .column {
        width: 100%;
        margin: 0px;
        position: relative;
      }

      .column::before {
        content: "";
        position: absolute;
        left: 0px;
        top: 0px;
        width: 1px;
        height: 100%;
        background-color: rgb(234, 234, 234);
      }

      .column.last::after {
        content: "";
        position: absolute;
        right: 0px;
        top: 0px;
        width: 1px;
        height: 100%;
        background-color: rgb(234, 234, 234);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiComponentResizerService }, { type: i2.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXBhZ2UtZ3JpZC1vdmVybGF5LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3N0aS1wYWdlLWdyaWQtb3ZlcmxheS5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxNQUFNLGVBQWUsQ0FBQzs7Ozs7QUE2RGxELE1BQU0sT0FBTywyQkFBMkI7SUFDdEMsWUFBbUIsdUJBQW1ELEVBQVMsS0FBc0I7UUFBbEYsNEJBQXVCLEdBQXZCLHVCQUF1QixDQUE0QjtRQUFTLFVBQUssR0FBTCxLQUFLLENBQWlCO0lBQUcsQ0FBQztJQUN6RyxJQUFJLFdBQVc7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUM7SUFDL0MsQ0FBQztJQUNELElBQUksWUFBWTtRQUNkLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEVBQUUsT0FBTyxDQUFDLEtBQUssQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBSSxVQUFVO1FBQ1osT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFJLGFBQWE7UUFDZixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxNQUFNLENBQUM7SUFDakQsQ0FBQztJQUNELElBQUksT0FBTztRQUNULE9BQU8sSUFBSSxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN6RSxDQUFDO0lBQ0QsUUFBUSxLQUFJLENBQUM7K0dBakJGLDJCQUEyQjttR0FBM0IsMkJBQTJCLDZEQXZENUI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBcURUOzs0RkFFVSwyQkFBMkI7a0JBekR2QyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSx1QkFBdUI7b0JBQ2pDLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FxRFQ7aUJBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUNvbXBvbmVudFJlc2l6ZXJTZXJ2aWNlIH0gZnJvbSBcIi4uL3NlcnZpY2VzL3N0aS1jb21wb25lbnQtcmVzaXplci5zZXJ2aWNlXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktcGFnZS1ncmlkLW92ZXJsYXlcIixcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgPGRpdlxyXG4gICAgICBjbGFzcz1cImdyaWQtb3ZlcmxheVwiXHJcbiAgICAgIFtzdHlsZS5vcGFjaXR5XT1cImNvbXBvbmVudFJlc2l6ZXJTZXJ2aWNlLmlzUmVzaXppbmcgfHwgdGhpcy5tb2RlbC5wYWdlV2l0aEdyaWQgPyAwLjUgOiAwXCJcclxuICAgICAgW3N0eWxlLnBhZGRpbmctbGVmdC5weF09XCJ0aGlzLnBhZGRpbmdMZWZ0XCJcclxuICAgICAgW3N0eWxlLnBhZGRpbmctcmlnaHQucHhdPVwidGhpcy5wYWRkaW5nUmlnaHRcIlxyXG4gICAgICBbc3R5bGUucGFkZGluZy10b3AucHhdPVwidGhpcy5wYWRkaW5nVG9wXCJcclxuICAgICAgW3N0eWxlLnBhZGRpbmctYm90dG9tLnB4XT1cInRoaXMucGFkZGluZ0JvdHRvbVwiXHJcbiAgICA+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJjb2x1bW4ge3sgaSA9PSBjb2x1bW5zLmxlbmd0aCAtIDEgPyAnbGFzdCcgOiAnJyB9fVwiICpuZ0Zvcj1cImxldCBjb2x1bW4gb2YgY29sdW1uczsgaW5kZXggYXMgaVwiPjwvZGl2PlxyXG4gICAgPC9kaXY+XHJcblxyXG4gICAgPHN0eWxlPlxyXG4gICAgICAuZ3JpZC1vdmVybGF5IHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgcG9pbnRlci1ldmVudHM6IG5vbmU7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xyXG4gICAgICAgIHRvcDogMHB4O1xyXG4gICAgICAgIGxlZnQ6IDBweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIG9wYWNpdHk6IDA7XHJcbiAgICAgICAgcGFkZGluZzogMTBweDtcclxuICAgICAgICB0cmFuc2l0aW9uOiBvcGFjaXR5IDAuM3MgZWFzZSAwcztcclxuICAgICAgICB6LWluZGV4OiAxO1xyXG4gICAgICB9XHJcblxyXG4gICAgICAuY29sdW1uIHtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBtYXJnaW46IDBweDtcclxuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC5jb2x1bW46OmJlZm9yZSB7XHJcbiAgICAgICAgY29udGVudDogXCJcIjtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgbGVmdDogMHB4O1xyXG4gICAgICAgIHRvcDogMHB4O1xyXG4gICAgICAgIHdpZHRoOiAxcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMzQsIDIzNCwgMjM0KTtcclxuICAgICAgfVxyXG5cclxuICAgICAgLmNvbHVtbi5sYXN0OjphZnRlciB7XHJcbiAgICAgICAgY29udGVudDogXCJcIjtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgcmlnaHQ6IDBweDtcclxuICAgICAgICB0b3A6IDBweDtcclxuICAgICAgICB3aWR0aDogMXB4O1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjM0LCAyMzQsIDIzNCk7XHJcbiAgICAgIH1cclxuICAgIDwvc3R5bGU+XHJcbiAgYCxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aVBhZ2VHcmlkT3ZlcmxheUNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgY29uc3RydWN0b3IocHVibGljIGNvbXBvbmVudFJlc2l6ZXJTZXJ2aWNlOiBTdGlDb21wb25lbnRSZXNpemVyU2VydmljZSwgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHt9XHJcbiAgZ2V0IHBhZGRpbmdMZWZ0KCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RlbC5sYXN0VXNlZFBhZ2U/LnBhZGRpbmcubGVmdDtcclxuICB9XHJcbiAgZ2V0IHBhZGRpbmdSaWdodCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMubW9kZWwubGFzdFVzZWRQYWdlPy5wYWRkaW5nLnJpZ2h0O1xyXG4gIH1cclxuICBnZXQgcGFkZGluZ1RvcCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMubW9kZWwubGFzdFVzZWRQYWdlPy5wYWRkaW5nLnRvcDtcclxuICB9XHJcbiAgZ2V0IHBhZGRpbmdCb3R0b20oKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLmxhc3RVc2VkUGFnZT8ucGFkZGluZy5ib3R0b207XHJcbiAgfVxyXG4gIGdldCBjb2x1bW5zKCkge1xyXG4gICAgcmV0dXJuIG5ldyBBcnJheShOdW1iZXIodGhpcy5tb2RlbC5mb3JtLnNldHRpbmdzLmdyaWRDb2x1bW5zKSkuZmlsbCgzKTtcclxuICB9XHJcbiAgbmdPbkluaXQoKSB7fVxyXG59XHJcbiJdfQ==