import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../svg.components/svg.checkbox.component";
export class StiMultipleSelectionComponent {
    get columns() {
        return (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) >
            this.element.columns
            ? new Array(Number(this.element.columns)).fill(3)
            : new Array(this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length).fill(1);
    }
    get rows() {
        return this.element.useCustomOption
            ? new Array(Math.ceil((this.element.options.length + 1) / Number(this.element.columns))).fill(2)
            : new Array(Math.ceil(this.element.options.length / Number(this.element.columns))).fill(2);
    }
    getColumns(rowIndex) {
        if ((this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
            Number(this.element.columns) * rowIndex >=
            Number(this.element.columns)) {
            return new Array(Number(this.element.columns)).fill(3);
        }
        else {
            let count = (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
                Number(this.element.columns) * rowIndex;
            return new Array(Number(count)).fill(3);
        }
    }
    get align() {
        return "start";
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState(option) {
        if (this.element.selectedOptions.indexOf(option) >= 0) {
            this.element.selectedOptions.splice(this.element.selectedOptions.indexOf(option), 1);
        }
        else {
            this.element.selectedOptions.push(option);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiMultipleSelectionComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiMultipleSelectionComponent, selector: "sti-multipleselection-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-multiple-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-checkbox-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [state]="element.selectedOptions.indexOf(element?.options[i * element.columns + idx]) >= 0"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-checkbox-component>
                  <sti-svg-checkbox-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [id]="'MultipleSelectionCustomOption'"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [text]="element?.customOptionText"
                    [state]="element.selectedOptions.indexOf(element?.customOptionText) >= 0"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-checkbox-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}tr{max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: ["element", "id", "text", "state", "useCustomOption", "disablePlaceHolder", "tabIndex"], outputs: ["buttonClick"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiMultipleSelectionComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-multipleselection-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-multiple-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-checkbox-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [state]="element.selectedOptions.indexOf(element?.options[i * element.columns + idx]) >= 0"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-checkbox-component>
                  <sti-svg-checkbox-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [id]="'MultipleSelectionCustomOption'"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [text]="element?.customOptionText"
                    [state]="element.selectedOptions.indexOf(element?.customOptionText) >= 0"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-checkbox-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}tr{max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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