import { Component, Input, ViewChild } from "@angular/core";
import { StiInputTextItem } from "../helper/StiInputTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-helper.service";
import * as i3 from "../services/sti-editable-content.service";
import * as i4 from "@angular/forms";
export class StiInputTextComponent {
    get needToFill() {
        return this.element.required && !this.value && this.model.hasEmptyReuiredFields;
    }
    get value() {
        return this.helper.getProperty(this.element, this.property);
    }
    set value(val) {
        this.helper.setProperty(this.element, this.property, val);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    get placeholder() {
        return this.element.mask == null || this.element.mask.length == 0 ? "" : this.element.mask.replace(/(A)|(X)|(O)|(9)/g, "_");
    }
    constructor(model, helper, editableService) {
        this.model = model;
        this.helper = helper;
        this.editableService = editableService;
        this.MASK_PATTERN = { A: "[a-zA-Z]", X: "[ -ÿ]", O: "[0-9a-zA-Z]", 9: "[0-9]" };
    }
    disableDrag(event) {
        let t = null;
        this.model.canDrag = false;
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    inFocus(e) {
        setTimeout(() => {
            let editableContent = new StiInputTextItem(this.element.text, this.element.font, this.element.textColor, this.element.backgroundColor, this.element.contentAlignment);
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
        this.checkMask(e);
    }
    lostFocus() {
        if (this.model.selectedComponent?.element != this.element) {
            this.editableService.editableContent = null;
        }
    }
    checkMask(e) {
        if (this.element.mask != null && this.element.mask.length > 0) {
            let msk = this.element.mask.split("");
            let i = this.input.nativeElement;
            if (e.type == "focus" && i.value !== "")
                return;
            const mskd = [];
            let s = i.selectionStart - 1;
            msk.forEach((el, n) => {
                if (this.MASK_PATTERN[el]) {
                    const t = new RegExp(this.MASK_PATTERN[el], "i").test(i.value.charAt(n));
                    mskd.push(t ? i.value.charAt(n) : "_");
                    if (t && s === n && i.value.charAt(n) !== "_") {
                        s++;
                    }
                }
                else {
                    mskd.push(el);
                    if (s === n)
                        s++;
                }
            });
            i.value = mskd.join("");
            i.selectionStart = i.selectionEnd = s < 0 ? 0 : s;
            setTimeout(function () {
                i.selectionStart = i.selectionEnd = s < 0 ? 0 : s;
            }, 0);
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiInputTextComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiInputTextComponent, selector: "sti-input-text-component", inputs: { element: "element", property: "property", tabIndex: "tabIndex" }, viewQueries: [{ propertyName: "input", first: true, predicate: ["input"], descendants: true }], ngImport: i0, template: `
    <input
      #input
      type="text"
      [style]="element?.htmlStyle()"
      [style.color]="element?.textColor.toHtmlColor()"
      [style.background-color]="element?.backgroundColor.toHtmlColor()"
      [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
      [style.border-width]="borderWidth()"
      autocomplete="disabled"
      spellcheck="false"
      [placeholder]="placeholder"
      [style.align-self]="'center'"
      [attr.maxlength]="element['useRange'] ? element['maximum'] : '255'"
      tooltipPosition="bottom"
      showDelay="500"
      [required]="element?.required"
      [readonly]="element?.readOnly"
      [tabIndex]="tabIndex"
      [(ngModel)]="value"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
      (focus)="inFocus($event)"
      (input)="checkMask($event)"
      (blur)="lostFocus()"
    />
  `, isInline: true, styles: ["input{height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}input:hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiInputTextComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-input-text-component", template: `
    <input
      #input
      type="text"
      [style]="element?.htmlStyle()"
      [style.color]="element?.textColor.toHtmlColor()"
      [style.background-color]="element?.backgroundColor.toHtmlColor()"
      [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
      [style.border-width]="borderWidth()"
      autocomplete="disabled"
      spellcheck="false"
      [placeholder]="placeholder"
      [style.align-self]="'center'"
      [attr.maxlength]="element['useRange'] ? element['maximum'] : '255'"
      tooltipPosition="bottom"
      showDelay="500"
      [required]="element?.required"
      [readonly]="element?.readOnly"
      [tabIndex]="tabIndex"
      [(ngModel)]="value"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
      (focus)="inFocus($event)"
      (input)="checkMask($event)"
      (blur)="lostFocus()"
    />
  `, styles: ["input{height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}input:hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiEditableContentService }], propDecorators: { input: [{
                type: ViewChild,
                args: ["input"]
            }], element: [{
                type: Input
            }], property: [{
                type: Input
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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