import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/mouse.service";
import * as i4 from "../../services/sti-form-checker.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-form-checker-item.component";
export class StiFormCheckerComponent {
    constructor(model, loc, mouseService, formCheckerService) {
        this.model = model;
        this.loc = loc;
        this.mouseService = mouseService;
        this.formCheckerService = formCheckerService;
        this.isDragging = false;
    }
    ngOnDestroy() {
        this.mouseMoveSubscription?.unsubscribe();
        this.mouseUpSubscription?.unsubscribe();
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.formCheckerService.componentX;
        this.startComponentY = this.formCheckerService.componentY;
        this.isDragging = true;
    }
    showInfo() { }
    onMouseMove(event) {
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.formCheckerService.componentX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.formCheckerService.componentWidth) {
                this.formCheckerService.componentX = window.innerWidth - this.formCheckerService.componentWidth;
            }
            else {
                this.formCheckerService.componentX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.formCheckerService.componentY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.formCheckerService.componentHeight) {
                this.formCheckerService.componentY = window.innerHeight - this.formCheckerService.componentHeight;
            }
            else {
                this.formCheckerService.componentY = this.startComponentY + deltaY;
            }
        }
    }
    ngOnInit() {
        this.formCheckerService.getButtonNames();
        this.formCheckerService.componentX = (window.innerWidth - this.formCheckerService.componentWidth) / 2;
        this.formCheckerService.componentY = (window.innerHeight - this.formCheckerService.componentHeight) / 2;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiMouseService }, { token: i4.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFormCheckerComponent, selector: "sti-form-checker", ngImport: i0, template: `<div
    class="form-checker-container"
    [style.left.px]="formCheckerService.componentX"
    [style.top.px]="formCheckerService.componentY"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <!-- <span>{{ loc.get2("FormTitles", "FormsChecker") }}</span> -->
      <span>{{ "Form Checker" }}</span>
      <!-- <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div> -->
      <div class="nav-button" (click)="formCheckerService.showFormCheckerWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content">
      <sti-form-checker-item
        *ngFor="let item of formCheckerService.formMessages; let i = index"
        [index]="i + 1"
        [item]="item"
      ></sti-form-checker-item>
    </div>
  </div>`, isInline: true, styles: [".content{flex:1;overflow-x:hidden;overflow-y:auto}.form-checker-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;z-index:999;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i6.StiFormCheckerItemComponent, selector: "sti-form-checker-item", inputs: ["item", "index"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-form-checker", template: `<div
    class="form-checker-container"
    [style.left.px]="formCheckerService.componentX"
    [style.top.px]="formCheckerService.componentY"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <!-- <span>{{ loc.get2("FormTitles", "FormsChecker") }}</span> -->
      <span>{{ "Form Checker" }}</span>
      <!-- <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div> -->
      <div class="nav-button" (click)="formCheckerService.showFormCheckerWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content">
      <sti-form-checker-item
        *ngFor="let item of formCheckerService.formMessages; let i = index"
        [index]="i + 1"
        [item]="item"
      ></sti-form-checker-item>
    </div>
  </div>`, styles: [".content{flex:1;overflow-x:hidden;overflow-y:auto}.form-checker-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;z-index:999;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiMouseService }, { type: i4.StiFormCheckerService }] });
//# sourceMappingURL=data:application/json;base64,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