import { Component } from "@angular/core";
import { StiLocalizationService } from "../../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/http-client.service";
import * as i3 from "../../services/sti-export.service";
export class StiFileSaveDialogComponent {
    get question() {
        return this.model.showSaveDialog
            ? StiLocalizationService.get("Questions", "qnSaveChanges").replace("{0}", StiLocalizationService.get("Dialogs", "StiForm"))
            : "Would you like to save the form to Stimulsoft Cloud?";
    }
    constructor(model, httpService, exportService) {
        this.model = model;
        this.httpService = httpService;
        this.exportService = exportService;
        this.designer = StiLocalizationService.get("Permissions", "ItemForms");
        this.yes = StiLocalizationService.get("PropertyMain", "Yes");
        this.no = StiLocalizationService.get("PropertyMain", "No");
        this.cancel = StiLocalizationService.get("PropertyMain", "Cancel");
    }
    close(option) {
        if (this.model.showSaveDialog) {
            this.model.showSaveDialog = false;
            if (option === "No") {
                if (this.model.saveDialogFromNew) {
                    this.model.interfaceEvent.next({ name: "FormNew" });
                }
                else if (this.model.saveDialogFromOpen) {
                    this.model.interfaceEvent.next({ name: "FormOpen" });
                }
            }
        }
        else {
            this.model.showSaveDialogFromCloud = false;
            if (option === "No") {
                this.exportService.showModalWindow = !this.exportService.showModalWindow;
            }
        }
    }
    save() {
        if (this.model.showSaveDialog) {
            this.model.form.attachedFiles = [];
            this.model.saveLastFormState();
            this.model.interfaceEvent.next({ name: "FormSave", data: { form: this.model.form, name: this.model.fileName } });
            this.model.showSaveDialog = false;
            if (this.model.saveDialogFromNew) {
                this.model.interfaceEvent.next({ name: "FormNew" });
            }
            else if (this.model.saveDialogFromOpen) {
                this.model.interfaceEvent.next({ name: "FormOpen" });
            }
        }
        else {
            let currentForm = this.model.form.saveToReportJsonObject().serialize();
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClick", data: { form: currentForm } })
                .subscribe(() => { });
            this.model.showSaveDialogFromCloud = false;
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileSaveDialogComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiExportService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFileSaveDialogComponent, selector: "sti-file-save-dialog", ngImport: i0, template: `<div class="save-dialog">
    <div class="save-dialog-navigation">
      <label>{{ designer }}</label>
      <div class="close-button" (click)="close('Cancel')">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="text-content">
      <img [src]="model.getImage('images.Other.Question.png')" />
      <span>{{ question }}</span>
    </div>
    <div class="buttons-container">
      <div class="button accept" (click)="save()">
        <span>{{ yes }}</span>
      </div>
      <div class="button cancel" (click)="close('No')">
        <span>{{ no }}</span>
      </div>
      <div class="button cancel" (click)="close('Cancel')" [style.margin-right.px]="10">
        <span>{{ cancel }}</span>
      </div>
    </div>
  </div>`, isInline: true, styles: [".save-dialog{width:500px;height:150px;position:absolute;z-index:9999999;left:calc(50% - 250px);top:calc(50% - 70px);background-color:#fff;cursor:default;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);display:flex;border-top-right-radius:5px;border-top-left-radius:5px;flex-direction:column;color:#444}.save-dialog-navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none}.text-content{flex:1;padding:20px 10px;display:flex;align-items:center}.text-content span{font-size:13px;margin:12px 0}.text-content img{margin-left:10px;margin-right:10px;width:32px;height:32px}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}label{font-size:13px;color:#fff;font-family:Arial;flex:1;display:flex;align-items:center;margin-left:10px}.buttons-container{height:50px;width:100%;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}span{height:100%;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileSaveDialogComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-save-dialog", template: `<div class="save-dialog">
    <div class="save-dialog-navigation">
      <label>{{ designer }}</label>
      <div class="close-button" (click)="close('Cancel')">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="text-content">
      <img [src]="model.getImage('images.Other.Question.png')" />
      <span>{{ question }}</span>
    </div>
    <div class="buttons-container">
      <div class="button accept" (click)="save()">
        <span>{{ yes }}</span>
      </div>
      <div class="button cancel" (click)="close('No')">
        <span>{{ no }}</span>
      </div>
      <div class="button cancel" (click)="close('Cancel')" [style.margin-right.px]="10">
        <span>{{ cancel }}</span>
      </div>
    </div>
  </div>`, styles: [".save-dialog{width:500px;height:150px;position:absolute;z-index:9999999;left:calc(50% - 250px);top:calc(50% - 70px);background-color:#fff;cursor:default;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);display:flex;border-top-right-radius:5px;border-top-left-radius:5px;flex-direction:column;color:#444}.save-dialog-navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none}.text-content{flex:1;padding:20px 10px;display:flex;align-items:center}.text-content span{font-size:13px;margin:12px 0}.text-content img{margin-left:10px;margin-right:10px;width:32px;height:32px}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}label{font-size:13px;color:#fff;font-family:Arial;flex:1;display:flex;align-items:center;margin-left:10px}.buttons-container{height:50px;width:100%;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}span{height:100%;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiExportService }] });
//# sourceMappingURL=data:application/json;base64,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