import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
export class StiExpressionHelpWindowComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
    }
    get itemInfo() {
        if (this.model.currentExpressionInfo == 1) {
            return `Supports list operations: adding, subtracting and multiplying lists, list and value.
Example:
    { Col( 'Qty' ) * Col( 'Price' ) }
    { ( Col( 'Fahrenheit degrees' ) - 32 ) * 5 / 9 }
Available functions:
    Count,
    Min,
    Max,
    Sum,
    Value,
    Cell,
    Total,
    Col`;
        }
        else if (this.model.currentExpressionInfo == 2) {
            return `Example:
  { Sum( Col( 'Final price' ) ) }
  { ( Total( 'Tax' ) + 1 ) * Total( 'Price' ) }
Available functions:
  Count,
  Min,
  Max,
  Sum,
  Value,
  Cell,
  Total,
  Col,
  Row`;
        }
        else if (this.model.currentExpressionInfo == 3) {
            return `Multiple expressions, enclosed in { and }, are supported.
Example:
    "Tax is { Value( 'Tax' ) * 100}%, total is { Value( 'Tax' ) * Value( 'Subtotal' ) } dollars",
    evaluates to "Tax is 15%, total is 230 dollars"
Available functions:
    Count,
    Min,
    Max,
    Sum,
    Value,
    Cell,
    Total,
    Col,
    Row`;
        }
        else {
            return "";
        }
    }
    get generalInfo() {
        return `Expressions : used in Label element, Labels column and Totals fields of Table element.
|
|- Values: numbers: 1, 2.3, -4.5.
|          strings: 'text'.
|          lists: returned from some functions.
|
|- Operators: JS-style type casting is applied when possible.
|   |
|   |- "+" : when applied to numbers:            2 + 3 = 5
|   |        when applied to strings:            'abc' + 'def' = 'abcdef'
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] + [ 4, 5, 6 ] = [ 5, 7, 9 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] + 8 = [ 9, 10, 11 ].
|   |
|   |- "-" : when applied to numbers:            2 - 3 = 5
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] - [ 4, 5, 6 ] = [ -3, -3, -3 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] - 8 = [ -7, -6, -5 ].
|   |
|   |- "*" : when applied to numbers:            2 * 3 = 6
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] * [ 4, 5, 6 ] = [ 4, 10, 18 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] * 8 = [ 8, 16, 24 ].
|   |
|   |- "/" : when applied to numbers: 2 / 3 = 0.666667.
|   |
|   |- "(" and ")" : operations order.
|
|- Functions:
    |
    |- Value( name ) - value of NumberBox, TextBox or Label element.
    |                  For Label element - value of the last expression,
    |                  for ex., value of Label with text "Price: {2 * 100} dollars" is 200.
    |
    |- Count( list ) - number of items in the list.
    |
    |- Min( list ) - the smallest number in list.
    |
    |- Max( list ) - the largest number in list.
    |
    |- Sum( list ) - sum of all numbers in list.
    |
    |- Cell( oneBasedColumnIndex, oneBasedRowIndex, 'tableName' ) - number value of specified cell.
    |                                                               Cell must be from either NumberBox column or Label column.
    |                                                               Parameter 'tableName' can be omitted if function is used
    |                                                               in the same table (for ex., in Totals field's expression)
    |                                                               as the specified cell.
    |
    |- Total( totalsFieldID, 'tableName' ) - value of Table's Totals field.
    |                                        totalsFieldID - either one-based index or header text of desired totals field.
    |                                        Parameter 'tableName' can be omitted if function is used
    |                                        in the same table (for ex., in Totals field's expression)
    |                                        as the specified totals field.
    |
    |- Col( columnID, 'tableName' ) - list of numbers which are cell values from specified column.
    |                                 columnID - either one-based index or label text of desired column.
    |                                 Only NumberBox and Label columns are supported.
    |                                 Parameter 'tableName' can be omitted if function is used
    |                                 in the same table (for ex., in Totals field's expression)
    |                                 as the specified column.
    |
    |
    |- Row( rowID, 'tableName' ) - list of numbers which are cell values from specified row.
                                  rowID - either one-based index or label text of desired row.
                                  Only cells from NumberBox or Label columns are included.
                                  Parameter 'tableName' can be omitted if function is used
                                  in the same table (for ex., in Totals field's expression)
                                  as the specified row.
                                  Not available in Label column expressions.
  `;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionHelpWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiExpressionHelpWindowComponent, selector: "expression-help-window", ngImport: i0, template: `<div class="help-window">
    <div class="navigation">
      <span>{{ loc.get2("HelpDesigner", "StimulsoftHelp") }}</span>
      <div class="close-button" (click)="model.showHelpWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="content">
      <div class="item-info">{{ itemInfo }}</div>
      <div class="general-info">{{ generalInfo }}</div>
    </div>
  </div>`, isInline: true, styles: [".pi{font-size:.825rem;color:var(--text-color)}.help-window{position:absolute;height:500px;width:620px;display:flex;flex-direction:column;left:calc(50% - 310px);top:calc(50% - 250px);z-index:9999999;background:var(--back-color);border:1px solid rgb(25,71,138);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;font-family:Arial;border-radius:5px;font-size:12px}.navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation span{padding-left:10px;color:#fff;flex:1}.item-info{margin-bottom:10px}.close-button{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.close-button:hover{background-color:#dadada}.content{height:100%;width:100%;overflow-y:scroll;padding:0 10px;word-wrap:auto;white-space:pre-wrap}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionHelpWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "expression-help-window", template: `<div class="help-window">
    <div class="navigation">
      <span>{{ loc.get2("HelpDesigner", "StimulsoftHelp") }}</span>
      <div class="close-button" (click)="model.showHelpWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="content">
      <div class="item-info">{{ itemInfo }}</div>
      <div class="general-info">{{ generalInfo }}</div>
    </div>
  </div>`, styles: [".pi{font-size:.825rem;color:var(--text-color)}.help-window{position:absolute;height:500px;width:620px;display:flex;flex-direction:column;left:calc(50% - 310px);top:calc(50% - 250px);z-index:9999999;background:var(--back-color);border:1px solid rgb(25,71,138);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;font-family:Arial;border-radius:5px;font-size:12px}.navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation span{padding-left:10px;color:#fff;flex:1}.item-info{margin-bottom:10px}.close-button{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.close-button:hover{background-color:#dadada}.content{height:100%;width:100%;overflow-y:scroll;padding:0 10px;word-wrap:auto;white-space:pre-wrap}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWV4cHJlc3Npb24taGVscC13aW5kb3cuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLWV4cHJlc3Npb24tZWRpdG9yL3N0aS1leHByZXNzaW9uLWhlbHAtd2luZG93LmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDOzs7O0FBcUZsRCxNQUFNLE9BQU8sZ0NBQWdDO0lBQzNDLFlBQW1CLEtBQXNCLEVBQVMsR0FBMkI7UUFBMUQsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFBUyxRQUFHLEdBQUgsR0FBRyxDQUF3QjtJQUFHLENBQUM7SUFDakYsSUFBSSxRQUFRO1FBQ1YsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHFCQUFxQixJQUFJLENBQUMsRUFBRSxDQUFDO1lBQzFDLE9BQU87Ozs7Ozs7Ozs7OztRQVlMLENBQUM7UUFDTCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHFCQUFxQixJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ2pELE9BQU87Ozs7Ozs7Ozs7OztNQVlQLENBQUM7UUFDSCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHFCQUFxQixJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ2pELE9BQU87Ozs7Ozs7Ozs7Ozs7UUFhTCxDQUFDO1FBQ0wsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBSSxXQUFXO1FBQ2IsT0FBTzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBa0VSLENBQUM7SUFDRixDQUFDO0lBQ0QsUUFBUSxLQUFJLENBQUM7K0dBdkhGLGdDQUFnQzttR0FBaEMsZ0NBQWdDLDhEQS9FakM7Ozs7Ozs7Ozs7O1NBV0g7OzRGQW9FSSxnQ0FBZ0M7a0JBakY1QyxTQUFTOytCQUNFLHdCQUF3QixZQUN4Qjs7Ozs7Ozs7Ozs7U0FXSCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktbG9jYWxpemF0aW9uLnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcImV4cHJlc3Npb24taGVscC13aW5kb3dcIixcclxuICB0ZW1wbGF0ZTogYDxkaXYgY2xhc3M9XCJoZWxwLXdpbmRvd1wiPlxyXG4gICAgPGRpdiBjbGFzcz1cIm5hdmlnYXRpb25cIj5cclxuICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJIZWxwRGVzaWduZXJcIiwgXCJTdGltdWxzb2Z0SGVscFwiKSB9fTwvc3Bhbj5cclxuICAgICAgPGRpdiBjbGFzcz1cImNsb3NlLWJ1dHRvblwiIChjbGljayk9XCJtb2RlbC5zaG93SGVscFdpbmRvdyA9IGZhbHNlXCI+XHJcbiAgICAgICAgPGltZyBbc3JjXT1cIm1vZGVsLmdldEltYWdlKCdpbWFnZXMuT3RoZXIuQ2xvc2VGb3JtLnBuZycpXCIgYWx0PVwiXCIgLz5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICAgIDxkaXYgY2xhc3M9XCJjb250ZW50XCI+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJpdGVtLWluZm9cIj57eyBpdGVtSW5mbyB9fTwvZGl2PlxyXG4gICAgICA8ZGl2IGNsYXNzPVwiZ2VuZXJhbC1pbmZvXCI+e3sgZ2VuZXJhbEluZm8gfX08L2Rpdj5cclxuICAgIDwvZGl2PlxyXG4gIDwvZGl2PmAsXHJcbiAgc3R5bGVzOiBbXHJcbiAgICBgXHJcbiAgICAgIC5waSB7XHJcbiAgICAgICAgZm9udC1zaXplOiAwLjgyNXJlbTtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgICAgLmhlbHAtd2luZG93IHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgaGVpZ2h0OiA1MDBweDtcclxuICAgICAgICB3aWR0aDogNjIwcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICAgIGxlZnQ6IGNhbGMoNTAlIC0gMzEwcHgpO1xyXG4gICAgICAgIHRvcDogY2FsYyg1MCUgLSAyNTBweCk7XHJcbiAgICAgICAgei1pbmRleDogOTk5OTk5OTtcclxuICAgICAgICBiYWNrZ3JvdW5kOiB2YXIoLS1iYWNrLWNvbG9yKTtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCByZ2IoMjUsIDcxLCAxMzgpO1xyXG4gICAgICAgIC1tb3otYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiYSgwLCAwLCAwLCAwLjYpO1xyXG4gICAgICAgIC13ZWJraXQtYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiKDAgMCAwIC8gNjAlKTtcclxuICAgICAgICBib3gtc2hhZG93OiAwIDAgN3B4IHJnYigwIDAgMCAvIDMwJSk7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDVweDtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgIH1cclxuICAgICAgLm5hdmlnYXRpb24ge1xyXG4gICAgICAgIGhlaWdodDogMzBweDtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgYm9yZGVyLXRvcC1sZWZ0LXJhZGl1czogM3B4O1xyXG4gICAgICAgIGJvcmRlci10b3AtcmlnaHQtcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDgxLCA5MiwgMTA2KTtcclxuICAgICAgfVxyXG4gICAgICAubmF2aWdhdGlvbiBzcGFuIHtcclxuICAgICAgICBwYWRkaW5nLWxlZnQ6IDEwcHg7XHJcbiAgICAgICAgY29sb3I6IHdoaXRlO1xyXG4gICAgICAgIGZsZXg6IDE7XHJcbiAgICAgIH1cclxuICAgICAgLml0ZW0taW5mbyB7XHJcbiAgICAgICAgbWFyZ2luLWJvdHRvbTogMTBweDtcclxuICAgICAgfVxyXG4gICAgICAuY2xvc2UtYnV0dG9uIHtcclxuICAgICAgICBoZWlnaHQ6IDMwcHg7XHJcbiAgICAgICAgd2lkdGg6IDMwcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5jbG9zZS1idXR0b24gaW1nIHtcclxuICAgICAgICBoZWlnaHQ6IDE2cHg7XHJcbiAgICAgICAgd2lkdGg6IDE2cHg7XHJcbiAgICAgICAgZmlsdGVyOiBicmlnaHRuZXNzKDApIGludmVydCgxKTtcclxuICAgICAgfVxyXG4gICAgICAuY2xvc2UtYnV0dG9uOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjE4LCAyMTgsIDIxOCk7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbnRlbnQge1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBvdmVyZmxvdy15OiBzY3JvbGw7XHJcbiAgICAgICAgcGFkZGluZzogMHB4IDEwcHg7XHJcbiAgICAgICAgd29yZC13cmFwOiBhdXRvO1xyXG4gICAgICAgIHdoaXRlLXNwYWNlOiBwcmUtd3JhcDtcclxuICAgICAgfVxyXG4gICAgYCxcclxuICBdLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpRXhwcmVzc2lvbkhlbHBXaW5kb3dDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLCBwdWJsaWMgbG9jOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlKSB7fVxyXG4gIGdldCBpdGVtSW5mbygpIHtcclxuICAgIGlmICh0aGlzLm1vZGVsLmN1cnJlbnRFeHByZXNzaW9uSW5mbyA9PSAxKSB7XHJcbiAgICAgIHJldHVybiBgU3VwcG9ydHMgbGlzdCBvcGVyYXRpb25zOiBhZGRpbmcsIHN1YnRyYWN0aW5nIGFuZCBtdWx0aXBseWluZyBsaXN0cywgbGlzdCBhbmQgdmFsdWUuXHJcbkV4YW1wbGU6XHJcbiAgICB7IENvbCggJ1F0eScgKSAqIENvbCggJ1ByaWNlJyApIH1cclxuICAgIHsgKCBDb2woICdGYWhyZW5oZWl0IGRlZ3JlZXMnICkgLSAzMiApICogNSAvIDkgfVxyXG5BdmFpbGFibGUgZnVuY3Rpb25zOlxyXG4gICAgQ291bnQsXHJcbiAgICBNaW4sXHJcbiAgICBNYXgsXHJcbiAgICBTdW0sXHJcbiAgICBWYWx1ZSxcclxuICAgIENlbGwsXHJcbiAgICBUb3RhbCxcclxuICAgIENvbGA7XHJcbiAgICB9IGVsc2UgaWYgKHRoaXMubW9kZWwuY3VycmVudEV4cHJlc3Npb25JbmZvID09IDIpIHtcclxuICAgICAgcmV0dXJuIGBFeGFtcGxlOlxyXG4gIHsgU3VtKCBDb2woICdGaW5hbCBwcmljZScgKSApIH1cclxuICB7ICggVG90YWwoICdUYXgnICkgKyAxICkgKiBUb3RhbCggJ1ByaWNlJyApIH1cclxuQXZhaWxhYmxlIGZ1bmN0aW9uczpcclxuICBDb3VudCxcclxuICBNaW4sXHJcbiAgTWF4LFxyXG4gIFN1bSxcclxuICBWYWx1ZSxcclxuICBDZWxsLFxyXG4gIFRvdGFsLFxyXG4gIENvbCxcclxuICBSb3dgO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLm1vZGVsLmN1cnJlbnRFeHByZXNzaW9uSW5mbyA9PSAzKSB7XHJcbiAgICAgIHJldHVybiBgTXVsdGlwbGUgZXhwcmVzc2lvbnMsIGVuY2xvc2VkIGluIHsgYW5kIH0sIGFyZSBzdXBwb3J0ZWQuXHJcbkV4YW1wbGU6XHJcbiAgICBcIlRheCBpcyB7IFZhbHVlKCAnVGF4JyApICogMTAwfSUsIHRvdGFsIGlzIHsgVmFsdWUoICdUYXgnICkgKiBWYWx1ZSggJ1N1YnRvdGFsJyApIH0gZG9sbGFyc1wiLFxyXG4gICAgZXZhbHVhdGVzIHRvIFwiVGF4IGlzIDE1JSwgdG90YWwgaXMgMjMwIGRvbGxhcnNcIlxyXG5BdmFpbGFibGUgZnVuY3Rpb25zOlxyXG4gICAgQ291bnQsXHJcbiAgICBNaW4sXHJcbiAgICBNYXgsXHJcbiAgICBTdW0sXHJcbiAgICBWYWx1ZSxcclxuICAgIENlbGwsXHJcbiAgICBUb3RhbCxcclxuICAgIENvbCxcclxuICAgIFJvd2A7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gXCJcIjtcclxuICAgIH1cclxuICB9XHJcbiAgZ2V0IGdlbmVyYWxJbmZvKCkge1xyXG4gICAgcmV0dXJuIGBFeHByZXNzaW9ucyA6IHVzZWQgaW4gTGFiZWwgZWxlbWVudCwgTGFiZWxzIGNvbHVtbiBhbmQgVG90YWxzIGZpZWxkcyBvZiBUYWJsZSBlbGVtZW50LlxyXG58XHJcbnwtIFZhbHVlczogbnVtYmVyczogMSwgMi4zLCAtNC41LlxyXG58ICAgICAgICAgIHN0cmluZ3M6ICd0ZXh0Jy5cclxufCAgICAgICAgICBsaXN0czogcmV0dXJuZWQgZnJvbSBzb21lIGZ1bmN0aW9ucy5cclxufFxyXG58LSBPcGVyYXRvcnM6IEpTLXN0eWxlIHR5cGUgY2FzdGluZyBpcyBhcHBsaWVkIHdoZW4gcG9zc2libGUuXHJcbnwgICB8XHJcbnwgICB8LSBcIitcIiA6IHdoZW4gYXBwbGllZCB0byBudW1iZXJzOiAgICAgICAgICAgIDIgKyAzID0gNVxyXG58ICAgfCAgICAgICAgd2hlbiBhcHBsaWVkIHRvIHN0cmluZ3M6ICAgICAgICAgICAgJ2FiYycgKyAnZGVmJyA9ICdhYmNkZWYnXHJcbnwgICB8ICAgICAgICBpbiBMYWJlbHMgY29sdW1uIGV4cHJlc3Npb25zLCB3aGVuIGFwcGxpZWQgdG8gbGlzdHMgb2Ygc2FtZSBzaXplOiBbIDEsIDIsIDMgXSArIFsgNCwgNSwgNiBdID0gWyA1LCA3LCA5IF0uXHJcbnwgICB8ICAgICAgICBpbiBMYWJlbHMgY29sdW1uIGV4cHJlc3Npb25zLCB3aGVuIGFwcGxpZWQgdG8gbGlzdCBhbmQgbnVtYmVyOiAgICBbIDEsIDIsIDMgXSArIDggPSBbIDksIDEwLCAxMSBdLlxyXG58ICAgfFxyXG58ICAgfC0gXCItXCIgOiB3aGVuIGFwcGxpZWQgdG8gbnVtYmVyczogICAgICAgICAgICAyIC0gMyA9IDVcclxufCAgIHwgICAgICAgIGluIExhYmVscyBjb2x1bW4gZXhwcmVzc2lvbnMsIHdoZW4gYXBwbGllZCB0byBsaXN0cyBvZiBzYW1lIHNpemU6IFsgMSwgMiwgMyBdIC0gWyA0LCA1LCA2IF0gPSBbIC0zLCAtMywgLTMgXS5cclxufCAgIHwgICAgICAgIGluIExhYmVscyBjb2x1bW4gZXhwcmVzc2lvbnMsIHdoZW4gYXBwbGllZCB0byBsaXN0IGFuZCBudW1iZXI6ICAgIFsgMSwgMiwgMyBdIC0gOCA9IFsgLTcsIC02LCAtNSBdLlxyXG58ICAgfFxyXG58ICAgfC0gXCIqXCIgOiB3aGVuIGFwcGxpZWQgdG8gbnVtYmVyczogICAgICAgICAgICAyICogMyA9IDZcclxufCAgIHwgICAgICAgIGluIExhYmVscyBjb2x1bW4gZXhwcmVzc2lvbnMsIHdoZW4gYXBwbGllZCB0byBsaXN0cyBvZiBzYW1lIHNpemU6IFsgMSwgMiwgMyBdICogWyA0LCA1LCA2IF0gPSBbIDQsIDEwLCAxOCBdLlxyXG58ICAgfCAgICAgICAgaW4gTGFiZWxzIGNvbHVtbiBleHByZXNzaW9ucywgd2hlbiBhcHBsaWVkIHRvIGxpc3QgYW5kIG51bWJlcjogICAgWyAxLCAyLCAzIF0gKiA4ID0gWyA4LCAxNiwgMjQgXS5cclxufCAgIHxcclxufCAgIHwtIFwiL1wiIDogd2hlbiBhcHBsaWVkIHRvIG51bWJlcnM6IDIgLyAzID0gMC42NjY2NjcuXHJcbnwgICB8XHJcbnwgICB8LSBcIihcIiBhbmQgXCIpXCIgOiBvcGVyYXRpb25zIG9yZGVyLlxyXG58XHJcbnwtIEZ1bmN0aW9uczpcclxuICAgIHxcclxuICAgIHwtIFZhbHVlKCBuYW1lICkgLSB2YWx1ZSBvZiBOdW1iZXJCb3gsIFRleHRCb3ggb3IgTGFiZWwgZWxlbWVudC5cclxuICAgIHwgICAgICAgICAgICAgICAgICBGb3IgTGFiZWwgZWxlbWVudCAtIHZhbHVlIG9mIHRoZSBsYXN0IGV4cHJlc3Npb24sXHJcbiAgICB8ICAgICAgICAgICAgICAgICAgZm9yIGV4LiwgdmFsdWUgb2YgTGFiZWwgd2l0aCB0ZXh0IFwiUHJpY2U6IHsyICogMTAwfSBkb2xsYXJzXCIgaXMgMjAwLlxyXG4gICAgfFxyXG4gICAgfC0gQ291bnQoIGxpc3QgKSAtIG51bWJlciBvZiBpdGVtcyBpbiB0aGUgbGlzdC5cclxuICAgIHxcclxuICAgIHwtIE1pbiggbGlzdCApIC0gdGhlIHNtYWxsZXN0IG51bWJlciBpbiBsaXN0LlxyXG4gICAgfFxyXG4gICAgfC0gTWF4KCBsaXN0ICkgLSB0aGUgbGFyZ2VzdCBudW1iZXIgaW4gbGlzdC5cclxuICAgIHxcclxuICAgIHwtIFN1bSggbGlzdCApIC0gc3VtIG9mIGFsbCBudW1iZXJzIGluIGxpc3QuXHJcbiAgICB8XHJcbiAgICB8LSBDZWxsKCBvbmVCYXNlZENvbHVtbkluZGV4LCBvbmVCYXNlZFJvd0luZGV4LCAndGFibGVOYW1lJyApIC0gbnVtYmVyIHZhbHVlIG9mIHNwZWNpZmllZCBjZWxsLlxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIENlbGwgbXVzdCBiZSBmcm9tIGVpdGhlciBOdW1iZXJCb3ggY29sdW1uIG9yIExhYmVsIGNvbHVtbi5cclxuICAgIHwgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbWV0ZXIgJ3RhYmxlTmFtZScgY2FuIGJlIG9taXR0ZWQgaWYgZnVuY3Rpb24gaXMgdXNlZFxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluIHRoZSBzYW1lIHRhYmxlIChmb3IgZXguLCBpbiBUb3RhbHMgZmllbGQncyBleHByZXNzaW9uKVxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGFzIHRoZSBzcGVjaWZpZWQgY2VsbC5cclxuICAgIHxcclxuICAgIHwtIFRvdGFsKCB0b3RhbHNGaWVsZElELCAndGFibGVOYW1lJyApIC0gdmFsdWUgb2YgVGFibGUncyBUb3RhbHMgZmllbGQuXHJcbiAgICB8ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRvdGFsc0ZpZWxkSUQgLSBlaXRoZXIgb25lLWJhc2VkIGluZGV4IG9yIGhlYWRlciB0ZXh0IG9mIGRlc2lyZWQgdG90YWxzIGZpZWxkLlxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbWV0ZXIgJ3RhYmxlTmFtZScgY2FuIGJlIG9taXR0ZWQgaWYgZnVuY3Rpb24gaXMgdXNlZFxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpbiB0aGUgc2FtZSB0YWJsZSAoZm9yIGV4LiwgaW4gVG90YWxzIGZpZWxkJ3MgZXhwcmVzc2lvbilcclxuICAgIHwgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXMgdGhlIHNwZWNpZmllZCB0b3RhbHMgZmllbGQuXHJcbiAgICB8XHJcbiAgICB8LSBDb2woIGNvbHVtbklELCAndGFibGVOYW1lJyApIC0gbGlzdCBvZiBudW1iZXJzIHdoaWNoIGFyZSBjZWxsIHZhbHVlcyBmcm9tIHNwZWNpZmllZCBjb2x1bW4uXHJcbiAgICB8ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sdW1uSUQgLSBlaXRoZXIgb25lLWJhc2VkIGluZGV4IG9yIGxhYmVsIHRleHQgb2YgZGVzaXJlZCBjb2x1bW4uXHJcbiAgICB8ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgT25seSBOdW1iZXJCb3ggYW5kIExhYmVsIGNvbHVtbnMgYXJlIHN1cHBvcnRlZC5cclxuICAgIHwgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbWV0ZXIgJ3RhYmxlTmFtZScgY2FuIGJlIG9taXR0ZWQgaWYgZnVuY3Rpb24gaXMgdXNlZFxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluIHRoZSBzYW1lIHRhYmxlIChmb3IgZXguLCBpbiBUb3RhbHMgZmllbGQncyBleHByZXNzaW9uKVxyXG4gICAgfCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGFzIHRoZSBzcGVjaWZpZWQgY29sdW1uLlxyXG4gICAgfFxyXG4gICAgfFxyXG4gICAgfC0gUm93KCByb3dJRCwgJ3RhYmxlTmFtZScgKSAtIGxpc3Qgb2YgbnVtYmVycyB3aGljaCBhcmUgY2VsbCB2YWx1ZXMgZnJvbSBzcGVjaWZpZWQgcm93LlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcm93SUQgLSBlaXRoZXIgb25lLWJhc2VkIGluZGV4IG9yIGxhYmVsIHRleHQgb2YgZGVzaXJlZCByb3cuXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBPbmx5IGNlbGxzIGZyb20gTnVtYmVyQm94IG9yIExhYmVsIGNvbHVtbnMgYXJlIGluY2x1ZGVkLlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUGFyYW1ldGVyICd0YWJsZU5hbWUnIGNhbiBiZSBvbWl0dGVkIGlmIGZ1bmN0aW9uIGlzIHVzZWRcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluIHRoZSBzYW1lIHRhYmxlIChmb3IgZXguLCBpbiBUb3RhbHMgZmllbGQncyBleHByZXNzaW9uKVxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXMgdGhlIHNwZWNpZmllZCByb3cuXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBOb3QgYXZhaWxhYmxlIGluIExhYmVsIGNvbHVtbiBleHByZXNzaW9ucy5cclxuICBgO1xyXG4gIH1cclxuICBuZ09uSW5pdCgpIHt9XHJcbn1cclxuIl19