import { Component, ViewChild } from "@angular/core";
import { StiFormElement } from "../../elements/base/StiFormElement";
import { StiLabelElement } from "../../elements/StiLabelElement";
import { StiNumberBoxElement } from "../../elements/StiNumberBoxElement";
import { StiTableElement } from "../../elements/StiTableElement";
import { StiTextBoxElement } from "../../elements/StiTextBoxElement";
import { StiTotalsFieldItem } from "../../elements/table/StiTotalsFieldItem";
import { StiExpressionService } from "../../services/sti-expression.service";
import { RotateAnimation } from "../animations/animations";
import { StiColumnItem } from "../../elements/table/StiColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-expression.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/mouse.service";
import * as i5 from "../../services/sti-editable-content.service";
import * as i6 from "@angular/common";
import * as i7 from "./sti-columns-preview.component";
import * as i8 from "../sti-tooltip/sti-tooltip.directive";
export class StiExpressionEditorComponent {
    constructor(model, expressionService, loc, mouseService, editableService, cdr) {
        this.model = model;
        this.expressionService = expressionService;
        this.loc = loc;
        this.mouseService = mouseService;
        this.editableService = editableService;
        this.cdr = cdr;
        this.expressionString = "{}";
        this.currentSelectedMode = "functions";
        this.currentSelectedFunction = "value";
        this.canDragExpression = false;
        this.arrayOfSamples = [
            {
                functionName: "value",
                samples: ["Value('TextBox')", "Value('NumberBox')", "Value('Label')"],
                title: "Value of NumberBox, TextBox or Label element",
            },
            {
                functionName: "count",
                samples: ["Count(Col(1,'Table'))", "Count(Row('First','Table'))"],
                title: "Number of items in the list",
            },
            {
                functionName: "min",
                samples: ["Min(Col(1,'Table'))", "Min(Row('First','Table'))"],
                title: "The smallest number in list",
            },
            {
                functionName: "max",
                samples: ["Max(Col(1,'Table'))", "Max(Row('First','Table'))"],
                title: "The largest number in list",
            },
            {
                functionName: "sum",
                samples: ["Sum(Col(1,'Table'))", "Sum(Row('First','Table'))"],
                title: "Sum of all numbers in list",
            },
            {
                functionName: "cell",
                samples: ["Cell(columnId,rowId)", "Cell(columnId,rowId,'Table')"],
                title: "Number value of specified cell",
            },
            {
                functionName: "total",
                samples: ["Total(totalId)", "Total(totalId,'Table')"],
                title: "Value of Tables Totals field",
            },
            {
                functionName: "col",
                samples: ["Col(columnId)", "Col(columnId,'Table')"],
                title: "List of numbers which are cell values from specified column",
            },
            {
                functionName: "row",
                samples: ["Row(rowLabel)", "Row(rowLabel,'Table')"],
                title: "List of numbers which are cell values from specified row",
            },
            {
                functionName: "line",
                samples: ["Line"],
                title: "Returns the current table line number (starts from 1).",
            },
            {
                functionName: "today",
                samples: ["Today"],
                title: "Returns the current date in default format.",
            },
            {
                functionName: "time",
                samples: ["Time"],
                title: "Returns the current time in default format.",
            },
        ];
        this.arrayOfStates = [];
    }
    ngAfterViewInit() {
        this.expressionService.elementRef = this.elementRef;
    }
    ngOnDestroy() {
        this.mouseMoveSubscription?.unsubscribe();
        this.mouseUpSubscription?.unsubscribe();
        this.expressionUpdatingSubscription?.unsubscribe();
        this.expressionService.elementRef = null;
    }
    startExpressionDragging(dragObject) {
        this.startX = dragObject.event.clientX;
        this.startY = dragObject.event.clientY;
        this.canDragExpression = true;
        this.dragObject = dragObject;
    }
    setContent(innerText) {
        if (innerText == "" || innerText == null) {
            this.expressionString = innerText;
        }
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.detach();
        }
    }
    checkBrackets() {
        let haveCloseBreaket = false;
        let haveOpenBreaket = false;
        if (this.lastCaretPosition) {
            for (let i = this.lastCaretPosition - 1; i >= 0; i--) {
                if (this.expressionString[i] === "}") {
                    haveCloseBreaket = true;
                    break;
                }
                else if (this.expressionString[i] === "{") {
                    haveOpenBreaket = true;
                    break;
                }
            }
        }
        if (haveCloseBreaket || (!haveCloseBreaket && !haveOpenBreaket)) {
            return true;
        }
        else {
            return false;
        }
    }
    showInfo() {
        this.model.showHelpWindow = true;
    }
    addValue(element) {
        this.addFunction("Value", element.name, true);
    }
    changeMode(mode) {
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.reattach();
            this.cdr.detectChanges();
        }
        if (this.currentSelectedMode != mode && mode == "systemVariable") {
            this.currentSelectedFunction = "line";
        }
        else {
            this.currentSelectedFunction = "value";
        }
        this.currentSelectedMode = mode;
    }
    changeCurrentFuction(func) {
        this.currentSelectedFunction = func;
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.expressionService.componentX;
        this.startComponentY = this.expressionService.componentY;
        this.isDragging = true;
    }
    get samples() {
        return this.arrayOfSamples.find((sample) => sample.functionName == this.currentSelectedFunction).samples;
    }
    get title() {
        return this.arrayOfSamples.find((sample) => sample.functionName == this.currentSelectedFunction).title;
    }
    nestedFieldClick(field) {
        if (field instanceof StiTotalsFieldItem) {
            this.insertInExpression(this.lastCaretPosition, `Total(${field.eParent.totalsFields.indexOf(field) + 1},'${field.eParent.name}')`);
        }
        else {
            this.insertInExpression(this.lastCaretPosition, `Cell(${field.column.eParent.columns.indexOf(field.column) + 1},${field.index},'${field.column.eParent.name}')`);
        }
    }
    get fields() {
        let fields = [];
        this.model?.form?.pages?.forEach((page) => {
            page.allElements.forEach((element) => {
                if (this.haveExpression(element)) {
                    fields.push(element);
                }
            });
        });
        return fields;
    }
    isTable(element) {
        return element instanceof StiTableElement;
    }
    haveExpression(element) {
        return element instanceof StiTableElement ||
            element instanceof StiTextBoxElement ||
            element instanceof StiNumberBoxElement
            ? true
            : false;
    }
    addOperator(operator) {
        this.insertInExpression(this.lastCaretPosition, operator, true);
    }
    addFunction(func, name, filled = false) {
        let string = "";
        if (func.toLowerCase() == "value") {
            string = func + `('${name ? name : ""}')`;
        }
        else if (func.toLowerCase() == "line" || func.toLowerCase() == "today" || func.toLowerCase() == "time") {
            string = func;
        }
        else if (func.toLowerCase() == "cell") {
            string = func + "(,,'')";
        }
        else if (func.toLowerCase() == "total" || func.toLowerCase() == "col" || func.toLowerCase() == "row") {
            string = func + "(,'')";
        }
        else {
            string = func + "()";
        }
        this.insertInExpression(this.lastCaretPosition, string, false, filled ? false : true);
    }
    insertInExpression(position, string, isOperator = false, isFunction = false) {
        let needBrackets = isOperator ? false : this.checkBrackets();
        let previousString = this.expressionString;
        let insertedExpression = `${needBrackets ? "{" : ""}${string}${needBrackets ? "}" : ""}`;
        if (this.expressionString.length > 0 && position) {
            if (position == 0) {
                this.expressionString = insertedExpression + previousString;
            }
            else {
                this.expressionString =
                    previousString.slice(0, position) +
                        insertedExpression +
                        previousString.slice(position, previousString.length);
            }
        }
        else {
            this.expressionString += insertedExpression;
        }
        this.setCaret(insertedExpression, isFunction);
    }
    setCaret(insertedExpression, isFunction = false) {
        let leftBracketIndex = insertedExpression.indexOf("(");
        let carretOffset = 0;
        if (!this.lastCaretPosition) {
            this.lastCaretPosition = this.expressionString.length - insertedExpression.length;
        }
        if (isFunction) {
            if (insertedExpression[leftBracketIndex + 1] == "'") {
                carretOffset = this.lastCaretPosition + leftBracketIndex + 2;
            }
            else {
                carretOffset = this.lastCaretPosition + leftBracketIndex + 1;
            }
        }
        else {
            carretOffset = this.lastCaretPosition + insertedExpression.length;
        }
        let elem = this.elementRef.nativeElement;
        elem.focus();
        setTimeout(() => {
            var range = document.createRange();
            var sel = window.getSelection();
            range.setStart(elem.childNodes[0], carretOffset);
            range.collapse(true);
            this.lastCaretPosition += insertedExpression.length;
            sel.removeAllRanges();
            sel.addRange(range);
        });
    }
    save() {
        if (this.expressionService.currentSelectedObject instanceof StiLabelElement) {
            this.expressionService.currentSelectedObject.text.value = this.expressionString;
            this.model.formEvents.next({ name: "ValueChanged" });
        }
        else {
            this.expressionService.currentSelectedObject.expression = this.expressionString;
        }
        this.model.showExpressionEditor = false;
    }
    ngOnInit() {
        this.expressionService.componentX = (window.innerWidth - this.expressionService.componentWidth) / 2;
        this.expressionService.componentY = (window.innerHeight - this.expressionService.componentHeight) / 2;
        this.expressionString = this.expressionService.currentSelectedObject?.expression
            ? this.expressionService.currentSelectedObject?.expression
            : this.expressionService.currentSelectedObject?.text?.value
                ? this.expressionService.currentSelectedObject?.text?.value
                : "";
        this.fields?.forEach((field) => {
            if (this.isTable(field)) {
                this.arrayOfStates.push({ element: field, state: "default" });
            }
        });
        this.currentSelectedFunction = "value";
        this.currentSelectedMode = "functions";
        this.expressionUpdatingSubscription = this.expressionService.needToAddExpression.subscribe((object) => {
            this.addExpressionByDrag(object);
        });
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
            this.canDragExpression = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
    addExpressionByDrag(expressionObject) {
        if (this.expressionString.length == 0) {
            this.lastCaretPosition = 0;
        }
        else {
            this.lastCaretPosition = expressionObject.lastCaretOffset;
        }
        if (typeof expressionObject.startObject.object == "string") {
            if (expressionObject.startObject.object.length == 1) {
                this.addOperator(expressionObject.startObject.object);
            }
            else {
                this.addFunction(expressionObject.startObject.object);
            }
        }
        else {
            if (expressionObject.startObject.object instanceof StiFormElement) {
                this.addFunction("Value", expressionObject.startObject.object.name, true);
            }
            else {
                if (expressionObject.startObject.object instanceof StiTotalsFieldItem) {
                    this.insertInExpression(this.lastCaretPosition, `Total(${expressionObject.startObject.object.eParent.totalsFields.indexOf(expressionObject.startObject.object) + 1},'${expressionObject.startObject.object.eParent.name}')`);
                }
                else if (expressionObject.startObject.object instanceof StiColumnItem &&
                    !expressionObject.startObject.isCell) {
                    this.insertInExpression(this.lastCaretPosition, `Col(${expressionObject.startObject.object.eParent.columns.indexOf(expressionObject.startObject.object) + 1},'${expressionObject.startObject.object.eParent.name}')`);
                }
                else {
                    this.insertInExpression(this.lastCaretPosition, `Cell(${expressionObject.startObject.object.eParent.columns.indexOf(expressionObject.startObject.object) + 1},${expressionObject.startObject.index},'${expressionObject.startObject.object.eParent.name}')`);
                }
            }
        }
    }
    onMouseMove(event) {
        if (this.canDragExpression &&
            Math.max(Math.abs(this.startX - event.clientX), Math.abs(this.startY - event.clientY)) >
                StiExpressionService.MOUSE_DELTA) {
            this.expressionService.expressionDraggableContainerX = this.dragObject.event.clientX - 10;
            this.expressionService.expressionDraggableContainerY = this.dragObject.event.clientY - 10;
            this.expressionService.startContainerDrag(this.dragObject);
            this.canDragExpression = false;
        }
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.expressionService.componentX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.expressionService.componentWidth) {
                this.expressionService.componentX = window.innerWidth - this.expressionService.componentWidth;
            }
            else {
                this.expressionService.componentX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.expressionService.componentY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.expressionService.componentHeight) {
                this.expressionService.componentY = window.innerHeight - this.expressionService.componentHeight;
            }
            else {
                this.expressionService.componentY = this.startComponentY + deltaY;
            }
        }
    }
    getState(element) {
        return this.arrayOfStates.find((item) => item.element == element).state;
    }
    changeState(element) {
        let index = this.arrayOfStates.findIndex((item) => item.element == element);
        this.arrayOfStates[index].state == "default"
            ? (this.arrayOfStates[index].state = "rotated")
            : (this.arrayOfStates[index].state = "default");
    }
    focus() {
        this.expressionService.elementRef = this.elementRef;
    }
    blur() {
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.reattach();
            this.cdr.detectChanges();
        }
    }
    getCaret() {
        this.lastCaretPosition = this.expressionService.getCaretOffset(this.elementRef.nativeElement ?? this.elementRef);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExpressionService }, { token: i3.StiLocalizationService }, { token: i4.StiMouseService }, { token: i5.StiEditableContentService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiExpressionEditorComponent, selector: "sti-expression-editor", viewQueries: [{ propertyName: "elementRef", first: true, predicate: ["expressionRef"], descendants: true }], ngImport: i0, template: `<div
    class="expression-editor-container"
    [style.left.px]="expressionService.componentX"
    [style.top.px]="expressionService.componentY"
    [style.pointer-events]="model.showHelpWindow ? 'none' : ''"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <span>{{ loc.get2("FormTitles", "ExpressionEditorForm") }}</span>
      <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div>
      <div class="nav-button" (click)="model.showExpressionEditor = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
        <!-- <i class="pi pi-times"></i> -->
      </div>
    </div>
    <div
      class="expression-preview {{ expressionService.isDragging ? 'dragging-over' : '' }}"
      (click)="expressionRef.focus()"
    >
      <label
        [id]="'expressionLabel'"
        #expressionRef
        contenteditable="plaintext-only"
        (mouseup)="getCaret()"
        (input)="setContent($event.target.textContent)"
        (blur)="expressionString = $event.target.textContent"
        (keyup)="getCaret()"
        spellcheck="false"
        [textContent]="expressionString"
        [style.cursor]="expressionService.isDragging ? 'default' : 'text'"
      ></label>
    </div>
    <div class="expression-navigation">
      <div
        class="expression-functions column"
        [style.width]="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable' ? '100%' : '30%'"
      >
        <div class="column-content">
          <span
            class="column-item {{ currentSelectedMode == 'functions' ? 'selected' : '' }}"
            (click)="changeMode('functions')"
          >
            {{ loc.getP("Functions") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'elements' ? 'selected' : '' }}"
            (click)="changeMode('elements')"
          >
            {{ loc.get2("Report", "Components") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'systemVariable' ? 'selected' : '' }}"
            (click)="changeMode('systemVariable')"
          >
            {{ loc.getP("SystemVariable") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'operators' ? 'selected' : '' }}"
            (click)="changeMode('operators')"
          >
            {{ loc.get2("MathFormula", "Operators") }}
          </span>
        </div>
      </div>
      <div
        class="expression-operators column"
        *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
      >
        <div class="column-content" *ngIf="currentSelectedMode == 'functions'">
          <span
            class="column-item {{ currentSelectedFunction == 'value' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('value')"
            (mousedown)="startExpressionDragging({ object: 'Value', event: $event })"
            (dblclick)="addFunction('Value')"
          >
            {{ "Value()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'count' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('count')"
            (mousedown)="startExpressionDragging({ object: 'Count', event: $event })"
            (dblclick)="addFunction('Count')"
          >
            {{ "Count()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'min' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('min')"
            (mousedown)="startExpressionDragging({ object: 'Min', event: $event })"
            (dblclick)="addFunction('Min')"
          >
            {{ "Min()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'max' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('max')"
            (mousedown)="startExpressionDragging({ object: 'Max', event: $event })"
            (dblclick)="addFunction('Max')"
          >
            {{ "Max()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'sum' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('sum')"
            (mousedown)="startExpressionDragging({ object: 'Sum', event: $event })"
            (dblclick)="addFunction('Sum')"
          >
            {{ "Sum()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'cell' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('cell')"
            (mousedown)="startExpressionDragging({ object: 'Cell', event: $event })"
            (dblclick)="addFunction('Cell')"
          >
            {{ "Cell()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'total' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('total')"
            (mousedown)="startExpressionDragging({ object: 'Total', event: $event })"
            (dblclick)="addFunction('Total')"
          >
            {{ "Total()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'col' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('col')"
            (mousedown)="startExpressionDragging({ object: 'Col', event: $event })"
            (dblclick)="addFunction('Col')"
          >
            {{ "Col()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'row' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('row')"
            (mousedown)="startExpressionDragging({ object: 'Row', event: $event })"
            (dblclick)="addFunction('Row')"
          >
            {{ "Row()" }}
          </span>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'systemVariable'">
          <span
            class="column-item {{ currentSelectedFunction == 'line' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('line')"
            (mousedown)="startExpressionDragging({ object: 'Line', event: $event })"
            (dblclick)="addFunction('Line')"
          >
            {{ "Line" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'today' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('today')"
            (mousedown)="startExpressionDragging({ object: 'Today', event: $event })"
            (dblclick)="addFunction('Today')"
          >
            {{ "Today" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'time' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('time')"
            (mousedown)="startExpressionDragging({ object: 'Time', event: $event })"
            (dblclick)="addFunction('Time')"
          >
            {{ "Time" }}
          </span>
        </div>
      </div>
      <div class="expression-fields column">
        <div
          class="column-content"
          *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
        >
          <div *ngFor="let sample of samples" class="sample-item">
            <span>{{ sample }}</span>
          </div>
          <div class="sample-item" [style.padding]="'15px 0px'">
            <span>{{ title }}</span>
          </div>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'operators'">
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Plus')"
            tooltipPosition="bottom"
            showDelay="500"
            (dblclick)="addOperator('+')"
            (mousedown)="startExpressionDragging({ object: '+', event: $event })"
            >+</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Minus')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '-', event: $event })"
            (dblclick)="addOperator('-')"
            >-</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Multiply')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '*', event: $event })"
            (dblclick)="addOperator('*')"
            >*</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Division')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '/', event: $event })"
            (dblclick)="addOperator('/')"
            >/</span
          >
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'elements'">
          <div *ngFor="let field of fields">
            <div
              class="column-item field"
              [style.padding]="isTable(field) ? '4px 5px 4px 0px' : '4px 5px'"
              (click)="isTable(field) ? changeState(field) : ''"
              (mousedown)="!isTable(field) ? startExpressionDragging({ object: field, event: $event }) : ''"
              (dblclick)="!isTable(field) ? addValue(field) : ''"
            >
              <div *ngIf="isTable(field)" class="arrow" [@rotatedState]="getState(field)">
                <i class="pi pi-chevron-right"></i>
              </div>
              <span>{{ field.name }}</span>
            </div>
            <sti-columns-preview
              *ngIf="isTable(field)"
              [object]="field"
              (fieldClick)="nestedFieldClick($event)"
              (startFieldDrag)="startExpressionDragging($event)"
              [state]="getState(field) == 'default' ? false : true"
            ></sti-columns-preview>
          </div>
        </div>
      </div>
    </div>
    <div class="footer-navigation">
      <div class="footer-button accept" (click)="save()" [style.margin-right.px]="0">
        <span>{{ loc.get2("Buttons", "Save") }}</span>
      </div>
      <div class="footer-button cancel" (click)="model.showExpressionEditor = false">
        <span>{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div>`, isInline: true, styles: [".arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.pi{font-size:.825rem}.selected{background-color:#e5e5e5}.expression-editor-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;z-index:999}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.expression-preview{width:calc(100% - 20px);margin:10px 10px 5px;padding:5px;background-color:#fafafa;border:1px solid lightgray;height:135px;-webkit-user-select:text;display:flex}.expression-preview label{-webkit-user-select:text;font-size:13px;outline:none;height:100%;width:100%;overflow:auto}.dragging-over{background-color:#ebebeb!important;border:1px dashed black!important}.expression-navigation{display:flex;width:100%;padding:0 5px}.column{border:1px solid lightgray;height:230px;width:100%;margin:5px}.buttons{height:250px;min-width:150px;display:flex;flex-direction:column;justify-content:center;align-items:center}.buttons img{height:52px;width:52px;border-radius:3px;margin:5px;padding:10px}.buttons img:hover{background-color:#d3d3d3}.column-header{-webkit-user-select:none;height:30px;background-color:#d3d3d3;display:flex;align-items:center;padding:0 10px;border-top-left-radius:4px;border-top-right-radius:4px}.column-header span{font-size:15px;-webkit-user-select:none;cursor:default}.footer-navigation{width:100%;display:flex;justify-content:flex-end;height:50px;align-items:center}.footer-button{min-width:90px;height:30px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px;-webkit-user-select:none;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.column-content{width:100%;padding:5px;display:flex;max-height:229px;overflow-y:auto;flex-direction:column}.operator-item{font-family:Arial;color:var(--text-color);font-size:17px;padding:2px 7px;border-radius:3px;-webkit-user-select:none}.operator-item:hover{background-color:#f0f0f0}.sample-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding-bottom:3px;cursor:default}.column-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding:5px;cursor:default}.column-item:hover{background-color:#f0f0f0}.info{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.info img{height:16px;width:16px;cursor:pointer}.field{display:flex;align-items:center}.field img{height:16px;width:16px;margin-right:5px}\n"], dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiColumnsPreviewComponent, selector: "sti-columns-preview", inputs: ["state", "object"], outputs: ["fieldClick", "startFieldDrag"] }, { kind: "directive", type: i8.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }], animations: [RotateAnimation] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-expression-editor", template: `<div
    class="expression-editor-container"
    [style.left.px]="expressionService.componentX"
    [style.top.px]="expressionService.componentY"
    [style.pointer-events]="model.showHelpWindow ? 'none' : ''"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <span>{{ loc.get2("FormTitles", "ExpressionEditorForm") }}</span>
      <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div>
      <div class="nav-button" (click)="model.showExpressionEditor = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
        <!-- <i class="pi pi-times"></i> -->
      </div>
    </div>
    <div
      class="expression-preview {{ expressionService.isDragging ? 'dragging-over' : '' }}"
      (click)="expressionRef.focus()"
    >
      <label
        [id]="'expressionLabel'"
        #expressionRef
        contenteditable="plaintext-only"
        (mouseup)="getCaret()"
        (input)="setContent($event.target.textContent)"
        (blur)="expressionString = $event.target.textContent"
        (keyup)="getCaret()"
        spellcheck="false"
        [textContent]="expressionString"
        [style.cursor]="expressionService.isDragging ? 'default' : 'text'"
      ></label>
    </div>
    <div class="expression-navigation">
      <div
        class="expression-functions column"
        [style.width]="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable' ? '100%' : '30%'"
      >
        <div class="column-content">
          <span
            class="column-item {{ currentSelectedMode == 'functions' ? 'selected' : '' }}"
            (click)="changeMode('functions')"
          >
            {{ loc.getP("Functions") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'elements' ? 'selected' : '' }}"
            (click)="changeMode('elements')"
          >
            {{ loc.get2("Report", "Components") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'systemVariable' ? 'selected' : '' }}"
            (click)="changeMode('systemVariable')"
          >
            {{ loc.getP("SystemVariable") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'operators' ? 'selected' : '' }}"
            (click)="changeMode('operators')"
          >
            {{ loc.get2("MathFormula", "Operators") }}
          </span>
        </div>
      </div>
      <div
        class="expression-operators column"
        *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
      >
        <div class="column-content" *ngIf="currentSelectedMode == 'functions'">
          <span
            class="column-item {{ currentSelectedFunction == 'value' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('value')"
            (mousedown)="startExpressionDragging({ object: 'Value', event: $event })"
            (dblclick)="addFunction('Value')"
          >
            {{ "Value()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'count' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('count')"
            (mousedown)="startExpressionDragging({ object: 'Count', event: $event })"
            (dblclick)="addFunction('Count')"
          >
            {{ "Count()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'min' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('min')"
            (mousedown)="startExpressionDragging({ object: 'Min', event: $event })"
            (dblclick)="addFunction('Min')"
          >
            {{ "Min()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'max' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('max')"
            (mousedown)="startExpressionDragging({ object: 'Max', event: $event })"
            (dblclick)="addFunction('Max')"
          >
            {{ "Max()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'sum' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('sum')"
            (mousedown)="startExpressionDragging({ object: 'Sum', event: $event })"
            (dblclick)="addFunction('Sum')"
          >
            {{ "Sum()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'cell' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('cell')"
            (mousedown)="startExpressionDragging({ object: 'Cell', event: $event })"
            (dblclick)="addFunction('Cell')"
          >
            {{ "Cell()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'total' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('total')"
            (mousedown)="startExpressionDragging({ object: 'Total', event: $event })"
            (dblclick)="addFunction('Total')"
          >
            {{ "Total()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'col' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('col')"
            (mousedown)="startExpressionDragging({ object: 'Col', event: $event })"
            (dblclick)="addFunction('Col')"
          >
            {{ "Col()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'row' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('row')"
            (mousedown)="startExpressionDragging({ object: 'Row', event: $event })"
            (dblclick)="addFunction('Row')"
          >
            {{ "Row()" }}
          </span>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'systemVariable'">
          <span
            class="column-item {{ currentSelectedFunction == 'line' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('line')"
            (mousedown)="startExpressionDragging({ object: 'Line', event: $event })"
            (dblclick)="addFunction('Line')"
          >
            {{ "Line" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'today' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('today')"
            (mousedown)="startExpressionDragging({ object: 'Today', event: $event })"
            (dblclick)="addFunction('Today')"
          >
            {{ "Today" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'time' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('time')"
            (mousedown)="startExpressionDragging({ object: 'Time', event: $event })"
            (dblclick)="addFunction('Time')"
          >
            {{ "Time" }}
          </span>
        </div>
      </div>
      <div class="expression-fields column">
        <div
          class="column-content"
          *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
        >
          <div *ngFor="let sample of samples" class="sample-item">
            <span>{{ sample }}</span>
          </div>
          <div class="sample-item" [style.padding]="'15px 0px'">
            <span>{{ title }}</span>
          </div>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'operators'">
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Plus')"
            tooltipPosition="bottom"
            showDelay="500"
            (dblclick)="addOperator('+')"
            (mousedown)="startExpressionDragging({ object: '+', event: $event })"
            >+</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Minus')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '-', event: $event })"
            (dblclick)="addOperator('-')"
            >-</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Multiply')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '*', event: $event })"
            (dblclick)="addOperator('*')"
            >*</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Division')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '/', event: $event })"
            (dblclick)="addOperator('/')"
            >/</span
          >
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'elements'">
          <div *ngFor="let field of fields">
            <div
              class="column-item field"
              [style.padding]="isTable(field) ? '4px 5px 4px 0px' : '4px 5px'"
              (click)="isTable(field) ? changeState(field) : ''"
              (mousedown)="!isTable(field) ? startExpressionDragging({ object: field, event: $event }) : ''"
              (dblclick)="!isTable(field) ? addValue(field) : ''"
            >
              <div *ngIf="isTable(field)" class="arrow" [@rotatedState]="getState(field)">
                <i class="pi pi-chevron-right"></i>
              </div>
              <span>{{ field.name }}</span>
            </div>
            <sti-columns-preview
              *ngIf="isTable(field)"
              [object]="field"
              (fieldClick)="nestedFieldClick($event)"
              (startFieldDrag)="startExpressionDragging($event)"
              [state]="getState(field) == 'default' ? false : true"
            ></sti-columns-preview>
          </div>
        </div>
      </div>
    </div>
    <div class="footer-navigation">
      <div class="footer-button accept" (click)="save()" [style.margin-right.px]="0">
        <span>{{ loc.get2("Buttons", "Save") }}</span>
      </div>
      <div class="footer-button cancel" (click)="model.showExpressionEditor = false">
        <span>{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div>`, animations: [RotateAnimation], styles: [".arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.pi{font-size:.825rem}.selected{background-color:#e5e5e5}.expression-editor-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;z-index:999}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.expression-preview{width:calc(100% - 20px);margin:10px 10px 5px;padding:5px;background-color:#fafafa;border:1px solid lightgray;height:135px;-webkit-user-select:text;display:flex}.expression-preview label{-webkit-user-select:text;font-size:13px;outline:none;height:100%;width:100%;overflow:auto}.dragging-over{background-color:#ebebeb!important;border:1px dashed black!important}.expression-navigation{display:flex;width:100%;padding:0 5px}.column{border:1px solid lightgray;height:230px;width:100%;margin:5px}.buttons{height:250px;min-width:150px;display:flex;flex-direction:column;justify-content:center;align-items:center}.buttons img{height:52px;width:52px;border-radius:3px;margin:5px;padding:10px}.buttons img:hover{background-color:#d3d3d3}.column-header{-webkit-user-select:none;height:30px;background-color:#d3d3d3;display:flex;align-items:center;padding:0 10px;border-top-left-radius:4px;border-top-right-radius:4px}.column-header span{font-size:15px;-webkit-user-select:none;cursor:default}.footer-navigation{width:100%;display:flex;justify-content:flex-end;height:50px;align-items:center}.footer-button{min-width:90px;height:30px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px;-webkit-user-select:none;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.column-content{width:100%;padding:5px;display:flex;max-height:229px;overflow-y:auto;flex-direction:column}.operator-item{font-family:Arial;color:var(--text-color);font-size:17px;padding:2px 7px;border-radius:3px;-webkit-user-select:none}.operator-item:hover{background-color:#f0f0f0}.sample-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding-bottom:3px;cursor:default}.column-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding:5px;cursor:default}.column-item:hover{background-color:#f0f0f0}.info{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.info img{height:16px;width:16px;cursor:pointer}.field{display:flex;align-items:center}.field img{height:16px;width:16px;margin-right:5px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiExpressionService }, { type: i3.StiLocalizationService }, { type: i4.StiMouseService }, { type: i5.StiEditableContentService }, { type: i0.ChangeDetectorRef }], propDecorators: { elementRef: [{
                type: ViewChild,
                args: ["expressionRef"]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWV4cHJlc3Npb24tZWRpdG9yLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3N0aS1leHByZXNzaW9uLWVkaXRvci9zdGktZXhwcmVzc2lvbi1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBb0MsU0FBUyxFQUFpQyxTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFFdEgsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLG9DQUFvQyxDQUFDO0FBQ3BFLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxnQ0FBZ0MsQ0FBQztBQUNqRSxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxvQ0FBb0MsQ0FBQztBQUN6RSxPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sZ0NBQWdDLENBQUM7QUFDakUsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sa0NBQWtDLENBQUM7QUFDckUsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0seUNBQXlDLENBQUM7QUFJN0UsT0FBTyxFQUFFLG9CQUFvQixFQUFFLE1BQU0sdUNBQXVDLENBQUM7QUFHN0UsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLDBCQUEwQixDQUFDO0FBQzNELE9BQU8sRUFBRSxhQUFhLEVBQUUsTUFBTSxvQ0FBb0MsQ0FBQzs7Ozs7Ozs7OztBQThlbkUsTUFBTSxPQUFPLDRCQUE0QjtJQW1GdkMsWUFDUyxLQUFzQixFQUN0QixpQkFBdUMsRUFDdkMsR0FBMkIsRUFDM0IsWUFBNkIsRUFDN0IsZUFBMEMsRUFDekMsR0FBc0I7UUFMdkIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2QyxRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUMzQixpQkFBWSxHQUFaLFlBQVksQ0FBaUI7UUFDN0Isb0JBQWUsR0FBZixlQUFlLENBQTJCO1FBQ3pDLFFBQUcsR0FBSCxHQUFHLENBQW1CO1FBdEZ6QixxQkFBZ0IsR0FBRyxJQUFJLENBQUM7UUFDeEIsd0JBQW1CLEdBQUcsV0FBVyxDQUFDO1FBQ2xDLDRCQUF1QixHQUFHLE9BQU8sQ0FBQztRQU9sQyxzQkFBaUIsR0FBWSxLQUFLLENBQUM7UUFPbkMsbUJBQWMsR0FBMEI7WUFDN0M7Z0JBQ0UsWUFBWSxFQUFFLE9BQU87Z0JBQ3JCLE9BQU8sRUFBRSxDQUFDLGtCQUFrQixFQUFFLG9CQUFvQixFQUFFLGdCQUFnQixDQUFDO2dCQUNyRSxLQUFLLEVBQUUsOENBQThDO2FBQ3REO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLE9BQU87Z0JBQ3JCLE9BQU8sRUFBRSxDQUFDLHVCQUF1QixFQUFFLDZCQUE2QixDQUFDO2dCQUNqRSxLQUFLLEVBQUUsNkJBQTZCO2FBQ3JDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLE9BQU8sRUFBRSxDQUFDLHFCQUFxQixFQUFFLDJCQUEyQixDQUFDO2dCQUM3RCxLQUFLLEVBQUUsNkJBQTZCO2FBQ3JDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLE9BQU8sRUFBRSxDQUFDLHFCQUFxQixFQUFFLDJCQUEyQixDQUFDO2dCQUM3RCxLQUFLLEVBQUUsNEJBQTRCO2FBQ3BDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLE9BQU8sRUFBRSxDQUFDLHFCQUFxQixFQUFFLDJCQUEyQixDQUFDO2dCQUM3RCxLQUFLLEVBQUUsNEJBQTRCO2FBQ3BDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLE1BQU07Z0JBQ3BCLE9BQU8sRUFBRSxDQUFDLHNCQUFzQixFQUFFLDhCQUE4QixDQUFDO2dCQUNqRSxLQUFLLEVBQUUsZ0NBQWdDO2FBQ3hDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLE9BQU87Z0JBQ3JCLE9BQU8sRUFBRSxDQUFDLGdCQUFnQixFQUFFLHdCQUF3QixDQUFDO2dCQUNyRCxLQUFLLEVBQUUsOEJBQThCO2FBQ3RDO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLE9BQU8sRUFBRSxDQUFDLGVBQWUsRUFBRSx1QkFBdUIsQ0FBQztnQkFDbkQsS0FBSyxFQUFFLDZEQUE2RDthQUNyRTtZQUNEO2dCQUNFLFlBQVksRUFBRSxLQUFLO2dCQUNuQixPQUFPLEVBQUUsQ0FBQyxlQUFlLEVBQUUsdUJBQXVCLENBQUM7Z0JBQ25ELEtBQUssRUFBRSwwREFBMEQ7YUFDbEU7WUFDRDtnQkFDRSxZQUFZLEVBQUUsTUFBTTtnQkFDcEIsT0FBTyxFQUFFLENBQUMsTUFBTSxDQUFDO2dCQUNqQixLQUFLLEVBQUUsd0RBQXdEO2FBQ2hFO1lBQ0Q7Z0JBQ0UsWUFBWSxFQUFFLE9BQU87Z0JBQ3JCLE9BQU8sRUFBRSxDQUFDLE9BQU8sQ0FBQztnQkFDbEIsS0FBSyxFQUFFLDZDQUE2QzthQUNyRDtZQUNEO2dCQUNFLFlBQVksRUFBRSxNQUFNO2dCQUNwQixPQUFPLEVBQUUsQ0FBQyxNQUFNLENBQUM7Z0JBQ2pCLEtBQUssRUFBRSw2Q0FBNkM7YUFDckQ7U0FDRixDQUFDO1FBRUssa0JBQWEsR0FBRyxFQUFFLENBQUM7SUFRdEIsQ0FBQztJQUNMLGVBQWU7UUFDYixJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDdEQsQ0FBQztJQUNELFdBQVc7UUFDVCxJQUFJLENBQUMscUJBQXFCLEVBQUUsV0FBVyxFQUFFLENBQUM7UUFDMUMsSUFBSSxDQUFDLG1CQUFtQixFQUFFLFdBQVcsRUFBRSxDQUFDO1FBQ3hDLElBQUksQ0FBQyw4QkFBOEIsRUFBRSxXQUFXLEVBQUUsQ0FBQztRQUNuRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztJQUMzQyxDQUFDO0lBRUQsdUJBQXVCLENBQUMsVUFBVTtRQUNoQyxJQUFJLENBQUMsTUFBTSxHQUFHLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxNQUFNLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDdkMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQztRQUM5QixJQUFJLENBQUMsVUFBVSxHQUFHLFVBQVUsQ0FBQztJQUMvQixDQUFDO0lBQ0QsVUFBVSxDQUFDLFNBQVM7UUFDbEIsSUFBSSxTQUFTLElBQUksRUFBRSxJQUFJLFNBQVMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUN6QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO1FBQ3BDLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksU0FBUyxFQUFFLENBQUM7WUFDeEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztRQUNwQixDQUFDO0lBQ0gsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxnQkFBZ0IsR0FBWSxLQUFLLENBQUM7UUFDdEMsSUFBSSxlQUFlLEdBQVksS0FBSyxDQUFDO1FBQ3JDLElBQUksSUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUM7WUFDM0IsS0FBSyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztnQkFDckQsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7b0JBQ3JDLGdCQUFnQixHQUFHLElBQUksQ0FBQztvQkFDeEIsTUFBTTtnQkFDUixDQUFDO3FCQUFNLElBQUksSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO29CQUM1QyxlQUFlLEdBQUcsSUFBSSxDQUFDO29CQUN2QixNQUFNO2dCQUNSLENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUNELElBQUksZ0JBQWdCLElBQUksQ0FBQyxDQUFDLGdCQUFnQixJQUFJLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQztZQUNoRSxPQUFPLElBQUksQ0FBQztRQUNkLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxLQUFLLENBQUM7UUFDZixDQUFDO0lBQ0gsQ0FBQztJQUNELFFBQVE7UUFDTixJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUM7SUFDbkMsQ0FBQztJQUNELFFBQVEsQ0FBQyxPQUFPO1FBQ2QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsVUFBVSxDQUFDLElBQUk7UUFDYixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksU0FBUyxFQUFFLENBQUM7WUFDeEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNwQixJQUFJLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQzNCLENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLGdCQUFnQixFQUFFLENBQUM7WUFDakUsSUFBSSxDQUFDLHVCQUF1QixHQUFHLE1BQU0sQ0FBQztRQUN4QyxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxPQUFPLENBQUM7UUFDekMsQ0FBQztRQUNELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUM7SUFDbEMsQ0FBQztJQUNELG9CQUFvQixDQUFDLElBQUk7UUFDdkIsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQztJQUN0QyxDQUFDO0lBQ0QsU0FBUyxDQUFDLEtBQUs7UUFDYixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDNUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzVCLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsQ0FBQztRQUN6RCxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLENBQUM7UUFDekQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLE9BQU8sQ0FBQztJQUMzRyxDQUFDO0lBQ0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxLQUFLLENBQUM7SUFDekcsQ0FBQztJQUNELGdCQUFnQixDQUFDLEtBQUs7UUFDcEIsSUFBSSxLQUFLLFlBQVksa0JBQWtCLEVBQUUsQ0FBQztZQUN4QyxJQUFJLENBQUMsa0JBQWtCLENBQ3JCLElBQUksQ0FBQyxpQkFBaUIsRUFDdEIsU0FBUyxLQUFLLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQ2xGLENBQUM7UUFDSixDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQyxrQkFBa0IsQ0FDckIsSUFBSSxDQUFDLGlCQUFpQixFQUN0QixRQUFRLEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsS0FBSyxLQUFLLEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUNoSCxDQUFDO1FBQ0osQ0FBQztJQUNILENBQUM7SUFDRCxJQUFXLE1BQU07UUFDZixJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDaEIsSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1lBQ3hDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQ25DLElBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO29CQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUN2QixDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFDRCxPQUFPLENBQUMsT0FBTztRQUNiLE9BQU8sT0FBTyxZQUFZLGVBQWUsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsY0FBYyxDQUFDLE9BQU87UUFDcEIsT0FBTyxPQUFPLFlBQVksZUFBZTtZQUN2QyxPQUFPLFlBQVksaUJBQWlCO1lBQ3BDLE9BQU8sWUFBWSxtQkFBbUI7WUFDdEMsQ0FBQyxDQUFDLElBQUk7WUFDTixDQUFDLENBQUMsS0FBSyxDQUFDO0lBQ1osQ0FBQztJQUNELFdBQVcsQ0FBQyxRQUFnQjtRQUMxQixJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLFFBQVEsRUFBRSxJQUFJLENBQUMsQ0FBQztJQUNsRSxDQUFDO0lBQ0QsV0FBVyxDQUFDLElBQVksRUFBRSxJQUFhLEVBQUUsU0FBa0IsS0FBSztRQUM5RCxJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDaEIsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksT0FBTyxFQUFFLENBQUM7WUFDbEMsTUFBTSxHQUFHLElBQUksR0FBRyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQztRQUM1QyxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksTUFBTSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxPQUFPLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ3pHLE1BQU0sR0FBRyxJQUFJLENBQUM7UUFDaEIsQ0FBQzthQUFNLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ3hDLE1BQU0sR0FBRyxJQUFJLEdBQUcsUUFBUSxDQUFDO1FBQzNCLENBQUM7YUFBTSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxPQUFPLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLEtBQUssSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdkcsTUFBTSxHQUFHLElBQUksR0FBRyxPQUFPLENBQUM7UUFDMUIsQ0FBQzthQUFNLENBQUM7WUFDTixNQUFNLEdBQUcsSUFBSSxHQUFHLElBQUksQ0FBQztRQUN2QixDQUFDO1FBQ0QsSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4RixDQUFDO0lBQ0Qsa0JBQWtCLENBQUMsUUFBZ0IsRUFBRSxNQUFjLEVBQUUsVUFBVSxHQUFHLEtBQUssRUFBRSxVQUFVLEdBQUcsS0FBSztRQUN6RixJQUFJLFlBQVksR0FBRyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQzdELElBQUksY0FBYyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUMzQyxJQUFJLGtCQUFrQixHQUFHLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxNQUFNLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO1FBQ3pGLElBQUksSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksUUFBUSxFQUFFLENBQUM7WUFDakQsSUFBSSxRQUFRLElBQUksQ0FBQyxFQUFFLENBQUM7Z0JBQ2xCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxrQkFBa0IsR0FBRyxjQUFjLENBQUM7WUFDOUQsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxnQkFBZ0I7b0JBQ25CLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLFFBQVEsQ0FBQzt3QkFDakMsa0JBQWtCO3dCQUNsQixjQUFjLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxjQUFjLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDMUQsQ0FBQztRQUNILENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGdCQUFnQixJQUFJLGtCQUFrQixDQUFDO1FBQzlDLENBQUM7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxRQUFRLENBQUMsa0JBQTBCLEVBQUUsYUFBc0IsS0FBSztRQUM5RCxJQUFJLGdCQUFnQixHQUFHLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUN2RCxJQUFJLFlBQVksR0FBRyxDQUFDLENBQUM7UUFDckIsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1lBQzVCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxHQUFHLGtCQUFrQixDQUFDLE1BQU0sQ0FBQztRQUNwRixDQUFDO1FBQ0QsSUFBSSxVQUFVLEVBQUUsQ0FBQztZQUNmLElBQUksa0JBQWtCLENBQUMsZ0JBQWdCLEdBQUcsQ0FBQyxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7Z0JBQ3BELFlBQVksR0FBRyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsZ0JBQWdCLEdBQUcsQ0FBQyxDQUFDO1lBQy9ELENBQUM7aUJBQU0sQ0FBQztnQkFDTixZQUFZLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGdCQUFnQixHQUFHLENBQUMsQ0FBQztZQUMvRCxDQUFDO1FBQ0gsQ0FBQzthQUFNLENBQUM7WUFDTixZQUFZLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGtCQUFrQixDQUFDLE1BQU0sQ0FBQztRQUNwRSxDQUFDO1FBRUQsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ2IsVUFBVSxDQUFDLEdBQUcsRUFBRTtZQUNkLElBQUksS0FBSyxHQUFHLFFBQVEsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNuQyxJQUFJLEdBQUcsR0FBRyxNQUFNLENBQUMsWUFBWSxFQUFFLENBQUM7WUFFaEMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxFQUFFLFlBQVksQ0FBQyxDQUFDO1lBQ2pELEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDckIsSUFBSSxDQUFDLGlCQUFpQixJQUFJLGtCQUFrQixDQUFDLE1BQU0sQ0FBQztZQUNwRCxHQUFHLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDdEIsR0FBRyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN0QixDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFDRCxJQUFJO1FBQ0YsSUFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLFlBQVksZUFBZSxFQUFFLENBQUM7WUFDNUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1lBQ2hGLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO1FBQ3ZELENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDbEYsQ0FBQztRQUNELElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDRCxRQUFRO1FBQ04sSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNwRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxHQUFHLENBQUMsTUFBTSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3RHLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsVUFBVTtZQUM5RSxDQUFDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLFVBQVU7WUFDMUQsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLEVBQUUsS0FBSztnQkFDekQsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLEVBQUUsS0FBSztnQkFDM0QsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNULElBQUksQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUU7WUFDN0IsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEVBQUUsT0FBTyxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQztZQUNoRSxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsdUJBQXVCLEdBQUcsT0FBTyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLDhCQUE4QixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsQ0FBQyxTQUFTLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtZQUNwRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDbkMsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUU7WUFDL0UsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDeEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztRQUNqQyxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLG9CQUFvQixFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBaUIsRUFBRSxFQUFFO1lBQ3BHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUIsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsbUJBQW1CLENBQUMsZ0JBQThDO1FBQ2hFLElBQUksSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sSUFBSSxDQUFDLEVBQUUsQ0FBQztZQUN0QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO1FBQzdCLENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGlCQUFpQixHQUFHLGdCQUFnQixDQUFDLGVBQWUsQ0FBQztRQUM1RCxDQUFDO1FBQ0QsSUFBSSxPQUFPLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLElBQUksUUFBUSxFQUFFLENBQUM7WUFDM0QsSUFBSSxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE1BQU0sSUFBSSxDQUFDLEVBQUUsQ0FBQztnQkFDcEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDeEQsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxXQUFXLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ3hELENBQUM7UUFDSCxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sWUFBWSxjQUFjLEVBQUUsQ0FBQztnQkFDbEUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDNUUsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sWUFBWSxrQkFBa0IsRUFBRSxDQUFDO29CQUN0RSxJQUFJLENBQUMsa0JBQWtCLENBQ3JCLElBQUksQ0FBQyxpQkFBaUIsRUFDdEIsU0FBUyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUNqSCxLQUFLLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUMxRCxDQUFDO2dCQUNKLENBQUM7cUJBQU0sSUFDTCxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxZQUFZLGFBQWE7b0JBQzVELENBQUMsZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sRUFDcEMsQ0FBQztvQkFDRCxJQUFJLENBQUMsa0JBQWtCLENBQ3JCLElBQUksQ0FBQyxpQkFBaUIsRUFDdEIsT0FBTyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUMxRyxLQUFLLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUMxRCxDQUFDO2dCQUNKLENBQUM7cUJBQU0sQ0FBQztvQkFDTixJQUFJLENBQUMsa0JBQWtCLENBQ3JCLElBQUksQ0FBQyxpQkFBaUIsRUFDdEIsUUFBUSxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUMzRyxJQUFJLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxLQUFLLEtBQUssZ0JBQWdCLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQ2hHLENBQUM7Z0JBQ0osQ0FBQztZQUNILENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUNELFdBQVcsQ0FBQyxLQUFLO1FBQ2YsSUFDRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3RCLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUN0RixvQkFBb0IsQ0FBQyxXQUFXLEVBQ2hDLENBQUM7WUFDRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUMxRixJQUFJLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUMxRixJQUFJLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQzNELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7UUFDakMsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO1lBQ3BCLElBQUksTUFBTSxHQUFHLEtBQUssQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUN6QyxJQUFJLE1BQU0sR0FBRyxLQUFLLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7WUFDekMsSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztnQkFDdEMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUM7WUFDeEMsQ0FBQztpQkFBTSxJQUFJLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxHQUFHLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxDQUFDO2dCQUNyRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsQ0FBQztZQUNoRyxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQztZQUNwRSxDQUFDO1lBRUQsSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztnQkFDdEMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUM7WUFDeEMsQ0FBQztpQkFBTSxJQUFJLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxHQUFHLE1BQU0sQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxDQUFDO2dCQUN2RyxJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGVBQWUsQ0FBQztZQUNsRyxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQztZQUNwRSxDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUM7SUFDRCxRQUFRLENBQUMsT0FBTztRQUNkLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLENBQUMsS0FBSyxDQUFDO0lBQzFFLENBQUM7SUFDRCxXQUFXLENBQUMsT0FBTztRQUNqQixJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQztRQUM1RSxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLEtBQUssSUFBSSxTQUFTO1lBQzFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUMvQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsS0FBSztRQUNILElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBSTtRQUNGLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEVBQUUsSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEVBQUUsSUFBSSxTQUFTLEVBQUUsQ0FBQztZQUN4RixJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQ3BCLElBQUksQ0FBQyxHQUFHLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDM0IsQ0FBQztJQUNILENBQUM7SUFDRCxRQUFRO1FBQ04sSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ25ILENBQUM7K0dBNVlVLDRCQUE0QjttR0FBNUIsNEJBQTRCLDBLQTFlN0I7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O1NBMlBILHM3SEE2T0ssQ0FBQyxlQUFlLENBQUM7OzRGQUVsQiw0QkFBNEI7a0JBNWV4QyxTQUFTOytCQUNFLHVCQUF1QixZQUN2Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7U0EyUEgsY0E2T0ssQ0FBQyxlQUFlLENBQUM7a1FBR0QsVUFBVTtzQkFBckMsU0FBUzt1QkFBQyxlQUFlIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWZ0ZXJWaWV3SW5pdCwgQ2hhbmdlRGV0ZWN0b3JSZWYsIENvbXBvbmVudCwgRWxlbWVudFJlZiwgT25EZXN0cm95LCBPbkluaXQsIFZpZXdDaGlsZCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN1YnNjcmlwdGlvbiB9IGZyb20gXCJyeGpzXCI7XHJcbmltcG9ydCB7IFN0aUZvcm1FbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL2Jhc2UvU3RpRm9ybUVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpTGFiZWxFbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL1N0aUxhYmVsRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlOdW1iZXJCb3hFbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL1N0aU51bWJlckJveEVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpVGFibGVFbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL1N0aVRhYmxlRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlUZXh0Qm94RWxlbWVudCB9IGZyb20gXCIuLi8uLi9lbGVtZW50cy9TdGlUZXh0Qm94RWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlUb3RhbHNGaWVsZEl0ZW0gfSBmcm9tIFwiLi4vLi4vZWxlbWVudHMvdGFibGUvU3RpVG90YWxzRmllbGRJdGVtXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aU1vdXNlU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9tb3VzZS5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRhYmxlQ29udGVudFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLWVkaXRhYmxlLWNvbnRlbnQuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlFeHByZXNzaW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktZXhwcmVzc2lvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUxvY2FsaXphdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLWxvY2FsaXphdGlvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aURyYWdnYWJsZUV4cHJlc3Npb25PYmplY3QsIFN0aUV4cHJlc3Npb25TYW1wbGUgfSBmcm9tIFwiLi4vLi4vc3lzdGVtL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IHsgUm90YXRlQW5pbWF0aW9uIH0gZnJvbSBcIi4uL2FuaW1hdGlvbnMvYW5pbWF0aW9uc1wiO1xyXG5pbXBvcnQgeyBTdGlDb2x1bW5JdGVtIH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL3RhYmxlL1N0aUNvbHVtbkl0ZW1cIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1leHByZXNzaW9uLWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgPGRpdlxyXG4gICAgY2xhc3M9XCJleHByZXNzaW9uLWVkaXRvci1jb250YWluZXJcIlxyXG4gICAgW3N0eWxlLmxlZnQucHhdPVwiZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WFwiXHJcbiAgICBbc3R5bGUudG9wLnB4XT1cImV4cHJlc3Npb25TZXJ2aWNlLmNvbXBvbmVudFlcIlxyXG4gICAgW3N0eWxlLnBvaW50ZXItZXZlbnRzXT1cIm1vZGVsLnNob3dIZWxwV2luZG93ID8gJ25vbmUnIDogJydcIlxyXG4gID5cclxuICAgIDxkaXYgY2xhc3M9XCJoZWFkZXItbmF2aWdhdGlvblwiIChtb3VzZWRvd24pPVwic3RhcnREcmFnKCRldmVudClcIj5cclxuICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJGb3JtVGl0bGVzXCIsIFwiRXhwcmVzc2lvbkVkaXRvckZvcm1cIikgfX08L3NwYW4+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJuYXYtYnV0dG9uXCIgKGNsaWNrKT1cInNob3dJbmZvKClcIj48aW1nIFtzcmNdPVwibW9kZWwuZ2V0SW1hZ2UoJ2ltYWdlcy5PdGhlci5IZWxwSWNvbi5wbmcnKVwiIC8+PC9kaXY+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJuYXYtYnV0dG9uXCIgKGNsaWNrKT1cIm1vZGVsLnNob3dFeHByZXNzaW9uRWRpdG9yID0gZmFsc2VcIj5cclxuICAgICAgICA8aW1nIFtzcmNdPVwibW9kZWwuZ2V0SW1hZ2UoJ2ltYWdlcy5PdGhlci5DbG9zZUZvcm0ucG5nJylcIiAvPlxyXG4gICAgICAgIDwhLS0gPGkgY2xhc3M9XCJwaSBwaS10aW1lc1wiPjwvaT4gLS0+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgPC9kaXY+XHJcbiAgICA8ZGl2XHJcbiAgICAgIGNsYXNzPVwiZXhwcmVzc2lvbi1wcmV2aWV3IHt7IGV4cHJlc3Npb25TZXJ2aWNlLmlzRHJhZ2dpbmcgPyAnZHJhZ2dpbmctb3ZlcicgOiAnJyB9fVwiXHJcbiAgICAgIChjbGljayk9XCJleHByZXNzaW9uUmVmLmZvY3VzKClcIlxyXG4gICAgPlxyXG4gICAgICA8bGFiZWxcclxuICAgICAgICBbaWRdPVwiJ2V4cHJlc3Npb25MYWJlbCdcIlxyXG4gICAgICAgICNleHByZXNzaW9uUmVmXHJcbiAgICAgICAgY29udGVudGVkaXRhYmxlPVwicGxhaW50ZXh0LW9ubHlcIlxyXG4gICAgICAgIChtb3VzZXVwKT1cImdldENhcmV0KClcIlxyXG4gICAgICAgIChpbnB1dCk9XCJzZXRDb250ZW50KCRldmVudC50YXJnZXQudGV4dENvbnRlbnQpXCJcclxuICAgICAgICAoYmx1cik9XCJleHByZXNzaW9uU3RyaW5nID0gJGV2ZW50LnRhcmdldC50ZXh0Q29udGVudFwiXHJcbiAgICAgICAgKGtleXVwKT1cImdldENhcmV0KClcIlxyXG4gICAgICAgIHNwZWxsY2hlY2s9XCJmYWxzZVwiXHJcbiAgICAgICAgW3RleHRDb250ZW50XT1cImV4cHJlc3Npb25TdHJpbmdcIlxyXG4gICAgICAgIFtzdHlsZS5jdXJzb3JdPVwiZXhwcmVzc2lvblNlcnZpY2UuaXNEcmFnZ2luZyA/ICdkZWZhdWx0JyA6ICd0ZXh0J1wiXHJcbiAgICAgID48L2xhYmVsPlxyXG4gICAgPC9kaXY+XHJcbiAgICA8ZGl2IGNsYXNzPVwiZXhwcmVzc2lvbi1uYXZpZ2F0aW9uXCI+XHJcbiAgICAgIDxkaXZcclxuICAgICAgICBjbGFzcz1cImV4cHJlc3Npb24tZnVuY3Rpb25zIGNvbHVtblwiXHJcbiAgICAgICAgW3N0eWxlLndpZHRoXT1cImN1cnJlbnRTZWxlY3RlZE1vZGUgPT0gJ2Z1bmN0aW9ucycgfHwgY3VycmVudFNlbGVjdGVkTW9kZSA9PSAnc3lzdGVtVmFyaWFibGUnID8gJzEwMCUnIDogJzMwJSdcIlxyXG4gICAgICA+XHJcbiAgICAgICAgPGRpdiBjbGFzcz1cImNvbHVtbi1jb250ZW50XCI+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZE1vZGUgPT0gJ2Z1bmN0aW9ucycgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlTW9kZSgnZnVuY3Rpb25zJylcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICB7eyBsb2MuZ2V0UChcIkZ1bmN0aW9uc1wiKSB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRNb2RlID09ICdlbGVtZW50cycgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlTW9kZSgnZWxlbWVudHMnKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IGxvYy5nZXQyKFwiUmVwb3J0XCIsIFwiQ29tcG9uZW50c1wiKSB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRNb2RlID09ICdzeXN0ZW1WYXJpYWJsZScgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlTW9kZSgnc3lzdGVtVmFyaWFibGUnKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IGxvYy5nZXRQKFwiU3lzdGVtVmFyaWFibGVcIikgfX1cclxuICAgICAgICAgIDwvc3Bhbj5cclxuICAgICAgICAgIDxzcGFuXHJcbiAgICAgICAgICAgIGNsYXNzPVwiY29sdW1uLWl0ZW0ge3sgY3VycmVudFNlbGVjdGVkTW9kZSA9PSAnb3BlcmF0b3JzJyA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIChjbGljayk9XCJjaGFuZ2VNb2RlKCdvcGVyYXRvcnMnKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IGxvYy5nZXQyKFwiTWF0aEZvcm11bGFcIiwgXCJPcGVyYXRvcnNcIikgfX1cclxuICAgICAgICAgIDwvc3Bhbj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDxkaXZcclxuICAgICAgICBjbGFzcz1cImV4cHJlc3Npb24tb3BlcmF0b3JzIGNvbHVtblwiXHJcbiAgICAgICAgKm5nSWY9XCJjdXJyZW50U2VsZWN0ZWRNb2RlID09ICdmdW5jdGlvbnMnIHx8IGN1cnJlbnRTZWxlY3RlZE1vZGUgPT0gJ3N5c3RlbVZhcmlhYmxlJ1wiXHJcbiAgICAgID5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY29sdW1uLWNvbnRlbnRcIiAqbmdJZj1cImN1cnJlbnRTZWxlY3RlZE1vZGUgPT0gJ2Z1bmN0aW9ucydcIj5cclxuICAgICAgICAgIDxzcGFuXHJcbiAgICAgICAgICAgIGNsYXNzPVwiY29sdW1uLWl0ZW0ge3sgY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPT0gJ3ZhbHVlJyA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIChjbGljayk9XCJjaGFuZ2VDdXJyZW50RnVjdGlvbigndmFsdWUnKVwiXHJcbiAgICAgICAgICAgIChtb3VzZWRvd24pPVwic3RhcnRFeHByZXNzaW9uRHJhZ2dpbmcoeyBvYmplY3Q6ICdWYWx1ZScsIGV2ZW50OiAkZXZlbnQgfSlcIlxyXG4gICAgICAgICAgICAoZGJsY2xpY2spPVwiYWRkRnVuY3Rpb24oJ1ZhbHVlJylcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICB7eyBcIlZhbHVlKClcIiB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRGdW5jdGlvbiA9PSAnY291bnQnID8gJ3NlbGVjdGVkJyA6ICcnIH19XCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cImNoYW5nZUN1cnJlbnRGdWN0aW9uKCdjb3VudCcpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ0NvdW50JywgZXZlbnQ6ICRldmVudCB9KVwiXHJcbiAgICAgICAgICAgIChkYmxjbGljayk9XCJhZGRGdW5jdGlvbignQ291bnQnKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IFwiQ291bnQoKVwiIH19XHJcbiAgICAgICAgICA8L3NwYW4+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID09ICdtaW4nID8gJ3NlbGVjdGVkJyA6ICcnIH19XCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cImNoYW5nZUN1cnJlbnRGdWN0aW9uKCdtaW4nKVwiXHJcbiAgICAgICAgICAgIChtb3VzZWRvd24pPVwic3RhcnRFeHByZXNzaW9uRHJhZ2dpbmcoeyBvYmplY3Q6ICdNaW4nLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZEZ1bmN0aW9uKCdNaW4nKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IFwiTWluKClcIiB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRGdW5jdGlvbiA9PSAnbWF4JyA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIChjbGljayk9XCJjaGFuZ2VDdXJyZW50RnVjdGlvbignbWF4JylcIlxyXG4gICAgICAgICAgICAobW91c2Vkb3duKT1cInN0YXJ0RXhwcmVzc2lvbkRyYWdnaW5nKHsgb2JqZWN0OiAnTWF4JywgZXZlbnQ6ICRldmVudCB9KVwiXHJcbiAgICAgICAgICAgIChkYmxjbGljayk9XCJhZGRGdW5jdGlvbignTWF4JylcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICB7eyBcIk1heCgpXCIgfX1cclxuICAgICAgICAgIDwvc3Bhbj5cclxuICAgICAgICAgIDxzcGFuXHJcbiAgICAgICAgICAgIGNsYXNzPVwiY29sdW1uLWl0ZW0ge3sgY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPT0gJ3N1bScgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlQ3VycmVudEZ1Y3Rpb24oJ3N1bScpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ1N1bScsIGV2ZW50OiAkZXZlbnQgfSlcIlxyXG4gICAgICAgICAgICAoZGJsY2xpY2spPVwiYWRkRnVuY3Rpb24oJ1N1bScpXCJcclxuICAgICAgICAgID5cclxuICAgICAgICAgICAge3sgXCJTdW0oKVwiIH19XHJcbiAgICAgICAgICA8L3NwYW4+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID09ICdjZWxsJyA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIChjbGljayk9XCJjaGFuZ2VDdXJyZW50RnVjdGlvbignY2VsbCcpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ0NlbGwnLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZEZ1bmN0aW9uKCdDZWxsJylcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICB7eyBcIkNlbGwoKVwiIH19XHJcbiAgICAgICAgICA8L3NwYW4+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID09ICd0b3RhbCcgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlQ3VycmVudEZ1Y3Rpb24oJ3RvdGFsJylcIlxyXG4gICAgICAgICAgICAobW91c2Vkb3duKT1cInN0YXJ0RXhwcmVzc2lvbkRyYWdnaW5nKHsgb2JqZWN0OiAnVG90YWwnLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZEZ1bmN0aW9uKCdUb3RhbCcpXCJcclxuICAgICAgICAgID5cclxuICAgICAgICAgICAge3sgXCJUb3RhbCgpXCIgfX1cclxuICAgICAgICAgIDwvc3Bhbj5cclxuICAgICAgICAgIDxzcGFuXHJcbiAgICAgICAgICAgIGNsYXNzPVwiY29sdW1uLWl0ZW0ge3sgY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPT0gJ2NvbCcgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlQ3VycmVudEZ1Y3Rpb24oJ2NvbCcpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ0NvbCcsIGV2ZW50OiAkZXZlbnQgfSlcIlxyXG4gICAgICAgICAgICAoZGJsY2xpY2spPVwiYWRkRnVuY3Rpb24oJ0NvbCcpXCJcclxuICAgICAgICAgID5cclxuICAgICAgICAgICAge3sgXCJDb2woKVwiIH19XHJcbiAgICAgICAgICA8L3NwYW4+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID09ICdyb3cnID8gJ3NlbGVjdGVkJyA6ICcnIH19XCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cImNoYW5nZUN1cnJlbnRGdWN0aW9uKCdyb3cnKVwiXHJcbiAgICAgICAgICAgIChtb3VzZWRvd24pPVwic3RhcnRFeHByZXNzaW9uRHJhZ2dpbmcoeyBvYmplY3Q6ICdSb3cnLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZEZ1bmN0aW9uKCdSb3cnKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IFwiUm93KClcIiB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJjb2x1bW4tY29udGVudFwiICpuZ0lmPVwiY3VycmVudFNlbGVjdGVkTW9kZSA9PSAnc3lzdGVtVmFyaWFibGUnXCI+XHJcbiAgICAgICAgICA8c3BhblxyXG4gICAgICAgICAgICBjbGFzcz1cImNvbHVtbi1pdGVtIHt7IGN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID09ICdsaW5lJyA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIChjbGljayk9XCJjaGFuZ2VDdXJyZW50RnVjdGlvbignbGluZScpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ0xpbmUnLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZEZ1bmN0aW9uKCdMaW5lJylcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICB7eyBcIkxpbmVcIiB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRGdW5jdGlvbiA9PSAndG9kYXknID8gJ3NlbGVjdGVkJyA6ICcnIH19XCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cImNoYW5nZUN1cnJlbnRGdWN0aW9uKCd0b2RheScpXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJ1RvZGF5JywgZXZlbnQ6ICRldmVudCB9KVwiXHJcbiAgICAgICAgICAgIChkYmxjbGljayk9XCJhZGRGdW5jdGlvbignVG9kYXknKVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIHt7IFwiVG9kYXlcIiB9fVxyXG4gICAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJjb2x1bW4taXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRGdW5jdGlvbiA9PSAndGltZScgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAgICAgICAoY2xpY2spPVwiY2hhbmdlQ3VycmVudEZ1Y3Rpb24oJ3RpbWUnKVwiXHJcbiAgICAgICAgICAgIChtb3VzZWRvd24pPVwic3RhcnRFeHByZXNzaW9uRHJhZ2dpbmcoeyBvYmplY3Q6ICdUaW1lJywgZXZlbnQ6ICRldmVudCB9KVwiXHJcbiAgICAgICAgICAgIChkYmxjbGljayk9XCJhZGRGdW5jdGlvbignVGltZScpXCJcclxuICAgICAgICAgID5cclxuICAgICAgICAgICAge3sgXCJUaW1lXCIgfX1cclxuICAgICAgICAgIDwvc3Bhbj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJleHByZXNzaW9uLWZpZWxkcyBjb2x1bW5cIj5cclxuICAgICAgICA8ZGl2XHJcbiAgICAgICAgICBjbGFzcz1cImNvbHVtbi1jb250ZW50XCJcclxuICAgICAgICAgICpuZ0lmPVwiY3VycmVudFNlbGVjdGVkTW9kZSA9PSAnZnVuY3Rpb25zJyB8fCBjdXJyZW50U2VsZWN0ZWRNb2RlID09ICdzeXN0ZW1WYXJpYWJsZSdcIlxyXG4gICAgICAgID5cclxuICAgICAgICAgIDxkaXYgKm5nRm9yPVwibGV0IHNhbXBsZSBvZiBzYW1wbGVzXCIgY2xhc3M9XCJzYW1wbGUtaXRlbVwiPlxyXG4gICAgICAgICAgICA8c3Bhbj57eyBzYW1wbGUgfX08L3NwYW4+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJzYW1wbGUtaXRlbVwiIFtzdHlsZS5wYWRkaW5nXT1cIicxNXB4IDBweCdcIj5cclxuICAgICAgICAgICAgPHNwYW4+e3sgdGl0bGUgfX08L3NwYW4+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY29sdW1uLWNvbnRlbnRcIiAqbmdJZj1cImN1cnJlbnRTZWxlY3RlZE1vZGUgPT0gJ29wZXJhdG9ycydcIj5cclxuICAgICAgICAgIDxzcGFuXHJcbiAgICAgICAgICAgIGNsYXNzPVwib3BlcmF0b3ItaXRlbVwiXHJcbiAgICAgICAgICAgIFtzdGlUb29sdGlwXT1cImxvYy5nZXQyKCdTaGFwZXMnLCAnUGx1cycpXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZE9wZXJhdG9yKCcrJylcIlxyXG4gICAgICAgICAgICAobW91c2Vkb3duKT1cInN0YXJ0RXhwcmVzc2lvbkRyYWdnaW5nKHsgb2JqZWN0OiAnKycsIGV2ZW50OiAkZXZlbnQgfSlcIlxyXG4gICAgICAgICAgICA+Kzwvc3BhblxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJvcGVyYXRvci1pdGVtXCJcclxuICAgICAgICAgICAgW3N0aVRvb2x0aXBdPVwibG9jLmdldDIoJ1NoYXBlcycsICdNaW51cycpXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJy0nLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZE9wZXJhdG9yKCctJylcIlxyXG4gICAgICAgICAgICA+LTwvc3BhblxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJvcGVyYXRvci1pdGVtXCJcclxuICAgICAgICAgICAgW3N0aVRvb2x0aXBdPVwibG9jLmdldDIoJ1NoYXBlcycsICdNdWx0aXBseScpXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJyonLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZE9wZXJhdG9yKCcqJylcIlxyXG4gICAgICAgICAgICA+Kjwvc3BhblxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgPHNwYW5cclxuICAgICAgICAgICAgY2xhc3M9XCJvcGVyYXRvci1pdGVtXCJcclxuICAgICAgICAgICAgW3N0aVRvb2x0aXBdPVwibG9jLmdldDIoJ1NoYXBlcycsICdEaXZpc2lvbicpXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzdGFydEV4cHJlc3Npb25EcmFnZ2luZyh7IG9iamVjdDogJy8nLCBldmVudDogJGV2ZW50IH0pXCJcclxuICAgICAgICAgICAgKGRibGNsaWNrKT1cImFkZE9wZXJhdG9yKCcvJylcIlxyXG4gICAgICAgICAgICA+Lzwvc3BhblxyXG4gICAgICAgICAgPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJjb2x1bW4tY29udGVudFwiICpuZ0lmPVwiY3VycmVudFNlbGVjdGVkTW9kZSA9PSAnZWxlbWVudHMnXCI+XHJcbiAgICAgICAgICA8ZGl2ICpuZ0Zvcj1cImxldCBmaWVsZCBvZiBmaWVsZHNcIj5cclxuICAgICAgICAgICAgPGRpdlxyXG4gICAgICAgICAgICAgIGNsYXNzPVwiY29sdW1uLWl0ZW0gZmllbGRcIlxyXG4gICAgICAgICAgICAgIFtzdHlsZS5wYWRkaW5nXT1cImlzVGFibGUoZmllbGQpID8gJzRweCA1cHggNHB4IDBweCcgOiAnNHB4IDVweCdcIlxyXG4gICAgICAgICAgICAgIChjbGljayk9XCJpc1RhYmxlKGZpZWxkKSA/IGNoYW5nZVN0YXRlKGZpZWxkKSA6ICcnXCJcclxuICAgICAgICAgICAgICAobW91c2Vkb3duKT1cIiFpc1RhYmxlKGZpZWxkKSA/IHN0YXJ0RXhwcmVzc2lvbkRyYWdnaW5nKHsgb2JqZWN0OiBmaWVsZCwgZXZlbnQ6ICRldmVudCB9KSA6ICcnXCJcclxuICAgICAgICAgICAgICAoZGJsY2xpY2spPVwiIWlzVGFibGUoZmllbGQpID8gYWRkVmFsdWUoZmllbGQpIDogJydcIlxyXG4gICAgICAgICAgICA+XHJcbiAgICAgICAgICAgICAgPGRpdiAqbmdJZj1cImlzVGFibGUoZmllbGQpXCIgY2xhc3M9XCJhcnJvd1wiIFtAcm90YXRlZFN0YXRlXT1cImdldFN0YXRlKGZpZWxkKVwiPlxyXG4gICAgICAgICAgICAgICAgPGkgY2xhc3M9XCJwaSBwaS1jaGV2cm9uLXJpZ2h0XCI+PC9pPlxyXG4gICAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICAgIDxzcGFuPnt7IGZpZWxkLm5hbWUgfX08L3NwYW4+XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICA8c3RpLWNvbHVtbnMtcHJldmlld1xyXG4gICAgICAgICAgICAgICpuZ0lmPVwiaXNUYWJsZShmaWVsZClcIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwiZmllbGRcIlxyXG4gICAgICAgICAgICAgIChmaWVsZENsaWNrKT1cIm5lc3RlZEZpZWxkQ2xpY2soJGV2ZW50KVwiXHJcbiAgICAgICAgICAgICAgKHN0YXJ0RmllbGREcmFnKT1cInN0YXJ0RXhwcmVzc2lvbkRyYWdnaW5nKCRldmVudClcIlxyXG4gICAgICAgICAgICAgIFtzdGF0ZV09XCJnZXRTdGF0ZShmaWVsZCkgPT0gJ2RlZmF1bHQnID8gZmFsc2UgOiB0cnVlXCJcclxuICAgICAgICAgICAgPjwvc3RpLWNvbHVtbnMtcHJldmlldz5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgIDwvZGl2PlxyXG4gICAgPGRpdiBjbGFzcz1cImZvb3Rlci1uYXZpZ2F0aW9uXCI+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJmb290ZXItYnV0dG9uIGFjY2VwdFwiIChjbGljayk9XCJzYXZlKClcIiBbc3R5bGUubWFyZ2luLXJpZ2h0LnB4XT1cIjBcIj5cclxuICAgICAgICA8c3Bhbj57eyBsb2MuZ2V0MihcIkJ1dHRvbnNcIiwgXCJTYXZlXCIpIH19PC9zcGFuPlxyXG4gICAgICA8L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cImZvb3Rlci1idXR0b24gY2FuY2VsXCIgKGNsaWNrKT1cIm1vZGVsLnNob3dFeHByZXNzaW9uRWRpdG9yID0gZmFsc2VcIj5cclxuICAgICAgICA8c3Bhbj57eyBsb2MuZ2V0UChcIkNhbmNlbFwiKSB9fTwvc3Bhbj5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICA8L2Rpdj5gLFxyXG4gIHN0eWxlczogW1xyXG4gICAgYFxyXG4gICAgICAuYXJyb3cge1xyXG4gICAgICAgIHdpZHRoOiAyMHB4O1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgICAtd2Via2l0LXRvdWNoLWNhbGxvdXQ6IG5vbmU7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmFycm93IC5waSB7XHJcbiAgICAgICAgZm9udC1zaXplOiAwLjYyNXJlbTtcclxuICAgICAgfVxyXG4gICAgICAucGkge1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMC44MjVyZW07XHJcbiAgICAgIH1cclxuICAgICAgLnNlbGVjdGVkIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjZTVlNWU1O1xyXG4gICAgICB9XHJcbiAgICAgIC5leHByZXNzaW9uLWVkaXRvci1jb250YWluZXIge1xyXG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICAgICAgICBmb250LXNpemU6IDEzcHg7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IFwiQXJpYWxcIjtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgbWluLWhlaWdodDogNDgwcHg7XHJcbiAgICAgICAgd2lkdGg6IDcwMHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDVweDtcclxuICAgICAgICBsZWZ0OiBjYWxjKDUwJSAtIDM1MHB4KTtcclxuICAgICAgICB0b3A6IGNhbGMoNTAlIC0gMjUwcHgpO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCByZ2IoMjgsIDcxLCAxMzQpO1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6ICNmZmZmZmY7XHJcbiAgICAgICAgLW1vei1ib3gtc2hhZG93OiAwcHggMHB4IDdweCByZ2JhKDAsIDAsIDAsIDAuNik7XHJcbiAgICAgICAgLXdlYmtpdC1ib3gtc2hhZG93OiAwcHggMHB4IDdweCByZ2IoMCAwIDAgLyA2MCUpO1xyXG4gICAgICAgIGJveC1zaGFkb3c6IDAgMCA3cHggcmdiKDAgMCAwIC8gMzAlKTtcclxuICAgICAgICB6LWluZGV4OiA5OTk7XHJcbiAgICAgIH1cclxuICAgICAgLmhlYWRlci1uYXZpZ2F0aW9uIHtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGhlaWdodDogNDBweDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIHBhZGRpbmctbGVmdDogMTVweDtcclxuICAgICAgICBwYWRkaW5nLXJpZ2h0OiA1cHg7XHJcbiAgICAgICAgYm9yZGVyLXRvcC1sZWZ0LXJhZGl1czogM3B4O1xyXG4gICAgICAgIGJvcmRlci10b3AtcmlnaHQtcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDgxLCA5MiwgMTA2KTtcclxuICAgICAgICBjb2xvcjogd2hpdGU7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAuaGVhZGVyLW5hdmlnYXRpb24gc3BhbiB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgZm9udC1zaXplOiAxN3B4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICB9XHJcbiAgICAgIC5uYXYtYnV0dG9uIHtcclxuICAgICAgICBoZWlnaHQ6IDI0cHg7XHJcbiAgICAgICAgd2lkdGg6IDI4cHg7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgICBhbGlnbi1zZWxmOiBzdGFydDtcclxuICAgICAgICBtYXJnaW4tdG9wOiA1cHg7XHJcbiAgICAgIH1cclxuICAgICAgLm5hdi1idXR0b246aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IGxpZ2h0Z3JheTtcclxuICAgICAgfVxyXG4gICAgICAubmF2LWJ1dHRvbiBpbWcge1xyXG4gICAgICAgIGhlaWdodDogMTZweDtcclxuICAgICAgICB3aWR0aDogMTZweDtcclxuICAgICAgICBmaWx0ZXI6IGJyaWdodG5lc3MoMCkgaW52ZXJ0KDEpO1xyXG4gICAgICB9XHJcbiAgICAgIC5leHByZXNzaW9uLXByZXZpZXcge1xyXG4gICAgICAgIHdpZHRoOiBjYWxjKDEwMCUgLSAyMHB4KTtcclxuICAgICAgICBtYXJnaW46IDEwcHggMTBweCA1cHggMTBweDtcclxuICAgICAgICBwYWRkaW5nOiA1cHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI1MCwgMjUwLCAyNTApO1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIGxpZ2h0Z3JheTtcclxuICAgICAgICBoZWlnaHQ6IDEzNXB4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IHRleHQ7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgfVxyXG4gICAgICAuZXhwcmVzc2lvbi1wcmV2aWV3IGxhYmVsIHtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiB0ZXh0O1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTNweDtcclxuICAgICAgICBvdXRsaW5lOiBub25lO1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBvdmVyZmxvdzogYXV0bztcclxuICAgICAgfVxyXG4gICAgICAuZHJhZ2dpbmctb3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIzNSwgMjM1LCAyMzUpICFpbXBvcnRhbnQ7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggZGFzaGVkIGJsYWNrICFpbXBvcnRhbnQ7XHJcbiAgICAgIH1cclxuICAgICAgLmV4cHJlc3Npb24tbmF2aWdhdGlvbiB7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBwYWRkaW5nOiAwcHggNXB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5jb2x1bW4ge1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIGxpZ2h0Z3JheTtcclxuICAgICAgICBoZWlnaHQ6IDIzMHB4O1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIG1hcmdpbjogNXB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b25zIHtcclxuICAgICAgICBoZWlnaHQ6IDI1MHB4O1xyXG4gICAgICAgIG1pbi13aWR0aDogMTUwcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbnMgaW1nIHtcclxuICAgICAgICBoZWlnaHQ6IDUycHg7XHJcbiAgICAgICAgd2lkdGg6IDUycHg7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIG1hcmdpbjogNXB4O1xyXG4gICAgICAgIHBhZGRpbmc6IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbnMgaW1nOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiBsaWdodGdyYXk7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbHVtbi1oZWFkZXIge1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgaGVpZ2h0OiAzMHB4O1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IGxpZ2h0Z3JheTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgcGFkZGluZzogMHB4IDEwcHg7XHJcbiAgICAgICAgYm9yZGVyLXRvcC1sZWZ0LXJhZGl1czogNHB4O1xyXG4gICAgICAgIGJvcmRlci10b3AtcmlnaHQtcmFkaXVzOiA0cHg7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbHVtbi1oZWFkZXIgc3BhbiB7XHJcbiAgICAgICAgZm9udC1zaXplOiAxNXB4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICB9XHJcbiAgICAgIC5mb290ZXItbmF2aWdhdGlvbiB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGZsZXgtZW5kO1xyXG4gICAgICAgIGhlaWdodDogNTBweDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5mb290ZXItYnV0dG9uIHtcclxuICAgICAgICBtaW4td2lkdGg6IDkwcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAzMHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgICAgbWFyZ2luOiAwIDEwcHg7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuXHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5hY2NlcHQge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyNSwgNzEsIDEzOCk7XHJcbiAgICAgICAgY29sb3I6IHdoaXRlO1xyXG4gICAgICB9XHJcbiAgICAgIC5hY2NlcHQ6aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYig2MSwgOTgsIDE1Mik7XHJcbiAgICAgIH1cclxuICAgICAgLmNhbmNlbCB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIyMSwgMjIxLCAyMjEpO1xyXG4gICAgICAgIGNvbG9yOiByZ2IoNjgsIDY4LCA2OCk7XHJcbiAgICAgIH1cclxuICAgICAgLmNhbmNlbDpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIxMywgMjEzLCAyMTMpO1xyXG4gICAgICB9XHJcbiAgICAgIC5jb2x1bW4tY29udGVudCB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgcGFkZGluZzogNXB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgbWF4LWhlaWdodDogMjI5cHg7XHJcbiAgICAgICAgb3ZlcmZsb3cteTogYXV0bztcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICB9XHJcbiAgICAgIC5vcGVyYXRvci1pdGVtIHtcclxuICAgICAgICBmb250LWZhbWlseTogXCJBcmlhbFwiO1xyXG4gICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LWNvbG9yKTtcclxuICAgICAgICBmb250LXNpemU6IDE3cHg7XHJcbiAgICAgICAgcGFkZGluZzogMnB4IDdweDtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAub3BlcmF0b3ItaXRlbTpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI0MCwgMjQwLCAyNDApO1xyXG4gICAgICB9XHJcbiAgICAgIC5zYW1wbGUtaXRlbSB7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IFwiQXJpYWxcIjtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgcGFkZGluZy1ib3R0b206IDNweDtcclxuICAgICAgICBjdXJzb3I6IGRlZmF1bHQ7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC5jb2x1bW4taXRlbSB7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IFwiQXJpYWxcIjtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgcGFkZGluZzogNXB4O1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgfVxyXG4gICAgICAuY29sdW1uLWl0ZW06aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyNDAsIDI0MCwgMjQwKTtcclxuICAgICAgfVxyXG4gICAgICAuaW5mbyB7XHJcbiAgICAgICAgaGVpZ2h0OiAzMHB4O1xyXG4gICAgICAgIHdpZHRoOiAzMHB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuaW5mbyBpbWcge1xyXG4gICAgICAgIGhlaWdodDogMTZweDtcclxuICAgICAgICB3aWR0aDogMTZweDtcclxuICAgICAgICBjdXJzb3I6IHBvaW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmZpZWxkIHtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmZpZWxkIGltZyB7XHJcbiAgICAgICAgaGVpZ2h0OiAxNnB4O1xyXG4gICAgICAgIHdpZHRoOiAxNnB4O1xyXG4gICAgICAgIG1hcmdpbi1yaWdodDogNXB4O1xyXG4gICAgICB9XHJcbiAgICBgLFxyXG4gIF0sXHJcbiAgYW5pbWF0aW9uczogW1JvdGF0ZUFuaW1hdGlvbl0sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlFeHByZXNzaW9uRWRpdG9yQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0LCBPbkRlc3Ryb3ksIEFmdGVyVmlld0luaXQge1xyXG4gIEBWaWV3Q2hpbGQoXCJleHByZXNzaW9uUmVmXCIpIGVsZW1lbnRSZWY6IEVsZW1lbnRSZWY7XHJcblxyXG4gIHB1YmxpYyBleHByZXNzaW9uU3RyaW5nID0gXCJ7fVwiO1xyXG4gIHB1YmxpYyBjdXJyZW50U2VsZWN0ZWRNb2RlID0gXCJmdW5jdGlvbnNcIjtcclxuICBwdWJsaWMgY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPSBcInZhbHVlXCI7XHJcbiAgcHVibGljIHN0YXJ0WDogbnVtYmVyO1xyXG4gIHB1YmxpYyBzdGFydFk6IG51bWJlcjtcclxuICBwdWJsaWMgc3RhcnRDb21wb25lbnRYOiBudW1iZXI7XHJcbiAgcHVibGljIHN0YXJ0Q29tcG9uZW50WTogbnVtYmVyO1xyXG4gIHB1YmxpYyBpc0RyYWdnaW5nOiBib29sZWFuO1xyXG4gIHB1YmxpYyBsYXN0Q2FyZXRQb3NpdGlvbjogbnVtYmVyO1xyXG4gIHB1YmxpYyBjYW5EcmFnRXhwcmVzc2lvbjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBkcmFnT2JqZWN0OiBhbnk7XHJcblxyXG4gIG1vdXNlVXBTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcclxuICBtb3VzZU1vdmVTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcclxuICBleHByZXNzaW9uVXBkYXRpbmdTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcclxuXHJcbiAgcHVibGljIGFycmF5T2ZTYW1wbGVzOiBTdGlFeHByZXNzaW9uU2FtcGxlW10gPSBbXHJcbiAgICB7XHJcbiAgICAgIGZ1bmN0aW9uTmFtZTogXCJ2YWx1ZVwiLFxyXG4gICAgICBzYW1wbGVzOiBbXCJWYWx1ZSgnVGV4dEJveCcpXCIsIFwiVmFsdWUoJ051bWJlckJveCcpXCIsIFwiVmFsdWUoJ0xhYmVsJylcIl0sXHJcbiAgICAgIHRpdGxlOiBcIlZhbHVlIG9mIE51bWJlckJveCwgVGV4dEJveCBvciBMYWJlbCBlbGVtZW50XCIsXHJcbiAgICB9LFxyXG4gICAge1xyXG4gICAgICBmdW5jdGlvbk5hbWU6IFwiY291bnRcIixcclxuICAgICAgc2FtcGxlczogW1wiQ291bnQoQ29sKDEsJ1RhYmxlJykpXCIsIFwiQ291bnQoUm93KCdGaXJzdCcsJ1RhYmxlJykpXCJdLFxyXG4gICAgICB0aXRsZTogXCJOdW1iZXIgb2YgaXRlbXMgaW4gdGhlIGxpc3RcIixcclxuICAgIH0sXHJcbiAgICB7XHJcbiAgICAgIGZ1bmN0aW9uTmFtZTogXCJtaW5cIixcclxuICAgICAgc2FtcGxlczogW1wiTWluKENvbCgxLCdUYWJsZScpKVwiLCBcIk1pbihSb3coJ0ZpcnN0JywnVGFibGUnKSlcIl0sXHJcbiAgICAgIHRpdGxlOiBcIlRoZSBzbWFsbGVzdCBudW1iZXIgaW4gbGlzdFwiLFxyXG4gICAgfSxcclxuICAgIHtcclxuICAgICAgZnVuY3Rpb25OYW1lOiBcIm1heFwiLFxyXG4gICAgICBzYW1wbGVzOiBbXCJNYXgoQ29sKDEsJ1RhYmxlJykpXCIsIFwiTWF4KFJvdygnRmlyc3QnLCdUYWJsZScpKVwiXSxcclxuICAgICAgdGl0bGU6IFwiVGhlIGxhcmdlc3QgbnVtYmVyIGluIGxpc3RcIixcclxuICAgIH0sXHJcbiAgICB7XHJcbiAgICAgIGZ1bmN0aW9uTmFtZTogXCJzdW1cIixcclxuICAgICAgc2FtcGxlczogW1wiU3VtKENvbCgxLCdUYWJsZScpKVwiLCBcIlN1bShSb3coJ0ZpcnN0JywnVGFibGUnKSlcIl0sXHJcbiAgICAgIHRpdGxlOiBcIlN1bSBvZiBhbGwgbnVtYmVycyBpbiBsaXN0XCIsXHJcbiAgICB9LFxyXG4gICAge1xyXG4gICAgICBmdW5jdGlvbk5hbWU6IFwiY2VsbFwiLFxyXG4gICAgICBzYW1wbGVzOiBbXCJDZWxsKGNvbHVtbklkLHJvd0lkKVwiLCBcIkNlbGwoY29sdW1uSWQscm93SWQsJ1RhYmxlJylcIl0sXHJcbiAgICAgIHRpdGxlOiBcIk51bWJlciB2YWx1ZSBvZiBzcGVjaWZpZWQgY2VsbFwiLFxyXG4gICAgfSxcclxuICAgIHtcclxuICAgICAgZnVuY3Rpb25OYW1lOiBcInRvdGFsXCIsXHJcbiAgICAgIHNhbXBsZXM6IFtcIlRvdGFsKHRvdGFsSWQpXCIsIFwiVG90YWwodG90YWxJZCwnVGFibGUnKVwiXSxcclxuICAgICAgdGl0bGU6IFwiVmFsdWUgb2YgVGFibGVzIFRvdGFscyBmaWVsZFwiLFxyXG4gICAgfSxcclxuICAgIHtcclxuICAgICAgZnVuY3Rpb25OYW1lOiBcImNvbFwiLFxyXG4gICAgICBzYW1wbGVzOiBbXCJDb2woY29sdW1uSWQpXCIsIFwiQ29sKGNvbHVtbklkLCdUYWJsZScpXCJdLFxyXG4gICAgICB0aXRsZTogXCJMaXN0IG9mIG51bWJlcnMgd2hpY2ggYXJlIGNlbGwgdmFsdWVzIGZyb20gc3BlY2lmaWVkIGNvbHVtblwiLFxyXG4gICAgfSxcclxuICAgIHtcclxuICAgICAgZnVuY3Rpb25OYW1lOiBcInJvd1wiLFxyXG4gICAgICBzYW1wbGVzOiBbXCJSb3cocm93TGFiZWwpXCIsIFwiUm93KHJvd0xhYmVsLCdUYWJsZScpXCJdLFxyXG4gICAgICB0aXRsZTogXCJMaXN0IG9mIG51bWJlcnMgd2hpY2ggYXJlIGNlbGwgdmFsdWVzIGZyb20gc3BlY2lmaWVkIHJvd1wiLFxyXG4gICAgfSxcclxuICAgIHtcclxuICAgICAgZnVuY3Rpb25OYW1lOiBcImxpbmVcIixcclxuICAgICAgc2FtcGxlczogW1wiTGluZVwiXSxcclxuICAgICAgdGl0bGU6IFwiUmV0dXJucyB0aGUgY3VycmVudCB0YWJsZSBsaW5lIG51bWJlciAoc3RhcnRzIGZyb20gMSkuXCIsXHJcbiAgICB9LFxyXG4gICAge1xyXG4gICAgICBmdW5jdGlvbk5hbWU6IFwidG9kYXlcIixcclxuICAgICAgc2FtcGxlczogW1wiVG9kYXlcIl0sXHJcbiAgICAgIHRpdGxlOiBcIlJldHVybnMgdGhlIGN1cnJlbnQgZGF0ZSBpbiBkZWZhdWx0IGZvcm1hdC5cIixcclxuICAgIH0sXHJcbiAgICB7XHJcbiAgICAgIGZ1bmN0aW9uTmFtZTogXCJ0aW1lXCIsXHJcbiAgICAgIHNhbXBsZXM6IFtcIlRpbWVcIl0sXHJcbiAgICAgIHRpdGxlOiBcIlJldHVybnMgdGhlIGN1cnJlbnQgdGltZSBpbiBkZWZhdWx0IGZvcm1hdC5cIixcclxuICAgIH0sXHJcbiAgXTtcclxuXHJcbiAgcHVibGljIGFycmF5T2ZTdGF0ZXMgPSBbXTtcclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLFxyXG4gICAgcHVibGljIGV4cHJlc3Npb25TZXJ2aWNlOiBTdGlFeHByZXNzaW9uU2VydmljZSxcclxuICAgIHB1YmxpYyBsb2M6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UsXHJcbiAgICBwdWJsaWMgbW91c2VTZXJ2aWNlOiBTdGlNb3VzZVNlcnZpY2UsXHJcbiAgICBwdWJsaWMgZWRpdGFibGVTZXJ2aWNlOiBTdGlFZGl0YWJsZUNvbnRlbnRTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBjZHI6IENoYW5nZURldGVjdG9yUmVmXHJcbiAgKSB7IH1cclxuICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XHJcbiAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmVsZW1lbnRSZWYgPSB0aGlzLmVsZW1lbnRSZWY7XHJcbiAgfVxyXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xyXG4gICAgdGhpcy5tb3VzZU1vdmVTdWJzY3JpcHRpb24/LnVuc3Vic2NyaWJlKCk7XHJcbiAgICB0aGlzLm1vdXNlVXBTdWJzY3JpcHRpb24/LnVuc3Vic2NyaWJlKCk7XHJcbiAgICB0aGlzLmV4cHJlc3Npb25VcGRhdGluZ1N1YnNjcmlwdGlvbj8udW5zdWJzY3JpYmUoKTtcclxuICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuZWxlbWVudFJlZiA9IG51bGw7XHJcbiAgfVxyXG5cclxuICBzdGFydEV4cHJlc3Npb25EcmFnZ2luZyhkcmFnT2JqZWN0KSB7XHJcbiAgICB0aGlzLnN0YXJ0WCA9IGRyYWdPYmplY3QuZXZlbnQuY2xpZW50WDtcclxuICAgIHRoaXMuc3RhcnRZID0gZHJhZ09iamVjdC5ldmVudC5jbGllbnRZO1xyXG4gICAgdGhpcy5jYW5EcmFnRXhwcmVzc2lvbiA9IHRydWU7XHJcbiAgICB0aGlzLmRyYWdPYmplY3QgPSBkcmFnT2JqZWN0O1xyXG4gIH1cclxuICBzZXRDb250ZW50KGlubmVyVGV4dCkge1xyXG4gICAgaWYgKGlubmVyVGV4dCA9PSBcIlwiIHx8IGlubmVyVGV4dCA9PSBudWxsKSB7XHJcbiAgICAgIHRoaXMuZXhwcmVzc2lvblN0cmluZyA9IGlubmVyVGV4dDtcclxuICAgIH1cclxuXHJcbiAgICBpZiAodGhpcy5tb2RlbC5nZXRCcm93c2VyVHlwZSgpID09IFwic2FmYXJpXCIgfHwgdGhpcy5tb2RlbC5nZXRCcm93c2VyVHlwZSgpID09IFwiZmlyZWZveFwiKSB7XHJcbiAgICAgIHRoaXMuY2RyLmRldGFjaCgpO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgY2hlY2tCcmFja2V0cygpIHtcclxuICAgIGxldCBoYXZlQ2xvc2VCcmVha2V0OiBib29sZWFuID0gZmFsc2U7XHJcbiAgICBsZXQgaGF2ZU9wZW5CcmVha2V0OiBib29sZWFuID0gZmFsc2U7XHJcbiAgICBpZiAodGhpcy5sYXN0Q2FyZXRQb3NpdGlvbikge1xyXG4gICAgICBmb3IgKGxldCBpID0gdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbiAtIDE7IGkgPj0gMDsgaS0tKSB7XHJcbiAgICAgICAgaWYgKHRoaXMuZXhwcmVzc2lvblN0cmluZ1tpXSA9PT0gXCJ9XCIpIHtcclxuICAgICAgICAgIGhhdmVDbG9zZUJyZWFrZXQgPSB0cnVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgfSBlbHNlIGlmICh0aGlzLmV4cHJlc3Npb25TdHJpbmdbaV0gPT09IFwie1wiKSB7XHJcbiAgICAgICAgICBoYXZlT3BlbkJyZWFrZXQgPSB0cnVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICBpZiAoaGF2ZUNsb3NlQnJlYWtldCB8fCAoIWhhdmVDbG9zZUJyZWFrZXQgJiYgIWhhdmVPcGVuQnJlYWtldCkpIHtcclxuICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHNob3dJbmZvKCkge1xyXG4gICAgdGhpcy5tb2RlbC5zaG93SGVscFdpbmRvdyA9IHRydWU7XHJcbiAgfVxyXG4gIGFkZFZhbHVlKGVsZW1lbnQpIHtcclxuICAgIHRoaXMuYWRkRnVuY3Rpb24oXCJWYWx1ZVwiLCBlbGVtZW50Lm5hbWUsIHRydWUpO1xyXG4gIH1cclxuICBjaGFuZ2VNb2RlKG1vZGUpIHtcclxuICAgIGlmICh0aGlzLm1vZGVsLmdldEJyb3dzZXJUeXBlKCkgPT0gXCJzYWZhcmlcIiB8fCB0aGlzLm1vZGVsLmdldEJyb3dzZXJUeXBlKCkgPT0gXCJmaXJlZm94XCIpIHtcclxuICAgICAgdGhpcy5jZHIucmVhdHRhY2goKTtcclxuICAgICAgdGhpcy5jZHIuZGV0ZWN0Q2hhbmdlcygpO1xyXG4gICAgfVxyXG4gICAgaWYgKHRoaXMuY3VycmVudFNlbGVjdGVkTW9kZSAhPSBtb2RlICYmIG1vZGUgPT0gXCJzeXN0ZW1WYXJpYWJsZVwiKSB7XHJcbiAgICAgIHRoaXMuY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPSBcImxpbmVcIjtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMuY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPSBcInZhbHVlXCI7XHJcbiAgICB9XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZE1vZGUgPSBtb2RlO1xyXG4gIH1cclxuICBjaGFuZ2VDdXJyZW50RnVjdGlvbihmdW5jKSB7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZEZ1bmN0aW9uID0gZnVuYztcclxuICB9XHJcbiAgc3RhcnREcmFnKGV2ZW50KSB7XHJcbiAgICB0aGlzLnN0YXJ0WCA9IGV2ZW50LmNsaWVudFg7XHJcbiAgICB0aGlzLnN0YXJ0WSA9IGV2ZW50LmNsaWVudFk7XHJcbiAgICB0aGlzLnN0YXJ0Q29tcG9uZW50WCA9IHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WDtcclxuICAgIHRoaXMuc3RhcnRDb21wb25lbnRZID0gdGhpcy5leHByZXNzaW9uU2VydmljZS5jb21wb25lbnRZO1xyXG4gICAgdGhpcy5pc0RyYWdnaW5nID0gdHJ1ZTtcclxuICB9XHJcbiAgcHVibGljIGdldCBzYW1wbGVzKCkge1xyXG4gICAgcmV0dXJuIHRoaXMuYXJyYXlPZlNhbXBsZXMuZmluZCgoc2FtcGxlKSA9PiBzYW1wbGUuZnVuY3Rpb25OYW1lID09IHRoaXMuY3VycmVudFNlbGVjdGVkRnVuY3Rpb24pLnNhbXBsZXM7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgdGl0bGUoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5hcnJheU9mU2FtcGxlcy5maW5kKChzYW1wbGUpID0+IHNhbXBsZS5mdW5jdGlvbk5hbWUgPT0gdGhpcy5jdXJyZW50U2VsZWN0ZWRGdW5jdGlvbikudGl0bGU7XHJcbiAgfVxyXG4gIG5lc3RlZEZpZWxkQ2xpY2soZmllbGQpIHtcclxuICAgIGlmIChmaWVsZCBpbnN0YW5jZW9mIFN0aVRvdGFsc0ZpZWxkSXRlbSkge1xyXG4gICAgICB0aGlzLmluc2VydEluRXhwcmVzc2lvbihcclxuICAgICAgICB0aGlzLmxhc3RDYXJldFBvc2l0aW9uLFxyXG4gICAgICAgIGBUb3RhbCgke2ZpZWxkLmVQYXJlbnQudG90YWxzRmllbGRzLmluZGV4T2YoZmllbGQpICsgMX0sJyR7ZmllbGQuZVBhcmVudC5uYW1lfScpYFxyXG4gICAgICApO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5pbnNlcnRJbkV4cHJlc3Npb24oXHJcbiAgICAgICAgdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbixcclxuICAgICAgICBgQ2VsbCgke2ZpZWxkLmNvbHVtbi5lUGFyZW50LmNvbHVtbnMuaW5kZXhPZihmaWVsZC5jb2x1bW4pICsgMX0sJHtmaWVsZC5pbmRleH0sJyR7ZmllbGQuY29sdW1uLmVQYXJlbnQubmFtZX0nKWBcclxuICAgICAgKTtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBmaWVsZHMoKSB7XHJcbiAgICBsZXQgZmllbGRzID0gW107XHJcbiAgICB0aGlzLm1vZGVsPy5mb3JtPy5wYWdlcz8uZm9yRWFjaCgocGFnZSkgPT4ge1xyXG4gICAgICBwYWdlLmFsbEVsZW1lbnRzLmZvckVhY2goKGVsZW1lbnQpID0+IHtcclxuICAgICAgICBpZiAodGhpcy5oYXZlRXhwcmVzc2lvbihlbGVtZW50KSkge1xyXG4gICAgICAgICAgZmllbGRzLnB1c2goZWxlbWVudCk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgIH0pO1xyXG4gICAgcmV0dXJuIGZpZWxkcztcclxuICB9XHJcbiAgaXNUYWJsZShlbGVtZW50KSB7XHJcbiAgICByZXR1cm4gZWxlbWVudCBpbnN0YW5jZW9mIFN0aVRhYmxlRWxlbWVudDtcclxuICB9XHJcbiAgaGF2ZUV4cHJlc3Npb24oZWxlbWVudCkge1xyXG4gICAgcmV0dXJuIGVsZW1lbnQgaW5zdGFuY2VvZiBTdGlUYWJsZUVsZW1lbnQgfHxcclxuICAgICAgZWxlbWVudCBpbnN0YW5jZW9mIFN0aVRleHRCb3hFbGVtZW50IHx8XHJcbiAgICAgIGVsZW1lbnQgaW5zdGFuY2VvZiBTdGlOdW1iZXJCb3hFbGVtZW50XHJcbiAgICAgID8gdHJ1ZVxyXG4gICAgICA6IGZhbHNlO1xyXG4gIH1cclxuICBhZGRPcGVyYXRvcihvcGVyYXRvcjogc3RyaW5nKSB7XHJcbiAgICB0aGlzLmluc2VydEluRXhwcmVzc2lvbih0aGlzLmxhc3RDYXJldFBvc2l0aW9uLCBvcGVyYXRvciwgdHJ1ZSk7XHJcbiAgfVxyXG4gIGFkZEZ1bmN0aW9uKGZ1bmM6IHN0cmluZywgbmFtZT86IHN0cmluZywgZmlsbGVkOiBib29sZWFuID0gZmFsc2UpIHtcclxuICAgIGxldCBzdHJpbmcgPSBcIlwiO1xyXG4gICAgaWYgKGZ1bmMudG9Mb3dlckNhc2UoKSA9PSBcInZhbHVlXCIpIHtcclxuICAgICAgc3RyaW5nID0gZnVuYyArIGAoJyR7bmFtZSA/IG5hbWUgOiBcIlwifScpYDtcclxuICAgIH0gZWxzZSBpZiAoZnVuYy50b0xvd2VyQ2FzZSgpID09IFwibGluZVwiIHx8IGZ1bmMudG9Mb3dlckNhc2UoKSA9PSBcInRvZGF5XCIgfHwgZnVuYy50b0xvd2VyQ2FzZSgpID09IFwidGltZVwiKSB7XHJcbiAgICAgIHN0cmluZyA9IGZ1bmM7XHJcbiAgICB9IGVsc2UgaWYgKGZ1bmMudG9Mb3dlckNhc2UoKSA9PSBcImNlbGxcIikge1xyXG4gICAgICBzdHJpbmcgPSBmdW5jICsgXCIoLCwnJylcIjtcclxuICAgIH0gZWxzZSBpZiAoZnVuYy50b0xvd2VyQ2FzZSgpID09IFwidG90YWxcIiB8fCBmdW5jLnRvTG93ZXJDYXNlKCkgPT0gXCJjb2xcIiB8fCBmdW5jLnRvTG93ZXJDYXNlKCkgPT0gXCJyb3dcIikge1xyXG4gICAgICBzdHJpbmcgPSBmdW5jICsgXCIoLCcnKVwiO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgc3RyaW5nID0gZnVuYyArIFwiKClcIjtcclxuICAgIH1cclxuICAgIHRoaXMuaW5zZXJ0SW5FeHByZXNzaW9uKHRoaXMubGFzdENhcmV0UG9zaXRpb24sIHN0cmluZywgZmFsc2UsIGZpbGxlZCA/IGZhbHNlIDogdHJ1ZSk7XHJcbiAgfVxyXG4gIGluc2VydEluRXhwcmVzc2lvbihwb3NpdGlvbjogbnVtYmVyLCBzdHJpbmc6IHN0cmluZywgaXNPcGVyYXRvciA9IGZhbHNlLCBpc0Z1bmN0aW9uID0gZmFsc2UpIHtcclxuICAgIGxldCBuZWVkQnJhY2tldHMgPSBpc09wZXJhdG9yID8gZmFsc2UgOiB0aGlzLmNoZWNrQnJhY2tldHMoKTtcclxuICAgIGxldCBwcmV2aW91c1N0cmluZyA9IHRoaXMuZXhwcmVzc2lvblN0cmluZztcclxuICAgIGxldCBpbnNlcnRlZEV4cHJlc3Npb24gPSBgJHtuZWVkQnJhY2tldHMgPyBcIntcIiA6IFwiXCJ9JHtzdHJpbmd9JHtuZWVkQnJhY2tldHMgPyBcIn1cIiA6IFwiXCJ9YDtcclxuICAgIGlmICh0aGlzLmV4cHJlc3Npb25TdHJpbmcubGVuZ3RoID4gMCAmJiBwb3NpdGlvbikge1xyXG4gICAgICBpZiAocG9zaXRpb24gPT0gMCkge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblN0cmluZyA9IGluc2VydGVkRXhwcmVzc2lvbiArIHByZXZpb3VzU3RyaW5nO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblN0cmluZyA9XHJcbiAgICAgICAgICBwcmV2aW91c1N0cmluZy5zbGljZSgwLCBwb3NpdGlvbikgK1xyXG4gICAgICAgICAgaW5zZXJ0ZWRFeHByZXNzaW9uICtcclxuICAgICAgICAgIHByZXZpb3VzU3RyaW5nLnNsaWNlKHBvc2l0aW9uLCBwcmV2aW91c1N0cmluZy5sZW5ndGgpO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICB0aGlzLmV4cHJlc3Npb25TdHJpbmcgKz0gaW5zZXJ0ZWRFeHByZXNzaW9uO1xyXG4gICAgfVxyXG4gICAgdGhpcy5zZXRDYXJldChpbnNlcnRlZEV4cHJlc3Npb24sIGlzRnVuY3Rpb24pO1xyXG4gIH1cclxuICBzZXRDYXJldChpbnNlcnRlZEV4cHJlc3Npb246IHN0cmluZywgaXNGdW5jdGlvbjogYm9vbGVhbiA9IGZhbHNlKSB7XHJcbiAgICBsZXQgbGVmdEJyYWNrZXRJbmRleCA9IGluc2VydGVkRXhwcmVzc2lvbi5pbmRleE9mKFwiKFwiKTtcclxuICAgIGxldCBjYXJyZXRPZmZzZXQgPSAwO1xyXG4gICAgaWYgKCF0aGlzLmxhc3RDYXJldFBvc2l0aW9uKSB7XHJcbiAgICAgIHRoaXMubGFzdENhcmV0UG9zaXRpb24gPSB0aGlzLmV4cHJlc3Npb25TdHJpbmcubGVuZ3RoIC0gaW5zZXJ0ZWRFeHByZXNzaW9uLmxlbmd0aDtcclxuICAgIH1cclxuICAgIGlmIChpc0Z1bmN0aW9uKSB7XHJcbiAgICAgIGlmIChpbnNlcnRlZEV4cHJlc3Npb25bbGVmdEJyYWNrZXRJbmRleCArIDFdID09IFwiJ1wiKSB7XHJcbiAgICAgICAgY2FycmV0T2Zmc2V0ID0gdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbiArIGxlZnRCcmFja2V0SW5kZXggKyAyO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIGNhcnJldE9mZnNldCA9IHRoaXMubGFzdENhcmV0UG9zaXRpb24gKyBsZWZ0QnJhY2tldEluZGV4ICsgMTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgY2FycmV0T2Zmc2V0ID0gdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbiArIGluc2VydGVkRXhwcmVzc2lvbi5sZW5ndGg7XHJcbiAgICB9XHJcblxyXG4gICAgbGV0IGVsZW0gPSB0aGlzLmVsZW1lbnRSZWYubmF0aXZlRWxlbWVudDtcclxuICAgIGVsZW0uZm9jdXMoKTtcclxuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICB2YXIgcmFuZ2UgPSBkb2N1bWVudC5jcmVhdGVSYW5nZSgpO1xyXG4gICAgICB2YXIgc2VsID0gd2luZG93LmdldFNlbGVjdGlvbigpO1xyXG5cclxuICAgICAgcmFuZ2Uuc2V0U3RhcnQoZWxlbS5jaGlsZE5vZGVzWzBdLCBjYXJyZXRPZmZzZXQpO1xyXG4gICAgICByYW5nZS5jb2xsYXBzZSh0cnVlKTtcclxuICAgICAgdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbiArPSBpbnNlcnRlZEV4cHJlc3Npb24ubGVuZ3RoO1xyXG4gICAgICBzZWwucmVtb3ZlQWxsUmFuZ2VzKCk7XHJcbiAgICAgIHNlbC5hZGRSYW5nZShyYW5nZSk7XHJcbiAgICB9KTtcclxuICB9XHJcbiAgc2F2ZSgpIHtcclxuICAgIGlmICh0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmN1cnJlbnRTZWxlY3RlZE9iamVjdCBpbnN0YW5jZW9mIFN0aUxhYmVsRWxlbWVudCkge1xyXG4gICAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmN1cnJlbnRTZWxlY3RlZE9iamVjdC50ZXh0LnZhbHVlID0gdGhpcy5leHByZXNzaW9uU3RyaW5nO1xyXG4gICAgICB0aGlzLm1vZGVsLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiVmFsdWVDaGFuZ2VkXCIgfSk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmN1cnJlbnRTZWxlY3RlZE9iamVjdC5leHByZXNzaW9uID0gdGhpcy5leHByZXNzaW9uU3RyaW5nO1xyXG4gICAgfVxyXG4gICAgdGhpcy5tb2RlbC5zaG93RXhwcmVzc2lvbkVkaXRvciA9IGZhbHNlO1xyXG4gIH1cclxuICBuZ09uSW5pdCgpIHtcclxuICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WCA9ICh3aW5kb3cuaW5uZXJXaWR0aCAtIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50V2lkdGgpIC8gMjtcclxuICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WSA9ICh3aW5kb3cuaW5uZXJIZWlnaHQgLSB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmNvbXBvbmVudEhlaWdodCkgLyAyO1xyXG4gICAgdGhpcy5leHByZXNzaW9uU3RyaW5nID0gdGhpcy5leHByZXNzaW9uU2VydmljZS5jdXJyZW50U2VsZWN0ZWRPYmplY3Q/LmV4cHJlc3Npb25cclxuICAgICAgPyB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmN1cnJlbnRTZWxlY3RlZE9iamVjdD8uZXhwcmVzc2lvblxyXG4gICAgICA6IHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY3VycmVudFNlbGVjdGVkT2JqZWN0Py50ZXh0Py52YWx1ZVxyXG4gICAgICAgID8gdGhpcy5leHByZXNzaW9uU2VydmljZS5jdXJyZW50U2VsZWN0ZWRPYmplY3Q/LnRleHQ/LnZhbHVlXHJcbiAgICAgICAgOiBcIlwiO1xyXG4gICAgdGhpcy5maWVsZHM/LmZvckVhY2goKGZpZWxkKSA9PiB7XHJcbiAgICAgIGlmICh0aGlzLmlzVGFibGUoZmllbGQpKSB7XHJcbiAgICAgICAgdGhpcy5hcnJheU9mU3RhdGVzLnB1c2goeyBlbGVtZW50OiBmaWVsZCwgc3RhdGU6IFwiZGVmYXVsdFwiIH0pO1xyXG4gICAgICB9XHJcbiAgICB9KTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkRnVuY3Rpb24gPSBcInZhbHVlXCI7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZE1vZGUgPSBcImZ1bmN0aW9uc1wiO1xyXG4gICAgdGhpcy5leHByZXNzaW9uVXBkYXRpbmdTdWJzY3JpcHRpb24gPSB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLm5lZWRUb0FkZEV4cHJlc3Npb24uc3Vic2NyaWJlKChvYmplY3QpID0+IHtcclxuICAgICAgdGhpcy5hZGRFeHByZXNzaW9uQnlEcmFnKG9iamVjdCk7XHJcbiAgICB9KTtcclxuICAgIHRoaXMubW91c2VVcFN1YnNjcmlwdGlvbiA9IHRoaXMubW91c2VTZXJ2aWNlLmdldERvY3VtZW50TW91c2VVcCgpLnN1YnNjcmliZSgoKSA9PiB7XHJcbiAgICAgIHRoaXMuaXNEcmFnZ2luZyA9IGZhbHNlO1xyXG4gICAgICB0aGlzLmNhbkRyYWdFeHByZXNzaW9uID0gZmFsc2U7XHJcbiAgICB9KTtcclxuICAgIHRoaXMubW91c2VNb3ZlU3Vic2NyaXB0aW9uID0gdGhpcy5tb3VzZVNlcnZpY2UuZ2V0RG9jdW1lbnRNb3VzZU1vdmUoKS5zdWJzY3JpYmUoKGV2ZW50OiBNb3VzZUV2ZW50KSA9PiB7XHJcbiAgICAgIHRoaXMub25Nb3VzZU1vdmUoZXZlbnQpO1xyXG4gICAgfSk7XHJcbiAgfVxyXG4gIGFkZEV4cHJlc3Npb25CeURyYWcoZXhwcmVzc2lvbk9iamVjdDogU3RpRHJhZ2dhYmxlRXhwcmVzc2lvbk9iamVjdCkge1xyXG4gICAgaWYgKHRoaXMuZXhwcmVzc2lvblN0cmluZy5sZW5ndGggPT0gMCkge1xyXG4gICAgICB0aGlzLmxhc3RDYXJldFBvc2l0aW9uID0gMDtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMubGFzdENhcmV0UG9zaXRpb24gPSBleHByZXNzaW9uT2JqZWN0Lmxhc3RDYXJldE9mZnNldDtcclxuICAgIH1cclxuICAgIGlmICh0eXBlb2YgZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QgPT0gXCJzdHJpbmdcIikge1xyXG4gICAgICBpZiAoZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QubGVuZ3RoID09IDEpIHtcclxuICAgICAgICB0aGlzLmFkZE9wZXJhdG9yKGV4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0KTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmFkZEZ1bmN0aW9uKGV4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0KTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgaWYgKGV4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0IGluc3RhbmNlb2YgU3RpRm9ybUVsZW1lbnQpIHtcclxuICAgICAgICB0aGlzLmFkZEZ1bmN0aW9uKFwiVmFsdWVcIiwgZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QubmFtZSwgdHJ1ZSk7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgaWYgKGV4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0IGluc3RhbmNlb2YgU3RpVG90YWxzRmllbGRJdGVtKSB7XHJcbiAgICAgICAgICB0aGlzLmluc2VydEluRXhwcmVzc2lvbihcclxuICAgICAgICAgICAgdGhpcy5sYXN0Q2FyZXRQb3NpdGlvbixcclxuICAgICAgICAgICAgYFRvdGFsKCR7ZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QuZVBhcmVudC50b3RhbHNGaWVsZHMuaW5kZXhPZihleHByZXNzaW9uT2JqZWN0LnN0YXJ0T2JqZWN0Lm9iamVjdCkgKyAxXHJcbiAgICAgICAgICAgIH0sJyR7ZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QuZVBhcmVudC5uYW1lfScpYFxyXG4gICAgICAgICAgKTtcclxuICAgICAgICB9IGVsc2UgaWYgKFxyXG4gICAgICAgICAgZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QgaW5zdGFuY2VvZiBTdGlDb2x1bW5JdGVtICYmXHJcbiAgICAgICAgICAhZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5pc0NlbGxcclxuICAgICAgICApIHtcclxuICAgICAgICAgIHRoaXMuaW5zZXJ0SW5FeHByZXNzaW9uKFxyXG4gICAgICAgICAgICB0aGlzLmxhc3RDYXJldFBvc2l0aW9uLFxyXG4gICAgICAgICAgICBgQ29sKCR7ZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QuZVBhcmVudC5jb2x1bW5zLmluZGV4T2YoZXhwcmVzc2lvbk9iamVjdC5zdGFydE9iamVjdC5vYmplY3QpICsgMVxyXG4gICAgICAgICAgICB9LCcke2V4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0LmVQYXJlbnQubmFtZX0nKWBcclxuICAgICAgICAgICk7XHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgIHRoaXMuaW5zZXJ0SW5FeHByZXNzaW9uKFxyXG4gICAgICAgICAgICB0aGlzLmxhc3RDYXJldFBvc2l0aW9uLFxyXG4gICAgICAgICAgICBgQ2VsbCgke2V4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0LmVQYXJlbnQuY29sdW1ucy5pbmRleE9mKGV4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0KSArIDFcclxuICAgICAgICAgICAgfSwke2V4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3QuaW5kZXh9LCcke2V4cHJlc3Npb25PYmplY3Quc3RhcnRPYmplY3Qub2JqZWN0LmVQYXJlbnQubmFtZX0nKWBcclxuICAgICAgICAgICk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG4gIG9uTW91c2VNb3ZlKGV2ZW50KSB7XHJcbiAgICBpZiAoXHJcbiAgICAgIHRoaXMuY2FuRHJhZ0V4cHJlc3Npb24gJiZcclxuICAgICAgTWF0aC5tYXgoTWF0aC5hYnModGhpcy5zdGFydFggLSBldmVudC5jbGllbnRYKSwgTWF0aC5hYnModGhpcy5zdGFydFkgLSBldmVudC5jbGllbnRZKSkgPlxyXG4gICAgICBTdGlFeHByZXNzaW9uU2VydmljZS5NT1VTRV9ERUxUQVxyXG4gICAgKSB7XHJcbiAgICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuZXhwcmVzc2lvbkRyYWdnYWJsZUNvbnRhaW5lclggPSB0aGlzLmRyYWdPYmplY3QuZXZlbnQuY2xpZW50WCAtIDEwO1xyXG4gICAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmV4cHJlc3Npb25EcmFnZ2FibGVDb250YWluZXJZID0gdGhpcy5kcmFnT2JqZWN0LmV2ZW50LmNsaWVudFkgLSAxMDtcclxuICAgICAgdGhpcy5leHByZXNzaW9uU2VydmljZS5zdGFydENvbnRhaW5lckRyYWcodGhpcy5kcmFnT2JqZWN0KTtcclxuICAgICAgdGhpcy5jYW5EcmFnRXhwcmVzc2lvbiA9IGZhbHNlO1xyXG4gICAgfVxyXG4gICAgaWYgKHRoaXMuaXNEcmFnZ2luZykge1xyXG4gICAgICBsZXQgZGVsdGFYID0gZXZlbnQuY2xpZW50WCAtIHRoaXMuc3RhcnRYO1xyXG4gICAgICBsZXQgZGVsdGFZID0gZXZlbnQuY2xpZW50WSAtIHRoaXMuc3RhcnRZO1xyXG4gICAgICBpZiAodGhpcy5zdGFydENvbXBvbmVudFggKyBkZWx0YVggPCAwKSB7XHJcbiAgICAgICAgdGhpcy5leHByZXNzaW9uU2VydmljZS5jb21wb25lbnRYID0gMDtcclxuICAgICAgfSBlbHNlIGlmICh0aGlzLnN0YXJ0Q29tcG9uZW50WCArIGRlbHRhWCA+IHdpbmRvdy5pbm5lcldpZHRoIC0gdGhpcy5leHByZXNzaW9uU2VydmljZS5jb21wb25lbnRXaWR0aCkge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WCA9IHdpbmRvdy5pbm5lcldpZHRoIC0gdGhpcy5leHByZXNzaW9uU2VydmljZS5jb21wb25lbnRXaWR0aDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmNvbXBvbmVudFggPSB0aGlzLnN0YXJ0Q29tcG9uZW50WCArIGRlbHRhWDtcclxuICAgICAgfVxyXG5cclxuICAgICAgaWYgKHRoaXMuc3RhcnRDb21wb25lbnRZICsgZGVsdGFZIDwgMCkge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WSA9IDA7XHJcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5zdGFydENvbXBvbmVudFkgKyBkZWx0YVkgPiB3aW5kb3cuaW5uZXJIZWlnaHQgLSB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmNvbXBvbmVudEhlaWdodCkge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WSA9IHdpbmRvdy5pbm5lckhlaWdodCAtIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50SGVpZ2h0O1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuZXhwcmVzc2lvblNlcnZpY2UuY29tcG9uZW50WSA9IHRoaXMuc3RhcnRDb21wb25lbnRZICsgZGVsdGFZO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG4gIGdldFN0YXRlKGVsZW1lbnQpIHtcclxuICAgIHJldHVybiB0aGlzLmFycmF5T2ZTdGF0ZXMuZmluZCgoaXRlbSkgPT4gaXRlbS5lbGVtZW50ID09IGVsZW1lbnQpLnN0YXRlO1xyXG4gIH1cclxuICBjaGFuZ2VTdGF0ZShlbGVtZW50KSB7XHJcbiAgICBsZXQgaW5kZXggPSB0aGlzLmFycmF5T2ZTdGF0ZXMuZmluZEluZGV4KChpdGVtKSA9PiBpdGVtLmVsZW1lbnQgPT0gZWxlbWVudCk7XHJcbiAgICB0aGlzLmFycmF5T2ZTdGF0ZXNbaW5kZXhdLnN0YXRlID09IFwiZGVmYXVsdFwiXHJcbiAgICAgID8gKHRoaXMuYXJyYXlPZlN0YXRlc1tpbmRleF0uc3RhdGUgPSBcInJvdGF0ZWRcIilcclxuICAgICAgOiAodGhpcy5hcnJheU9mU3RhdGVzW2luZGV4XS5zdGF0ZSA9IFwiZGVmYXVsdFwiKTtcclxuICB9XHJcbiAgZm9jdXMoKSB7XHJcbiAgICB0aGlzLmV4cHJlc3Npb25TZXJ2aWNlLmVsZW1lbnRSZWYgPSB0aGlzLmVsZW1lbnRSZWY7XHJcbiAgfVxyXG4gIGJsdXIoKSB7XHJcbiAgICBpZiAodGhpcy5tb2RlbC5nZXRCcm93c2VyVHlwZSgpID09IFwic2FmYXJpXCIgfHwgdGhpcy5tb2RlbC5nZXRCcm93c2VyVHlwZSgpID09IFwiZmlyZWZveFwiKSB7XHJcbiAgICAgIHRoaXMuY2RyLnJlYXR0YWNoKCk7XHJcbiAgICAgIHRoaXMuY2RyLmRldGVjdENoYW5nZXMoKTtcclxuICAgIH1cclxuICB9XHJcbiAgZ2V0Q2FyZXQoKSB7XHJcbiAgICB0aGlzLmxhc3RDYXJldFBvc2l0aW9uID0gdGhpcy5leHByZXNzaW9uU2VydmljZS5nZXRDYXJldE9mZnNldCh0aGlzLmVsZW1lbnRSZWYubmF0aXZlRWxlbWVudCA/PyB0aGlzLmVsZW1lbnRSZWYpO1xyXG4gIH1cclxufVxyXG4iXX0=