import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../system/enums";
import { Enum } from "../system/Enum";
import { StiTableElement } from "../elements/StiTableElement";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import { StiRowLabel } from "../elements/table/StiRowLabel";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { StiLabelItem } from "../elements/text/StiLabelItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-editable-content.service";
import * as i3 from "../services/mouse.service";
import * as i4 from "@angular/common";
////
export class StiEditableContentComponent {
    get cursor() {
        if (this.model.previewMode) {
            return "default";
        }
        else {
            return this.showPlaceholder ? "text" : "";
        }
    }
    get showPlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.getValue()) &&
            this.active &&
            !this.model.previewMode /* &&
        this.editableContentService.editableContent != this.editableContent */);
    }
    hasWordWrap() {
        return this.editableContent["useWordWrap"] ? true : false;
    }
    getValue() {
        return this.editableContent?.sValue ?? this.editableContent.eValue;
    }
    get showNonActivePlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.getValue()) &&
            ((!this.active && !this.model.previewMode) ||
                (!this.active && this.model.previewMode) ||
                (this.active && this.model.previewMode)) /* &&
      this.editableContentService.editableContent != this.editableContent */);
    }
    get placeholderOutline() {
        if (this.showPlaceholder) {
            return !this.fromButton ? "1px dashed rgba(213, 213, 213, 0.8)" : "1px dashed rgba(255, 255, 255, 1)";
        }
        else {
            return "";
        }
    }
    click() {
        if (this.showPlaceholder) {
            this.elementRef.nativeElement.focus();
        }
    }
    get isEditable() {
        return (!this.model.previewMode &&
            (this.editableContentService.editableContent == this.editableContent || this.showPlaceholder));
    }
    get width() {
        if (this.editableContent instanceof StiLabelItem && this.editableContent.alignment != StiLabelAlignment.Top) {
            return this.editableContent.width + "px";
        }
        else {
            return "100%";
        }
    }
    get align() {
        if (this.alignment) {
            return Enum.getName(StiHorizontalAlignment, this.alignment);
        }
        else {
            return "";
        }
    }
    constructor(model, editableContentService, mouseService, cdr) {
        this.model = model;
        this.editableContentService = editableContentService;
        this.mouseService = mouseService;
        this.cdr = cdr;
        this.required = false;
        this.hideEmpty = true;
        this.active = true;
        this.isTableTotalHeader = false;
        this.disablePadding = false;
        this.fromButton = false;
        this.isTableHeader = false;
        this.isInitialize = false;
        this.focused = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    ngAfterContentInit() {
        setTimeout(() => {
            if (this.editableContent && this.eParent) {
                this.editableContent.eParent = this.eParent;
            }
        }, 0);
    }
    needToUpdate(event) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let needToUpdate = true;
        elements.forEach((element) => {
            if (element.className == "Properties") {
                needToUpdate = false;
            }
        });
        if (needToUpdate &&
            typeof this.editableContentService.editableContent != typeof this.editableContent &&
            this.isInitialize &&
            !this.editableContentService.activeControl) {
            this.closeAll(this.model.selectedComponent?.element);
            this.isInitialize = false;
            needToUpdate = true;
            this.model.needToRefresh.next(true);
        }
    }
    focus() {
        this.editableContentService.editableContent = this.editableContent;
        this.editableContentService.editableElementRef = this.elementRef;
        if (this.model.selectedComponent?.element instanceof StiTableElement) {
            // this.closeAll(this.model.selectedComponent.element);
            // this.model.currentTablePropertyHeader.next("Table");
            if (this.editableContent instanceof StiColumnItem) {
                if (!this.model.selectedComponent?.element.showColumnsEditor) {
                    this.model.selectedComponent.element.showColumnsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Columns");
                setTimeout(() => {
                    if (this.model.selectedComponent?.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.columns.findIndex((column) => column == this.editableContent);
                        if (this.model.currentContentEditableItemIndex != index ||
                            this.model.previousSelectedComponent != this.model.selectedComponent)
                            this.model.currentContentEditableItem.next(index);
                        this.model.currentContentEditableItemIndex = index;
                    }
                }, 0);
            }
            else if (this.editableContent instanceof StiRowLabel) {
                this.model.selectedComponent.element.showRowsEditor = true;
                this.model.needToRefresh.next(true);
                // this.model.currentTablePropertyHeader.next("Rows");
                /*  setTimeout(() => {
                  if (this.model.selectedComponent.element instanceof StiTableElement) {
                    this.model.currentContentEditableItem.next(
                      this.model.selectedComponent.element.rowLabelsContentEditable.findIndex(
                        (column) => column == this.editableContent
                      )
                    );
                  }
                }, 0); */
            }
            else if (this.editableContent instanceof StiTotalsFieldItem) {
                if (!this.model.selectedComponent.element.showTotalsEditor) {
                    this.model.selectedComponent.element.showTotalsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Totals");
                setTimeout(() => {
                    if (this.model.selectedComponent.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.totalsFields.findIndex((column) => column == this.editableContent);
                        this.model.currentContentEditableItem.next(index);
                    }
                }, 0);
            }
            else if (this.isTableTotalHeader) {
                this.model.selectedComponent.element.showTotalsEditor = true;
                this.model.needToRefresh.next(true);
            }
            else {
                this.model.selectedComponent.element.showHeaderEditor = true;
                this.model.needToRefresh.next(true);
            }
        }
        this.isInitialize = true;
        this.focused = true;
    }
    blur() {
        let sValue = this.editableContent.sValue;
        if (sValue != null) {
            this.editableContent.eValue = sValue;
            this.editableContent.sValue = null;
        }
        if (!this.editableContentService.activeControl) {
            setTimeout(() => {
                if (this.editableContentService.editableContent == this.editableContent) {
                    this.editableContentService.editableContent = null;
                    this.editableContentService.editableElementRef = null;
                    if (this.model.getBrowserType() == "safari" ||
                        (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
                        this.cdr.reattach();
                        this.cdr.detectChanges();
                    }
                    this.model.formEvents.next({ name: "ValueChanged" });
                }
                this.focused = false;
            }, 0);
        }
    }
    setContent(innerText) {
        if ((this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") && this.showPlaceholder) {
            this.editableContentService.startEdit();
        }
        if (this.model.getBrowserType() == "safari" ||
            (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
            this.cdr.detach();
        }
        this.editableContent.sValue = innerText;
        if (innerText == "") {
            this.editableContent.eValue = "";
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event)) {
            event.preventDefault();
            this.blur();
        }
    }
    disableDrag(event) {
        event.fromEditableContent = true;
        this.focus();
    }
    closeAll(element) {
        if (element instanceof StiTableElement) {
            element.showTotalsEditor = false;
            element.showRowsEditor = false;
            element.showColumnsEditor = false;
        }
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.needToUpdate(event);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }, { token: i3.StiMouseService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiEditableContentComponent, selector: "sti-editable-content-component", inputs: { editableContent: "editableContent", displayContent: "displayContent", required: "required", eParent: "eParent", hideEmpty: "hideEmpty", active: "active", alignment: "alignment", isTableTotalHeader: "isTableTotalHeader", disablePadding: "disablePadding", fromButton: "fromButton", parentCursor: "parentCursor", isTableHeader: "isTableHeader" }, viewQueries: [{ propertyName: "elementRef", first: true, predicate: ["elementRef"], descendants: true }], ngImport: i0, template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : getValue() || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.previewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, isInline: true, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-editable-content-component", template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : getValue() || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.previewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }, { type: i3.StiMouseService }, { type: i0.ChangeDetectorRef }], propDecorators: { elementRef: [{
                type: ViewChild,
                args: ["elementRef"]
            }], editableContent: [{
                type: Input
            }], displayContent: [{
                type: Input
            }], required: [{
                type: Input
            }], eParent: [{
                type: Input
            }], hideEmpty: [{
                type: Input
            }], active: [{
                type: Input
            }], alignment: [{
                type: Input
            }], isTableTotalHeader: [{
                type: Input
            }], disablePadding: [{
                type: Input
            }], fromButton: [{
                type: Input
            }], parentCursor: [{
                type: Input
            }], isTableHeader: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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