import { Component, Input, ViewChild } from "@angular/core";
import { StiDateTimeBoxValueChoise, StiDateTimeBoxType, StiHorizontalAlignment } from "../../system/enums";
import { StiInputTextItem } from "../../helper/StiInputTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
import * as i4 from "../sti-component";
import * as i5 from "../sti-editable-content.component";
import * as i6 from "../svg.components/svg.checkbox.component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiDateTimeBoxComponent {
    get isCurrent() {
        return this.element.initialState == StiDateTimeBoxValueChoise.Current;
    }
    get isReadOnly() {
        return this.element.readOnly;
    }
    get needToFill() {
        return (this.element.required &&
            (this.element.allowNull ? !this.element.dateTimeValueIsNotNull : !this.element.value) &&
            this.model.hasEmptyReuiredFields);
    }
    get align() {
        return "start";
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get horizontalAlignment() {
        if (this.element.contentAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else if (this.element.contentAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get format() {
        return this.element.valueType == StiDateTimeBoxType.Date
            ? this.element.dateFormat
            : this.element.valueType == StiDateTimeBoxType.Time
                ? this.element.timeFormat
                : this.element.dateTimeFormat;
    }
    getValue() {
        return this.element.dateValueString;
    }
    parseDate(value) {
        if (value.length > 0) {
            this.element.dateValue = new Date(value);
            this.model.formEvents.next({ name: "ValueChanged" });
        }
    }
    formattingDate(dateFormat) {
        let result = dateFormat
            .replace(/M/g, "k")
            .replace(/m/g, "r")
            .replace(/tt/g, "a")
            .replace(/k/g, "m")
            .replace(/r/g, "M");
        return result;
    }
    changeState() {
        this.element.dateTimeValueIsNotNull = !this.element.dateTimeValueIsNotNull;
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    inFocus() {
        setTimeout(() => {
            let editableContent = new StiInputTextItem("", this.element.font, this.element.textColor, this.element.backgroundColor, this.element.contentAlignment);
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
    }
    constructor(model, editableService) {
        this.model = model;
        this.editableService = editableService;
        this.isClone = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDateTimeBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiDateTimeBoxComponent, selector: "sti-datetimebox-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "inputDate", first: true, predicate: ["inputDate"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-date-time-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.position]="'relative'">
          <div
            class="date-time-box-container"
            [style.align-self]="align"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="element?.htmlStyle()"
            [style.justify-content]="horizontalAlignment"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="this.element.backgroundColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            (click)="inFocus(); inputDate.click()"
          >
            <sti-svg-checkbox-component
              *ngIf="element.allowNull && !model.previewMode"
              [style.margin-top.px]="margin"
              [style.align-self]="align"
              [style.margin-block]="'auto'"
              [element]="element"
              [id]="element?.name"
              [text]=""
              [state]="element?.dateTimeValueIsNotNull"
              [disablePlaceHolder]="true"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
            <span
              [style.width]="'100%'"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.color]="this.element.textColor.toHtmlColor()"
              (click)="inputDate.click()"
              >{{getValue()}}</span
            >
            <div
              class="date-picker"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              *ngIf="!isReadOnly"
            >
              <label [style.display]="'flex'" [style.align-items]="'center'" [style.justify-content]="'center'"
                ><i class="pi pi-chevron-down"></i
              ></label>
            </div>
            <input
              #inputDate
              [style.left.px]="element.allowNull ? 20 : 0"
              [type]="isMozila ? 'date' : 'datetime-local'"
              (input)="parseDate($event.target.value)"
              [tabIndex]="element['tabIndex']"
              [disabled]="element.readOnly && model.previewMode"
              (select)="inputDate.click()"
            />
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".date-time-box-container{align-items:center;padding:3px 4px;display:flex;width:100%;border:1px solid transparent}.date-time-box-container:hover{border-color:#a3bde3!important}input{opacity:0;position:absolute;left:0;top:0;width:100%;height:100%}input::-webkit-datetime-edit{display:none}input::-webkit-calendar-picker-indicator{cursor:pointer;width:100%}.date-picker{background-color:transparent;width:16px;position:relative;height:16px;display:flex;align-items:center;justify-content:center;margin-left:4px;padding-right:1px}i{color:#d3d3d3}.pi-chevron-down{font-size:.575rem;font-weight:700;color:#c5c5c5;padding-top:1px}img{vertical-align:middle;margin-left:0;height:16px;width:16px}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i5.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i6.StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: ["element", "id", "text", "state", "useCustomOption", "disablePlaceHolder", "tabIndex"], outputs: ["buttonClick"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDateTimeBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-datetimebox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-date-time-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.position]="'relative'">
          <div
            class="date-time-box-container"
            [style.align-self]="align"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="element?.htmlStyle()"
            [style.justify-content]="horizontalAlignment"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="this.element.backgroundColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            (click)="inFocus(); inputDate.click()"
          >
            <sti-svg-checkbox-component
              *ngIf="element.allowNull && !model.previewMode"
              [style.margin-top.px]="margin"
              [style.align-self]="align"
              [style.margin-block]="'auto'"
              [element]="element"
              [id]="element?.name"
              [text]=""
              [state]="element?.dateTimeValueIsNotNull"
              [disablePlaceHolder]="true"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
            <span
              [style.width]="'100%'"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.color]="this.element.textColor.toHtmlColor()"
              (click)="inputDate.click()"
              >{{getValue()}}</span
            >
            <div
              class="date-picker"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              *ngIf="!isReadOnly"
            >
              <label [style.display]="'flex'" [style.align-items]="'center'" [style.justify-content]="'center'"
                ><i class="pi pi-chevron-down"></i
              ></label>
            </div>
            <input
              #inputDate
              [style.left.px]="element.allowNull ? 20 : 0"
              [type]="isMozila ? 'date' : 'datetime-local'"
              (input)="parseDate($event.target.value)"
              [tabIndex]="element['tabIndex']"
              [disabled]="element.readOnly && model.previewMode"
              (select)="inputDate.click()"
            />
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".date-time-box-container{align-items:center;padding:3px 4px;display:flex;width:100%;border:1px solid transparent}.date-time-box-container:hover{border-color:#a3bde3!important}input{opacity:0;position:absolute;left:0;top:0;width:100%;height:100%}input::-webkit-datetime-edit{display:none}input::-webkit-calendar-picker-indicator{cursor:pointer;width:100%}.date-picker{background-color:transparent;width:16px;position:relative;height:16px;display:flex;align-items:center;justify-content:center;margin-left:4px;padding-right:1px}i{color:#d3d3d3}.pi-chevron-down{font-size:.575rem;font-weight:700;color:#c5c5c5;padding-top:1px}img{vertical-align:middle;margin-left:0;height:16px;width:16px}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }], propDecorators: { inputDate: [{
                type: ViewChild,
                args: ["inputDate"]
            }], element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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