import { Component, Input, ViewChild } from "@angular/core";
import { StiLabelAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-progress.component";
import * as i6 from "../sti-tooltip/sti-tooltip.directive";
export class StiBarcodeComponent {
    get align() {
        return "start";
    }
    get barcode() {
        return "url(" + this.element.img + ")";
    }
    get barcodeHeight() {
        return this.element.Height;
    }
    get barcodeWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return (this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left - 2);
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left - 2 /*borderWidth */;
            }
        }
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    ngOnInit() { }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.ref;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiBarcodeComponent, selector: "sti-barcode-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "ref", first: true, predicate: ["ref"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-barcode">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="align"
      [style.width]="element?.getLabelWidth()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
    ></sti-editable-content-component>
    <sti-progress [display]="element.showProgress"></sti-progress>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 55 : 0"
            [style.min-height.px]="isClone ? 55 : 0"
            [style.background-image]="this.barcode"
            [style.background-size]="'contain'"
            [style.background-repeat]="this.barcode ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
          ></div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiProgressComponent, selector: "sti-progress", inputs: ["display"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-barcode-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-barcode">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="align"
      [style.width]="element?.getLabelWidth()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
    ></sti-editable-content-component>
    <sti-progress [display]="element.showProgress"></sti-progress>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 55 : 0"
            [style.min-height.px]="isClone ? 55 : 0"
            [style.background-image]="this.barcode"
            [style.background-size]="'contain'"
            [style.background-repeat]="this.barcode ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
          ></div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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