import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "@angular/common";
import * as i4 from "@angular/forms";
import * as i5 from "../sti-component";
import * as i6 from "../sti-editable-content.component";
import * as i7 from "../sti-input-text.component";
export class StiAddressComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        this.isClone = false;
    }
    get values() {
        return this.helper.countries;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiAddressComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiAddressComponent, selector: "sti-address-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" [style.align-items]="'center'" class="StiButton">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="'start'"
      [style.width]="element?.getLabelWidth()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div
            class="address-form"
            (mousedown)="disableDrag($event)"
            [style.maxWidth.px]="element.maxWidth + 0.1"
            (mouseup)="this.model.canDrag = true"
          >
            <div class="field" *ngIf="element.useStreetAddress">
              <sti-input-text-component
                [element]="element"
                [tabIndex]="element['tabIndex']"
                [property]="'streetAddress'"
                [style.width]="'100%'"
              ></sti-input-text-component>
              <sti-editable-content-component
                [editableContent]="element.streetAddressLabelItem"
                [style.width]="'min-content'"
              ></sti-editable-content-component>
            </div>
            <div class="field" *ngIf="element.useStreetAddress2">
              <sti-input-text-component
                [element]="element"
                [tabIndex]="element['tabIndex'] + 1"
                [property]="'streetAddress2'"
                [style.width]="'100%'"
              ></sti-input-text-component>
              <sti-editable-content-component
                [editableContent]="element.streetAddress2LabelItem"
              ></sti-editable-content-component>
            </div>
            <div
              class="group"
              [style.grid-template-columns]="element.useCity && element.useState ? '50% 50%' : '100%'"
              *ngIf="element.useCity || element.useState"
            >
              <div class="group-field" *ngIf="element.useCity" [style.padding-right.px]="element.useState ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [property]="'city'"
                  [tabIndex]="element['tabIndex'] + 2"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.cityLabelItem"
                ></sti-editable-content-component>
              </div>
              <div class="group-field" *ngIf="element.useState" [style.padding-left.px]="element.useCity ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [tabIndex]="element['tabIndex'] + 3"
                  [property]="'state'"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.stateLabelItem"
                ></sti-editable-content-component>
              </div>
            </div>
            <div
              class="group"
              [style.grid-template-columns]="element.useZipCode && element.useCountry ? '50% 50%' : '100%'"
              *ngIf="element.useZipCode || element.useCountry"
            >
              <div class="group-field" *ngIf="element.useZipCode" [style.padding-right.px]="element.useCountry ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [tabIndex]="element['tabIndex'] + 4"
                  [property]="'zipCode'"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.zipCodeLabelItem"
                ></sti-editable-content-component>
              </div>
              <div class="group-field" *ngIf="element.useCountry" [style.padding-left.px]="element.useZipCode ? 3 : 0">
                <select
                  class="selection"
                  name=""
                  id=""
                  [(ngModel)]="element.country"
                  [style.align-self]="'start'"
                  [style]="element?.comboBoxHtmlStyle()"
                  [style.color]="element?.textColor.toHtmlColor()"
                  [style.background-color]="element?.backgroundColor.toHtmlColor()"
                  [style.border-color]="element?.borderColor.toHtmlColor()"
                  [style.border-width]="borderWidth()"
                  [style.padding-right]="'20px'"
                  [disabled]="element?.readOnly"
                  [required]="element?.required"
                  [tabIndex]="element['tabIndex'] + 5"
                  (mousedown)="disableDrag($event)"
                  (mouseup)="this.model.canDrag = true"
                >
                  <option *ngFor="let country of helper?.countries">{{ country.name }}</option>
                </select>
                <sti-editable-content-component
                  [editableContent]="element.countryLabelItem"
                ></sti-editable-content-component>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.address-form{flex:1}.field{flex:1;margin-bottom:5px}.group{display:grid;grid-template-columns:50% 50%}.group-field{width:100%;margin-bottom:5px}.selection{width:100%;border:1px solid rgb(198,198,198);background-color:#fff;height:fit-content;padding:3px 4px;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i4.NgSelectOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i4.ɵNgSelectMultipleOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i4.SelectControlValueAccessor, selector: "select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]", inputs: ["compareWith"] }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i5.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i6.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i7.StiInputTextComponent, selector: "sti-input-text-component", inputs: ["element", "property", "tabIndex"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiAddressComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-address-component", template: ` <sti-component [element]="element" [isClone]="isClone" [style.align-items]="'center'" class="StiButton">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="'start'"
      [style.width]="element?.getLabelWidth()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div
            class="address-form"
            (mousedown)="disableDrag($event)"
            [style.maxWidth.px]="element.maxWidth + 0.1"
            (mouseup)="this.model.canDrag = true"
          >
            <div class="field" *ngIf="element.useStreetAddress">
              <sti-input-text-component
                [element]="element"
                [tabIndex]="element['tabIndex']"
                [property]="'streetAddress'"
                [style.width]="'100%'"
              ></sti-input-text-component>
              <sti-editable-content-component
                [editableContent]="element.streetAddressLabelItem"
                [style.width]="'min-content'"
              ></sti-editable-content-component>
            </div>
            <div class="field" *ngIf="element.useStreetAddress2">
              <sti-input-text-component
                [element]="element"
                [tabIndex]="element['tabIndex'] + 1"
                [property]="'streetAddress2'"
                [style.width]="'100%'"
              ></sti-input-text-component>
              <sti-editable-content-component
                [editableContent]="element.streetAddress2LabelItem"
              ></sti-editable-content-component>
            </div>
            <div
              class="group"
              [style.grid-template-columns]="element.useCity && element.useState ? '50% 50%' : '100%'"
              *ngIf="element.useCity || element.useState"
            >
              <div class="group-field" *ngIf="element.useCity" [style.padding-right.px]="element.useState ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [property]="'city'"
                  [tabIndex]="element['tabIndex'] + 2"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.cityLabelItem"
                ></sti-editable-content-component>
              </div>
              <div class="group-field" *ngIf="element.useState" [style.padding-left.px]="element.useCity ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [tabIndex]="element['tabIndex'] + 3"
                  [property]="'state'"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.stateLabelItem"
                ></sti-editable-content-component>
              </div>
            </div>
            <div
              class="group"
              [style.grid-template-columns]="element.useZipCode && element.useCountry ? '50% 50%' : '100%'"
              *ngIf="element.useZipCode || element.useCountry"
            >
              <div class="group-field" *ngIf="element.useZipCode" [style.padding-right.px]="element.useCountry ? 3 : 0">
                <sti-input-text-component
                  [element]="element"
                  [tabIndex]="element['tabIndex'] + 4"
                  [property]="'zipCode'"
                  [style.width]="'100%'"
                ></sti-input-text-component>
                <sti-editable-content-component
                  [editableContent]="element.zipCodeLabelItem"
                ></sti-editable-content-component>
              </div>
              <div class="group-field" *ngIf="element.useCountry" [style.padding-left.px]="element.useZipCode ? 3 : 0">
                <select
                  class="selection"
                  name=""
                  id=""
                  [(ngModel)]="element.country"
                  [style.align-self]="'start'"
                  [style]="element?.comboBoxHtmlStyle()"
                  [style.color]="element?.textColor.toHtmlColor()"
                  [style.background-color]="element?.backgroundColor.toHtmlColor()"
                  [style.border-color]="element?.borderColor.toHtmlColor()"
                  [style.border-width]="borderWidth()"
                  [style.padding-right]="'20px'"
                  [disabled]="element?.readOnly"
                  [required]="element?.required"
                  [tabIndex]="element['tabIndex'] + 5"
                  (mousedown)="disableDrag($event)"
                  (mouseup)="this.model.canDrag = true"
                >
                  <option *ngFor="let country of helper?.countries">{{ country.name }}</option>
                </select>
                <sti-editable-content-component
                  [editableContent]="element.countryLabelItem"
                ></sti-editable-content-component>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.address-form{flex:1}.field{flex:1;margin-bottom:5px}.group{display:grid;grid-template-columns:50% 50%}.group-field{width:100%;margin-bottom:5px}.selection{width:100%;border:1px solid rgb(198,198,198);background-color:#fff;height:fit-content;padding:3px 4px;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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