import { Component, Input } from "@angular/core";
import { SlideInOutAnimation } from "../../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../sti-color-editor/sti-color-editor.component";
import * as i7 from "../../sti-enum-editor/sti-enum-editor.component";
import * as i8 from "../../sti-number-editor/sti-number-editor.component";
import * as i9 from "../border-sides-editor/border-sides-editor.component";
export class StiTableBorderEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.properties = [];
        this.properties.push({
            type: "borderAlignment",
            property: this.getProperty(this.property.property),
            label: this.loc.getP("Sides"),
        });
        this.properties.push({ type: "color", property: "color", label: this.loc.getP("Color") });
        this.properties.push({ type: "Number", property: "width", label: this.loc.getP("LineWidth") });
        this.properties.push({ type: "enum", property: "style", label: this.loc.getP("Style") });
        //
    }
    getProperty(property) {
        if (property == "showBorderEditor") {
            return "border";
        }
        else if (property == "showColumnsBorderEditor") {
            return "columnHeadersBorder";
        }
        else if (property == "showRowsBorderEditor") {
            return "rowHeadersBorder";
        }
        else {
            return "gridLines";
        }
    }
    get content() {
        return this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    set content(value) {
        this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableBorderEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: { property: "property", state: "state", object: "object" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="border-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td>
            <sti-border-sides-editor
              *ngIf="prop.type === 'borderAlignment'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '95%' }"
            ></sti-border-sides-editor>
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object?.pen"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object?.pen"
            ></sti-enum-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object?.pen" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .border-editor {
        overflow: hidden;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 150px;\n        white-space: nowrap;\n        color: var(--property-label-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .border-editor {\n        overflow: hidden;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i7.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i8.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i9.StiBorderSidesEditorComponent, selector: "sti-border-sides-editor", inputs: ["property", "object"] }], animations: [SlideInOutAnimation] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableBorderEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-border-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="border-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td>
            <sti-border-sides-editor
              *ngIf="prop.type === 'borderAlignment'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '95%' }"
            ></sti-border-sides-editor>
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object?.pen"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object?.pen"
            ></sti-enum-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object?.pen" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .border-editor {
        overflow: hidden;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }], state: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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