import { Component, Input } from "@angular/core";
import { RenderComponentsGeometry } from "../../../../computed/RenderComponentsGeometry";
import { PaperKind } from "../../../../system/enums";
import StiPagePaperKind from "../../../../properties/StiPagePaperKind";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-dropdown-editor/sti-dropdown-editor.component";
export class StiPaperKindEditorComponent {
    constructor(model) {
        this.model = model;
        this.enum = PaperKind;
        this.kinds = StiPagePaperKind.availableStandardKinds();
        this.values = Object.values(this.kinds);
        this.obj = this.values.map((it) => PaperKind[it.kind]);
    }
    ngOnInit() { }
    get paperKind() {
        StiPagePaperKind.fromStandardPaperKind(9);
        return this.model.selectedPage[this.property.property];
    }
    get kind() {
        return this.model.selectedPage.paperKind.kind;
    }
    set kind(value) {
        this.model.selectedPage.paperKind = StiPagePaperKind.fromStandardPaperKind(value);
        RenderComponentsGeometry(this.model.form.pages, this.model);
        this.model.previousContentAreaWidth = this.model.selectedPage.contentAreaWidth;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPaperKindEditorComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPaperKindEditorComponent, selector: "sti-paper-kind-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'paperKind'">
        <td colspan="5" [style]="{ width: '100%' }">
          <sti-dropdown-editor
            [options]="values"
            [(value)]="kind"
            class="p-inputtext-sm"
            optionValue="kind"
            optionLabel="name"
            [style]="{ width: '100%', height: '24px' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPaperKindEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-paper-kind-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'paperKind'">
        <td colspan="5" [style]="{ width: '100%' }">
          <sti-dropdown-editor
            [options]="values"
            [(value)]="kind"
            class="p-inputtext-sm"
            optionValue="kind"
            optionLabel="name"
            [style]="{ width: '100%', height: '24px' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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