import { Component, Input, ViewChild } from "@angular/core";
import { StiNumberBoxElement } from "../../../../elements/StiNumberBoxElement";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
export class StiNumberEditorComponent {
    get gridCounter() {
        return this._gridCounter;
    }
    set gridCounter(value) {
        if (this.property.property == "gridColumns") {
            if (value <= 12) {
                this._gridCounter = 12;
            }
            else if (this.model.form?.pages.length > 0 && value > this.model.form.pages[this.model.form.pages.length - 1].contentAreaWidth) {
                this._gridCounter = this.model.form.pages[this.model.form.pages.length - 1].contentAreaWidth;
            }
            else {
                this._gridCounter = value;
            }
        }
        else {
            if (value <= 1) {
                this._gridCounter = 1;
            }
            else if (this.model.form?.pages.length > 0 && value > this.model.form.pages[this.model.form.pages.length - 1].contentAreaHeight) {
                this._gridCounter = this.model.form.pages[this.model.form.pages.length - 1].contentAreaHeight;
            }
            else {
                this._gridCounter = value;
            }
        }
    }
    constructor(model, helper, theme, loc, render) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.render = render;
        this.isIncrement = false;
        this.isDecrement = false;
    }
    ngOnDestroy() {
        if (this.numberInput) {
            if (this.numberInput.nativeElement.value && Number(this.numberInput.nativeElement.value) != this.counter) {
                this.onLostFocus(this.numberInput.nativeElement.value);
            }
        }
    }
    ngOnInit() {
        if (this.property.property == "gridColumns" || this.property.property == "gridVerticalStep") {
            this.gridCounter = this.helper.getProperty(this.element, this.property.property)
                ? parseFloat(this.helper.getProperty(this.element, this.property.property))
                : this.helper.getProperty(this.element, this.property.property);
        }
    }
    onLostFocus(value) {
        if (this.property.property == "gridColumns" || this.property.property == "gridVerticalStep") {
            this.gridCounter = Number(value);
            return;
        }
        this.helper.setProperty(this.obj ?? this.element, this.property.property, Number(value));
        if (this.element instanceof StiNumberBoxElement && this.element.useRange && this.property.property == "value") {
            this.model.checkNumberRange(this.element);
        }
        else if (this.element instanceof StiNumberBoxElement && this.property.property == "decimalDigits") {
            this.model.needToRefresh.next(true);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    applySettings() {
        this.helper.setProperty(this.element, this.property.property, this.gridCounter);
        this.model.formEvents.next({ name: "ValueChanged" });
        setTimeout(() => {
            this.checkOutputs();
        }, 300);
    }
    checkOutputs() {
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element.x + element.width > page.contentAreaWidth) {
                    element.x = 0;
                }
            });
        });
        this.checkOnOverlay();
        this.model.form.pages.forEach((page) => {
            this.render.checkOutputs(page);
        });
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    checkOnOverlay() {
        let hasOverlayedElements = false;
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                let overlayedElements = page.allElements.filter((elem) => elem.x == element.x && elem.y == element.x);
                if (overlayedElements.length > 1) {
                    overlayedElements.forEach((overlayedElement, index) => {
                        if (index != 0) {
                            hasOverlayedElements = true;
                            overlayedElement.y += index;
                        }
                    });
                }
            });
        });
        if (hasOverlayedElements) {
            this.model.form.allElements.forEach((element) => {
                let container = this.model.getElementPage(element) ?? this.model.getElementPanel(element);
                this.render.insertElement(element, container.contentAreaWidth);
            });
        }
    }
    clearTimers() {
        this.isIncrement = false;
        this.isDecrement = false;
        clearTimeout(this.timeout);
        clearInterval(this.interval);
    }
    iterate() {
        if (this.isIncrement) {
            if (this.model.selectedPage) {
                this.model.selectedPage[this.property.property] += 1;
            }
            else {
                this.counter += 1;
            }
        }
        else if (this.isDecrement) {
            if (this.model.selectedPage) {
                this.model.selectedPage[this.property.property] -= 1;
            }
            else {
                this.counter -= 1;
            }
        }
    }
    setIncrementInterval() {
        this.isIncrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    setDecrementInterval() {
        this.isDecrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    get element() {
        return this.model.selectedComponent?.element ?? this.model.form.settings;
    }
    get counter() {
        if (this.property.property != "gridColumns" && this.property.property != "gridVerticalStep") {
            if (this.obj) {
                return this.helper.getProperty(this.obj, this.property.property)
                    ? parseFloat(this.helper.getProperty(this.obj, this.property.property))
                    : this.helper.getProperty(this.obj, this.property.property);
            }
            return this.helper.getProperty(this.element, this.property.property);
        }
        else {
            return this.gridCounter;
        }
    }
    validNegativeValue() {
        if (this.obj instanceof StiNumberBoxElement) {
            if (this.property.property == "value" ||
                this.property.property == "minimum" ||
                this.property.property == "maximum") {
                return true;
            }
            else
                return false;
        }
        else {
            return false;
        }
    }
    set counter(value) {
        if (value < 0 && !this.validNegativeValue()) {
            return;
        }
        if (this.property.property != "gridColumns" && this.property.property != "gridVerticalStep") {
            if (this.obj) {
                this.helper.setProperty(this.obj, this.property.property, value);
            }
            else {
                this.helper.setProperty(this.element, this.property.property, value);
                if (this.element instanceof StiNumberBoxElement && this.element.useRange && this.property.property == "value") {
                    this.model.checkNumberRange(this.element);
                }
            }
        }
        else {
            this.gridCounter = value;
            this.model.formEvents.next({ name: "ValueChanged" });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiNumberEditorComponent, selector: "sti-number-editor", inputs: { property: "property", obj: "obj" }, viewQueries: [{ propertyName: "numberInput", first: true, predicate: ["numberInput"], descendants: true }], ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'pageNumberEditor'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                [(ngModel)]="model.selectedPage[property.property]"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>

      <tr *ngIf="property.type === 'NumberEditor' || property.type === 'Number'">
        <td [colSpan]="this.property.property == 'label.width' ? 5 : 7">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                #numberInput
                (blur)="onLostFocus($event.currentTarget.value)"
                (keyup.enter)="onLostFocus($event.currentTarget.value)"
                [value]="counter"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
        <td
          *ngIf="
            property.type === 'Number' &&
            (property.property == 'gridColumns' || property.property == 'gridVerticalStep')
          "
        >
          <div class="apply-button" (click)="applySettings()">
            <label>{{ loc.getP("Apply") }}</label>
          </div>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 1px;
      }
      label {
        margin: 0;
        font-size: 12px;
        font-weight: 500;
        color: var(--text-color);
        white-space: nowrap;
        outline: none;
        overflow: hidden;
        scroll-behavior: smooth;
      }
      .apply-button {
        height: 24px;
        width: 100%;
        min-width: 60px;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 3px;
      }
      .apply-button:hover {
        background-color: var(--active-color);
      }
      .value:hover {
        cursor: text;
      }
      .image-upload > input {
        display: none;
      }
      .number-box {
        width: 100%;
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        background-color: var(--input-color);
        position: relative;
        display: flex;
      }
      .value {
        outline: none;
        width: 100%;
        height: 100%;
      }
      .value input {
        outline: none;
        background-color: var(--input-color);
        -moz-appearance: textfield;
        color: var(--text-color);
        border: 0px;
      }
      .value input[type="number"]::-webkit-inner-spin-button,
      .value input[type="number"]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
        opacity: 0;
      }

      .value:after {
        content: "";
        position: absolute;
        right: 22px;
        z-index: 100;
        top: 2px;
        width: 1px;
        height: 18px;
        background-color: var(--inputBorder-color);
      }
      .buttons {
        width: 22px;
        height: 100%;
        align-self: flex-end;
        display: flex;
        flex-direction: column;

        color: rgb(186, 185, 184);
      }
      .button-up {
        width: 22px;
        position: relative;
        height: 11px;
        border-bottom: 1px solid var(--inputBorder-color);
        text-align: center;
      }
      .button-up:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-up:active {
        background-color: rgb(195, 195, 195);
      }
      .button-down {
        width: 22px;
        position: relative;
        height: 11px;
        text-align: center;
      }
      .button-down:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-down:active {
        background-color: rgb(195, 195, 195);
      }
      i {
        position: absolute;
        left: 5px;
        height: 8px;
        width: 10px;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 1px;\n      }\n      label {\n        margin: 0;\n        font-size: 12px;\n        font-weight: 500;\n        color: var(--text-color);\n        white-space: nowrap;\n        outline: none;\n        overflow: hidden;\n        scroll-behavior: smooth;\n      }\n      .apply-button {\n        height: 24px;\n        width: 100%;\n        min-width: 60px;\n        border-radius: 3px;\n        background-color: var(--hover-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        margin-left: 3px;\n      }\n      .apply-button:hover {\n        background-color: var(--active-color);\n      }\n      .value:hover {\n        cursor: text;\n      }\n      .image-upload > input {\n        display: none;\n      }\n      .number-box {\n        width: 100%;\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        border-radius: 3px;\n        background-color: var(--input-color);\n        position: relative;\n        display: flex;\n      }\n      .value {\n        outline: none;\n        width: 100%;\n        height: 100%;\n      }\n      .value input {\n        outline: none;\n        background-color: var(--input-color);\n        -moz-appearance: textfield;\n        color: var(--text-color);\n        border: 0px;\n      }\n      .value input[type=\"number\"]::-webkit-inner-spin-button,\n      .value input[type=\"number\"]::-webkit-outer-spin-button {\n        -webkit-appearance: none;\n        margin: 0;\n        opacity: 0;\n      }\n\n      .value:after {\n        content: \"\";\n        position: absolute;\n        right: 22px;\n        z-index: 100;\n        top: 2px;\n        width: 1px;\n        height: 18px;\n        background-color: var(--inputBorder-color);\n      }\n      .buttons {\n        width: 22px;\n        height: 100%;\n        align-self: flex-end;\n        display: flex;\n        flex-direction: column;\n\n        color: rgb(186, 185, 184);\n      }\n      .button-up {\n        width: 22px;\n        position: relative;\n        height: 11px;\n        border-bottom: 1px solid var(--inputBorder-color);\n        text-align: center;\n      }\n      .button-up:hover {\n        background-color: rgb(209, 208, 207);\n      }\n      .button-up:active {\n        background-color: rgb(195, 195, 195);\n      }\n      .button-down {\n        width: 22px;\n        position: relative;\n        height: 11px;\n        text-align: center;\n      }\n      .button-down:hover {\n        background-color: rgb(209, 208, 207);\n      }\n      .button-down:active {\n        background-color: rgb(195, 195, 195);\n      }\n      i {\n        position: absolute;\n        left: 5px;\n        height: 8px;\n        width: 10px;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NumberValueAccessor, selector: "input[type=number][formControlName],input[type=number][formControl],input[type=number][ngModel]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-number-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'pageNumberEditor'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                [(ngModel)]="model.selectedPage[property.property]"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>

      <tr *ngIf="property.type === 'NumberEditor' || property.type === 'Number'">
        <td [colSpan]="this.property.property == 'label.width' ? 5 : 7">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                #numberInput
                (blur)="onLostFocus($event.currentTarget.value)"
                (keyup.enter)="onLostFocus($event.currentTarget.value)"
                [value]="counter"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
        <td
          *ngIf="
            property.type === 'Number' &&
            (property.property == 'gridColumns' || property.property == 'gridVerticalStep')
          "
        >
          <div class="apply-button" (click)="applySettings()">
            <label>{{ loc.getP("Apply") }}</label>
          </div>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 1px;
      }
      label {
        margin: 0;
        font-size: 12px;
        font-weight: 500;
        color: var(--text-color);
        white-space: nowrap;
        outline: none;
        overflow: hidden;
        scroll-behavior: smooth;
      }
      .apply-button {
        height: 24px;
        width: 100%;
        min-width: 60px;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 3px;
      }
      .apply-button:hover {
        background-color: var(--active-color);
      }
      .value:hover {
        cursor: text;
      }
      .image-upload > input {
        display: none;
      }
      .number-box {
        width: 100%;
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        background-color: var(--input-color);
        position: relative;
        display: flex;
      }
      .value {
        outline: none;
        width: 100%;
        height: 100%;
      }
      .value input {
        outline: none;
        background-color: var(--input-color);
        -moz-appearance: textfield;
        color: var(--text-color);
        border: 0px;
      }
      .value input[type="number"]::-webkit-inner-spin-button,
      .value input[type="number"]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
        opacity: 0;
      }

      .value:after {
        content: "";
        position: absolute;
        right: 22px;
        z-index: 100;
        top: 2px;
        width: 1px;
        height: 18px;
        background-color: var(--inputBorder-color);
      }
      .buttons {
        width: 22px;
        height: 100%;
        align-self: flex-end;
        display: flex;
        flex-direction: column;

        color: rgb(186, 185, 184);
      }
      .button-up {
        width: 22px;
        position: relative;
        height: 11px;
        border-bottom: 1px solid var(--inputBorder-color);
        text-align: center;
      }
      .button-up:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-up:active {
        background-color: rgb(195, 195, 195);
      }
      .button-down {
        width: 22px;
        position: relative;
        height: 11px;
        text-align: center;
      }
      .button-down:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-down:active {
        background-color: rgb(195, 195, 195);
      }
      i {
        position: absolute;
        left: 5px;
        height: 8px;
        width: 10px;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: StiRectangleGeometryLayout }], propDecorators: { numberInput: [{
                type: ViewChild,
                args: ["numberInput"]
            }], property: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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