import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../../../../directives/sti-input-text.directive";
export class StiNameEditorComponent {
    constructor(model) {
        this.model = model;
        this.hasName = false;
        this.required = false;
    }
    get name() {
        return (this.model.selectedComponent?.element[this.property.property] ?? (this.model.selectedPage ? this.model.selectedPage[this.property.property] : ""));
    }
    ngOnInit() { }
    onInput(name) {
        this.hasName = false;
        this.required = false;
        if (name) {
            this.nameEditor.nativeElement?.classList.remove("ng-invalid");
            this.model.form.pages.forEach((page) => {
                if (page.name == name && page != this.model.selectedPage) {
                    this.hasName = true;
                }
                page.allElements.forEach((element) => {
                    if (element.name == name && element != this.model.selectedComponent.element) {
                        this.hasName = true;
                    }
                });
            });
            if (this.hasName == false && this.isValid(name)) {
                if (this.model.selectedPage) {
                    this.model.selectedPage.name = name;
                }
                else {
                    this.model.selectedComponent.element.name = name;
                }
                this.nameEditor.nativeElement?.classList.remove("ng-invalid");
            }
            else {
                this.nameEditor.nativeElement?.classList.add("ng-invalid");
            }
        }
        else {
            this.required = true;
            this.nameEditor.nativeElement?.classList.add("ng-invalid");
        }
    }
    onFocus() {
        this.nameEditor.nativeElement?.classList.add("valid");
    }
    onBlur() {
        this.nameEditor.nativeElement?.classList.remove("valid");
    }
    isValid(name) {
        let valid = true;
        let chars = name.trim().split("");
        let isValid = true;
        chars.forEach((char) => {
            if (!this.isLetterOrDigit(char)) {
                valid = false;
            }
        });
        return valid;
    }
    isLetterOrDigit(char) {
        let numberPattern = new RegExp(/^\d+$/);
        let isNumber = numberPattern.test(char);
        let isDivider = char == "-" || char == "_";
        return char.toLowerCase() != char.toUpperCase() || isNumber || isDivider;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNameEditorComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiNameEditorComponent, selector: "sti-name-editor", inputs: { property: "property" }, viewQueries: [{ propertyName: "nameEditor", first: true, predicate: ["nameEditor"], descendants: true }], ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'nameEditor'">
        <td colspan="7">
          <input
            type="text"
            #nameEditor
            stiInputText
            [ngModel]="name"
            spellcheck="false"
            (input)="onInput($event.target.value)"
            (focus)="onFocus()"
            (blur)="onBlur()"
            [style]="{ width: '100%' }"
          />
          <span style="color: #a80000; vertical-align:middle;" *ngIf="hasName">Name is used.</span>
          <span style="color: #a80000; vertical-align:middle;" *ngIf="required">This field is required.</span>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      input {
        font-size: 12px;
        font-weight: 500;
        padding: 3px 5px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      input {\n        font-size: 12px;\n        font-weight: 500;\n        padding: 3px 5px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n      td {\n        padding: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i4.StiInputTextDirective, selector: "[stiInputText]" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNameEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-name-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'nameEditor'">
        <td colspan="7">
          <input
            type="text"
            #nameEditor
            stiInputText
            [ngModel]="name"
            spellcheck="false"
            (input)="onInput($event.target.value)"
            (focus)="onFocus()"
            (blur)="onBlur()"
            [style]="{ width: '100%' }"
          />
          <span style="color: #a80000; vertical-align:middle;" *ngIf="hasName">Name is used.</span>
          <span style="color: #a80000; vertical-align:middle;" *ngIf="required">This field is required.</span>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      input {
        font-size: 12px;
        font-weight: 500;
        padding: 3px 5px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { property: [{
                type: Input
            }], nameEditor: [{
                type: ViewChild,
                args: ["nameEditor"]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLW5hbWUtZWRpdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvcHJvcGVydHlHcmlkL2VkaXRvcnMvc3RpLW5hbWUtZWRpdG9yL3N0aS1uYW1lLWVkaXRvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFjLEtBQUssRUFBVSxTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7Ozs7OztBQTRDaEYsTUFBTSxPQUFPLHNCQUFzQjtJQUdqQyxZQUFtQixLQUFzQjtRQUF0QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUNsQyxZQUFPLEdBQVksS0FBSyxDQUFDO1FBQ3pCLGFBQVEsR0FBWSxLQUFLLENBQUM7SUFGWSxDQUFDO0lBRzlDLElBQVcsSUFBSTtRQUNiLE9BQU8sQ0FDTCxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUNsSixDQUFDO0lBQ0osQ0FBQztJQUNELFFBQVEsS0FBVyxDQUFDO0lBQ3BCLE9BQU8sQ0FBQyxJQUFZO1FBQ2xCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1FBQ3JCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO1FBQ3RCLElBQUksSUFBSSxFQUFFLENBQUM7WUFDVCxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxTQUFTLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQzlELElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtnQkFDckMsSUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEVBQUUsQ0FBQztvQkFDekQsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7Z0JBQ3RCLENBQUM7Z0JBQ0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxPQUFPLEVBQUUsRUFBRTtvQkFDbkMsSUFBSSxPQUFPLENBQUMsSUFBSSxJQUFJLElBQUksSUFBSSxPQUFPLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQzt3QkFDNUUsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7b0JBQ3RCLENBQUM7Z0JBQ0gsQ0FBQyxDQUFDLENBQUM7WUFDTCxDQUFDLENBQUMsQ0FBQztZQUNILElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxLQUFLLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO2dCQUNoRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7b0JBQzVCLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7Z0JBQ3RDLENBQUM7cUJBQU0sQ0FBQztvQkFDTixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO2dCQUNuRCxDQUFDO2dCQUNELElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxFQUFFLFNBQVMsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDaEUsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxFQUFFLFNBQVMsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDN0QsQ0FBQztRQUNILENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7WUFDckIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUM3RCxDQUFDO0lBQ0gsQ0FBQztJQUNELE9BQU87UUFDTCxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxTQUFTLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxNQUFNO1FBQ0osSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsU0FBUyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsT0FBTyxDQUFDLElBQVk7UUFDbEIsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDbEMsSUFBSSxPQUFPLEdBQUcsSUFBSSxDQUFDO1FBQ25CLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUNyQixJQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO2dCQUNoQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1lBQ2hCLENBQUM7UUFDSCxDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUNELGVBQWUsQ0FBQyxJQUFJO1FBQ2xCLElBQUksYUFBYSxHQUFHLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hDLElBQUksUUFBUSxHQUFHLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDeEMsSUFBSSxTQUFTLEdBQUcsSUFBSSxJQUFJLEdBQUcsSUFBSSxJQUFJLElBQUksR0FBRyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxRQUFRLElBQUksU0FBUyxDQUFDO0lBQzNFLENBQUM7K0dBaEVVLHNCQUFzQjttR0FBdEIsc0JBQXNCLG1NQXRDdkI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW9DVDs7NEZBRVUsc0JBQXNCO2tCQXhDbEMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsaUJBQWlCO29CQUMzQixRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW9DVDtpQkFDRjtvRkFFVSxRQUFRO3NCQUFoQixLQUFLO2dCQUNtQixVQUFVO3NCQUFsQyxTQUFTO3VCQUFDLFlBQVkiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEVsZW1lbnRSZWYsIElucHV0LCBPbkluaXQsIFZpZXdDaGlsZCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRvclByb3BlcnR5IH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL29iamVjdHNcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1uYW1lLWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgPHRyICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ25hbWVFZGl0b3InXCI+XHJcbiAgICAgICAgPHRkIGNvbHNwYW49XCI3XCI+XHJcbiAgICAgICAgICA8aW5wdXRcclxuICAgICAgICAgICAgdHlwZT1cInRleHRcIlxyXG4gICAgICAgICAgICAjbmFtZUVkaXRvclxyXG4gICAgICAgICAgICBzdGlJbnB1dFRleHRcclxuICAgICAgICAgICAgW25nTW9kZWxdPVwibmFtZVwiXHJcbiAgICAgICAgICAgIHNwZWxsY2hlY2s9XCJmYWxzZVwiXHJcbiAgICAgICAgICAgIChpbnB1dCk9XCJvbklucHV0KCRldmVudC50YXJnZXQudmFsdWUpXCJcclxuICAgICAgICAgICAgKGZvY3VzKT1cIm9uRm9jdXMoKVwiXHJcbiAgICAgICAgICAgIChibHVyKT1cIm9uQmx1cigpXCJcclxuICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICcxMDAlJyB9XCJcclxuICAgICAgICAgIC8+XHJcbiAgICAgICAgICA8c3BhbiBzdHlsZT1cImNvbG9yOiAjYTgwMDAwOyB2ZXJ0aWNhbC1hbGlnbjptaWRkbGU7XCIgKm5nSWY9XCJoYXNOYW1lXCI+TmFtZSBpcyB1c2VkLjwvc3Bhbj5cclxuICAgICAgICAgIDxzcGFuIHN0eWxlPVwiY29sb3I6ICNhODAwMDA7IHZlcnRpY2FsLWFsaWduOm1pZGRsZTtcIiAqbmdJZj1cInJlcXVpcmVkXCI+VGhpcyBmaWVsZCBpcyByZXF1aXJlZC48L3NwYW4+XHJcbiAgICAgICAgPC90ZD5cclxuICAgICAgPC90cj5cclxuXHJcbiAgICAgIDx0cj48L3RyPlxyXG4gICAgPC90YWJsZT5cclxuXHJcbiAgICA8c3R5bGU+XHJcbiAgICAgIGlucHV0IHtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IDUwMDtcclxuICAgICAgICBwYWRkaW5nOiAzcHggNXB4O1xyXG4gICAgICB9XHJcbiAgICAgIC52YWxpZCB7XHJcbiAgICAgICAgYm9yZGVyLWNvbG9yOiByZ2IoMCwgMTI4LCAwKTtcclxuICAgICAgfVxyXG4gICAgICB0ZCB7XHJcbiAgICAgICAgcGFkZGluZzogMDtcclxuICAgICAgfVxyXG4gICAgPC9zdHlsZT5cclxuICBgLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpTmFtZUVkaXRvckNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgQElucHV0KCkgcHJvcGVydHk6IFN0aUVkaXRvclByb3BlcnR5O1xyXG4gIEBWaWV3Q2hpbGQoXCJuYW1lRWRpdG9yXCIpIG5hbWVFZGl0b3I6IEVsZW1lbnRSZWY7XHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHsgfVxyXG4gIHB1YmxpYyBoYXNOYW1lOiBib29sZWFuID0gZmFsc2U7XHJcbiAgcHVibGljIHJlcXVpcmVkOiBib29sZWFuID0gZmFsc2U7XHJcbiAgcHVibGljIGdldCBuYW1lKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gKFxyXG4gICAgICB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50W3RoaXMucHJvcGVydHkucHJvcGVydHldID8/ICh0aGlzLm1vZGVsLnNlbGVjdGVkUGFnZSA/IHRoaXMubW9kZWwuc2VsZWN0ZWRQYWdlW3RoaXMucHJvcGVydHkucHJvcGVydHldIDogXCJcIilcclxuICAgICk7XHJcbiAgfVxyXG4gIG5nT25Jbml0KCk6IHZvaWQgeyB9XHJcbiAgb25JbnB1dChuYW1lOiBzdHJpbmcpIHtcclxuICAgIHRoaXMuaGFzTmFtZSA9IGZhbHNlO1xyXG4gICAgdGhpcy5yZXF1aXJlZCA9IGZhbHNlO1xyXG4gICAgaWYgKG5hbWUpIHtcclxuICAgICAgdGhpcy5uYW1lRWRpdG9yLm5hdGl2ZUVsZW1lbnQ/LmNsYXNzTGlzdC5yZW1vdmUoXCJuZy1pbnZhbGlkXCIpO1xyXG4gICAgICB0aGlzLm1vZGVsLmZvcm0ucGFnZXMuZm9yRWFjaCgocGFnZSkgPT4ge1xyXG4gICAgICAgIGlmIChwYWdlLm5hbWUgPT0gbmFtZSAmJiBwYWdlICE9IHRoaXMubW9kZWwuc2VsZWN0ZWRQYWdlKSB7XHJcbiAgICAgICAgICB0aGlzLmhhc05hbWUgPSB0cnVlO1xyXG4gICAgICAgIH1cclxuICAgICAgICBwYWdlLmFsbEVsZW1lbnRzLmZvckVhY2goKGVsZW1lbnQpID0+IHtcclxuICAgICAgICAgIGlmIChlbGVtZW50Lm5hbWUgPT0gbmFtZSAmJiBlbGVtZW50ICE9IHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQuZWxlbWVudCkge1xyXG4gICAgICAgICAgICB0aGlzLmhhc05hbWUgPSB0cnVlO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgIH0pO1xyXG4gICAgICB9KTtcclxuICAgICAgaWYgKHRoaXMuaGFzTmFtZSA9PSBmYWxzZSAmJiB0aGlzLmlzVmFsaWQobmFtZSkpIHtcclxuICAgICAgICBpZiAodGhpcy5tb2RlbC5zZWxlY3RlZFBhZ2UpIHtcclxuICAgICAgICAgIHRoaXMubW9kZWwuc2VsZWN0ZWRQYWdlLm5hbWUgPSBuYW1lO1xyXG4gICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50LmVsZW1lbnQubmFtZSA9IG5hbWU7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIHRoaXMubmFtZUVkaXRvci5uYXRpdmVFbGVtZW50Py5jbGFzc0xpc3QucmVtb3ZlKFwibmctaW52YWxpZFwiKTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLm5hbWVFZGl0b3IubmF0aXZlRWxlbWVudD8uY2xhc3NMaXN0LmFkZChcIm5nLWludmFsaWRcIik7XHJcbiAgICAgIH1cclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMucmVxdWlyZWQgPSB0cnVlO1xyXG4gICAgICB0aGlzLm5hbWVFZGl0b3IubmF0aXZlRWxlbWVudD8uY2xhc3NMaXN0LmFkZChcIm5nLWludmFsaWRcIik7XHJcbiAgICB9XHJcbiAgfVxyXG4gIG9uRm9jdXMoKSB7XHJcbiAgICB0aGlzLm5hbWVFZGl0b3IubmF0aXZlRWxlbWVudD8uY2xhc3NMaXN0LmFkZChcInZhbGlkXCIpO1xyXG4gIH1cclxuICBvbkJsdXIoKSB7XHJcbiAgICB0aGlzLm5hbWVFZGl0b3IubmF0aXZlRWxlbWVudD8uY2xhc3NMaXN0LnJlbW92ZShcInZhbGlkXCIpO1xyXG4gIH1cclxuICBpc1ZhbGlkKG5hbWU6IHN0cmluZyk6IGJvb2xlYW4ge1xyXG4gICAgbGV0IHZhbGlkID0gdHJ1ZTtcclxuICAgIGxldCBjaGFycyA9IG5hbWUudHJpbSgpLnNwbGl0KFwiXCIpO1xyXG4gICAgbGV0IGlzVmFsaWQgPSB0cnVlO1xyXG4gICAgY2hhcnMuZm9yRWFjaCgoY2hhcikgPT4ge1xyXG4gICAgICBpZiAoIXRoaXMuaXNMZXR0ZXJPckRpZ2l0KGNoYXIpKSB7XHJcbiAgICAgICAgdmFsaWQgPSBmYWxzZTtcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gdmFsaWQ7XHJcbiAgfVxyXG4gIGlzTGV0dGVyT3JEaWdpdChjaGFyKTogYm9vbGVhbiB7XHJcbiAgICBsZXQgbnVtYmVyUGF0dGVybiA9IG5ldyBSZWdFeHAoL15cXGQrJC8pO1xyXG4gICAgbGV0IGlzTnVtYmVyID0gbnVtYmVyUGF0dGVybi50ZXN0KGNoYXIpO1xyXG4gICAgbGV0IGlzRGl2aWRlciA9IGNoYXIgPT0gXCItXCIgfHwgY2hhciA9PSBcIl9cIjtcclxuICAgIHJldHVybiBjaGFyLnRvTG93ZXJDYXNlKCkgIT0gY2hhci50b1VwcGVyQ2FzZSgpIHx8IGlzTnVtYmVyIHx8IGlzRGl2aWRlcjtcclxuICB9XHJcbn1cclxuIl19