import { Component, Input } from "@angular/core";
import { UsedFont } from "../../../../services/objects";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "../../../../services/sti-color-dialog.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-dropdown-editor/sti-dropdown-editor.component";
import * as i8 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i9 from "../../../sti-select-button/sti-select-button.component";
export class StiFontEditorComponent {
    constructor(model, helper, theme, loc, colorService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.colorService = colorService;
    }
    ngOnInit() { }
    showColorPicker(element, object) {
        this.colorService.openDialog(element, object);
    }
    isSettings() {
        return !this.model.selectedComponent && !this.model.selectedPage;
    }
    get content() {
        return this.helper.getProperty(this.object ?? this.model.form.settings, this.property.property);
    }
    changeEvent() {
        if (this.content.eFont) {
            let currentChangableFont = new UsedFont(this.content.eFont.family, this.model.arrayOfStylesToString(this.content.eFont.style), this.content.eFont.size);
            this.model.form.formEvents.next({ name: "UpdateFonts", value: currentChangableFont });
        }
        else {
            let currentChangableFont = new UsedFont(this.content.family ? this.content.family : this.content.font.family, this.model.arrayOfStylesToString(this.content.style ? this.content.style : this.content.font.style), this.content.size ? this.content.size : this.content.font.size);
            this.model.form.formEvents.next({ name: "UpdateFonts", value: currentChangableFont });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFontEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: i5.StiColorDialogService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFontEditorComponent, selector: "sti-font-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `<table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.font.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontFamilyTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.font.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontSizeTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.font.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.get2('HelpDesigner', 'FontName')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.getP('FontSize')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr *ngIf="property.property == 'innerText' && (content.eValue?.length > 0 || isSettings())">
        <td colspan="7">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, content.color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="content.color.toHtmlColor()"></span>
              <span class="color-value">{{ content.color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>`, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      .custom-color-picker {\n        width: 100%;\n        background-color: var(--input-color);\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        position: relative;\n        border-radius: 3px;\n      }\n      .custom-color-picker:hover {\n        background-color: var(--hover-color);\n      }\n      .custom-color-picker:focus {\n        background-color: var(--input-color);\n      }\n      .preview {\n        display: flex;\n        position: relative;\n        width: 100%;\n        height: 100%;\n      }\n      .pick {\n        position: absolute;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 22px;\n      }\n      .color-value {\n        font-weight: 500;\n        font-size: 12px;\n        align-self: center;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .custom-color-preview {\n        width: 24px;\n        height: 14px;\n        margin: 4px;\n        background-color: black;\n        border: 1px solid var(--inputBorder-color);\n      }\n      .select-button {\n        float: right;\n        margin-left: auto;\n        margin-right: 5px;\n        color: rgb(186, 185, 184);\n        display: flex;\n        align-items: center;\n      }\n      .i {\n        height: 12px;\n        width: 12px;\n        right: 3px;\n      }\n    "], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }, { kind: "directive", type: i8.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i9.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFontEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-font-editor",
                    template: `<table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.font.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontFamilyTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.font.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontSizeTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.font.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.get2('HelpDesigner', 'FontName')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.getP('FontSize')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr *ngIf="property.property == 'innerText' && (content.eValue?.length > 0 || isSettings())">
        <td colspan="7">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, content.color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="content.color.toHtmlColor()"></span>
              <span class="color-value">{{ content.color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>`,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: i5.StiColorDialogService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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