import { Component, Input } from "@angular/core";
import { StiFormElement } from "../../../../elements/base/StiFormElement";
import { StiFormSettings } from "../../../../elements/settings/StiFormSettings";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/sti-localization.service";
import * as i4 from "../../../../services/sti-color-dialog.service";
import * as i5 from "../../../sti-tooltip/sti-tooltip.directive";
//import Color from "../../../system/Color";
export class StiColorEditorComponent {
    showColorPicker(element, object) {
        this.colorService.openDialog(element, object);
    }
    constructor(model, helper, loc, colorService) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.colorService = colorService;
    }
    ngOnInit() { }
    get color() {
        if (this.obj instanceof StiFormElement || this.obj instanceof StiFormSettings) {
            return this.helper.getProperty(this.obj, this.property.property);
        }
        else {
            return this.obj[this.property.property];
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i4.StiColorDialogService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiColorEditorComponent, selector: "sti-color-editor", inputs: { property: "property", textColor: "textColor", obj: "obj" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="color.toHtmlColor()"> </span>
              <span class="color-value">{{ color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      .custom-color-picker {\n        width: 100%;\n        background-color: var(--input-color);\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        position: relative;\n        border-radius: 3px;\n      }\n      .custom-color-picker:hover {\n        background-color: var(--hover-color);\n      }\n      .custom-color-picker:focus {\n        background-color: var(--input-color);\n      }\n      .preview {\n        display: flex;\n        position: relative;\n        width: 100%;\n        height: 100%;\n      }\n      .pick {\n        position: absolute;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 22px;\n      }\n      .color-value {\n        font-weight: 500;\n        font-size: 12px;\n        align-self: center;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .custom-color-preview {\n        width: 24px;\n        height: 14px;\n        margin: 4px;\n        background-color: black;\n        border: 1px solid var(--inputBorder-color);\n      }\n      .select-button {\n        float: right;\n        margin-left: auto;\n        margin-right: 5px;\n        color: rgb(186, 185, 184);\n        display: flex;\n        align-items: center;\n      }\n      .i {\n        height: 12px;\n        width: 12px;\n        right: 3px;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-color-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="color.toHtmlColor()"> </span>
              <span class="color-value">{{ color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i4.StiColorDialogService }], propDecorators: { property: [{
                type: Input
            }], textColor: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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