import { Component, Input } from "@angular/core";
import { RotateAnimation, SlideInOutAnimation } from "../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../table/table-border-editor/table-border-editor.component";
import * as i7 from "../sti-barcode-shape-editor/sti-barcode-shape-editor.component";
export class StiBooleanWithArrowEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
    }
    ngOnInit() {
        this._state = this.model.selectedComponent.element[this.property.property] == true ? "rotated" : "default";
    }
    get isBarcodeShape() {
        return this.property.property == "showBodyBrushEditor" ||
            this.property.property == "showEyeBallBrushEditor" ||
            this.property.property == "showEyeFrameBrushEditor"
            ? true
            : false;
    }
    get content() {
        if (!this.isBarcodeShape) {
            return this.property.property == "showGridLinesEditor"
                ? this.loc.get2("Chart", "GridLines")
                : this.loc.getP("Border");
        }
        else {
            if (this.property.property == "showBodyBrushEditor") {
                return this.loc.getP("BodyBrush");
            }
            else if (this.property.property == "showEyeBallBrushEditor") {
                return this.loc.getP("EyeBallBrush");
            }
            else {
                return this.loc.getP("EyeFrameBrush");
            }
        }
    }
    getObject() {
        if (this.property.property == "showGridLinesEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "gridLines");
        }
        else if (this.property.property == "showBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "border");
        }
        else if (this.property.property == "showColumnsBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "columnHeadersBorder");
        }
        else if (this.property.property == "showRowsBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "rowHeadersBorder");
        }
        else {
            return this.model.selectedComponent?.element;
        }
    }
    get state() {
        return this._state;
    }
    set state(value) {
        this._state = value;
    }
    changeState() {
        this.model.selectedComponent.element[this.property.property] =
            !this.model.selectedComponent.element[this.property.property];
        this.state = this.state == "default" ? "rotated" : "default";
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBooleanWithArrowEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiBooleanWithArrowEditorComponent, selector: "boolean-with-arrow-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7">
          <div class="boolean-button" (click)="changeState()">
            <div class="arrow" [@rotatedState]="state">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">{{ content }}</div>
          </div>
          <sti-table-border-editor
            *ngIf="!isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-table-border-editor>
          <sti-barcode-shape-editor
            *ngIf="isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-barcode-shape-editor>
        </td>
      </tr>
    </table>
    <style>
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }

      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }
    </style>
  `, isInline: true, styles: ["\n      i {\n        width: 10px;\n        height: 10px;\n      }\n      .arrow {\n        width: 20px;\n        text-align: center;\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n\n      .content {\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .boolean-button {\n        width: 100%;\n        height: 22px;\n        display: flex;\n        flex-direction: row;\n        color: var(--text-color);\n        background-color: var(--hover-color);\n        border-top: 2px solid var(--toolbarResizerBorder-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: ["property", "state", "object"] }, { kind: "component", type: i7.StiBarcodeShapeEditorComponent, selector: "sti-barcode-shape-editor", inputs: ["property", "state", "object"] }], animations: [RotateAnimation, SlideInOutAnimation] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBooleanWithArrowEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "boolean-with-arrow-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7">
          <div class="boolean-button" (click)="changeState()">
            <div class="arrow" [@rotatedState]="state">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">{{ content }}</div>
          </div>
          <sti-table-border-editor
            *ngIf="!isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-table-border-editor>
          <sti-barcode-shape-editor
            *ngIf="isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-barcode-shape-editor>
        </td>
      </tr>
    </table>
    <style>
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }

      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }
    </style>
  `,
                    animations: [RotateAnimation, SlideInOutAnimation],
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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