import { Component } from "@angular/core";
import { StiAddressElement } from "../../../elements/StiAddressElement";
import { StiBarcodeElement } from "../../../elements/StiBarcodeElement";
import { StiButtonElement } from "../../../elements/StiButtonElement";
import { StiCheckBoxElement } from "../../../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../../../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../../../elements/StiDateTimeBoxElement";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import { StiImageElement } from "../../../elements/StiImageElement";
import { StiLabelElement } from "../../../elements/StiLabelElement";
import StiLineElement from "../../../elements/StiLineElement";
import { StiListBoxElement } from "../../../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../../../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../../../elements/StiNumberBoxElement";
import { StiPDFSignatureElement } from "../../../elements/StiPDFSignatureElement";
import { StiPanelElement } from "../../../elements/StiPanelElement";
import { StiSignatureElement } from "../../../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../../../elements/StiSingleSelectionElement";
import { StiTableElement } from "../../../elements/StiTableElement";
import { StiTextBoxElement } from "../../../elements/StiTextBoxElement";
import { StiTextElement } from "../../../elements/StiTextElement";
import { StiLocalizationService } from "../../../services/sti-localization.service";
import StiAddressCreator from "../creators/StiAddressCreator";
import StiBarcodeCreator from "../creators/StiBarcodeCreator";
import StiButtonCreator from "../creators/StiButtonCreator";
import StiCheckBoxCreator from "../creators/StiCheckBoxCreator";
import StiComboBoxCreator from "../creators/StiComboBoxCreator";
import StiDateTimeBoxCreator from "../creators/StiDateTimeBoxCreator";
import StiFormPageCreator from "../creators/StiFormPageCreator";
import StiImageCreator from "../creators/StiImageCreator";
import StiLabelCreator from "../creators/StiLabelCreator";
import StiLineCreator from "../creators/StiLineCreator";
import StiListBoxCreator from "../creators/StiListBoxCreator";
import StiMultipleSelectionCreator from "../creators/StiMultipleSelectionCreator";
import StiNumberBoxCreator from "../creators/StiNumberBoxEditor";
import StiPDFSignatureCreator from "../creators/StiPDFSignatureCreator";
import StiPanelCreator from "../creators/StiPanelCreator";
import StiSettingsCreator from "../creators/StiSettingsCreator";
import StiSignatureCreator from "../creators/StiSignatureCreator";
import StiSingleSelectionCreator from "../creators/StiSingleSelectionCreator";
import StiTableCreator from "../creators/StiTableCreator";
import StiTextBoxCreator from "../creators/StiTextBoxCreator";
import StiTextCreator from "../creators/StiTextCreator";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-helper.service";
import * as i3 from "../../../services/sti-localization.service";
import * as i4 from "@angular/common";
import * as i5 from "../../propertyGrid/editors/sti-bool-editor/sti-bool-editor.component";
import * as i6 from "../../propertyGrid/editors/sti-color-editor/sti-color-editor.component";
import * as i7 from "../../propertyGrid/editors/sti-enum-editor/sti-enum-editor.component";
import * as i8 from "../../propertyGrid/editors/sti-font-editor/sti-font-editor.component";
import * as i9 from "../../propertyGrid/editors/sti-image-editor/sti-image-editor.component";
import * as i10 from "../../propertyGrid/editors/sti-padding-editor/sti-padding-editor.component";
import * as i11 from "../../propertyGrid/editors/sti-multiline-string-editor/sti-multiline-string-editor.component";
import * as i12 from "../../propertyGrid/editors/sti-number-editor/sti-number-editor.component";
import * as i13 from "../../propertyGrid/editors/sti-paper-kind-editor/sti-paper-kind-editor.component";
import * as i14 from "../../propertyGrid/editors/sti-vertical-alignment-editor/sti-vertical-alignment-editor";
import * as i15 from "../../propertyGrid/editors/sti-text-editor/sti-text-editor.component";
import * as i16 from "../../propertyGrid/editors/sti-name-editor/sti-name-editor";
import * as i17 from "../../propertyGrid/editors/sti-horizontal-alignment-editor/sti-horizontal-alignment-editor";
import * as i18 from "../../propertyGrid/editors/sti-label-alignment-editor/sti-label-alignment-editor";
import * as i19 from "../../propertyGrid/editors/boolean-with-arrow-editor/boolean-with-arrow-editor.component";
import * as i20 from "../../propertyGrid/editors/table/table-item-editor/table-item-editor.component";
import * as i21 from "../../propertyGrid/editors/table/table-border-editor/table-border-editor.component";
import * as i22 from "../../propertyGrid/editors/table/table-columns-editor/table-columns-editor.component";
import * as i23 from "../../propertyGrid/editors/sti-exceed-margins/sti-exceed-margins.component";
import * as i24 from "../../propertyGrid/editors/sti-select-button-editor.component";
import * as i25 from "../../propertyGrid/editors/sti-barcode-style-editor/sti-barcode-style-editor.component";
import * as i26 from "../../propertyGrid/editors/sti-simple-enum-editor/sti-simple-enum-editor.component";
import * as i27 from "../../propertyGrid/editors/table/table-navigation/table-navigation.component";
import * as i28 from "../../propertyGrid/editors/sti-component-height-editor/sti-component-height-editor.component";
import * as i29 from "../../propertyGrid/editors/auto-complete-editor/auto-complete-editor.component";
import * as i30 from "../../sti-divider/sti-divider.component";
import * as i31 from "../sti-forms-elements-dropdown/sti-forms-elements-dropdown.component";
export class StiPropertyGridComponent {
    get isTable() {
        return this.model?.selectedComponent?.element instanceof StiTableElement ? true : false;
    }
    get object() {
        if (this.model.selectedComponent) {
            return this.model.selectedComponent.element;
        }
        else if (this.model.selectedPage) {
            return this.model.selectedPage;
        }
        else {
            return this.model.form.settings;
        }
    }
    hasValue(property) {
        if ((property?.includes("label") || property?.includes("description")) &&
            !property?.includes("value") &&
            this.object != this.model.form.settings) {
            if (property.includes("label")) {
                let value = this.helper.getProperty(this.object, "label.value");
                if (value) {
                    return true;
                }
                else
                    return false;
            }
            else {
                if (this.object instanceof StiAddressElement) {
                    return true;
                }
                let value = this.helper.getProperty(this.object, "description.value");
                if (value) {
                    return true;
                }
                else
                    return false;
            }
        }
        else {
            return true;
        }
    }
    constructor(model, helper, loc) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.isDrag = false;
        this.properties = [];
    }
    ngOnDestroy() {
        this.refreshSubscription?.unsubscribe();
        this.refreshFromLocalizationSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.refreshSubscription = this.model.needToRefresh.subscribe(() => this.updateProperties());
        this.refreshFromLocalizationSubscription = StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateProperties();
        });
    }
    needToDisable(property) {
        if (this.object instanceof StiSingleSelectionElement || this.object instanceof StiMultipleSelectionElement) {
            if (this.object.prefix.length > 0 && property.property == "suffix") {
                return true;
            }
            else if (this.object.suffix.length > 0 && property.property == "prefix") {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    back() {
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            this.model.selectedComponent.element.showHeaderEditor = false;
            this.model.selectedComponent.element.showColumnsEditor = false;
            this.model.selectedComponent.element.showRowsEditor = false;
            this.model.selectedComponent.element.showTotalsEditor = false;
            this.model.needToRefresh.next(true);
        }
    }
    checkTableProperties() {
        if (this.model.selectedComponent?.element instanceof StiTableElement) {
            let tableJson = (this.model.selectedComponent?.element).saveToJsonObject({}).serialize();
            if (tableJson != this.savedTableJson) {
                this.savedTableJson = tableJson;
                this.model.form.formEvents.next({ name: "ValueChanged" });
            }
            setTimeout(() => {
                this.checkTableProperties();
            }, 500);
        }
        else {
            this.savedTableJson = null;
        }
    }
    updateProperties() {
        this.properties = [];
        this.checkTableProperties();
        if (this.model.selectedComponent?.element instanceof StiCheckBoxElement) {
            StiCheckBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTextBoxElement) {
            StiTextBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiNumberBoxElement) {
            StiNumberBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiComboBoxElement) {
            StiComboBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiListBoxElement) {
            StiListBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiSingleSelectionElement) {
            StiSingleSelectionCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiMultipleSelectionElement) {
            StiMultipleSelectionCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiLineElement) {
            StiLineCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiSignatureElement) {
            StiSignatureCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiPDFSignatureElement) {
            StiPDFSignatureCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiPanelElement) {
            StiPanelCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiDateTimeBoxElement) {
            StiDateTimeBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTableElement) {
            StiTableCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element, this.model);
        }
        else if (this.model.selectedComponent?.element instanceof StiImageElement) {
            StiImageCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiButtonElement) {
            StiButtonCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiBarcodeElement) {
            StiBarcodeCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTextElement) {
            StiTextCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiLabelElement) {
            StiLabelCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiAddressElement) {
            StiAddressCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedPage instanceof StiFormPageElement) {
            StiFormPageCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedPage == null && this.model.selectedComponent == null && this.model.form) {
            StiSettingsCreator.createPropertyEditors(this.properties, this.model.form.settings);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPropertyGridComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPropertyGridComponent, selector: "property-grid", ngImport: i0, template: ` <div style="width: 100%;">
    <!--   <span *ngIf="this.model.selectedComponent">{{
      loc.get2(
        helper.getLocalizationCategory(model.selectedComponent?.element.type),
        helper.getLocalizationKey(model.selectedComponent?.element.type)
      )
    }}</span>
    <span *ngIf="this.model.selectedPage">{{
      loc.get2("Components", helper.getLocalizationKey(model.selectedPage?.type))
    }}</span>
    <span *ngIf="model.selectedComponent == null && model.selectedPage == null">{{ loc.getP("FormSettings") }}</span> -->
    <sti-form-elements-dropdown></sti-form-elements-dropdown>
    <table class="sti-clear p-component property-grid">
      <tr *ngFor="let property of properties">
        <td
          *ngIf="
            property.type != 'BooleanWithArrowEditor' &&
            property.type != 'TableColumnsEditor' &&
            property.type != 'tableNavigations' &&
            hasValue(property.property)
          "
          [colSpan]="property.type != 'divider' && property.type != 'defaultLabel' ? 1 : 2"
          [style]="{
            padding: property.type != 'divider' && property.type != 'defaultLabel' ? '5px 0px 0px 5px' : '0px',
            verticalAlign: 'top'
          }"
        >
          <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          <span *ngIf="property.type === 'defaultLabel'">{{ loc.getP("DefaultSettings") }}</span>
          <div class="label" *ngIf="property.label">
            {{ property.label.replace(":", "") }}
          </div>
        </td>
        <td
          *ngIf="property.type != 'divider' && hasValue(property.property)"
          [colSpan]="
            property.type == 'BooleanWithArrowEditor' ||
            property.type == 'TableColumnsEditor' ||
            property.type == 'tableNavigations'
              ? 8
              : ''
          "
          [style]="{ width: '100%', padding: '0px 2px 0 px 2 px' }"
        >
          <table-navigation *ngIf="property.type === 'tableNavigations'" [style]="{ width: '100%' }"></table-navigation>
          <auto-complete-editor
            [property]="property"
            [obj]="object"
            *ngIf="property.type === 'autoCompleteEditor'"
            [style]="{ width: '95%' }"
          ></auto-complete-editor>
          <sti-bool-editor
            [property]="property"
            *ngIf="property.type === 'checkbox'"
            [style]="{ width: '95%' }"
            [object]="object"
          ></sti-bool-editor>
          <sti-name-editor
            *ngIf="property.type === 'nameEditor'"
            [property]="property"
            [style]="{ width: '95%' }"
          ></sti-name-editor>
          <sti-color-editor
            *ngIf="property.type === 'color'"
            [property]="property"
            [obj]="object"
            [style]="{ width: '95%' }"
          ></sti-color-editor>
          <sti-horizontal-alignment-editor
            [property]="property"
            *ngIf="property.type === 'horizontalAlignment'"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-horizontal-alignment-editor>
          <sti-vertical-alignment-editor
            [property]="property"
            *ngIf="property.type === 'verticalAlignment'"
            [style]="{ width: '95%' }"
          ></sti-vertical-alignment-editor>
          <sti-component-height-editor
            [property]="property"
            *ngIf="property.type === 'componentHeight'"
            [style]="{ width: '95%' }"
            [element]="object"
          >
          </sti-component-height-editor>
          <sti-label-alignment-editor
            [property]="property"
            *ngIf="property.type === 'labelAlignment'"
            [style]="{ width: '95%' }"
          >
          </sti-label-alignment-editor>
          <sti-enum-editor
            *ngIf="property.type === 'enum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-enum-editor>
          <sti-simple-enum-editor
            *ngIf="property.type === 'simpleEnum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-simple-enum-editor>
          <sti-font-editor
            *ngIf="property.type === 'FontEditor'"
            [object]="object"
            [property]="property"
          ></sti-font-editor>
          <sti-image-editor
            *ngIf="property.type === 'image'"
            [object]="object"
            [property]="property"
          ></sti-image-editor>
          <sti-initial-value-datetime-box-editor
            *ngIf="property.type === 'customDate'"
            [property]="property"
            [object]="object"
          ></sti-initial-value-datetime-box-editor>
          <sti-barcode-style-editor
            *ngIf="property.type === 'barcodeStyles'"
            [property]="property"
            [element]="object"
          ></sti-barcode-style-editor>
          <sti-padding-editor *ngIf="property.type === 'PaddingEditor'" [property]="property"></sti-padding-editor>
          <sti-multiline-string-editor
            *ngIf="property.type === 'MultilineEditor'"
            [property]="property"
          ></sti-multiline-string-editor>
          <sti-number-editor
            *ngIf="
              property.type === 'NumberEditor' || property.type === 'pageNumberEditor' || property.type === 'Number'
            "
            [property]="property"
            [obj]="object"
          ></sti-number-editor>
          <sti-paper-kind-editor
            *ngIf="property.type === 'paperKind' && this.model.selectedPage"
            [property]="property"
          ></sti-paper-kind-editor>
          <sti-text-editor
            *ngIf="property.type === 'TextEditor'"
            [object]="object"
            [property]="property"
            [disabled]="needToDisable(property)"
          ></sti-text-editor>
          <sti-table-item-editor
            *ngIf="property.type === 'TableItemEditor'"
            [property]="property"
          ></sti-table-item-editor>
          <sti-table-border-editor
            *ngIf="property.type === 'TableBorderEditor'"
            [property]="property"
          ></sti-table-border-editor>
          <boolean-with-arrow-editor
            *ngIf="property.type === 'BooleanWithArrowEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></boolean-with-arrow-editor>
          <sti-table-columns-editor
            *ngIf="property.type === 'TableColumnsEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></sti-table-columns-editor>
          <sti-exceed-margins-editor
            *ngIf="property.type === 'ExceedMarginsEditor'"
            [property]="property"
            [object]="object"
            [style]="{ width: '100%' }"
          ></sti-exceed-margins-editor>
          <sti-select-button-editor
            *ngIf="property.type === 'labelFormat' || property.type === 'currencyFormat'"
            [propertyType]="property.type"
            [property]="property.property"
            [object]="object"
            [style.height.px]="24"
            [style.display]="'flex'"
          >
          </sti-select-button-editor>
        </td>
      </tr>
    </table>
  </div>`, isInline: true, styles: [".table-property-header{width:100%;display:flex;margin-bottom:-3px}.table-property-header span{flex:1;display:flex;font-size:13px;justify-content:center;align-items:center;margin:0;font-weight:400;border-bottom:3px solid transparent}.table-property-header span:hover{background-color:var(--hover-color);color:#5579ae}.table-property-header .current{color:#767676;font-weight:600;border-color:var(--text-color);z-index:1}.table-property-header .other{color:var(--text-color)}.property-grid{position:relative}.property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}table{width:100%;font-size:13px;font-weight:600;-webkit-user-select:none}span{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:15px;-webkit-touch-callout:none;-webkit-user-select:none}.label{font-size:13px;font-weight:400;min-width:120px;color:var(--property-label-color);white-space:nowrap;-webkit-touch-callout:none;-webkit-user-select:none}\n"], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i6.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i7.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i8.StiFontEditorComponent, selector: "sti-font-editor", inputs: ["property", "object"] }, { kind: "component", type: i9.StiImageEditorComponent, selector: "sti-image-editor", inputs: ["property", "object"] }, { kind: "component", type: i10.StiPaddingEditorComponent, selector: "sti-padding-editor", inputs: ["property"] }, { kind: "component", type: i11.StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: ["property", "object"] }, { kind: "component", type: i12.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i13.StiPaperKindEditorComponent, selector: "sti-paper-kind-editor", inputs: ["property"] }, { kind: "component", type: i14.StiVerticalAlignmentEditorComponent, selector: "sti-vertical-alignment-editor", inputs: ["property"] }, { kind: "component", type: i15.StiTextEditorComponent, selector: "sti-text-editor", inputs: ["property", "object", "disabled"] }, { kind: "component", type: i16.StiNameEditorComponent, selector: "sti-name-editor", inputs: ["property"] }, { kind: "component", type: i17.StiHorizontalAlignmentEditorComponent, selector: "sti-horizontal-alignment-editor", inputs: ["property", "object"] }, { kind: "component", type: i18.StiLabelAlignmentEditorComponent, selector: "sti-label-alignment-editor", inputs: ["property"] }, { kind: "component", type: i19.StiBooleanWithArrowEditorComponent, selector: "boolean-with-arrow-editor", inputs: ["property"] }, { kind: "component", type: i20.StiTableItemEditorComponent, selector: "sti-table-item-editor", inputs: ["property"] }, { kind: "component", type: i21.StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: ["property", "state", "object"] }, { kind: "component", type: i22.StiTableColumnsEditorComponent, selector: "sti-table-columns-editor", inputs: ["property"] }, { kind: "component", type: i23.StiExceedMarginsEditorComponent, selector: "sti-exceed-margins-editor", inputs: ["property", "object"] }, { kind: "component", type: i24.StiSelectButtonEditorComponent, selector: "sti-select-button-editor", inputs: ["propertyType", "property", "object"] }, { kind: "component", type: i25.StiBarcodeStyleEditorComponent, selector: "sti-barcode-style-editor", inputs: ["property", "element"] }, { kind: "component", type: i26.StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: ["property", "object"] }, { kind: "component", type: i27.TableNavigationComponent, selector: "table-navigation" }, { kind: "component", type: i28.StiComponentHeightEditorComponent, selector: "sti-component-height-editor", inputs: ["property", "element"] }, { kind: "component", type: i29.AutoCompleteEditorComponent, selector: "auto-complete-editor", inputs: ["property", "obj"] }, { kind: "component", type: i30.StiDividerComponent, selector: "sti-divider" }, { kind: "component", type: i31.StiFormElementsDropdownComponent, selector: "sti-form-elements-dropdown" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPropertyGridComponent, decorators: [{
            type: Component,
            args: [{ selector: "property-grid", template: ` <div style="width: 100%;">
    <!--   <span *ngIf="this.model.selectedComponent">{{
      loc.get2(
        helper.getLocalizationCategory(model.selectedComponent?.element.type),
        helper.getLocalizationKey(model.selectedComponent?.element.type)
      )
    }}</span>
    <span *ngIf="this.model.selectedPage">{{
      loc.get2("Components", helper.getLocalizationKey(model.selectedPage?.type))
    }}</span>
    <span *ngIf="model.selectedComponent == null && model.selectedPage == null">{{ loc.getP("FormSettings") }}</span> -->
    <sti-form-elements-dropdown></sti-form-elements-dropdown>
    <table class="sti-clear p-component property-grid">
      <tr *ngFor="let property of properties">
        <td
          *ngIf="
            property.type != 'BooleanWithArrowEditor' &&
            property.type != 'TableColumnsEditor' &&
            property.type != 'tableNavigations' &&
            hasValue(property.property)
          "
          [colSpan]="property.type != 'divider' && property.type != 'defaultLabel' ? 1 : 2"
          [style]="{
            padding: property.type != 'divider' && property.type != 'defaultLabel' ? '5px 0px 0px 5px' : '0px',
            verticalAlign: 'top'
          }"
        >
          <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          <span *ngIf="property.type === 'defaultLabel'">{{ loc.getP("DefaultSettings") }}</span>
          <div class="label" *ngIf="property.label">
            {{ property.label.replace(":", "") }}
          </div>
        </td>
        <td
          *ngIf="property.type != 'divider' && hasValue(property.property)"
          [colSpan]="
            property.type == 'BooleanWithArrowEditor' ||
            property.type == 'TableColumnsEditor' ||
            property.type == 'tableNavigations'
              ? 8
              : ''
          "
          [style]="{ width: '100%', padding: '0px 2px 0 px 2 px' }"
        >
          <table-navigation *ngIf="property.type === 'tableNavigations'" [style]="{ width: '100%' }"></table-navigation>
          <auto-complete-editor
            [property]="property"
            [obj]="object"
            *ngIf="property.type === 'autoCompleteEditor'"
            [style]="{ width: '95%' }"
          ></auto-complete-editor>
          <sti-bool-editor
            [property]="property"
            *ngIf="property.type === 'checkbox'"
            [style]="{ width: '95%' }"
            [object]="object"
          ></sti-bool-editor>
          <sti-name-editor
            *ngIf="property.type === 'nameEditor'"
            [property]="property"
            [style]="{ width: '95%' }"
          ></sti-name-editor>
          <sti-color-editor
            *ngIf="property.type === 'color'"
            [property]="property"
            [obj]="object"
            [style]="{ width: '95%' }"
          ></sti-color-editor>
          <sti-horizontal-alignment-editor
            [property]="property"
            *ngIf="property.type === 'horizontalAlignment'"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-horizontal-alignment-editor>
          <sti-vertical-alignment-editor
            [property]="property"
            *ngIf="property.type === 'verticalAlignment'"
            [style]="{ width: '95%' }"
          ></sti-vertical-alignment-editor>
          <sti-component-height-editor
            [property]="property"
            *ngIf="property.type === 'componentHeight'"
            [style]="{ width: '95%' }"
            [element]="object"
          >
          </sti-component-height-editor>
          <sti-label-alignment-editor
            [property]="property"
            *ngIf="property.type === 'labelAlignment'"
            [style]="{ width: '95%' }"
          >
          </sti-label-alignment-editor>
          <sti-enum-editor
            *ngIf="property.type === 'enum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-enum-editor>
          <sti-simple-enum-editor
            *ngIf="property.type === 'simpleEnum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-simple-enum-editor>
          <sti-font-editor
            *ngIf="property.type === 'FontEditor'"
            [object]="object"
            [property]="property"
          ></sti-font-editor>
          <sti-image-editor
            *ngIf="property.type === 'image'"
            [object]="object"
            [property]="property"
          ></sti-image-editor>
          <sti-initial-value-datetime-box-editor
            *ngIf="property.type === 'customDate'"
            [property]="property"
            [object]="object"
          ></sti-initial-value-datetime-box-editor>
          <sti-barcode-style-editor
            *ngIf="property.type === 'barcodeStyles'"
            [property]="property"
            [element]="object"
          ></sti-barcode-style-editor>
          <sti-padding-editor *ngIf="property.type === 'PaddingEditor'" [property]="property"></sti-padding-editor>
          <sti-multiline-string-editor
            *ngIf="property.type === 'MultilineEditor'"
            [property]="property"
          ></sti-multiline-string-editor>
          <sti-number-editor
            *ngIf="
              property.type === 'NumberEditor' || property.type === 'pageNumberEditor' || property.type === 'Number'
            "
            [property]="property"
            [obj]="object"
          ></sti-number-editor>
          <sti-paper-kind-editor
            *ngIf="property.type === 'paperKind' && this.model.selectedPage"
            [property]="property"
          ></sti-paper-kind-editor>
          <sti-text-editor
            *ngIf="property.type === 'TextEditor'"
            [object]="object"
            [property]="property"
            [disabled]="needToDisable(property)"
          ></sti-text-editor>
          <sti-table-item-editor
            *ngIf="property.type === 'TableItemEditor'"
            [property]="property"
          ></sti-table-item-editor>
          <sti-table-border-editor
            *ngIf="property.type === 'TableBorderEditor'"
            [property]="property"
          ></sti-table-border-editor>
          <boolean-with-arrow-editor
            *ngIf="property.type === 'BooleanWithArrowEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></boolean-with-arrow-editor>
          <sti-table-columns-editor
            *ngIf="property.type === 'TableColumnsEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></sti-table-columns-editor>
          <sti-exceed-margins-editor
            *ngIf="property.type === 'ExceedMarginsEditor'"
            [property]="property"
            [object]="object"
            [style]="{ width: '100%' }"
          ></sti-exceed-margins-editor>
          <sti-select-button-editor
            *ngIf="property.type === 'labelFormat' || property.type === 'currencyFormat'"
            [propertyType]="property.type"
            [property]="property.property"
            [object]="object"
            [style.height.px]="24"
            [style.display]="'flex'"
          >
          </sti-select-button-editor>
        </td>
      </tr>
    </table>
  </div>`, styles: [".table-property-header{width:100%;display:flex;margin-bottom:-3px}.table-property-header span{flex:1;display:flex;font-size:13px;justify-content:center;align-items:center;margin:0;font-weight:400;border-bottom:3px solid transparent}.table-property-header span:hover{background-color:var(--hover-color);color:#5579ae}.table-property-header .current{color:#767676;font-weight:600;border-color:var(--text-color);z-index:1}.table-property-header .other{color:var(--text-color)}.property-grid{position:relative}.property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}table{width:100%;font-size:13px;font-weight:600;-webkit-user-select:none}span{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:15px;-webkit-touch-callout:none;-webkit-user-select:none}.label{font-size:13px;font-weight:400;min-width:120px;color:var(--property-label-color);white-space:nowrap;-webkit-touch-callout:none;-webkit-user-select:none}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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