import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/sti-localization.service";
import * as i2 from "../../../services/model.service";
export class StiPropertyGridNavigationComponent {
    constructor(loc, model) {
        this.loc = loc;
        this.model = model;
    }
    selectMode(mode) {
        if (this.model.currentPropertyGridMode != mode) {
            this.model.currentPropertyGridMode = mode;
            if (mode == "Properties") {
                setTimeout(() => {
                    this.model.needToRefresh.next(true);
                });
            }
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPropertyGridNavigationComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPropertyGridNavigationComponent, selector: "property-grid-navigation", ngImport: i0, template: `<div class="navigation-container">
    <div
      class="button {{ model.currentPropertyGridMode == 'Properties' ? 'selected' : '' }}"
      (click)="selectMode('Properties')"
    >
      <img [src]="model.getImage('images.Other.Properties.png')" />
      <div class="label">
        <span>{{ "Properties" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
    <div class="button {{ model.currentPropertyGridMode == 'Tree' ? 'selected' : '' }}" (click)="selectMode('Tree')">
      <img [src]="model.getImage('images.Other.ReportTree.png')" />
      <div class="label">
        <span>{{ "Form Tree" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
  </div>`, isInline: true, styles: [".navigation-container{display:flex;height:34px;-webkit-user-select:none;align-items:center}.label{display:flex;flex-direction:column}.selected .current-indicator{height:3px;width:100%;background-color:#19478a}.button{font-family:Arial;font-size:12px;min-width:80px;height:26px;border-radius:3px;background-color:transparent;display:flex;align-items:center;margin-right:3px;padding-right:10px}.button:hover{background-color:#dadada;cursor:pointer}.selected{background-color:#e5e5e5}img{height:16px;width:16px;margin:0 6px}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPropertyGridNavigationComponent, decorators: [{
            type: Component,
            args: [{ selector: "property-grid-navigation", template: `<div class="navigation-container">
    <div
      class="button {{ model.currentPropertyGridMode == 'Properties' ? 'selected' : '' }}"
      (click)="selectMode('Properties')"
    >
      <img [src]="model.getImage('images.Other.Properties.png')" />
      <div class="label">
        <span>{{ "Properties" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
    <div class="button {{ model.currentPropertyGridMode == 'Tree' ? 'selected' : '' }}" (click)="selectMode('Tree')">
      <img [src]="model.getImage('images.Other.ReportTree.png')" />
      <div class="label">
        <span>{{ "Form Tree" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
  </div>`, styles: [".navigation-container{display:flex;height:34px;-webkit-user-select:none;align-items:center}.label{display:flex;flex-direction:column}.selected .current-indicator{height:3px;width:100%;background-color:#19478a}.button{font-family:Arial;font-size:12px;min-width:80px;height:26px;border-radius:3px;background-color:transparent;display:flex;align-items:center;margin-right:3px;padding-right:10px}.button:hover{background-color:#dadada;cursor:pointer}.selected{background-color:#e5e5e5}img{height:16px;width:16px;margin:0 6px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXByb3BlcnR5LWdyaWQtbmF2aWdhdGlvbi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9wcm9wZXJ0aWVzLmNvbXBvbmVudC9zdGktcHJvcGVydHktZ3JpZC1uYXZpZ2F0aW9uL3N0aS1wcm9wZXJ0eS1ncmlkLW5hdmlnYXRpb24uY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQVUsTUFBTSxlQUFlLENBQUM7Ozs7QUFxRWxELE1BQU0sT0FBTyxrQ0FBa0M7SUFDN0MsWUFBbUIsR0FBMkIsRUFBUyxLQUFzQjtRQUExRCxRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUFTLFVBQUssR0FBTCxLQUFLLENBQWlCO0lBQUcsQ0FBQztJQUVqRixVQUFVLENBQUMsSUFBWTtRQUNyQixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLElBQUksSUFBSSxFQUFFLENBQUM7WUFDL0MsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUM7WUFDMUMsSUFBSSxJQUFJLElBQUksWUFBWSxFQUFFLENBQUM7Z0JBQ3pCLFVBQVUsQ0FBQyxHQUFHLEVBQUU7b0JBQ2QsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUN0QyxDQUFDLENBQUMsQ0FBQztZQUNMLENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUVELFFBQVEsS0FBSSxDQUFDOytHQWRGLGtDQUFrQzttR0FBbEMsa0NBQWtDLGdFQS9EbkM7Ozs7Ozs7Ozs7Ozs7Ozs7OztTQWtCSDs7NEZBNkNJLGtDQUFrQztrQkFqRTlDLFNBQVM7K0JBQ0UsMEJBQTBCLFlBQzFCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7U0FrQkgiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aUxvY2FsaXphdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vc2VydmljZXMvc3RpLWxvY2FsaXphdGlvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJwcm9wZXJ0eS1ncmlkLW5hdmlnYXRpb25cIixcclxuICB0ZW1wbGF0ZTogYDxkaXYgY2xhc3M9XCJuYXZpZ2F0aW9uLWNvbnRhaW5lclwiPlxyXG4gICAgPGRpdlxyXG4gICAgICBjbGFzcz1cImJ1dHRvbiB7eyBtb2RlbC5jdXJyZW50UHJvcGVydHlHcmlkTW9kZSA9PSAnUHJvcGVydGllcycgPyAnc2VsZWN0ZWQnIDogJycgfX1cIlxyXG4gICAgICAoY2xpY2spPVwic2VsZWN0TW9kZSgnUHJvcGVydGllcycpXCJcclxuICAgID5cclxuICAgICAgPGltZyBbc3JjXT1cIm1vZGVsLmdldEltYWdlKCdpbWFnZXMuT3RoZXIuUHJvcGVydGllcy5wbmcnKVwiIC8+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJsYWJlbFwiPlxyXG4gICAgICAgIDxzcGFuPnt7IFwiUHJvcGVydGllc1wiIH19PC9zcGFuPlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJjdXJyZW50LWluZGljYXRvclwiPjwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgIDwvZGl2PlxyXG4gICAgPGRpdiBjbGFzcz1cImJ1dHRvbiB7eyBtb2RlbC5jdXJyZW50UHJvcGVydHlHcmlkTW9kZSA9PSAnVHJlZScgPyAnc2VsZWN0ZWQnIDogJycgfX1cIiAoY2xpY2spPVwic2VsZWN0TW9kZSgnVHJlZScpXCI+XHJcbiAgICAgIDxpbWcgW3NyY109XCJtb2RlbC5nZXRJbWFnZSgnaW1hZ2VzLk90aGVyLlJlcG9ydFRyZWUucG5nJylcIiAvPlxyXG4gICAgICA8ZGl2IGNsYXNzPVwibGFiZWxcIj5cclxuICAgICAgICA8c3Bhbj57eyBcIkZvcm0gVHJlZVwiIH19PC9zcGFuPlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJjdXJyZW50LWluZGljYXRvclwiPjwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgIDwvZGl2PlxyXG4gIDwvZGl2PmAsXHJcbiAgc3R5bGVzOiBbXHJcbiAgICBgXHJcbiAgICAgIC5uYXZpZ2F0aW9uLWNvbnRhaW5lciB7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBoZWlnaHQ6IDM0cHg7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5sYWJlbCB7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICB9XHJcbiAgICAgIC5zZWxlY3RlZCAuY3VycmVudC1pbmRpY2F0b3Ige1xyXG4gICAgICAgIGhlaWdodDogM3B4O1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyNSwgNzEsIDEzOCk7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbiB7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcclxuICAgICAgICBtaW4td2lkdGg6IDgwcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAyNnB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB0cmFuc3BhcmVudDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgbWFyZ2luLXJpZ2h0OiAzcHg7XHJcbiAgICAgICAgcGFkZGluZy1yaWdodDogMTBweDtcclxuICAgICAgfVxyXG4gICAgICAuYnV0dG9uOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjE4LCAyMTgsIDIxOCk7XHJcbiAgICAgICAgY3Vyc29yOiBwb2ludGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5zZWxlY3RlZCB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIyOSwgMjI5LCAyMjkpO1xyXG4gICAgICB9XHJcbiAgICAgIGltZyB7XHJcbiAgICAgICAgaGVpZ2h0OiAxNnB4O1xyXG4gICAgICAgIHdpZHRoOiAxNnB4O1xyXG4gICAgICAgIG1hcmdpbjogMHB4IDZweDtcclxuICAgICAgfVxyXG4gICAgYCxcclxuICBdLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpUHJvcGVydHlHcmlkTmF2aWdhdGlvbkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgY29uc3RydWN0b3IocHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZSwgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHt9XHJcblxyXG4gIHNlbGVjdE1vZGUobW9kZTogc3RyaW5nKSB7XHJcbiAgICBpZiAodGhpcy5tb2RlbC5jdXJyZW50UHJvcGVydHlHcmlkTW9kZSAhPSBtb2RlKSB7XHJcbiAgICAgIHRoaXMubW9kZWwuY3VycmVudFByb3BlcnR5R3JpZE1vZGUgPSBtb2RlO1xyXG4gICAgICBpZiAobW9kZSA9PSBcIlByb3BlcnRpZXNcIikge1xyXG4gICAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5uZWVkVG9SZWZyZXNoLm5leHQodHJ1ZSk7XHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICB9XHJcblxyXG4gIG5nT25Jbml0KCkge31cclxufVxyXG4iXX0=